# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFileResult',
    'AwaitableGetFileResult',
    'get_file',
    'get_file_output',
]

@pulumi.output_type
class GetFileResult:
    """
    A collection of values returned by getFile.
    """
    def __init__(__self__, file=None, id=None, path=None):
        if file and not isinstance(file, dict):
            raise TypeError("Expected argument 'file' to be a dict")
        pulumi.set(__self__, "file", file)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def file(self) -> Mapping[str, str]:
        """
        A map of filename to metadata about the file. The metadata contains the file size and hash, and allows a deployment to be created if the file changes.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")


class AwaitableGetFileResult(GetFileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileResult(
            file=self.file,
            id=self.id,
            path=self.path)


def get_file(path: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileResult:
    """
    Provides information about a file on disk.

    This will read a single file, providing metadata for use with a `Deployment`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel
    import pulumiverse_vercel as vercel

    # In this example, we are assuming that a single index.html file
    # is being deployed. This file lives directly next to the terraform file.
    example = vercel.get_file(path="index.html")
    example_get_project = vercel.get_project(name="my-project")
    example_deployment = vercel.Deployment("example",
        project_id=example_get_project.id,
        files=example.file)
    ```
    """
    __args__ = dict()
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getFile:getFile', __args__, opts=opts, typ=GetFileResult).value

    return AwaitableGetFileResult(
        file=pulumi.get(__ret__, 'file'),
        id=pulumi.get(__ret__, 'id'),
        path=pulumi.get(__ret__, 'path'))
def get_file_output(path: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFileResult]:
    """
    Provides information about a file on disk.

    This will read a single file, providing metadata for use with a `Deployment`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel
    import pulumiverse_vercel as vercel

    # In this example, we are assuming that a single index.html file
    # is being deployed. This file lives directly next to the terraform file.
    example = vercel.get_file(path="index.html")
    example_get_project = vercel.get_project(name="my-project")
    example_deployment = vercel.Deployment("example",
        project_id=example_get_project.id,
        files=example.file)
    ```
    """
    __args__ = dict()
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getFile:getFile', __args__, opts=opts, typ=GetFileResult)
    return __ret__.apply(lambda __response__: GetFileResult(
        file=pulumi.get(__response__, 'file'),
        id=pulumi.get(__response__, 'id'),
        path=pulumi.get(__response__, 'path')))
