# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEndpointVerificationResult',
    'AwaitableGetEndpointVerificationResult',
    'get_endpoint_verification',
    'get_endpoint_verification_output',
]

@pulumi.output_type
class GetEndpointVerificationResult:
    """
    A collection of values returned by getEndpointVerification.
    """
    def __init__(__self__, id=None, team_id=None, verification_code=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)
        if verification_code and not isinstance(verification_code, str):
            raise TypeError("Expected argument 'verification_code' to be a str")
        pulumi.set(__self__, "verification_code", verification_code)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> str:
        """
        A verification code that should be set in the `x-vercel-verify` response header for your API. This is used to verify that the endpoint belongs to you.
        """
        return pulumi.get(self, "verification_code")


class AwaitableGetEndpointVerificationResult(GetEndpointVerificationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointVerificationResult(
            id=self.id,
            team_id=self.team_id,
            verification_code=self.verification_code)


def get_endpoint_verification(team_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointVerificationResult:
    """
    Provides a verification code that can be used to prove ownership over an API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_endpoint_verification()
    ```


    :param str team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getEndpointVerification:getEndpointVerification', __args__, opts=opts, typ=GetEndpointVerificationResult).value

    return AwaitableGetEndpointVerificationResult(
        id=pulumi.get(__ret__, 'id'),
        team_id=pulumi.get(__ret__, 'team_id'),
        verification_code=pulumi.get(__ret__, 'verification_code'))
def get_endpoint_verification_output(team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEndpointVerificationResult]:
    """
    Provides a verification code that can be used to prove ownership over an API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_endpoint_verification()
    ```


    :param str team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getEndpointVerification:getEndpointVerification', __args__, opts=opts, typ=GetEndpointVerificationResult)
    return __ret__.apply(lambda __response__: GetEndpointVerificationResult(
        id=pulumi.get(__response__, 'id'),
        team_id=pulumi.get(__response__, 'team_id'),
        verification_code=pulumi.get(__response__, 'verification_code')))
