# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEdgeConfigSchemaResult',
    'AwaitableGetEdgeConfigSchemaResult',
    'get_edge_config_schema',
    'get_edge_config_schema_output',
]

@pulumi.output_type
class GetEdgeConfigSchemaResult:
    """
    A collection of values returned by getEdgeConfigSchema.
    """
    def __init__(__self__, definition=None, id=None, team_id=None):
        if definition and not isinstance(definition, str):
            raise TypeError("Expected argument 'definition' to be a str")
        pulumi.set(__self__, "definition", definition)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def definition(self) -> str:
        """
        A JSON schema that will be used to validate data in the Edge Config.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Edge Config that the schema should be for.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetEdgeConfigSchemaResult(GetEdgeConfigSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEdgeConfigSchemaResult(
            definition=self.definition,
            id=self.id,
            team_id=self.team_id)


def get_edge_config_schema(id: Optional[str] = None,
                           team_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEdgeConfigSchemaResult:
    """
    An Edge Config Schema provides an existing Edge Config with a JSON schema. Use schema protection to prevent unexpected updates that may cause bugs or downtime.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    test = vercel.get_edge_config_schema(id="ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: The ID of the Edge Config that the schema should be for.
    :param str team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getEdgeConfigSchema:getEdgeConfigSchema', __args__, opts=opts, typ=GetEdgeConfigSchemaResult).value

    return AwaitableGetEdgeConfigSchemaResult(
        definition=pulumi.get(__ret__, 'definition'),
        id=pulumi.get(__ret__, 'id'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_edge_config_schema_output(id: Optional[pulumi.Input[str]] = None,
                                  team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEdgeConfigSchemaResult]:
    """
    An Edge Config Schema provides an existing Edge Config with a JSON schema. Use schema protection to prevent unexpected updates that may cause bugs or downtime.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    test = vercel.get_edge_config_schema(id="ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: The ID of the Edge Config that the schema should be for.
    :param str team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getEdgeConfigSchema:getEdgeConfigSchema', __args__, opts=opts, typ=GetEdgeConfigSchemaResult)
    return __ret__.apply(lambda __response__: GetEdgeConfigSchemaResult(
        definition=pulumi.get(__response__, 'definition'),
        id=pulumi.get(__response__, 'id'),
        team_id=pulumi.get(__response__, 'team_id')))
