# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCustomEnvironmentResult',
    'AwaitableGetCustomEnvironmentResult',
    'get_custom_environment',
    'get_custom_environment_output',
]

@pulumi.output_type
class GetCustomEnvironmentResult:
    """
    A collection of values returned by getCustomEnvironment.
    """
    def __init__(__self__, branch_tracking=None, description=None, id=None, name=None, project_id=None, team_id=None):
        if branch_tracking and not isinstance(branch_tracking, dict):
            raise TypeError("Expected argument 'branch_tracking' to be a dict")
        pulumi.set(__self__, "branch_tracking", branch_tracking)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="branchTracking")
    def branch_tracking(self) -> 'outputs.GetCustomEnvironmentBranchTrackingResult':
        """
        The branch tracking configuration for the environment. When enabled, each qualifying merge will generate a deployment.
        """
        return pulumi.get(self, "branch_tracking")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of what the environment is.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the environment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the existing Vercel Project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetCustomEnvironmentResult(GetCustomEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomEnvironmentResult(
            branch_tracking=self.branch_tracking,
            description=self.description,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            team_id=self.team_id)


def get_custom_environment(name: Optional[str] = None,
                           project_id: Optional[str] = None,
                           team_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomEnvironmentResult:
    """
    Provides information about an existing CustomEnvironment resource.

    An CustomEnvironment allows a `Deployment` to be accessed through a different URL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="example-project-with-custom-env")
    example_get_custom_environment = vercel.get_custom_environment(project_id=example.id,
        name="example-custom-env")
    ```


    :param str name: The name of the environment.
    :param str project_id: The ID of the existing Vercel Project.
    :param str team_id: The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getCustomEnvironment:getCustomEnvironment', __args__, opts=opts, typ=GetCustomEnvironmentResult).value

    return AwaitableGetCustomEnvironmentResult(
        branch_tracking=pulumi.get(__ret__, 'branch_tracking'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_custom_environment_output(name: Optional[pulumi.Input[str]] = None,
                                  project_id: Optional[pulumi.Input[str]] = None,
                                  team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomEnvironmentResult]:
    """
    Provides information about an existing CustomEnvironment resource.

    An CustomEnvironment allows a `Deployment` to be accessed through a different URL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="example-project-with-custom-env")
    example_get_custom_environment = vercel.get_custom_environment(project_id=example.id,
        name="example-custom-env")
    ```


    :param str name: The name of the environment.
    :param str project_id: The ID of the existing Vercel Project.
    :param str team_id: The team ID to add the project to. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getCustomEnvironment:getCustomEnvironment', __args__, opts=opts, typ=GetCustomEnvironmentResult)
    return __ret__.apply(lambda __response__: GetCustomEnvironmentResult(
        branch_tracking=pulumi.get(__response__, 'branch_tracking'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        team_id=pulumi.get(__response__, 'team_id')))
