# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccessGroupProjectResult',
    'AwaitableGetAccessGroupProjectResult',
    'get_access_group_project',
    'get_access_group_project_output',
]

@pulumi.output_type
class GetAccessGroupProjectResult:
    """
    A collection of values returned by getAccessGroupProject.
    """
    def __init__(__self__, access_group_id=None, id=None, project_id=None, role=None, team_id=None):
        if access_group_id and not isinstance(access_group_id, str):
            raise TypeError("Expected argument 'access_group_id' to be a str")
        pulumi.set(__self__, "access_group_id", access_group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="accessGroupId")
    def access_group_id(self) -> str:
        """
        The Access Group ID.
        """
        return pulumi.get(self, "access_group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Project ID.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The Access Group Project Role.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the team the Access Group Project should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetAccessGroupProjectResult(GetAccessGroupProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessGroupProjectResult(
            access_group_id=self.access_group_id,
            id=self.id,
            project_id=self.project_id,
            role=self.role,
            team_id=self.team_id)


def get_access_group_project(access_group_id: Optional[str] = None,
                             project_id: Optional[str] = None,
                             team_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessGroupProjectResult:
    """
    Provides information about an existing Access Group Project Assignment.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/accounts/team-members-and-roles/access-groups).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="my-existing-project")
    example_get_access_group_project = vercel.get_access_group_project(access_group_id="ag_xxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        project_id=example_vercel_project["id"])
    ```


    :param str access_group_id: The Access Group ID.
    :param str project_id: The Project ID.
    :param str team_id: The ID of the team the Access Group Project should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['accessGroupId'] = access_group_id
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getAccessGroupProject:getAccessGroupProject', __args__, opts=opts, typ=GetAccessGroupProjectResult).value

    return AwaitableGetAccessGroupProjectResult(
        access_group_id=pulumi.get(__ret__, 'access_group_id'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        role=pulumi.get(__ret__, 'role'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_access_group_project_output(access_group_id: Optional[pulumi.Input[str]] = None,
                                    project_id: Optional[pulumi.Input[str]] = None,
                                    team_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessGroupProjectResult]:
    """
    Provides information about an existing Access Group Project Assignment.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/accounts/team-members-and-roles/access-groups).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_project(name="my-existing-project")
    example_get_access_group_project = vercel.get_access_group_project(access_group_id="ag_xxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        project_id=example_vercel_project["id"])
    ```


    :param str access_group_id: The Access Group ID.
    :param str project_id: The Project ID.
    :param str team_id: The ID of the team the Access Group Project should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['accessGroupId'] = access_group_id
    __args__['projectId'] = project_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getAccessGroupProject:getAccessGroupProject', __args__, opts=opts, typ=GetAccessGroupProjectResult)
    return __ret__.apply(lambda __response__: GetAccessGroupProjectResult(
        access_group_id=pulumi.get(__response__, 'access_group_id'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        role=pulumi.get(__response__, 'role'),
        team_id=pulumi.get(__response__, 'team_id')))
