# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccessGroupResult',
    'AwaitableGetAccessGroupResult',
    'get_access_group',
    'get_access_group_output',
]

@pulumi.output_type
class GetAccessGroupResult:
    """
    A collection of values returned by getAccessGroup.
    """
    def __init__(__self__, id=None, name=None, team_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Access Group ID to be retrieved.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Access Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        The ID of the team the Access Group should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")


class AwaitableGetAccessGroupResult(GetAccessGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessGroupResult(
            id=self.id,
            name=self.name,
            team_id=self.team_id)


def get_access_group(id: Optional[str] = None,
                     team_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessGroupResult:
    """
    Provides information about an existing Access Group.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/accounts/team-members-and-roles/access-groups).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_access_group(id="ag_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: The Access Group ID to be retrieved.
    :param str team_id: The ID of the team the Access Group should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vercel:index/getAccessGroup:getAccessGroup', __args__, opts=opts, typ=GetAccessGroupResult).value

    return AwaitableGetAccessGroupResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        team_id=pulumi.get(__ret__, 'team_id'))
def get_access_group_output(id: Optional[pulumi.Input[str]] = None,
                            team_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessGroupResult]:
    """
    Provides information about an existing Access Group.

    For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/accounts/team-members-and-roles/access-groups).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vercel as vercel

    example = vercel.get_access_group(id="ag_xxxxxxxxxxxxxxxxxxxxxxxxxxxx")
    ```


    :param str id: The Access Group ID to be retrieved.
    :param str team_id: The ID of the team the Access Group should exist under. Required when configuring a team resource if a default team has not been set in the provider.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vercel:index/getAccessGroup:getAccessGroup', __args__, opts=opts, typ=GetAccessGroupResult)
    return __ret__.apply(lambda __response__: GetAccessGroupResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        team_id=pulumi.get(__response__, 'team_id')))
