# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallConfigArgs', 'FirewallConfig']

@pulumi.input_type
class FirewallConfigArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_rules: Optional[pulumi.Input['FirewallConfigIpRulesArgs']] = None,
                 managed_rulesets: Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']] = None,
                 rules: Optional[pulumi.Input['FirewallConfigRulesArgs']] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FirewallConfig resource.
        :param pulumi.Input[str] project_id: The ID of the project this configuration belongs to.
        :param pulumi.Input[bool] enabled: Whether firewall is enabled or not.
        :param pulumi.Input['FirewallConfigIpRulesArgs'] ip_rules: IP rules to apply to the project.
        :param pulumi.Input['FirewallConfigManagedRulesetsArgs'] managed_rulesets: The managed rulesets that are enabled.
        :param pulumi.Input['FirewallConfigRulesArgs'] rules: Custom rules to apply to the project
        :param pulumi.Input[str] team_id: The ID of the team this project belongs to.
        """
        pulumi.set(__self__, "project_id", project_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if managed_rulesets is not None:
            pulumi.set(__self__, "managed_rulesets", managed_rulesets)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project this configuration belongs to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input['FirewallConfigIpRulesArgs']]:
        """
        IP rules to apply to the project.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input['FirewallConfigIpRulesArgs']]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="managedRulesets")
    def managed_rulesets(self) -> Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']]:
        """
        The managed rulesets that are enabled.
        """
        return pulumi.get(self, "managed_rulesets")

    @managed_rulesets.setter
    def managed_rulesets(self, value: Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']]):
        pulumi.set(self, "managed_rulesets", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['FirewallConfigRulesArgs']]:
        """
        Custom rules to apply to the project
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['FirewallConfigRulesArgs']]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team this project belongs to.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _FirewallConfigState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_rules: Optional[pulumi.Input['FirewallConfigIpRulesArgs']] = None,
                 managed_rulesets: Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input['FirewallConfigRulesArgs']] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FirewallConfig resources.
        :param pulumi.Input[bool] enabled: Whether firewall is enabled or not.
        :param pulumi.Input['FirewallConfigIpRulesArgs'] ip_rules: IP rules to apply to the project.
        :param pulumi.Input['FirewallConfigManagedRulesetsArgs'] managed_rulesets: The managed rulesets that are enabled.
        :param pulumi.Input[str] project_id: The ID of the project this configuration belongs to.
        :param pulumi.Input['FirewallConfigRulesArgs'] rules: Custom rules to apply to the project
        :param pulumi.Input[str] team_id: The ID of the team this project belongs to.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if managed_rulesets is not None:
            pulumi.set(__self__, "managed_rulesets", managed_rulesets)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input['FirewallConfigIpRulesArgs']]:
        """
        IP rules to apply to the project.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input['FirewallConfigIpRulesArgs']]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="managedRulesets")
    def managed_rulesets(self) -> Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']]:
        """
        The managed rulesets that are enabled.
        """
        return pulumi.get(self, "managed_rulesets")

    @managed_rulesets.setter
    def managed_rulesets(self, value: Optional[pulumi.Input['FirewallConfigManagedRulesetsArgs']]):
        pulumi.set(self, "managed_rulesets", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project this configuration belongs to.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['FirewallConfigRulesArgs']]:
        """
        Custom rules to apply to the project
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['FirewallConfigRulesArgs']]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team this project belongs to.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class FirewallConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_rules: Optional[pulumi.Input[Union['FirewallConfigIpRulesArgs', 'FirewallConfigIpRulesArgsDict']]] = None,
                 managed_rulesets: Optional[pulumi.Input[Union['FirewallConfigManagedRulesetsArgs', 'FirewallConfigManagedRulesetsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Union['FirewallConfigRulesArgs', 'FirewallConfigRulesArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Define Custom Rules to shape the way your traffic is handled by the Vercel Edge Network.

        ## Import

        ```sh
        $ pulumi import vercel:index/firewallConfig:FirewallConfig example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether firewall is enabled or not.
        :param pulumi.Input[Union['FirewallConfigIpRulesArgs', 'FirewallConfigIpRulesArgsDict']] ip_rules: IP rules to apply to the project.
        :param pulumi.Input[Union['FirewallConfigManagedRulesetsArgs', 'FirewallConfigManagedRulesetsArgsDict']] managed_rulesets: The managed rulesets that are enabled.
        :param pulumi.Input[str] project_id: The ID of the project this configuration belongs to.
        :param pulumi.Input[Union['FirewallConfigRulesArgs', 'FirewallConfigRulesArgsDict']] rules: Custom rules to apply to the project
        :param pulumi.Input[str] team_id: The ID of the team this project belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Define Custom Rules to shape the way your traffic is handled by the Vercel Edge Network.

        ## Import

        ```sh
        $ pulumi import vercel:index/firewallConfig:FirewallConfig example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param FirewallConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 ip_rules: Optional[pulumi.Input[Union['FirewallConfigIpRulesArgs', 'FirewallConfigIpRulesArgsDict']]] = None,
                 managed_rulesets: Optional[pulumi.Input[Union['FirewallConfigManagedRulesetsArgs', 'FirewallConfigManagedRulesetsArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Union['FirewallConfigRulesArgs', 'FirewallConfigRulesArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallConfigArgs.__new__(FirewallConfigArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip_rules"] = ip_rules
            __props__.__dict__["managed_rulesets"] = managed_rulesets
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["rules"] = rules
            __props__.__dict__["team_id"] = team_id
        super(FirewallConfig, __self__).__init__(
            'vercel:index/firewallConfig:FirewallConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            ip_rules: Optional[pulumi.Input[Union['FirewallConfigIpRulesArgs', 'FirewallConfigIpRulesArgsDict']]] = None,
            managed_rulesets: Optional[pulumi.Input[Union['FirewallConfigManagedRulesetsArgs', 'FirewallConfigManagedRulesetsArgsDict']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Union['FirewallConfigRulesArgs', 'FirewallConfigRulesArgsDict']]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'FirewallConfig':
        """
        Get an existing FirewallConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Whether firewall is enabled or not.
        :param pulumi.Input[Union['FirewallConfigIpRulesArgs', 'FirewallConfigIpRulesArgsDict']] ip_rules: IP rules to apply to the project.
        :param pulumi.Input[Union['FirewallConfigManagedRulesetsArgs', 'FirewallConfigManagedRulesetsArgsDict']] managed_rulesets: The managed rulesets that are enabled.
        :param pulumi.Input[str] project_id: The ID of the project this configuration belongs to.
        :param pulumi.Input[Union['FirewallConfigRulesArgs', 'FirewallConfigRulesArgsDict']] rules: Custom rules to apply to the project
        :param pulumi.Input[str] team_id: The ID of the team this project belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallConfigState.__new__(_FirewallConfigState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip_rules"] = ip_rules
        __props__.__dict__["managed_rulesets"] = managed_rulesets
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["team_id"] = team_id
        return FirewallConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether firewall is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> pulumi.Output[Optional['outputs.FirewallConfigIpRules']]:
        """
        IP rules to apply to the project.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="managedRulesets")
    def managed_rulesets(self) -> pulumi.Output[Optional['outputs.FirewallConfigManagedRulesets']]:
        """
        The managed rulesets that are enabled.
        """
        return pulumi.get(self, "managed_rulesets")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project this configuration belongs to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional['outputs.FirewallConfigRules']]:
        """
        Custom rules to apply to the project
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team this project belongs to.
        """
        return pulumi.get(self, "team_id")

