# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FirewallBypassArgs', 'FirewallBypass']

@pulumi.input_type
class FirewallBypassArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 source_ip: pulumi.Input[str],
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FirewallBypass resource.
        :param pulumi.Input[str] domain: The domain to configure the bypass rule for.
        :param pulumi.Input[str] project_id: The ID of the Project to assign the bypass rule to
        :param pulumi.Input[str] source_ip: The source IP address to configure the bypass rule for.
        :param pulumi.Input[str] team_id: The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "source_ip", source_ip)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain to configure the bypass rule for.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the Project to assign the bypass rule to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Input[str]:
        """
        The source IP address to configure the bypass rule for.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _FirewallBypassState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FirewallBypass resources.
        :param pulumi.Input[str] domain: The domain to configure the bypass rule for.
        :param pulumi.Input[str] project_id: The ID of the Project to assign the bypass rule to
        :param pulumi.Input[str] source_ip: The source IP address to configure the bypass rule for.
        :param pulumi.Input[str] team_id: The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain to configure the bypass rule for.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Project to assign the bypass rule to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The source IP address to configure the bypass rule for.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ip", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class FirewallBypass(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Firewall Bypass Rule

        Firewall Bypass Rules configure sets of domains and ip address to prevent bypass Vercel's system mitigations for.  The hosts used in a bypass rule must be a production domain assigned to the associated project.  Requests that bypass system mitigations will incur usage.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="firewall-bypass-example")
        bypass_targeted = vercel.FirewallBypass("bypass_targeted",
            project_id=example.id,
            source_ip="5.6.7.8",
            domain="my-production-domain.com")
        bypass_cidr = vercel.FirewallBypass("bypass_cidr",
            project_id=example.id,
            source_ip="52.33.44.0/24",
            domain="my-production-domain.com")
        bypass_all = vercel.FirewallBypass("bypass_all",
            project_id=example.id,
            source_ip="52.33.44.0/24",
            domain="*")
        ```

        ## Import

        ```sh
        $ pulumi import vercel:index/firewallBypass:FirewallBypass example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx#mybypasshost.com#3.4.5.0/24
        ```

        ```sh
        $ pulumi import vercel:index/firewallBypass:FirewallBypass example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx#3.4.5.0/24
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: The domain to configure the bypass rule for.
        :param pulumi.Input[str] project_id: The ID of the Project to assign the bypass rule to
        :param pulumi.Input[str] source_ip: The source IP address to configure the bypass rule for.
        :param pulumi.Input[str] team_id: The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallBypassArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Firewall Bypass Rule

        Firewall Bypass Rules configure sets of domains and ip address to prevent bypass Vercel's system mitigations for.  The hosts used in a bypass rule must be a production domain assigned to the associated project.  Requests that bypass system mitigations will incur usage.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.Project("example", name="firewall-bypass-example")
        bypass_targeted = vercel.FirewallBypass("bypass_targeted",
            project_id=example.id,
            source_ip="5.6.7.8",
            domain="my-production-domain.com")
        bypass_cidr = vercel.FirewallBypass("bypass_cidr",
            project_id=example.id,
            source_ip="52.33.44.0/24",
            domain="my-production-domain.com")
        bypass_all = vercel.FirewallBypass("bypass_all",
            project_id=example.id,
            source_ip="52.33.44.0/24",
            domain="*")
        ```

        ## Import

        ```sh
        $ pulumi import vercel:index/firewallBypass:FirewallBypass example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx#mybypasshost.com#3.4.5.0/24
        ```

        ```sh
        $ pulumi import vercel:index/firewallBypass:FirewallBypass example team_xxxxxxxxxxxxxxxxxxxxxxxx/prj_xxxxxxxxxxxxxxxxxxxxxxxxxxxx#3.4.5.0/24
        ```

        :param str resource_name: The name of the resource.
        :param FirewallBypassArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallBypassArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 source_ip: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallBypassArgs.__new__(FirewallBypassArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if source_ip is None and not opts.urn:
                raise TypeError("Missing required property 'source_ip'")
            __props__.__dict__["source_ip"] = source_ip
            __props__.__dict__["team_id"] = team_id
        super(FirewallBypass, __self__).__init__(
            'vercel:index/firewallBypass:FirewallBypass',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            source_ip: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'FirewallBypass':
        """
        Get an existing FirewallBypass resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: The domain to configure the bypass rule for.
        :param pulumi.Input[str] project_id: The ID of the Project to assign the bypass rule to
        :param pulumi.Input[str] source_ip: The source IP address to configure the bypass rule for.
        :param pulumi.Input[str] team_id: The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallBypassState.__new__(_FirewallBypassState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["source_ip"] = source_ip
        __props__.__dict__["team_id"] = team_id
        return FirewallBypass(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain to configure the bypass rule for.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the Project to assign the bypass rule to
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> pulumi.Output[str]:
        """
        The source IP address to configure the bypass rule for.
        """
        return pulumi.get(self, "source_ip")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the Project exists under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

