# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeConfigTokenArgs', 'EdgeConfigToken']

@pulumi.input_type
class EdgeConfigTokenArgs:
    def __init__(__self__, *,
                 edge_config_id: pulumi.Input[str],
                 label: pulumi.Input[str],
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeConfigToken resource.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] label: The label of the Edge Config Token.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "edge_config_id", edge_config_id)
        pulumi.set(__self__, "label", label)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> pulumi.Input[str]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @edge_config_id.setter
    def edge_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "edge_config_id", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        The label of the Edge Config Token.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _EdgeConfigTokenState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EdgeConfigToken resources.
        :param pulumi.Input[str] connection_string: A connection string is a URL that connects a project to an Edge Config. The variable can be called anything, but our Edge Config client SDK will search for process.env.EDGE_CONFIG by default.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] label: The label of the Edge Config Token.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[str] token: A read access token used for authenticating against the Edge Config's endpoint for high volume, low-latency requests.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if edge_config_id is not None:
            pulumi.set(__self__, "edge_config_id", edge_config_id)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        A connection string is a URL that connects a project to an Edge Config. The variable can be called anything, but our Edge Config client SDK will search for process.env.EDGE_CONFIG by default.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @edge_config_id.setter
    def edge_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_config_id", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        The label of the Edge Config Token.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        A read access token used for authenticating against the Edge Config's endpoint for high volume, low-latency requests.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class EdgeConfigToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Edge Config Token resource.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        An Edge Config token is used to authenticate against an Edge Config's endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_project = vercel.Project("example", name="edge-config-example")
        example_edge_config_token = vercel.EdgeConfigToken("example",
            edge_config_id=example.id,
            label="example token")
        example_project_environment_variable = vercel.ProjectEnvironmentVariable("example",
            project_id=example_project.id,
            targets=[
                "production",
                "preview",
                "development",
            ],
            key="EDGE_CONFIG",
            value=example_edge_config_token.connection_string)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id and token value.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - token can be found in the Vercel UI under Storage, Edge Config, the specific Edge Config, Tokens.

        ```sh
        $ pulumi import vercel:index/edgeConfigToken:EdgeConfigToken example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and edge_config_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - token can be found in the Vercel UI under Storage, Edge Config, the specific Edge Config, Tokens.

        ```sh
        $ pulumi import vercel:index/edgeConfigToken:EdgeConfigToken example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] label: The label of the Edge Config Token.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeConfigTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Edge Config Token resource.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        An Edge Config token is used to authenticate against an Edge Config's endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_project = vercel.Project("example", name="edge-config-example")
        example_edge_config_token = vercel.EdgeConfigToken("example",
            edge_config_id=example.id,
            label="example token")
        example_project_environment_variable = vercel.ProjectEnvironmentVariable("example",
            project_id=example_project.id,
            targets=[
                "production",
                "preview",
                "development",
            ],
            key="EDGE_CONFIG",
            value=example_edge_config_token.connection_string)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id and token value.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - token can be found in the Vercel UI under Storage, Edge Config, the specific Edge Config, Tokens.

        ```sh
        $ pulumi import vercel:index/edgeConfigToken:EdgeConfigToken example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and edge_config_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - token can be found in the Vercel UI under Storage, Edge Config, the specific Edge Config, Tokens.

        ```sh
        $ pulumi import vercel:index/edgeConfigToken:EdgeConfigToken example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param EdgeConfigTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeConfigTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeConfigTokenArgs.__new__(EdgeConfigTokenArgs)

            if edge_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'edge_config_id'")
            __props__.__dict__["edge_config_id"] = edge_config_id
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["token"] = None
        super(EdgeConfigToken, __self__).__init__(
            'vercel:index/edgeConfigToken:EdgeConfigToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            edge_config_id: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'EdgeConfigToken':
        """
        Get an existing EdgeConfigToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_string: A connection string is a URL that connects a project to an Edge Config. The variable can be called anything, but our Edge Config client SDK will search for process.env.EDGE_CONFIG by default.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] label: The label of the Edge Config Token.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[str] token: A read access token used for authenticating against the Edge Config's endpoint for high volume, low-latency requests.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeConfigTokenState.__new__(_EdgeConfigTokenState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["edge_config_id"] = edge_config_id
        __props__.__dict__["label"] = label
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["token"] = token
        return EdgeConfigToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        A connection string is a URL that connects a project to an Edge Config. The variable can be called anything, but our Edge Config client SDK will search for process.env.EDGE_CONFIG by default.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> pulumi.Output[str]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        The label of the Edge Config Token.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        A read access token used for authenticating against the Edge Config's endpoint for high volume, low-latency requests.
        """
        return pulumi.get(self, "token")

