# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeConfigItemArgs', 'EdgeConfigItem']

@pulumi.input_type
class EdgeConfigItemArgs:
    def __init__(__self__, *,
                 edge_config_id: pulumi.Input[str],
                 key: pulumi.Input[str],
                 value: pulumi.Input[str],
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeConfigItem resource.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] key: The name of the key you want to add to or update within your Edge Config.
        :param pulumi.Input[str] value: The value you want to assign to the key.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        pulumi.set(__self__, "edge_config_id", edge_config_id)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> pulumi.Input[str]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @edge_config_id.setter
    def edge_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "edge_config_id", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name of the key you want to add to or update within your Edge Config.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value you want to assign to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _EdgeConfigItemState:
    def __init__(__self__, *,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EdgeConfigItem resources.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] key: The name of the key you want to add to or update within your Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[str] value: The value you want to assign to the key.
        """
        if edge_config_id is not None:
            pulumi.set(__self__, "edge_config_id", edge_config_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @edge_config_id.setter
    def edge_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_config_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key you want to add to or update within your Edge Config.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value you want to assign to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class EdgeConfigItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Edge Config Item.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        An Edge Config Item is a value within an Edge Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_edge_config_item = vercel.EdgeConfigItem("example",
            edge_config_id=example.id,
            key="foobar",
            value="baz")
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id and the key of the item to import.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - key is the key of teh item to import.

        ```sh
        $ pulumi import vercel:index/edgeConfigItem:EdgeConfigItem example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example_key
        ```

        Alternatively, you can import via the team_id, edge_config_id and the key of the item to import.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - key is the key of the item to import.

        ```sh
        $ pulumi import vercel:index/edgeConfigItem:EdgeConfigItem example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example_key
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] key: The name of the key you want to add to or update within your Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[str] value: The value you want to assign to the key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeConfigItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Edge Config Item.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        An Edge Config Item is a value within an Edge Config.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_edge_config_item = vercel.EdgeConfigItem("example",
            edge_config_id=example.id,
            key="foobar",
            value="baz")
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id and the key of the item to import.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - key is the key of teh item to import.

        ```sh
        $ pulumi import vercel:index/edgeConfigItem:EdgeConfigItem example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example_key
        ```

        Alternatively, you can import via the team_id, edge_config_id and the key of the item to import.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        - key is the key of the item to import.

        ```sh
        $ pulumi import vercel:index/edgeConfigItem:EdgeConfigItem example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx/example_key
        ```

        :param str resource_name: The name of the resource.
        :param EdgeConfigItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeConfigItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edge_config_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeConfigItemArgs.__new__(EdgeConfigItemArgs)

            if edge_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'edge_config_id'")
            __props__.__dict__["edge_config_id"] = edge_config_id
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["team_id"] = team_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(EdgeConfigItem, __self__).__init__(
            'vercel:index/edgeConfigItem:EdgeConfigItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            edge_config_id: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'EdgeConfigItem':
        """
        Get an existing EdgeConfigItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] edge_config_id: The ID of the Edge Config store.
        :param pulumi.Input[str] key: The name of the key you want to add to or update within your Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[str] value: The value you want to assign to the key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeConfigItemState.__new__(_EdgeConfigItemState)

        __props__.__dict__["edge_config_id"] = edge_config_id
        __props__.__dict__["key"] = key
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["value"] = value
        return EdgeConfigItem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="edgeConfigId")
    def edge_config_id(self) -> pulumi.Output[str]:
        """
        The ID of the Edge Config store.
        """
        return pulumi.get(self, "edge_config_id")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The name of the key you want to add to or update within your Edge Config.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[str]:
        """
        The value you want to assign to the key.
        """
        return pulumi.get(self, "value")

