# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeConfigArgs', 'EdgeConfig']

@pulumi.input_type
class EdgeConfigArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeConfig resource.
        :param pulumi.Input[str] name: The name/slug of the Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name/slug of the Edge Config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _EdgeConfigState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EdgeConfig resources.
        :param pulumi.Input[str] name: The name/slug of the Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name/slug of the Edge Config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class EdgeConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Edge Config resource.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_project = vercel.Project("example", name="edge-config-example")
        example_edge_config_token = vercel.EdgeConfigToken("example",
            edge_config_id=example.id,
            label="example token")
        example_project_environment_variable = vercel.ProjectEnvironmentVariable("example",
            project_id=example_project.id,
            targets=[
                "production",
                "preview",
                "development",
            ],
            key="EDGE_CONFIG",
            value=example_edge_config_token.connection_string)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        ```sh
        $ pulumi import vercel:index/edgeConfig:EdgeConfig example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and edge_config_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        ```sh
        $ pulumi import vercel:index/edgeConfig:EdgeConfig example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name/slug of the Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EdgeConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Edge Config resource.

        An Edge Config is a global data store that enables experimentation with feature flags, A/B testing, critical redirects, and more.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        example = vercel.EdgeConfig("example", name="example")
        example_project = vercel.Project("example", name="edge-config-example")
        example_edge_config_token = vercel.EdgeConfigToken("example",
            edge_config_id=example.id,
            label="example token")
        example_project_environment_variable = vercel.ProjectEnvironmentVariable("example",
            project_id=example_project.id,
            targets=[
                "production",
                "preview",
                "development",
            ],
            key="EDGE_CONFIG",
            value=example_edge_config_token.connection_string)
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the edge config id.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        ```sh
        $ pulumi import vercel:index/edgeConfig:EdgeConfig example ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and edge_config_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - edge_config_id can be found by navigating to the Edge Config in the Vercel UI. It should begin with `ecfg_`.

        ```sh
        $ pulumi import vercel:index/edgeConfig:EdgeConfig example team_xxxxxxxxxxxxxxxxxxxxxxxx/ecfg_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param EdgeConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeConfigArgs.__new__(EdgeConfigArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["team_id"] = team_id
        super(EdgeConfig, __self__).__init__(
            'vercel:index/edgeConfig:EdgeConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'EdgeConfig':
        """
        Get an existing EdgeConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name/slug of the Edge Config.
        :param pulumi.Input[str] team_id: The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeConfigState.__new__(_EdgeConfigState)

        __props__.__dict__["name"] = name
        __props__.__dict__["team_id"] = team_id
        return EdgeConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name/slug of the Edge Config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The ID of the team the Edge Config should exist under. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

