# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsRecordArgs', 'DnsRecord']

@pulumi.input_type
class DnsRecordArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 type: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 mx_priority: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 srv: Optional[pulumi.Input['DnsRecordSrvArgs']] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DnsRecord resource.
        :param pulumi.Input[str] domain: The domain name, or zone, that the DNS record should be created beneath.
        :param pulumi.Input[str] type: The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        :param pulumi.Input[str] comment: A comment explaining what the DNS record is for.
        :param pulumi.Input[int] mx_priority: The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        :param pulumi.Input[str] name: The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        :param pulumi.Input['DnsRecordSrvArgs'] srv: Settings for an SRV record.
        :param pulumi.Input[str] team_id: The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[int] ttl: The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        :param pulumi.Input[str] value: The value of the DNS record. The format depends on the 'type' property.
               For an 'A' record, this should be a valid IPv4 address.
               For an 'AAAA' record, this should be an IPv6 address.
               For 'ALIAS' records, this should be a hostname.
               For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
               For 'CNAME' records, this should be a different domain name.
               For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
               For 'TXT' records, this can contain arbitrary text.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "type", type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if mx_priority is not None:
            pulumi.set(__self__, "mx_priority", mx_priority)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if srv is not None:
            pulumi.set(__self__, "srv", srv)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain name, or zone, that the DNS record should be created beneath.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment explaining what the DNS record is for.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="mxPriority")
    def mx_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        """
        return pulumi.get(self, "mx_priority")

    @mx_priority.setter
    def mx_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mx_priority", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def srv(self) -> Optional[pulumi.Input['DnsRecordSrvArgs']]:
        """
        Settings for an SRV record.
        """
        return pulumi.get(self, "srv")

    @srv.setter
    def srv(self, value: Optional[pulumi.Input['DnsRecordSrvArgs']]):
        pulumi.set(self, "srv", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the DNS record. The format depends on the 'type' property.
        For an 'A' record, this should be a valid IPv4 address.
        For an 'AAAA' record, this should be an IPv6 address.
        For 'ALIAS' records, this should be a hostname.
        For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
        For 'CNAME' records, this should be a different domain name.
        For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
        For 'TXT' records, this can contain arbitrary text.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _DnsRecordState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mx_priority: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 srv: Optional[pulumi.Input['DnsRecordSrvArgs']] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DnsRecord resources.
        :param pulumi.Input[str] comment: A comment explaining what the DNS record is for.
        :param pulumi.Input[str] domain: The domain name, or zone, that the DNS record should be created beneath.
        :param pulumi.Input[int] mx_priority: The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        :param pulumi.Input[str] name: The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        :param pulumi.Input['DnsRecordSrvArgs'] srv: Settings for an SRV record.
        :param pulumi.Input[str] team_id: The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[int] ttl: The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        :param pulumi.Input[str] type: The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        :param pulumi.Input[str] value: The value of the DNS record. The format depends on the 'type' property.
               For an 'A' record, this should be a valid IPv4 address.
               For an 'AAAA' record, this should be an IPv6 address.
               For 'ALIAS' records, this should be a hostname.
               For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
               For 'CNAME' records, this should be a different domain name.
               For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
               For 'TXT' records, this can contain arbitrary text.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if mx_priority is not None:
            pulumi.set(__self__, "mx_priority", mx_priority)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if srv is not None:
            pulumi.set(__self__, "srv", srv)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment explaining what the DNS record is for.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name, or zone, that the DNS record should be created beneath.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="mxPriority")
    def mx_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        """
        return pulumi.get(self, "mx_priority")

    @mx_priority.setter
    def mx_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mx_priority", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def srv(self) -> Optional[pulumi.Input['DnsRecordSrvArgs']]:
        """
        Settings for an SRV record.
        """
        return pulumi.get(self, "srv")

    @srv.setter
    def srv(self, value: Optional[pulumi.Input['DnsRecordSrvArgs']]):
        pulumi.set(self, "srv", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the DNS record. The format depends on the 'type' property.
        For an 'A' record, this should be a valid IPv4 address.
        For an 'AAAA' record, this should be an IPv6 address.
        For 'ALIAS' records, this should be a hostname.
        For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
        For 'CNAME' records, this should be a different domain name.
        For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
        For 'TXT' records, this can contain arbitrary text.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class DnsRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mx_priority: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 srv: Optional[pulumi.Input[Union['DnsRecordSrvArgs', 'DnsRecordSrvArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DNS Record resource.

        DNS records are instructions that live in authoritative DNS servers and provide information about a domain.

        > The `value` field must be specified on all DNS record types except `SRV`. When using `SRV` DNS records, the `srv` field must be specified.

        For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/concepts/projects/custom-domains#dns-records)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        a = vercel.DnsRecord("a",
            domain="example.com",
            name="subdomain",
            type="A",
            ttl=60,
            value="192.168.0.1")
        aaaa = vercel.DnsRecord("aaaa",
            domain="example.com",
            name="subdomain",
            type="AAAA",
            ttl=60,
            value="::0")
        alias = vercel.DnsRecord("alias",
            domain="example.com",
            name="subdomain",
            type="ALIAS",
            ttl=60,
            value="example2.com.")
        caa = vercel.DnsRecord("caa",
            domain="example.com",
            name="subdomain",
            type="CAA",
            ttl=60,
            value="1 issue \\"letsencrypt.org\\"")
        cname = vercel.DnsRecord("cname",
            domain="example.com",
            name="subdomain",
            type="CNAME",
            ttl=60,
            value="example2.com.")
        mx = vercel.DnsRecord("mx",
            domain="example.com",
            name="subdomain",
            type="MX",
            ttl=60,
            mx_priority=333,
            value="example2.com.")
        srv = vercel.DnsRecord("srv",
            domain="example.com",
            name="subdomain",
            type="SRV",
            ttl=60,
            srv={
                "port": 6000,
                "weight": 60,
                "priority": 127,
                "target": "example2.com.",
            })
        txt = vercel.DnsRecord("txt",
            domain="example.com",
            name="subdomain",
            type="TXT",
            ttl=60,
            value="some text value")
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the record id.

        - record_id can be taken from the network tab inside developer tools, while you are on the domains page,

        or can be queried from the Vercel API directly (https://vercel.com/docs/rest-api/endpoints/dns#list-existing-dns-records).

        ```sh
        $ pulumi import vercel:index/dnsRecord:DnsRecord example rec_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and record_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - record_id can be taken from the network tab inside developer tools, while you are on the domains page,

        or can be queried from the Vercel API directly (https://vercel.com/docs/rest-api/endpoints/dns#list-existing-dns-records).

        ```sh
        $ pulumi import vercel:index/dnsRecord:DnsRecord example team_xxxxxxxxxxxxxxxxxxxxxxxx/rec_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment explaining what the DNS record is for.
        :param pulumi.Input[str] domain: The domain name, or zone, that the DNS record should be created beneath.
        :param pulumi.Input[int] mx_priority: The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        :param pulumi.Input[str] name: The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        :param pulumi.Input[Union['DnsRecordSrvArgs', 'DnsRecordSrvArgsDict']] srv: Settings for an SRV record.
        :param pulumi.Input[str] team_id: The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[int] ttl: The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        :param pulumi.Input[str] type: The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        :param pulumi.Input[str] value: The value of the DNS record. The format depends on the 'type' property.
               For an 'A' record, this should be a valid IPv4 address.
               For an 'AAAA' record, this should be an IPv6 address.
               For 'ALIAS' records, this should be a hostname.
               For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
               For 'CNAME' records, this should be a different domain name.
               For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
               For 'TXT' records, this can contain arbitrary text.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DNS Record resource.

        DNS records are instructions that live in authoritative DNS servers and provide information about a domain.

        > The `value` field must be specified on all DNS record types except `SRV`. When using `SRV` DNS records, the `srv` field must be specified.

        For more detailed information, please see the [Vercel documentation](https://vercel.com/docs/concepts/projects/custom-domains#dns-records)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_vercel as vercel

        a = vercel.DnsRecord("a",
            domain="example.com",
            name="subdomain",
            type="A",
            ttl=60,
            value="192.168.0.1")
        aaaa = vercel.DnsRecord("aaaa",
            domain="example.com",
            name="subdomain",
            type="AAAA",
            ttl=60,
            value="::0")
        alias = vercel.DnsRecord("alias",
            domain="example.com",
            name="subdomain",
            type="ALIAS",
            ttl=60,
            value="example2.com.")
        caa = vercel.DnsRecord("caa",
            domain="example.com",
            name="subdomain",
            type="CAA",
            ttl=60,
            value="1 issue \\"letsencrypt.org\\"")
        cname = vercel.DnsRecord("cname",
            domain="example.com",
            name="subdomain",
            type="CNAME",
            ttl=60,
            value="example2.com.")
        mx = vercel.DnsRecord("mx",
            domain="example.com",
            name="subdomain",
            type="MX",
            ttl=60,
            mx_priority=333,
            value="example2.com.")
        srv = vercel.DnsRecord("srv",
            domain="example.com",
            name="subdomain",
            type="SRV",
            ttl=60,
            srv={
                "port": 6000,
                "weight": 60,
                "priority": 127,
                "target": "example2.com.",
            })
        txt = vercel.DnsRecord("txt",
            domain="example.com",
            name="subdomain",
            type="TXT",
            ttl=60,
            value="some text value")
        ```

        ## Import

        If importing into a personal account, or with a team configured on

        the provider, simply use the record id.

        - record_id can be taken from the network tab inside developer tools, while you are on the domains page,

        or can be queried from the Vercel API directly (https://vercel.com/docs/rest-api/endpoints/dns#list-existing-dns-records).

        ```sh
        $ pulumi import vercel:index/dnsRecord:DnsRecord example rec_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        Alternatively, you can import via the team_id and record_id.

        - team_id can be found in the team `settings` tab in the Vercel UI.

        - record_id can be taken from the network tab inside developer tools, while you are on the domains page,

        or can be queried from the Vercel API directly (https://vercel.com/docs/rest-api/endpoints/dns#list-existing-dns-records).

        ```sh
        $ pulumi import vercel:index/dnsRecord:DnsRecord example team_xxxxxxxxxxxxxxxxxxxxxxxx/rec_xxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param DnsRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mx_priority: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 srv: Optional[pulumi.Input[Union['DnsRecordSrvArgs', 'DnsRecordSrvArgsDict']]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsRecordArgs.__new__(DnsRecordArgs)

            __props__.__dict__["comment"] = comment
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["mx_priority"] = mx_priority
            __props__.__dict__["name"] = name
            __props__.__dict__["srv"] = srv
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["value"] = value
        super(DnsRecord, __self__).__init__(
            'vercel:index/dnsRecord:DnsRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            mx_priority: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            srv: Optional[pulumi.Input[Union['DnsRecordSrvArgs', 'DnsRecordSrvArgsDict']]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            value: Optional[pulumi.Input[str]] = None) -> 'DnsRecord':
        """
        Get an existing DnsRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment explaining what the DNS record is for.
        :param pulumi.Input[str] domain: The domain name, or zone, that the DNS record should be created beneath.
        :param pulumi.Input[int] mx_priority: The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        :param pulumi.Input[str] name: The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        :param pulumi.Input[Union['DnsRecordSrvArgs', 'DnsRecordSrvArgsDict']] srv: Settings for an SRV record.
        :param pulumi.Input[str] team_id: The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        :param pulumi.Input[int] ttl: The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        :param pulumi.Input[str] type: The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        :param pulumi.Input[str] value: The value of the DNS record. The format depends on the 'type' property.
               For an 'A' record, this should be a valid IPv4 address.
               For an 'AAAA' record, this should be an IPv6 address.
               For 'ALIAS' records, this should be a hostname.
               For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
               For 'CNAME' records, this should be a different domain name.
               For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
               For 'TXT' records, this can contain arbitrary text.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsRecordState.__new__(_DnsRecordState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["domain"] = domain
        __props__.__dict__["mx_priority"] = mx_priority
        __props__.__dict__["name"] = name
        __props__.__dict__["srv"] = srv
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return DnsRecord(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[str]:
        """
        A comment explaining what the DNS record is for.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name, or zone, that the DNS record should be created beneath.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="mxPriority")
    def mx_priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of the MX record. The priority specifies the sequence that an email server receives emails. A smaller value indicates a higher priority.
        """
        return pulumi.get(self, "mx_priority")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The subdomain name of the record. This should be an empty string if the rercord is for the root domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def srv(self) -> pulumi.Output[Optional['outputs.DnsRecordSrv']]:
        """
        Settings for an SRV record.
        """
        return pulumi.get(self, "srv")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        The team ID that the domain and DNS records belong to. Required when configuring a team resource if a default team has not been set in the provider.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[int]:
        """
        The TTL value in seconds. Must be a number between 60 and 2147483647. If unspecified, it will default to 60 seconds.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of DNS record. Available types: `A`, `AAAA`, `ALIAS`, `CAA`, `CNAME`, `MX`, `NS`, `SRV`, `TXT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[str]]:
        """
        The value of the DNS record. The format depends on the 'type' property.
        For an 'A' record, this should be a valid IPv4 address.
        For an 'AAAA' record, this should be an IPv6 address.
        For 'ALIAS' records, this should be a hostname.
        For 'CAA' records, this should specify specify which Certificate Authorities (CAs) are allowed to issue certificates for the domain.
        For 'CNAME' records, this should be a different domain name.
        For 'MX' records, this should specify the mail server responsible for accepting messages on behalf of the domain name.
        For 'TXT' records, this can contain arbitrary text.
        """
        return pulumi.get(self, "value")

