/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.dexbacked.ZipDexContainer;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.ExceptionWithContext;

public final class DexFileFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MultiDexContainer<? extends DexBackedDexFile> loadDexContainer(File file, Opcodes opcodes) throws IOException {
        block14: {
            SingletonMultiDexContainer singletonMultiDexContainer;
            if (!file.exists()) {
                throw new DexFileNotFoundException("%s does not exist", file.getName());
            }
            ZipDexContainer zipDexContainer = new ZipDexContainer(file, opcodes);
            if (zipDexContainer.isZipFile()) {
                return zipDexContainer;
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                singletonMultiDexContainer = new SingletonMultiDexContainer(file.getPath(), dexFile);
            }
            catch (DexBackedDexFile.NotADexFile dexFile) {
                DexBackedOdexFile odexFile2222 = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                SingletonMultiDexContainer singletonMultiDexContainer2 = new SingletonMultiDexContainer(file.getPath(), odexFile2222);
                ((InputStream)inputStream).close();
                return singletonMultiDexContainer2;
                {
                    catch (DexBackedOdexFile.NotAnOdexFile odexFile2222) {
                        try {
                            OatFile oatFile = null;
                            try {
                                oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                            }
                            catch (OatFile.NotAnOatFileException notAnOatFileException) {
                                // empty catch block
                            }
                            if (oatFile != null) {
                                if (oatFile.isSupportedVersion() == 0) {
                                    throw new UnsupportedOatVersionException(oatFile);
                                }
                                OatFile oatFile2 = oatFile;
                                return oatFile2;
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)inputStream).close();
                        }
                    }
                }
            }
            ((InputStream)inputStream).close();
            return singletonMultiDexContainer;
        }
        throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
    }

    public static class FilenameVdexProvider
    implements OatFile.VdexProvider {
        private final File vdexFile;
        private byte[] buf = null;
        private boolean loadedVdex = false;

        public FilenameVdexProvider(File oatFile) {
            File oatParent = oatFile.getAbsoluteFile().getParentFile();
            String baseName = Files.getNameWithoutExtension(oatFile.getAbsolutePath());
            this.vdexFile = new File(oatParent, baseName + ".vdex");
        }

        @Override
        public byte[] getVdex() {
            if (!this.loadedVdex) {
                File parentDirectory;
                File candidateFile = this.vdexFile;
                if (!candidateFile.exists() && (parentDirectory = candidateFile.getParentFile().getParentFile()) != null) {
                    candidateFile = new File(parentDirectory, this.vdexFile.getName());
                }
                if (candidateFile.exists()) {
                    try {
                        this.buf = ByteStreams.toByteArray(new FileInputStream(candidateFile));
                    }
                    catch (FileNotFoundException e) {
                        this.buf = null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.loadedVdex = true;
            }
            return this.buf;
        }
    }

    private static class SingletonMultiDexContainer
    implements MultiDexContainer<DexBackedDexFile> {
        private final String entryName;
        private final DexBackedDexFile dexFile;

        public SingletonMultiDexContainer(String entryName, DexBackedDexFile dexFile) {
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        public List<String> getDexEntryNames() {
            return ImmutableList.of(this.entryName);
        }

        @Override
        public MultiDexContainer.DexEntry<DexBackedDexFile> getEntry(final String entryName) {
            if (entryName.equals(this.entryName)) {
                return new MultiDexContainer.DexEntry<DexBackedDexFile>(){

                    @Override
                    public DexBackedDexFile getDexFile() {
                        return dexFile;
                    }
                };
            }
            return null;
        }
    }

    public static class UnsupportedFileTypeException
    extends ExceptionWithContext {
        public UnsupportedFileTypeException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), new Object[0]);
        }
    }

    public static class UnsupportedOatVersionException
    extends ExceptionWithContext {
        public final OatFile oatFile;

        public UnsupportedOatVersionException(OatFile oatFile) {
            super("Unsupported oat version: %d", oatFile.getOatVersion());
            this.oatFile = oatFile;
        }
    }

    public static class DexFileNotFoundException
    extends ExceptionWithContext {
        public DexFileNotFoundException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }

        public DexFileNotFoundException(Throwable cause, String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }
    }
}

