"""Add Grant table

Revision ID: 6b10f4d6ecee
Revises: 978e795ec35b
Create Date: 2022-02-03 10:03:27.253121

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "6b10f4d6ecee"
down_revision = "978e795ec35b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_grants",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("scope", sa.JSON(), nullable=False),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("client_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(["client_id"], ["fief_clients.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["user_id"], ["fief_users.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user_id", "client_id"),
    )
    op.create_index(
        op.f("ix_fief_grants_created_at"), "fief_grants", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_fief_grants_updated_at"), "fief_grants", ["updated_at"], unique=False
    )
    op.add_column(
        "fief_login_sessions", sa.Column("prompt", sa.String(length=255), nullable=True)
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("fief_login_sessions", "prompt")
    op.drop_index(op.f("ix_fief_grants_updated_at"), table_name="fief_grants")
    op.drop_index(op.f("ix_fief_grants_created_at"), table_name="fief_grants")
    op.drop_table("fief_grants")
    # ### end Alembic commands ###
