"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.list_snapshots_response import ListSnapshotsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_snapshots_response import SearchSnapshotsResponse
from delphix.api.gateway.model.snapshot import Snapshot
from delphix.api.gateway.model.snapshots_day_ranges_response import SnapshotsDayRangesResponse


class SnapshotsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_snapshot_by_id(
            self,
            snapshot_id,
            **kwargs
        ):
            """Get a Snapshot by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_snapshot_by_id(snapshot_id, async_req=True)
            >>> result = thread.get()

            Args:
                snapshot_id (str): The ID of the snaphost.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Snapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['snapshot_id'] = \
                snapshot_id
            return self.call_with_http_info(**kwargs)

        self.get_snapshot_by_id = _Endpoint(
            settings={
                'response_type': (Snapshot,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/snapshots/{snapshotId}',
                'operation_id': 'get_snapshot_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'snapshot_id',
                ],
                'required': [
                    'snapshot_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'snapshot_id',
                ]
            },
            root_map={
                'validations': {
                    ('snapshot_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'snapshot_id':
                        (str,),
                },
                'attribute_map': {
                    'snapshot_id': 'snapshotId',
                },
                'location_map': {
                    'snapshot_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_snapshot_by_id
        )

        def __get_snapshots(
            self,
            **kwargs
        ):
            """Retrieve the list of snapshots.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_snapshots(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSnapshotsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_snapshots = _Endpoint(
            settings={
                'response_type': (ListSnapshotsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/snapshots',
                'operation_id': 'get_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "NAMESPACE": "namespace",
                        "-NAMESPACE": "-namespace",
                        "NAME": "name",
                        "-NAME": "-name",
                        "CONSISTENCY": "consistency",
                        "-CONSISTENCY": "-consistency",
                        "MISSING_NON_LOGGED_DATA": "missing_non_logged_data",
                        "-MISSING_NON_LOGGED_DATA": "-missing_non_logged_data",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "CREATION_TIME": "creation_time",
                        "-CREATION_TIME": "-creation_time",
                        "START_TIMESTAMP": "start_timestamp",
                        "-START_TIMESTAMP": "-start_timestamp",
                        "START_LOCATION": "start_location",
                        "-START_LOCATION": "-start_location",
                        "TIMESTAMP": "timestamp",
                        "-TIMESTAMP": "-timestamp",
                        "LOCATION": "location",
                        "-LOCATION": "-location",
                        "RETENTION": "retention",
                        "-RETENTION": "-retention",
                        "TIMEFLOW_ID": "timeflow_id",
                        "-TIMEFLOW_ID": "-timeflow_id",
                        "TIMEZONE": "timezone",
                        "-TIMEZONE": "-timezone",
                        "VERSION": "version",
                        "-VERSION": "-version",
                        "TEMPORARY": "temporary",
                        "-TEMPORARY": "-temporary",
                        "APPDATA_TOOLKIT": "appdata_toolkit",
                        "-APPDATA_TOOLKIT": "-appdata_toolkit",
                        "APPDATA_METADATA": "appdata_metadata",
                        "-APPDATA_METADATA": "-appdata_metadata",
                        "ASE_DB_ENCRYPTION_KEY": "ase_db_encryption_key",
                        "-ASE_DB_ENCRYPTION_KEY": "-ase_db_encryption_key",
                        "MSSQL_INTERNAL_VERSION": "mssql_internal_version",
                        "-MSSQL_INTERNAL_VERSION": "-mssql_internal_version",
                        "MSSQL_BACKUP_SET_UUID": "mssql_backup_set_uuid",
                        "-MSSQL_BACKUP_SET_UUID": "-mssql_backup_set_uuid",
                        "MSSQL_BACKUP_SOFTWARE_TYPE": "mssql_backup_software_type",
                        "-MSSQL_BACKUP_SOFTWARE_TYPE": "-mssql_backup_software_type",
                        "MSSQL_BACKUP_LOCATION_TYPE": "mssql_backup_location_type",
                        "-MSSQL_BACKUP_LOCATION_TYPE": "-mssql_backup_location_type",
                        "MSSQL_EMPTY_SNAPSHOT": "mssql_empty_snapshot",
                        "-MSSQL_EMPTY_SNAPSHOT": "-mssql_empty_snapshot",
                        "ORACLE_FROM_PHYSICAL_STANDBY_VDB": "oracle_from_physical_standby_vdb",
                        "-ORACLE_FROM_PHYSICAL_STANDBY_VDB": "-oracle_from_physical_standby_vdb",
                        "ORACLE_REDO_LOG_SIZE_IN_BYTES": "oracle_redo_log_size_in_bytes",
                        "-ORACLE_REDO_LOG_SIZE_IN_BYTES": "-oracle_redo_log_size_in_bytes"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_snapshots
        )

        def __get_snapshots_day_ranges(
            self,
            timeflow_id,
            **kwargs
        ):
            """Returns the count of TimeFlow snapshots of the timeflow aggregated by day. The time zone \\ used to perform the computation is the time zone of the last snapshot of the timeflow.   # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_snapshots_day_ranges(timeflow_id, async_req=True)
            >>> result = thread.get()

            Args:
                timeflow_id (str): The TimeFlow to aggregate snapshots from.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SnapshotsDayRangesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['timeflow_id'] = \
                timeflow_id
            return self.call_with_http_info(**kwargs)

        self.get_snapshots_day_ranges = _Endpoint(
            settings={
                'response_type': (SnapshotsDayRangesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/snapshots/dayRanges',
                'operation_id': 'get_snapshots_day_ranges',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'timeflow_id',
                ],
                'required': [
                    'timeflow_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'timeflow_id',
                ]
            },
            root_map={
                'validations': {
                    ('timeflow_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'timeflow_id':
                        (str,),
                },
                'attribute_map': {
                    'timeflow_id': 'timeflow_id',
                },
                'location_map': {
                    'timeflow_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_snapshots_day_ranges
        )

        def __search_snapshots(
            self,
            **kwargs
        ):
            """Search snapshots.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_snapshots(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchSnapshotsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_snapshots = _Endpoint(
            settings={
                'response_type': (SearchSnapshotsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/snapshots/search',
                'operation_id': 'search_snapshots',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "NAMESPACE": "namespace",
                        "-NAMESPACE": "-namespace",
                        "NAME": "name",
                        "-NAME": "-name",
                        "CONSISTENCY": "consistency",
                        "-CONSISTENCY": "-consistency",
                        "MISSING_NON_LOGGED_DATA": "missing_non_logged_data",
                        "-MISSING_NON_LOGGED_DATA": "-missing_non_logged_data",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "CREATION_TIME": "creation_time",
                        "-CREATION_TIME": "-creation_time",
                        "START_TIMESTAMP": "start_timestamp",
                        "-START_TIMESTAMP": "-start_timestamp",
                        "START_LOCATION": "start_location",
                        "-START_LOCATION": "-start_location",
                        "TIMESTAMP": "timestamp",
                        "-TIMESTAMP": "-timestamp",
                        "LOCATION": "location",
                        "-LOCATION": "-location",
                        "RETENTION": "retention",
                        "-RETENTION": "-retention",
                        "TIMEFLOW_ID": "timeflow_id",
                        "-TIMEFLOW_ID": "-timeflow_id",
                        "TIMEZONE": "timezone",
                        "-TIMEZONE": "-timezone",
                        "VERSION": "version",
                        "-VERSION": "-version",
                        "TEMPORARY": "temporary",
                        "-TEMPORARY": "-temporary",
                        "APPDATA_TOOLKIT": "appdata_toolkit",
                        "-APPDATA_TOOLKIT": "-appdata_toolkit",
                        "APPDATA_METADATA": "appdata_metadata",
                        "-APPDATA_METADATA": "-appdata_metadata",
                        "ASE_DB_ENCRYPTION_KEY": "ase_db_encryption_key",
                        "-ASE_DB_ENCRYPTION_KEY": "-ase_db_encryption_key",
                        "MSSQL_INTERNAL_VERSION": "mssql_internal_version",
                        "-MSSQL_INTERNAL_VERSION": "-mssql_internal_version",
                        "MSSQL_BACKUP_SET_UUID": "mssql_backup_set_uuid",
                        "-MSSQL_BACKUP_SET_UUID": "-mssql_backup_set_uuid",
                        "MSSQL_BACKUP_SOFTWARE_TYPE": "mssql_backup_software_type",
                        "-MSSQL_BACKUP_SOFTWARE_TYPE": "-mssql_backup_software_type",
                        "MSSQL_BACKUP_LOCATION_TYPE": "mssql_backup_location_type",
                        "-MSSQL_BACKUP_LOCATION_TYPE": "-mssql_backup_location_type",
                        "MSSQL_EMPTY_SNAPSHOT": "mssql_empty_snapshot",
                        "-MSSQL_EMPTY_SNAPSHOT": "-mssql_empty_snapshot",
                        "ORACLE_FROM_PHYSICAL_STANDBY_VDB": "oracle_from_physical_standby_vdb",
                        "-ORACLE_FROM_PHYSICAL_STANDBY_VDB": "-oracle_from_physical_standby_vdb",
                        "ORACLE_REDO_LOG_SIZE_IN_BYTES": "oracle_redo_log_size_in_bytes",
                        "-ORACLE_REDO_LOG_SIZE_IN_BYTES": "-oracle_redo_log_size_in_bytes"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_snapshots
        )
