# delphix-dct-api
Delphix DCT API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.1.0
- Package version: 5.0.0-rc3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import accounts_api
from delphix.api.gateway.model.account import Account
from delphix.api.gateway.model.account_create_parameter import AccountCreateParameter
from delphix.api.gateway.model.account_create_response import AccountCreateResponse
from delphix.api.gateway.model.account_update_parameter import AccountUpdateParameter
from delphix.api.gateway.model.change_password_parameter import ChangePasswordParameter
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_accounts_response import ListAccountsResponse
from delphix.api.gateway.model.password_policies_params import PasswordPoliciesParams
from delphix.api.gateway.model.reset_password_parameter import ResetPasswordParameter
from delphix.api.gateway.model.search_accounts_response import SearchAccountsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
# Defining the host is optional and defaults to http://localhost/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = accounts_api.AccountsApi(api_client)
    id = 1 # int | Numeric ID of the Account.
change_password_parameter = ChangePasswordParameter(
        old_password="old_password_example",
        new_password="new_password_example",
    ) # ChangePasswordParameter | 

    try:
        # Change Account Password. 
        api_instance.change_account_password(id, change_password_parameter)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling AccountsApi->change_account_password: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**change_account_password**](docs/AccountsApi.md#change_account_password) | **POST** /management/accounts/{id}/change_password | Change Account Password. 
*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /management/accounts | Create a new Account 
*AccountsApi* | [**create_account_tags**](docs/AccountsApi.md#create_account_tags) | **POST** /management/accounts/{id}/tags | Create tags for an Account.
*AccountsApi* | [**delete_account**](docs/AccountsApi.md#delete_account) | **DELETE** /management/accounts/{id} | Delete an Account
*AccountsApi* | [**delete_account_tags**](docs/AccountsApi.md#delete_account_tags) | **POST** /management/accounts/{id}/tags/delete | Delete tags for an Account.
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /management/accounts/{id} | Get an Account by id
*AccountsApi* | [**get_account_tags**](docs/AccountsApi.md#get_account_tags) | **GET** /management/accounts/{id}/tags | Get tags for an Account.
*AccountsApi* | [**get_accounts**](docs/AccountsApi.md#get_accounts) | **GET** /management/accounts | Returns a list of Accounts
*AccountsApi* | [**get_password_policies**](docs/AccountsApi.md#get_password_policies) | **GET** /management/accounts/password-policies | Returns the password policies
*AccountsApi* | [**reset_account_password**](docs/AccountsApi.md#reset_account_password) | **POST** /management/accounts/{id}/reset_password | Reset Account Password. 
*AccountsApi* | [**search_accounts**](docs/AccountsApi.md#search_accounts) | **POST** /management/accounts/search | Search for Accounts.
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /management/accounts/{id} | Update an Account 
*AccountsApi* | [**update_password_policies**](docs/AccountsApi.md#update_password_policies) | **PATCH** /management/accounts/password-policies | Update password policies.
*AuthorizationApi* | [**add_access_group_account_ids**](docs/AuthorizationApi.md#add_access_group_account_ids) | **POST** /access-groups/{accessGroupId}/account-ids | Add account ids to an Access group
*AuthorizationApi* | [**add_access_group_account_tags**](docs/AuthorizationApi.md#add_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags | Add account tags to an Access group
*AuthorizationApi* | [**add_access_group_scopes**](docs/AuthorizationApi.md#add_access_group_scopes) | **POST** /access-groups/{accessGroupId}/scopes | Add scopes to an Access group
*AuthorizationApi* | [**add_always_allowed_permissions**](docs/AuthorizationApi.md#add_always_allowed_permissions) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions | Add always allowed permissions for given object type.
*AuthorizationApi* | [**add_objects_to_access_group_scope**](docs/AuthorizationApi.md#add_objects_to_access_group_scope) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/objects | Add objects to the access group scope.
*AuthorizationApi* | [**add_role_permissions**](docs/AuthorizationApi.md#add_role_permissions) | **POST** /roles/{roleId}/permissions | Add permissions to a role.
*AuthorizationApi* | [**add_tags_to_scope**](docs/AuthorizationApi.md#add_tags_to_scope) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/object-tags | Add object tags to the access group scope.
*AuthorizationApi* | [**create_access_group**](docs/AuthorizationApi.md#create_access_group) | **POST** /access-groups | Create a new access group.
*AuthorizationApi* | [**create_role**](docs/AuthorizationApi.md#create_role) | **POST** /roles | Create custom role
*AuthorizationApi* | [**delete_access_group**](docs/AuthorizationApi.md#delete_access_group) | **DELETE** /access-groups/{accessGroupId} | Delete an Access group.
*AuthorizationApi* | [**delete_access_group_scope_object_tags**](docs/AuthorizationApi.md#delete_access_group_scope_object_tags) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/object-tags/delete | Remove tags from the access group scope.
*AuthorizationApi* | [**delete_access_group_scope_objects**](docs/AuthorizationApi.md#delete_access_group_scope_objects) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/objects/delete | Remove objects from the access group scope.
*AuthorizationApi* | [**delete_role**](docs/AuthorizationApi.md#delete_role) | **DELETE** /roles/{roleId} | Delete role by ID.
*AuthorizationApi* | [**get_access_group_by_id**](docs/AuthorizationApi.md#get_access_group_by_id) | **GET** /access-groups/{accessGroupId} | Returns an Access group by ID.
*AuthorizationApi* | [**get_access_group_scope**](docs/AuthorizationApi.md#get_access_group_scope) | **GET** /access-groups/{accessGroupId}/scopes/{scopeId} | Get access group scope.
*AuthorizationApi* | [**get_access_groups**](docs/AuthorizationApi.md#get_access_groups) | **GET** /access-groups | List all access groups.
*AuthorizationApi* | [**get_all_object_permissions**](docs/AuthorizationApi.md#get_all_object_permissions) | **GET** /auth/object-permissions | Returns all of the possible permissions for all of the objects.
*AuthorizationApi* | [**get_object_permissions**](docs/AuthorizationApi.md#get_object_permissions) | **GET** /auth/permissions/objects/{objectType}/{objectId} | Returns permissions for given object.
*AuthorizationApi* | [**get_role_by_id**](docs/AuthorizationApi.md#get_role_by_id) | **GET** /roles/{roleId} | Returns role by ID.
*AuthorizationApi* | [**get_roles**](docs/AuthorizationApi.md#get_roles) | **GET** /roles | List all roles
*AuthorizationApi* | [**remove_access_group_account_id**](docs/AuthorizationApi.md#remove_access_group_account_id) | **DELETE** /access-groups/{accessGroupId}/account-ids/{accountId} | Remove the account from the access group.
*AuthorizationApi* | [**remove_access_group_account_tags**](docs/AuthorizationApi.md#remove_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags/delete | Remove account tags from an access group.
*AuthorizationApi* | [**remove_access_group_scope**](docs/AuthorizationApi.md#remove_access_group_scope) | **DELETE** /access-groups/{accessGroupId}/scopes/{scopeId} | Remove the scope from the Access group.
*AuthorizationApi* | [**remove_always_allowed_permissions**](docs/AuthorizationApi.md#remove_always_allowed_permissions) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions/delete | Remove always allowed permissions for given object type.
*AuthorizationApi* | [**remove_role_permissions**](docs/AuthorizationApi.md#remove_role_permissions) | **POST** /roles/{roleId}/permissions/delete | Remove permissions from a role.
*AuthorizationApi* | [**search_access_groups**](docs/AuthorizationApi.md#search_access_groups) | **POST** /access-groups/search | Search for access groups.
*AuthorizationApi* | [**search_roles**](docs/AuthorizationApi.md#search_roles) | **POST** /roles/search | Search for roles.
*AuthorizationApi* | [**update_access_group**](docs/AuthorizationApi.md#update_access_group) | **PATCH** /access-groups/{accessGroupId} | Update an Access group.
*AuthorizationApi* | [**update_access_group_scope**](docs/AuthorizationApi.md#update_access_group_scope) | **PATCH** /access-groups/{accessGroupId}/scopes/{scopeId} | Update access group scope.
*AuthorizationApi* | [**update_role**](docs/AuthorizationApi.md#update_role) | **PATCH** /roles/{roleId} | Update a Role.
*BookmarksApi* | [**create_bookmark**](docs/BookmarksApi.md#create_bookmark) | **POST** /bookmarks | Create a bookmark at the current time.
*BookmarksApi* | [**create_bookmark_tags**](docs/BookmarksApi.md#create_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags | Create tags for a Bookmark.
*BookmarksApi* | [**delete_bookmark**](docs/BookmarksApi.md#delete_bookmark) | **DELETE** /bookmarks/{bookmarkId} | Delete a bookmark.
*BookmarksApi* | [**delete_bookmark_tags**](docs/BookmarksApi.md#delete_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags/delete | Delete tags for a Bookmark.
*BookmarksApi* | [**get_bookmark_by_id**](docs/BookmarksApi.md#get_bookmark_by_id) | **GET** /bookmarks/{bookmarkId} | Get a bookmark by ID.
*BookmarksApi* | [**get_bookmark_tags**](docs/BookmarksApi.md#get_bookmark_tags) | **GET** /bookmarks/{bookmarkId}/tags | Get tags for a Bookmark.
*BookmarksApi* | [**get_bookmarks**](docs/BookmarksApi.md#get_bookmarks) | **GET** /bookmarks | List all bookmarks.
*BookmarksApi* | [**get_vdb_groups_by_bookmark**](docs/BookmarksApi.md#get_vdb_groups_by_bookmark) | **GET** /bookmarks/{bookmarkId}/vdb-groups | List VDB Groups compatible with this bookmark.
*BookmarksApi* | [**search_bookmarks**](docs/BookmarksApi.md#search_bookmarks) | **POST** /bookmarks/search | Search for bookmarks.
*CDBsApi* | [**create_cdb_tags**](docs/CDBsApi.md#create_cdb_tags) | **POST** /cdbs/{cdbId}/tags | Create tags for a CDB.
*CDBsApi* | [**delete_cdb_tags**](docs/CDBsApi.md#delete_cdb_tags) | **POST** /cdbs/{cdbId}/tags/delete | Delete tags for a CDB.
*CDBsApi* | [**get_cdb_by_id**](docs/CDBsApi.md#get_cdb_by_id) | **GET** /cdbs/{cdbId} | Get a CDB by ID (Oracle only).
*CDBsApi* | [**get_cdbs**](docs/CDBsApi.md#get_cdbs) | **GET** /cdbs | List all CDBs (Oracle only).
*CDBsApi* | [**get_tags_cdb**](docs/CDBsApi.md#get_tags_cdb) | **GET** /cdbs/{cdbId}/tags | Get tags for a CDB.
*CDBsApi* | [**search_cdbs**](docs/CDBsApi.md#search_cdbs) | **POST** /cdbs/search | Search for CDBs (Oracle only).
*ConnectivityApi* | [**connectivity_check**](docs/ConnectivityApi.md#connectivity_check) | **POST** /connectivity/check | Checks connectivity between an engine and a remote host machine on a given port.
*ConnectorsApi* | [**connectors_test**](docs/ConnectorsApi.md#connectors_test) | **POST** /connectors/{connectorId}/test | Checks connectivity between a masking engine and a remote data source.
*ConnectorsApi* | [**get_connector_by_id**](docs/ConnectorsApi.md#get_connector_by_id) | **GET** /connectors/{connectorId} | Retrieve a masking Connector by ID.
*ConnectorsApi* | [**get_connectors**](docs/ConnectorsApi.md#get_connectors) | **GET** /connectors | Retrieve the list of masking connectors.
*ConnectorsApi* | [**search_connectors**](docs/ConnectorsApi.md#search_connectors) | **POST** /connectors/search | Search for masking Connectors.
*ConnectorsApi* | [**update_connector_by_id**](docs/ConnectorsApi.md#update_connector_by_id) | **PATCH** /connectors/{connectorId} | Update a masking Connector by ID.
*DSourcesApi* | [**create_tags_dsource**](docs/DSourcesApi.md#create_tags_dsource) | **POST** /dsources/{dsourceId}/tags | Create tags for a dSource.
*DSourcesApi* | [**delete_tags_dsource**](docs/DSourcesApi.md#delete_tags_dsource) | **POST** /dsources/{dsourceId}/tags/delete | Delete tags for a dSource.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsource_snapshots**](docs/DSourcesApi.md#get_dsource_snapshots) | **GET** /dsources/{dsourceId}/snapshots | List Snapshots for a dSource.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*DSourcesApi* | [**get_tags_dsource**](docs/DSourcesApi.md#get_tags_dsource) | **GET** /dsources/{dsourceId}/tags | Get tags for a dSource.
*DSourcesApi* | [**search_dsources**](docs/DSourcesApi.md#search_dsources) | **POST** /dsources/search | Search for DSources.
*DSourcesApi* | [**snapshot_dsource**](docs/DSourcesApi.md#snapshot_dsource) | **POST** /dsources/{dsourceId}/snapshots | Snapshot a DSource.
*DatabaseTemplatesApi* | [**create_database_template**](docs/DatabaseTemplatesApi.md#create_database_template) | **POST** /database-templates | Create a database template.
*DatabaseTemplatesApi* | [**delete_database_template**](docs/DatabaseTemplatesApi.md#delete_database_template) | **DELETE** /database-templates/{databaseTemplateId} | Delete a DatabaseTemplate by ID.
*DatabaseTemplatesApi* | [**get_database_template_by_id**](docs/DatabaseTemplatesApi.md#get_database_template_by_id) | **GET** /database-templates/{databaseTemplateId} | Retrieve a DatabaseTemplate by ID.
*DatabaseTemplatesApi* | [**get_database_templates**](docs/DatabaseTemplatesApi.md#get_database_templates) | **GET** /database-templates | Retrieve the list of database templates.
*DatabaseTemplatesApi* | [**import_database_templates**](docs/DatabaseTemplatesApi.md#import_database_templates) | **POST** /database-templates/import | Imports the database templates from an an engine.
*DatabaseTemplatesApi* | [**search_database_templates**](docs/DatabaseTemplatesApi.md#search_database_templates) | **POST** /database-templates/search | Search DatabaseTemplates.
*DatabaseTemplatesApi* | [**undo_import_database_templates**](docs/DatabaseTemplatesApi.md#undo_import_database_templates) | **POST** /database-templates/undo-import | Undo an import of DatabaseTemplates on a engine.
*DatabaseTemplatesApi* | [**update_database_template**](docs/DatabaseTemplatesApi.md#update_database_template) | **PATCH** /database-templates/{databaseTemplateId} | Updates a DatabaseTemplate by ID
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /environments | Create an environment.
*EnvironmentsApi* | [**create_environment_tags**](docs/EnvironmentsApi.md#create_environment_tags) | **POST** /environments/{environmentId}/tags | Create tags for an Environment.
*EnvironmentsApi* | [**create_environment_user**](docs/EnvironmentsApi.md#create_environment_user) | **POST** /environments/{environmentId}/users | Create environment user.
*EnvironmentsApi* | [**create_host**](docs/EnvironmentsApi.md#create_host) | **POST** /environments/{environmentId}/hosts | Create a new Host.
*EnvironmentsApi* | [**delete_environment**](docs/EnvironmentsApi.md#delete_environment) | **DELETE** /environments/{environmentId} | Delete an environment by ID.
*EnvironmentsApi* | [**delete_environment_tags**](docs/EnvironmentsApi.md#delete_environment_tags) | **POST** /environments/{environmentId}/tags/delete | Delete tags for an Environment.
*EnvironmentsApi* | [**delete_environment_user**](docs/EnvironmentsApi.md#delete_environment_user) | **DELETE** /environments/{environmentId}/users/{userRef} | Delete environment user.
*EnvironmentsApi* | [**delete_host**](docs/EnvironmentsApi.md#delete_host) | **DELETE** /environments/{environmentId}/hosts/{hostId} | Delete a Host.
*EnvironmentsApi* | [**disable_environment**](docs/EnvironmentsApi.md#disable_environment) | **POST** /environments/{environmentId}/disable | Disable environment.
*EnvironmentsApi* | [**enable_environment**](docs/EnvironmentsApi.md#enable_environment) | **POST** /environments/{environmentId}/enable | Enable a disabled environment.
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /environments/{environmentId} | Returns an environment by ID.
*EnvironmentsApi* | [**get_environments**](docs/EnvironmentsApi.md#get_environments) | **GET** /environments | List all environments.
*EnvironmentsApi* | [**get_tags_environment**](docs/EnvironmentsApi.md#get_tags_environment) | **GET** /environments/{environmentId}/tags | Get tags for an Environment.
*EnvironmentsApi* | [**list_environment_users**](docs/EnvironmentsApi.md#list_environment_users) | **GET** /environments/{environmentId}/users | List environment users.
*EnvironmentsApi* | [**primary_environment_user**](docs/EnvironmentsApi.md#primary_environment_user) | **POST** /environments/{environmentId}/users/{userRef}/primary | Set primary environment user.
*EnvironmentsApi* | [**refresh_environment**](docs/EnvironmentsApi.md#refresh_environment) | **POST** /environments/{environmentId}/refresh | Refresh environment.
*EnvironmentsApi* | [**search_environments**](docs/EnvironmentsApi.md#search_environments) | **POST** /environments/search | Search for environments.
*EnvironmentsApi* | [**update_environment**](docs/EnvironmentsApi.md#update_environment) | **PATCH** /environments/{environmentId} | Update an environment by ID.
*EnvironmentsApi* | [**update_environment_user**](docs/EnvironmentsApi.md#update_environment_user) | **PUT** /environments/{environmentId}/users/{userRef} | Update environment user.
*EnvironmentsApi* | [**update_host**](docs/EnvironmentsApi.md#update_host) | **PATCH** /environments/{environmentId}/hosts/{hostId} | Update a Host.
*ExecutionsApi* | [**cancel_execution**](docs/ExecutionsApi.md#cancel_execution) | **POST** /executions/{executionId}/cancel | Cancel an Execution.
*ExecutionsApi* | [**get_execution_by_id**](docs/ExecutionsApi.md#get_execution_by_id) | **GET** /executions/{executionId} | Retrieve an Execution by ID.
*ExecutionsApi* | [**get_executions**](docs/ExecutionsApi.md#get_executions) | **GET** /executions | Retrieve the list of masking executions.
*ExecutionsApi* | [**search_executions**](docs/ExecutionsApi.md#search_executions) | **POST** /executions/search | Search masking executions.
*JobsApi* | [**abandon_job**](docs/JobsApi.md#abandon_job) | **POST** /jobs/{jobId}/abandon | Abandons a job.
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /jobs/{jobId} | Returns a job by ID.
*JobsApi* | [**get_jobs**](docs/JobsApi.md#get_jobs) | **GET** /jobs | List all jobs.
*JobsApi* | [**search_jobs**](docs/JobsApi.md#search_jobs) | **POST** /jobs/search | Search for jobs.
*LoginApi* | [**account_login**](docs/LoginApi.md#account_login) | **POST** /login | Login to Account with Username and Password 
*LoginApi* | [**token_info**](docs/LoginApi.md#token_info) | **POST** /token-info | Get Token Information 
*ManagementApi* | [**create_engine_tags**](docs/ManagementApi.md#create_engine_tags) | **POST** /management/engines/{engineId}/tags | Create tags for a engine.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**delete_engine_tags**](docs/ManagementApi.md#delete_engine_tags) | **POST** /management/engines/{engineId}/tags/delete | Delete tags for an Engine.
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**get_api_classification**](docs/ManagementApi.md#get_api_classification) | **GET** /management/api-classification | Get api classification.
*ManagementApi* | [**get_engine_tags**](docs/ManagementApi.md#get_engine_tags) | **GET** /management/engines/{engineId}/tags | Get tags for a Engine.
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vaults**](docs/ManagementApi.md#get_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**get_ldap_config**](docs/ManagementApi.md#get_ldap_config) | **GET** /management/ldap-config | Returns the LDAP configuration
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**get_registered_engines**](docs/ManagementApi.md#get_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**get_saml_config**](docs/ManagementApi.md#get_saml_config) | **GET** /management/saml-config | Returns the SAML configuration
*ManagementApi* | [**get_smtp_config**](docs/ManagementApi.md#get_smtp_config) | **GET** /management/smtp | Returns the SMTP configuration
*ManagementApi* | [**list_properties**](docs/ManagementApi.md#list_properties) | **GET** /management/properties | Get global properties.
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**search_engines**](docs/ManagementApi.md#search_engines) | **POST** /management/engines/search | Search for engines.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_api_classification**](docs/ManagementApi.md#update_api_classification) | **PUT** /management/api-classification | Update the api classification to new version.
*ManagementApi* | [**update_ldap_config**](docs/ManagementApi.md#update_ldap_config) | **PUT** /management/ldap-config | Update LDAP Config.
*ManagementApi* | [**update_properties**](docs/ManagementApi.md#update_properties) | **PATCH** /management/properties | Update value of predefined properties.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*ManagementApi* | [**update_saml_config**](docs/ManagementApi.md#update_saml_config) | **PUT** /management/saml-config | Update SAML Config.
*ManagementApi* | [**update_smtp_config**](docs/ManagementApi.md#update_smtp_config) | **PUT** /management/smtp | Update SMTP Config.
*ManagementApi* | [**validate_ldap_config**](docs/ManagementApi.md#validate_ldap_config) | **POST** /management/ldap-config/validate | Validate LDAP Config. Without username/password, DCT performs an anonymous bind against the LDAP server. If credentials are provided DCT validates that authentication and mapping of optional properties are actually working with provided credentials. LDAP search is only validated if search attributes are set.
*ManagementApi* | [**validate_smtp_config**](docs/ManagementApi.md#validate_smtp_config) | **POST** /management/smtp/validate | Validate SMTP Config.
*MaskingJobsApi* | [**copy_masking_job**](docs/MaskingJobsApi.md#copy_masking_job) | **POST** /masking-jobs/{maskingJobId}/copy | Copies the masking job to another engine.
*MaskingJobsApi* | [**create_masking_job_tag**](docs/MaskingJobsApi.md#create_masking_job_tag) | **POST** /masking-jobs/{maskingJobId}/tags | Create tags for a Masking Job.
*MaskingJobsApi* | [**delete_masking_job**](docs/MaskingJobsApi.md#delete_masking_job) | **DELETE** /masking-jobs/{maskingJobId} | Delete a masking job.
*MaskingJobsApi* | [**delete_masking_job_tag**](docs/MaskingJobsApi.md#delete_masking_job_tag) | **POST** /masking-jobs/{maskingJobId}/tags/delete | Delete tags for a Masking Job.
*MaskingJobsApi* | [**execute_masking_job**](docs/MaskingJobsApi.md#execute_masking_job) | **POST** /masking-jobs/{maskingJobId}/execute | Execute a MaskingJob.
*MaskingJobsApi* | [**get_masking_job_by_id**](docs/MaskingJobsApi.md#get_masking_job_by_id) | **GET** /masking-jobs/{maskingJobId} | Retrieve a MaskingJob by ID.
*MaskingJobsApi* | [**get_masking_job_connectors**](docs/MaskingJobsApi.md#get_masking_job_connectors) | **GET** /masking-jobs/{maskingJobId}/connectors | Get connectors for a Masking Job by ID.
*MaskingJobsApi* | [**get_masking_job_source_engines**](docs/MaskingJobsApi.md#get_masking_job_source_engines) | **GET** /masking-jobs/source-engines | Retrieve the list of masking jobs along with their source engine.
*MaskingJobsApi* | [**get_masking_job_tag**](docs/MaskingJobsApi.md#get_masking_job_tag) | **GET** /masking-jobs/{maskingJobId}/tags | Get tags for a Masking Job.
*MaskingJobsApi* | [**get_masking_jobs**](docs/MaskingJobsApi.md#get_masking_jobs) | **GET** /masking-jobs | Retrieve the list of masking jobs.
*MaskingJobsApi* | [**migrate_masking_job**](docs/MaskingJobsApi.md#migrate_masking_job) | **POST** /masking-jobs/{maskingJobId}/migrate | Migrates the masking job from its current source engine to another engine.
*MaskingJobsApi* | [**search_masking_job_source_engines**](docs/MaskingJobsApi.md#search_masking_job_source_engines) | **POST** /masking-jobs/source-engines/search | Search the list of masking jobs along with their source engine.
*MaskingJobsApi* | [**search_masking_jobs**](docs/MaskingJobsApi.md#search_masking_jobs) | **POST** /masking-jobs/search | Search masking jobs.
*MaskingJobsApi* | [**update_masking_job_by_id**](docs/MaskingJobsApi.md#update_masking_job_by_id) | **PATCH** /masking-jobs/{maskingJobId} | Update values of a MaskingJob.
*ReportingApi* | [**create_reporting_schedule**](docs/ReportingApi.md#create_reporting_schedule) | **POST** /reporting/schedule | Create a new report schedule.
*ReportingApi* | [**delete_reporting_schedule**](docs/ReportingApi.md#delete_reporting_schedule) | **DELETE** /reporting/schedule/{reportId} | Delete report schedule by ID.
*ReportingApi* | [**get_api_usage_report**](docs/ReportingApi.md#get_api_usage_report) | **GET** /reporting/api-usage-report | Gets the report of API usage metrics over a given time period.
*ReportingApi* | [**get_dsource_consumption_report**](docs/ReportingApi.md#get_dsource_consumption_report) | **GET** /reporting/dsource-consumption-report | Gets the consumption report for virtualization engine dSources.
*ReportingApi* | [**get_dsource_usage_report**](docs/ReportingApi.md#get_dsource_usage_report) | **GET** /reporting/dsource-usage-report | Gets the usage report for virtualization engine dSources.
*ReportingApi* | [**get_product_info**](docs/ReportingApi.md#get_product_info) | **GET** /reporting/product_info | Returns the DCT Product Information.
*ReportingApi* | [**get_reporting_schedule_by_id**](docs/ReportingApi.md#get_reporting_schedule_by_id) | **GET** /reporting/schedule/{reportId} | Returns a report schedule by ID.
*ReportingApi* | [**get_reporting_schedules**](docs/ReportingApi.md#get_reporting_schedules) | **GET** /reporting/schedule | List all report schedules.
*ReportingApi* | [**get_vdb_inventory_report**](docs/ReportingApi.md#get_vdb_inventory_report) | **GET** /reporting/vdb-inventory-report | Gets the inventory report for virtualization engine VDBs.
*ReportingApi* | [**get_virtualization_storage_summary_report**](docs/ReportingApi.md#get_virtualization_storage_summary_report) | **GET** /reporting/virtualization-storage-summary-report | Gets the storage summary report for virtualization engines.
*ReportingApi* | [**search_dsource_consumption_report**](docs/ReportingApi.md#search_dsource_consumption_report) | **POST** /reporting/dsource-consumption-report/search | Search the consumption report for virtualization engine DSources.
*ReportingApi* | [**search_dsource_usage_report**](docs/ReportingApi.md#search_dsource_usage_report) | **POST** /reporting/dsource-usage-report/search | Search the usage report for virtualization engine dSources.
*ReportingApi* | [**search_vdb_inventory_report**](docs/ReportingApi.md#search_vdb_inventory_report) | **POST** /reporting/vdb-inventory-report/search | Search the inventory report for virtualization engine VDBs.
*ReportingApi* | [**search_virtualization_storage_summary_report**](docs/ReportingApi.md#search_virtualization_storage_summary_report) | **POST** /reporting/virtualization-storage-summary-report/search | Search the storage summary report for virtualization engines.
*ReportingApi* | [**update_reporting_schedule**](docs/ReportingApi.md#update_reporting_schedule) | **PUT** /reporting/schedule/{reportId} | Update a reporting schedule by ID.
*SamlLoginApi* | [**check_saml**](docs/SamlLoginApi.md#check_saml) | **GET** /is-saml-enabled | Check if SAML is enabled 
*SnapshotsApi* | [**get_snapshot_by_id**](docs/SnapshotsApi.md#get_snapshot_by_id) | **GET** /snapshots/{snapshotId} | Get a Snapshot by ID.
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /snapshots | Retrieve the list of snapshots.
*SnapshotsApi* | [**get_snapshots_day_ranges**](docs/SnapshotsApi.md#get_snapshots_day_ranges) | **GET** /snapshots/dayRanges | Returns the count of TimeFlow snapshots of the timeflow aggregated by day. The time zone \\ used to perform the computation is the time zone of the last snapshot of the timeflow. 
*SnapshotsApi* | [**search_snapshots**](docs/SnapshotsApi.md#search_snapshots) | **POST** /snapshots/search | Search snapshots.
*SourcesApi* | [**create_source_tags**](docs/SourcesApi.md#create_source_tags) | **POST** /sources/{sourceId}/tags | Create tags for a Source.
*SourcesApi* | [**delete_source_tags**](docs/SourcesApi.md#delete_source_tags) | **POST** /sources/{sourceId}/tags/delete | Delete tags for a Source.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_source_tags**](docs/SourcesApi.md#get_source_tags) | **GET** /sources/{sourceId}/tags | Get tags for a Source.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*SourcesApi* | [**search_sources**](docs/SourcesApi.md#search_sources) | **POST** /sources/search | Search for Sources.
*TestApi* | [**time_to_update_sources**](docs/TestApi.md#time_to_update_sources) | **POST** /time-to-update-sources | set sources loop count variable - this is being used during performance testing.
*VCDBsApi* | [**create_vcdb_tags**](docs/VCDBsApi.md#create_vcdb_tags) | **POST** /vcdbs/{vcdbId}/tags | Create tags for a vCDB.
*VCDBsApi* | [**delete_vcdb_tags**](docs/VCDBsApi.md#delete_vcdb_tags) | **POST** /vcdbs/{vcdbId}/tags/delete | Delete tags for a vCDB.
*VCDBsApi* | [**get_tags_vcdb**](docs/VCDBsApi.md#get_tags_vcdb) | **GET** /vcdbs/{vcdbId}/tags | Get tags for a vCDB.
*VCDBsApi* | [**get_vcdb_by_id**](docs/VCDBsApi.md#get_vcdb_by_id) | **GET** /vcdbs/{vcdbId} | Get a CDB by ID (Oracle only).
*VCDBsApi* | [**get_vcdbs**](docs/VCDBsApi.md#get_vcdbs) | **GET** /vcdbs | List all vCDBs (Oracle only).
*VCDBsApi* | [**search_vcdbs**](docs/VCDBsApi.md#search_vcdbs) | **POST** /vcdbs/search | Search for vCDBs (Oracle only).
*VDBGroupsApi* | [**create_vdb_group**](docs/VDBGroupsApi.md#create_vdb_group) | **POST** /vdb-groups | Create a new VDBGroup.
*VDBGroupsApi* | [**create_vdb_groups_tags**](docs/VDBGroupsApi.md#create_vdb_groups_tags) | **POST** /vdb-groups/{vdbGroupId}/tags | Create tags for a VDB Group.
*VDBGroupsApi* | [**delete_vdb_group**](docs/VDBGroupsApi.md#delete_vdb_group) | **DELETE** /vdb-groups/{vdbGroupId} | Delete a VDBGoup.
*VDBGroupsApi* | [**delete_vdb_group_tags**](docs/VDBGroupsApi.md#delete_vdb_group_tags) | **POST** /vdb-groups/{vdbGroupId}/tags/delete | Delete tags for a VDB Group.
*VDBGroupsApi* | [**get_bookmarks_by_vdb_group**](docs/VDBGroupsApi.md#get_bookmarks_by_vdb_group) | **GET** /vdb-groups/{vdbGroupId}/bookmarks | List bookmarks compatible with this VDB Group.
*VDBGroupsApi* | [**get_vdb_group**](docs/VDBGroupsApi.md#get_vdb_group) | **GET** /vdb-groups/{vdbGroupId} | Get a VDBGroup by name.
*VDBGroupsApi* | [**get_vdb_group_tags**](docs/VDBGroupsApi.md#get_vdb_group_tags) | **GET** /vdb-groups/{vdbGroupId}/tags | Get tags for a VDB Group.
*VDBGroupsApi* | [**get_vdb_groups**](docs/VDBGroupsApi.md#get_vdb_groups) | **GET** /vdb-groups | List all VDBGroups.
*VDBGroupsApi* | [**provision_vdb_group_from_bookmark**](docs/VDBGroupsApi.md#provision_vdb_group_from_bookmark) | **POST** /vdb-groups/provision_from_bookmark | Provision a new VDB Group from a Bookmark.
*VDBGroupsApi* | [**refresh_vdb_group**](docs/VDBGroupsApi.md#refresh_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/refresh | Refresh a VDBGroup.
*VDBGroupsApi* | [**rollback_vdb_group**](docs/VDBGroupsApi.md#rollback_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/rollback | Rollback a VDBGroup.
*VDBGroupsApi* | [**search_vdb_groups**](docs/VDBGroupsApi.md#search_vdb_groups) | **POST** /vdb-groups/search | Search for VDB Groups.
*VDBGroupsApi* | [**update_vdb_group_by_id**](docs/VDBGroupsApi.md#update_vdb_group_by_id) | **PATCH** /vdb-groups/{vdbGroupId} | Update values of a VDB group.
*VDBsApi* | [**create_vdb_tags**](docs/VDBsApi.md#create_vdb_tags) | **POST** /vdbs/{vdbId}/tags | Create tags for a VDB.
*VDBsApi* | [**delete_vdb**](docs/VDBsApi.md#delete_vdb) | **POST** /vdbs/{vdbId}/delete | Delete a VDB.
*VDBsApi* | [**delete_vdb_tags**](docs/VDBsApi.md#delete_vdb_tags) | **POST** /vdbs/{vdbId}/tags/delete | Delete tags for a VDB.
*VDBsApi* | [**disable_vdb**](docs/VDBsApi.md#disable_vdb) | **POST** /vdbs/{vdbId}/disable | Disable a VDB.
*VDBsApi* | [**enable_vdb**](docs/VDBsApi.md#enable_vdb) | **POST** /vdbs/{vdbId}/enable | Enable a VDB.
*VDBsApi* | [**get_tags_vdb**](docs/VDBsApi.md#get_tags_vdb) | **GET** /vdbs/{vdbId}/tags | Get tags for a VDB.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdb_snapshots**](docs/VDBsApi.md#get_vdb_snapshots) | **GET** /vdbs/{vdbId}/snapshots | List Snapshots for a VDB.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.
*VDBsApi* | [**provision_vdb_by_snapshot**](docs/VDBsApi.md#provision_vdb_by_snapshot) | **POST** /vdbs/provision_by_snapshot | Provision a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_snapshot_defaults**](docs/VDBsApi.md#provision_vdb_by_snapshot_defaults) | **POST** /vdbs/provision_by_snapshot/defaults | Get default provision parameters for provisioning a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_timestamp**](docs/VDBsApi.md#provision_vdb_by_timestamp) | **POST** /vdbs/provision_by_timestamp | Provision a new VDB by timestamp.
*VDBsApi* | [**provision_vdb_from_bookmark**](docs/VDBsApi.md#provision_vdb_from_bookmark) | **POST** /vdbs/provision_from_bookmark | Provision a new VDB from a bookmark with a single VDB.
*VDBsApi* | [**provision_vdb_from_bookmark_defaults**](docs/VDBsApi.md#provision_vdb_from_bookmark_defaults) | **POST** /vdbs/provision_from_bookmark/defaults | Get default provision parameters for provisioning a new VDB from a bookmark.
*VDBsApi* | [**refresh_vdb_by_snapshot**](docs/VDBsApi.md#refresh_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/refresh_by_snapshot | Refresh a VDB by snapshot.
*VDBsApi* | [**refresh_vdb_by_timestamp**](docs/VDBsApi.md#refresh_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/refresh_by_timestamp | Refresh a VDB by timestamp.
*VDBsApi* | [**refresh_vdb_from_bookmark**](docs/VDBsApi.md#refresh_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/refresh_from_bookmark | Refresh a VDB from bookmark with a single VDB.
*VDBsApi* | [**rollback_vdb_by_snapshot**](docs/VDBsApi.md#rollback_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/rollback_by_snapshot | Rollback a VDB by snapshot.
*VDBsApi* | [**rollback_vdb_by_timestamp**](docs/VDBsApi.md#rollback_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/rollback_by_timestamp | Rollback a VDB by timestamp.
*VDBsApi* | [**rollback_vdb_from_bookmark**](docs/VDBsApi.md#rollback_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/rollback_from_bookmark | Rollback a VDB from a bookmark with only the same VDB.
*VDBsApi* | [**search_vdbs**](docs/VDBsApi.md#search_vdbs) | **POST** /vdbs/search | Search for VDBs.
*VDBsApi* | [**snapshot_vdb**](docs/VDBsApi.md#snapshot_vdb) | **POST** /vdbs/{vdbId}/snapshots | Snapshot a VDB.
*VDBsApi* | [**start_vdb**](docs/VDBsApi.md#start_vdb) | **POST** /vdbs/{vdbId}/start | Start a VDB.
*VDBsApi* | [**stop_vdb**](docs/VDBsApi.md#stop_vdb) | **POST** /vdbs/{vdbId}/stop | Stop a VDB.
*VDBsApi* | [**update_vdb_by_id**](docs/VDBsApi.md#update_vdb_by_id) | **PATCH** /vdbs/{vdbId} | Update values of a VDB


## Documentation For Models

 - [APIClassificationConfig](docs/APIClassificationConfig.md)
 - [AccessGroup](docs/AccessGroup.md)
 - [AccessGroupAccountIdsRequest](docs/AccessGroupAccountIdsRequest.md)
 - [AccessGroupScope](docs/AccessGroupScope.md)
 - [AccessGroupScopesRequest](docs/AccessGroupScopesRequest.md)
 - [AccessGroupUpdateParameters](docs/AccessGroupUpdateParameters.md)
 - [Account](docs/Account.md)
 - [AccountCreateParameter](docs/AccountCreateParameter.md)
 - [AccountCreateResponse](docs/AccountCreateResponse.md)
 - [AccountLoginParameter](docs/AccountLoginParameter.md)
 - [AccountUpdateParameter](docs/AccountUpdateParameter.md)
 - [AdditionalMountPoint](docs/AdditionalMountPoint.md)
 - [AllObjectPermissionsResponse](docs/AllObjectPermissionsResponse.md)
 - [AlwaysAllowedPermission](docs/AlwaysAllowedPermission.md)
 - [AlwaysAllowedPermissionRequest](docs/AlwaysAllowedPermissionRequest.md)
 - [ApiClassificationObject](docs/ApiClassificationObject.md)
 - [ApiUsageData](docs/ApiUsageData.md)
 - [ApiUsageReportResponse](docs/ApiUsageReportResponse.md)
 - [BaseProvisionVDBParameters](docs/BaseProvisionVDBParameters.md)
 - [BaseProvisionVDBParametersAllOf](docs/BaseProvisionVDBParametersAllOf.md)
 - [Bookmark](docs/Bookmark.md)
 - [BookmarkCreateParameters](docs/BookmarkCreateParameters.md)
 - [CDB](docs/CDB.md)
 - [ChangePasswordParameter](docs/ChangePasswordParameter.md)
 - [ConnectivityCheckParameters](docs/ConnectivityCheckParameters.md)
 - [ConnectivityCheckResponse](docs/ConnectivityCheckResponse.md)
 - [Connector](docs/Connector.md)
 - [ConnectorTestResponse](docs/ConnectorTestResponse.md)
 - [ConnectorUpdateParameters](docs/ConnectorUpdateParameters.md)
 - [CopyMaskingJobParameters](docs/CopyMaskingJobParameters.md)
 - [CopyMaskingJobResponse](docs/CopyMaskingJobResponse.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [CreateDatabaseTemplateResponse](docs/CreateDatabaseTemplateResponse.md)
 - [CreateEnvironmentResponse](docs/CreateEnvironmentResponse.md)
 - [CreateEnvironmentUserResponse](docs/CreateEnvironmentUserResponse.md)
 - [CreateHostResponse](docs/CreateHostResponse.md)
 - [CreateRole](docs/CreateRole.md)
 - [CreateVDBGroupRequest](docs/CreateVDBGroupRequest.md)
 - [CreateVDBGroupResponse](docs/CreateVDBGroupResponse.md)
 - [DSource](docs/DSource.md)
 - [DSourceConsumptionData](docs/DSourceConsumptionData.md)
 - [DSourceConsumptionReportResponse](docs/DSourceConsumptionReportResponse.md)
 - [DSourceSnapshotParameters](docs/DSourceSnapshotParameters.md)
 - [DSourceUsageData](docs/DSourceUsageData.md)
 - [DSourceUsageReportResponse](docs/DSourceUsageReportResponse.md)
 - [DataPointBySnapshotParameters](docs/DataPointBySnapshotParameters.md)
 - [DataPointByTimestampParameters](docs/DataPointByTimestampParameters.md)
 - [DataPointFromBookmarkParameters](docs/DataPointFromBookmarkParameters.md)
 - [DatabaseTemplate](docs/DatabaseTemplate.md)
 - [DatabaseTemplateCreateParameters](docs/DatabaseTemplateCreateParameters.md)
 - [DeleteDatabaseTemplateResponse](docs/DeleteDatabaseTemplateResponse.md)
 - [DeleteEngineResponse](docs/DeleteEngineResponse.md)
 - [DeleteEnvironmentResponse](docs/DeleteEnvironmentResponse.md)
 - [DeleteEnvironmentUserResponse](docs/DeleteEnvironmentUserResponse.md)
 - [DeleteHostResponse](docs/DeleteHostResponse.md)
 - [DeleteMaskingJobResponse](docs/DeleteMaskingJobResponse.md)
 - [DeleteScopeObjectTags](docs/DeleteScopeObjectTags.md)
 - [DeleteScopedObjectItem](docs/DeleteScopedObjectItem.md)
 - [DeleteTag](docs/DeleteTag.md)
 - [DeleteVDBParameters](docs/DeleteVDBParameters.md)
 - [DeleteVDBResponse](docs/DeleteVDBResponse.md)
 - [DisableEnvironmentResponse](docs/DisableEnvironmentResponse.md)
 - [DisableVDBParameters](docs/DisableVDBParameters.md)
 - [DisableVDBResponse](docs/DisableVDBResponse.md)
 - [Domain](docs/Domain.md)
 - [EffectiveScope](docs/EffectiveScope.md)
 - [EnableEnvironmentResponse](docs/EnableEnvironmentResponse.md)
 - [EnableVDBParameters](docs/EnableVDBParameters.md)
 - [EnableVDBResponse](docs/EnableVDBResponse.md)
 - [Engine](docs/Engine.md)
 - [EngineIdBody](docs/EngineIdBody.md)
 - [EngineRegistrationParameter](docs/EngineRegistrationParameter.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentCreateParameters](docs/EnvironmentCreateParameters.md)
 - [EnvironmentUpdateParameters](docs/EnvironmentUpdateParameters.md)
 - [EnvironmentUser](docs/EnvironmentUser.md)
 - [EnvironmentUserParams](docs/EnvironmentUserParams.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [ExecuteMaskingJobParameters](docs/ExecuteMaskingJobParameters.md)
 - [ExecuteMaskingJobResponse](docs/ExecuteMaskingJobResponse.md)
 - [Execution](docs/Execution.md)
 - [ExecutionCancelParameters](docs/ExecutionCancelParameters.md)
 - [GlobalProperties](docs/GlobalProperties.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [Hook](docs/Hook.md)
 - [Host](docs/Host.md)
 - [HostCreateParameters](docs/HostCreateParameters.md)
 - [HostUpdateParameters](docs/HostUpdateParameters.md)
 - [Job](docs/Job.md)
 - [LDAPConfigParams](docs/LDAPConfigParams.md)
 - [LdapConfigValidateParameter](docs/LdapConfigValidateParameter.md)
 - [LdapValidateResponse](docs/LdapValidateResponse.md)
 - [ListAccessGroupsResponse](docs/ListAccessGroupsResponse.md)
 - [ListAccountsResponse](docs/ListAccountsResponse.md)
 - [ListBookmarksByVDBGroupsResponse](docs/ListBookmarksByVDBGroupsResponse.md)
 - [ListBookmarksResponse](docs/ListBookmarksResponse.md)
 - [ListCDBsResponse](docs/ListCDBsResponse.md)
 - [ListConnectorsResponse](docs/ListConnectorsResponse.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListDatabaseTemplatesResponse](docs/ListDatabaseTemplatesResponse.md)
 - [ListEnvironmentUsers](docs/ListEnvironmentUsers.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListExecutionsResponse](docs/ListExecutionsResponse.md)
 - [ListHashicorpVaultsResponse](docs/ListHashicorpVaultsResponse.md)
 - [ListJobsResponse](docs/ListJobsResponse.md)
 - [ListMaskingJobSourceEnginesResponse](docs/ListMaskingJobSourceEnginesResponse.md)
 - [ListMaskingJobsResponse](docs/ListMaskingJobsResponse.md)
 - [ListRegisteredEnginesResponse](docs/ListRegisteredEnginesResponse.md)
 - [ListReportingScheduleResponse](docs/ListReportingScheduleResponse.md)
 - [ListRolesResponse](docs/ListRolesResponse.md)
 - [ListSnapshotsResponse](docs/ListSnapshotsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListVCDBsResponse](docs/ListVCDBsResponse.md)
 - [ListVDBGroupsByBookmarkResponse](docs/ListVDBGroupsByBookmarkResponse.md)
 - [ListVDBGroupsResponse](docs/ListVDBGroupsResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [LoginToken](docs/LoginToken.md)
 - [MaskingJob](docs/MaskingJob.md)
 - [MaskingJobConnectorsResponse](docs/MaskingJobConnectorsResponse.md)
 - [MaskingJobSourceEngine](docs/MaskingJobSourceEngine.md)
 - [MaskingRuleset](docs/MaskingRuleset.md)
 - [MigrateMaskingJobParameters](docs/MigrateMaskingJobParameters.md)
 - [MigrateMaskingJobResponse](docs/MigrateMaskingJobResponse.md)
 - [ObjectPermissionAccessGroups](docs/ObjectPermissionAccessGroups.md)
 - [ObjectPermissionAccount](docs/ObjectPermissionAccount.md)
 - [ObjectPermissionsResponse](docs/ObjectPermissionsResponse.md)
 - [ObjectTypeEnum](docs/ObjectTypeEnum.md)
 - [ObjectTypeProperty](docs/ObjectTypeProperty.md)
 - [OracleRacCustomEnvFile](docs/OracleRacCustomEnvFile.md)
 - [OracleRacCustomEnvVar](docs/OracleRacCustomEnvVar.md)
 - [OracleVirtualIP](docs/OracleVirtualIP.md)
 - [PaginatedResponseMetadata](docs/PaginatedResponseMetadata.md)
 - [PasswordPoliciesParams](docs/PasswordPoliciesParams.md)
 - [PermissionEnum](docs/PermissionEnum.md)
 - [PermissionObject](docs/PermissionObject.md)
 - [PermissionProperty](docs/PermissionProperty.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PrimaryEnvironmentUserResponse](docs/PrimaryEnvironmentUserResponse.md)
 - [ProductHistory](docs/ProductHistory.md)
 - [ProductInfo](docs/ProductInfo.md)
 - [ProvisionVDBBySnapshotDefaultsRequest](docs/ProvisionVDBBySnapshotDefaultsRequest.md)
 - [ProvisionVDBBySnapshotParameters](docs/ProvisionVDBBySnapshotParameters.md)
 - [ProvisionVDBBySnapshotParametersAllOf](docs/ProvisionVDBBySnapshotParametersAllOf.md)
 - [ProvisionVDBByTimestampParameters](docs/ProvisionVDBByTimestampParameters.md)
 - [ProvisionVDBByTimestampParametersAllOf](docs/ProvisionVDBByTimestampParametersAllOf.md)
 - [ProvisionVDBFromBookmarkDefaultsRequest](docs/ProvisionVDBFromBookmarkDefaultsRequest.md)
 - [ProvisionVDBFromBookmarkParameters](docs/ProvisionVDBFromBookmarkParameters.md)
 - [ProvisionVDBFromBookmarkParametersAllOf](docs/ProvisionVDBFromBookmarkParametersAllOf.md)
 - [ProvisionVDBGroupFromBookmarkParameters](docs/ProvisionVDBGroupFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkResponse](docs/ProvisionVDBGroupFromBookmarkResponse.md)
 - [ProvisionVDBResponse](docs/ProvisionVDBResponse.md)
 - [RefreshEnvironmentResponse](docs/RefreshEnvironmentResponse.md)
 - [RefreshVDBBySnapshotParameters](docs/RefreshVDBBySnapshotParameters.md)
 - [RefreshVDBBySnapshotResponse](docs/RefreshVDBBySnapshotResponse.md)
 - [RefreshVDBByTimestampParameters](docs/RefreshVDBByTimestampParameters.md)
 - [RefreshVDBByTimestampParametersAllOf](docs/RefreshVDBByTimestampParametersAllOf.md)
 - [RefreshVDBByTimestampResponse](docs/RefreshVDBByTimestampResponse.md)
 - [RefreshVDBFromBookmarkParameters](docs/RefreshVDBFromBookmarkParameters.md)
 - [RefreshVDBFromBookmarkResponse](docs/RefreshVDBFromBookmarkResponse.md)
 - [RefreshVDBGroupParameters](docs/RefreshVDBGroupParameters.md)
 - [RefreshVDBGroupResponse](docs/RefreshVDBGroupResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [RemoveMaskingJobParameters](docs/RemoveMaskingJobParameters.md)
 - [ReportingSchedule](docs/ReportingSchedule.md)
 - [ReportingScheduleCreateParameters](docs/ReportingScheduleCreateParameters.md)
 - [Repository](docs/Repository.md)
 - [ResetPasswordParameter](docs/ResetPasswordParameter.md)
 - [Role](docs/Role.md)
 - [RoleAllOf](docs/RoleAllOf.md)
 - [RoleUpdateParameters](docs/RoleUpdateParameters.md)
 - [RollbackVDBBySnapshotParameters](docs/RollbackVDBBySnapshotParameters.md)
 - [RollbackVDBBySnapshotResponse](docs/RollbackVDBBySnapshotResponse.md)
 - [RollbackVDBByTimestampParameters](docs/RollbackVDBByTimestampParameters.md)
 - [RollbackVDBByTimestampResponse](docs/RollbackVDBByTimestampResponse.md)
 - [RollbackVDBFromBookmarkParameters](docs/RollbackVDBFromBookmarkParameters.md)
 - [RollbackVDBFromBookmarkResponse](docs/RollbackVDBFromBookmarkResponse.md)
 - [RollbackVDBGroupParameters](docs/RollbackVDBGroupParameters.md)
 - [RollbackVDBGroupResponse](docs/RollbackVDBGroupResponse.md)
 - [SAMLConfigParams](docs/SAMLConfigParams.md)
 - [SMTPConfigParams](docs/SMTPConfigParams.md)
 - [SMTPConfigValidate](docs/SMTPConfigValidate.md)
 - [SSHVerificationStrategy](docs/SSHVerificationStrategy.md)
 - [ScopeTag](docs/ScopeTag.md)
 - [ScopeTagsRequest](docs/ScopeTagsRequest.md)
 - [ScopeTagsResponse](docs/ScopeTagsResponse.md)
 - [ScopedObjectItem](docs/ScopedObjectItem.md)
 - [ScopedObjectItemsResponse](docs/ScopedObjectItemsResponse.md)
 - [ScopedObjectsRequest](docs/ScopedObjectsRequest.md)
 - [SearchAccessGroupsResponse](docs/SearchAccessGroupsResponse.md)
 - [SearchAccountsResponse](docs/SearchAccountsResponse.md)
 - [SearchBody](docs/SearchBody.md)
 - [SearchBookmarksResponse](docs/SearchBookmarksResponse.md)
 - [SearchCDBsResponse](docs/SearchCDBsResponse.md)
 - [SearchConnectorsResponse](docs/SearchConnectorsResponse.md)
 - [SearchDSourcesResponse](docs/SearchDSourcesResponse.md)
 - [SearchDatabaseTemplatesResponse](docs/SearchDatabaseTemplatesResponse.md)
 - [SearchEnginesResponse](docs/SearchEnginesResponse.md)
 - [SearchEnvironmentsResponse](docs/SearchEnvironmentsResponse.md)
 - [SearchExecutionsResponse](docs/SearchExecutionsResponse.md)
 - [SearchJobsResponse](docs/SearchJobsResponse.md)
 - [SearchMaskingJobSourceEnginesResponse](docs/SearchMaskingJobSourceEnginesResponse.md)
 - [SearchMaskingJobsResponse](docs/SearchMaskingJobsResponse.md)
 - [SearchRolesResponse](docs/SearchRolesResponse.md)
 - [SearchSnapshotsResponse](docs/SearchSnapshotsResponse.md)
 - [SearchSourcesResponse](docs/SearchSourcesResponse.md)
 - [SearchVCDBsResponse](docs/SearchVCDBsResponse.md)
 - [SearchVDBGroupResponse](docs/SearchVDBGroupResponse.md)
 - [SearchVDBsResponse](docs/SearchVDBsResponse.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotDSourceResponse](docs/SnapshotDSourceResponse.md)
 - [SnapshotDayRange](docs/SnapshotDayRange.md)
 - [SnapshotVDBResponse](docs/SnapshotVDBResponse.md)
 - [SnapshotsDayRangesResponse](docs/SnapshotsDayRangesResponse.md)
 - [Source](docs/Source.md)
 - [StartVDBResponse](docs/StartVDBResponse.md)
 - [StopVDBResponse](docs/StopVDBResponse.md)
 - [Tag](docs/Tag.md)
 - [TagsRequest](docs/TagsRequest.md)
 - [TagsResponse](docs/TagsResponse.md)
 - [TaskEvent](docs/TaskEvent.md)
 - [TimeToUpdateSourcesRequest](docs/TimeToUpdateSourcesRequest.md)
 - [TimeToUpdateSourcesResponse](docs/TimeToUpdateSourcesResponse.md)
 - [TokenInfoRequest](docs/TokenInfoRequest.md)
 - [TokenInfoResponse](docs/TokenInfoResponse.md)
 - [UpdateAccessGroupScope](docs/UpdateAccessGroupScope.md)
 - [UpdateConnectorResponse](docs/UpdateConnectorResponse.md)
 - [UpdateDatabaseTemplateParameters](docs/UpdateDatabaseTemplateParameters.md)
 - [UpdateDatabaseTemplateResponse](docs/UpdateDatabaseTemplateResponse.md)
 - [UpdateEnvironmentResponse](docs/UpdateEnvironmentResponse.md)
 - [UpdateEnvironmentUserResponse](docs/UpdateEnvironmentUserResponse.md)
 - [UpdateHostResponse](docs/UpdateHostResponse.md)
 - [UpdateMaskingJobParameters](docs/UpdateMaskingJobParameters.md)
 - [UpdateVDBGroupParameters](docs/UpdateVDBGroupParameters.md)
 - [UpdateVDBParameters](docs/UpdateVDBParameters.md)
 - [UpdateVDBResponse](docs/UpdateVDBResponse.md)
 - [VCDB](docs/VCDB.md)
 - [VDB](docs/VDB.md)
 - [VDBGroup](docs/VDBGroup.md)
 - [VDBInventoryData](docs/VDBInventoryData.md)
 - [VDBInventoryReportResponse](docs/VDBInventoryReportResponse.md)
 - [VirtualDatasetHooks](docs/VirtualDatasetHooks.md)
 - [VirtualizationStorageSummaryData](docs/VirtualizationStorageSummaryData.md)
 - [VirtualizationStorageSummaryReportResponse](docs/VirtualizationStorageSummaryReportResponse.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

