/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.validation;

import biouml.plugins.sbml.validation.MultipartPost;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SBMLValidator {
    public static final String validatorURL = "http://sbml-validator.caltech.edu:8888/validator_servlet/ValidatorServlet";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String validateSBML(File f) throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        MultipartPost post = new MultipartPost(validatorURL);
        post.writeParameter("file", f);
        post.writeParameter("offcheck", "u,p");
        post.writeParameter("output", "xml");
        try (InputStream stream = post.done();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equals("problem")) continue;
                NodeList nodes = ((Element)node).getElementsByTagName("location");
                String line = ((Element)nodes.item(0)).getAttribute("line");
                String column = ((Element)nodes.item(0)).getAttribute("column");
                nodes = ((Element)node).getElementsByTagName("message");
                String message = nodes.item(0).getChildNodes().item(0).getNodeValue();
                errors.add("At line=" + line + ", column=" + column + ":" + message);
            }
            if (errors.isEmpty()) {
                String string2 = null;
                return string2;
            }
            String string = "Not a valid SBML file. Next problems occured: \n" + StringUtils.join(errors, (String)"\n");
            return string;
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            return null;
        }
    }
}

