/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Random;

class MultipartPost {
    URLConnection connection;
    OutputStream stream;
    String boundary;

    public MultipartPost(String url) throws IOException {
        Random random = new Random();
        this.connection = new URL(url).openConnection();
        this.connection.setReadTimeout(10000);
        this.connection.setConnectTimeout(10000);
        this.boundary = "<<" + Long.toString(random.nextLong(), 30);
        String type = "multipart/form-data; boundary=" + this.boundary;
        this.connection.setDoOutput(true);
        this.connection.setRequestProperty("Content-Type", type);
        this.stream = this.connection.getOutputStream();
    }

    public InputStream done() throws IOException {
        this.writeln("--" + this.boundary + "--");
        this.writeln();
        this.stream.close();
        return this.connection.getInputStream();
    }

    public void writeParameter(String name, String value) throws IOException {
        this.writeln("--" + this.boundary);
        this.writeln("Content-Disposition: form-data; name=\"" + name + "\"");
        this.writeln();
        this.writeln(value);
    }

    public void writeParameter(String name, File file) throws IOException {
        String prefix = "Content-Disposition: form-data; name=\"file\"; filename=";
        this.writeln("--" + this.boundary);
        this.writeln(prefix + '\"' + file.getName() + '\"');
        this.writeln("Content-Type: text/xml");
        this.writeln();
        try (FileInputStream source = new FileInputStream(file);){
            this.copy(source, this.stream);
            this.writeln();
            this.stream.flush();
        }
    }

    void copy(InputStream source, OutputStream destination) throws IOException {
        byte[] buffer = new byte[8192];
        int nbytes = 0;
        while ((nbytes = source.read(buffer, 0, buffer.length)) >= 0) {
            destination.write(buffer, 0, nbytes);
        }
    }

    void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    void writeln() throws IOException {
        this.write('\r');
        this.write('\n');
    }

    void write(char c) throws IOException {
        this.stream.write(c);
    }

    void write(String s) throws IOException {
        this.stream.write(s.getBytes(StandardCharsets.UTF_8));
    }
}

