/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.plugins.sbml.extensions.SbmlExtension;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import ru.biosoft.util.ExtensionRegistrySupport;

public class SbmlAnnotationRegistry
extends ExtensionRegistrySupport<SbmlAnnotationInfo> {
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    public static final String EXTENSION_CLASS = "extension_class";
    public static final String PRIORITY = "priority";
    private static boolean pluginsMode = true;
    private static final SbmlAnnotationRegistry instance = new SbmlAnnotationRegistry();

    private SbmlAnnotationRegistry() {
        super("biouml.plugins.sbml.annotation", NAMESPACE);
    }

    public static Set<String> getNamespaces() {
        return instance.names().toSet();
    }

    public static List<SbmlAnnotationInfo> getAnnotations() {
        if (pluginsMode) {
            try {
                return instance.stream().toList();
            }
            catch (NoClassDefFoundError err) {
                pluginsMode = false;
            }
        }
        return null;
    }

    protected SbmlAnnotationInfo loadElement(IConfigurationElement element, String namespace) throws Exception {
        int priority = this.getIntAttribute(element, PRIORITY, 100);
        Class clazz = this.getClassAttribute(element, EXTENSION_CLASS, SbmlExtension.class);
        return new SbmlAnnotationInfo(clazz, namespace, priority);
    }

    public static class SbmlAnnotationInfo {
        protected Class<? extends SbmlExtension> extensionClass;
        protected String namespace;
        public int priority;

        public SbmlAnnotationInfo(Class<? extends SbmlExtension> extensionClass, String namespace, int priority) {
            this.extensionClass = extensionClass;
            this.namespace = namespace;
            this.priority = priority;
        }

        public SbmlExtension create() throws Exception {
            return this.extensionClass.newInstance();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

