/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.plugins.sbgn.SbgnCompositeDiagramType;
import biouml.plugins.sbgn.SbgnDiagramType;
import biouml.plugins.sbgn.SbgnModelReader;
import biouml.plugins.sbgn.SbgnModelWriter;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SBGNExtension
extends SbmlExtensionSupport {
    protected static final Logger log = Logger.getLogger(SBGNExtension.class.getName());
    public static final String SBGN_ELEMENT = "sbgn";

    @Override
    public void readElement(Element element, DiagramElement specie, @Nonnull Diagram diagram) {
        if (!element.getNodeName().equals(SBGN_ELEMENT)) {
            return;
        }
        try {
            SbgnModelReader reader = new SbgnModelReader(diagram.getOrigin(), diagram.getName(), diagram);
            Diagram sbgnDiagram = reader.read(element);
            diagram.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)sbgnDiagram));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not read SBGN diagram from SBML annotation", e);
        }
    }

    @Override
    public Element[] writeElement(DiagramElement specie, Document document) {
        if (!(specie instanceof Diagram)) {
            return null;
        }
        Diagram diagram = (Diagram)specie;
        Object sbgnDiagramObj = diagram.getAttributes().getValue("sbgn_diagram");
        if (this.isApplicable(sbgnDiagramObj)) {
            Diagram sbgnDiagram = (Diagram)sbgnDiagramObj;
            SbgnModelWriter writer = new SbgnModelWriter(sbgnDiagram, diagram);
            writer.setNewPaths(this.modelWriter.getNewPaths());
            try {
                String stateName = sbgnDiagram.getCurrentStateName();
                sbgnDiagram.restore();
                Element result = writer.write(document);
                sbgnDiagram.setCurrentStateName(stateName);
                return new Element[]{result};
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not write SBGN diagram to SBML annotation", e);
            }
        }
        return null;
    }

    protected boolean isApplicable(Object sbgnDiagramObj) {
        if (!(sbgnDiagramObj instanceof Diagram)) {
            return false;
        }
        Class<?> diagramType = ((Diagram)sbgnDiagramObj).getType().getClass();
        return SbgnDiagramType.class.equals(diagramType) || SbgnCompositeDiagramType.class.equals(diagramType);
    }
}

