/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.plugins.sbml.extensions.DiagramIndex;
import biouml.plugins.sbml.extensions.SimulationExtension;
import biouml.standard.simulation.SimulationResult;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.beans.DynamicProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import ru.biosoft.access.core.AbstractDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.Index;
import ru.biosoft.gui.Document;

public class ResultDataCollection
extends AbstractDataCollection<SimulationResult> {
    protected static final Logger log = Logger.getLogger(ResultDataCollection.class.getName());
    protected Index namesMap = null;
    protected boolean isInitNameList = false;

    public ResultDataCollection(DataCollection<?> parent, Properties properties) {
        super(parent, properties);
        try {
            this.namesMap = new DiagramIndex(new File(properties.getProperty("configPath")), "result.index");
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create index", t);
        }
    }

    protected void initNameList() {
        if (this.isInitNameList) {
            return;
        }
        this.isInitNameList = true;
        if (!this.namesMap.isValid()) {
            try {
                for (Diagram diagram : Module.getModule((DataElement)this).getDiagrams()) {
                    Object object = diagram.getAttributes().getValue("simulations");
                    if (!(object instanceof SimulationExtension.Simulation[])) continue;
                    for (SimulationExtension.Simulation simulation : (SimulationExtension.Simulation[])object) {
                        this.namesMap.put((Object)simulation.getName(), (Object)diagram.getName());
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't initialize collection " + this.getName(), t);
            }
        }
    }

    @Nonnull
    public List<String> getNameList() {
        this.initNameList();
        return new ArrayList<String>(this.namesMap.keySet());
    }

    protected SimulationResult doGet(String name) {
        if (this.namesMap.containsKey((Object)name)) {
            try {
                Diagram diagram = Module.getModule((DataElement)this).getDiagram((String)this.namesMap.get((Object)name));
                Object object = diagram.getAttributes().getValue("simulations");
                if (object instanceof SimulationExtension.Simulation[]) {
                    for (SimulationExtension.Simulation simulation : (SimulationExtension.Simulation[])object) {
                        if (!simulation.getName().equals(name)) continue;
                        return simulation.getResult();
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't get element " + name + " from " + this.getName(), t);
            }
        }
        return null;
    }

    protected void doPut(SimulationResult simulationResult, boolean isNew) throws Exception {
        SimulationExtension.Simulation simulation = new SimulationExtension.Simulation(null, simulationResult.getName());
        simulation.setTitle(simulationResult.getTitle());
        simulation.setResult(simulationResult);
        Document document = Document.getCurrentDocument();
        if (document instanceof DiagramDocument) {
            Diagram diagram = ((DiagramDocument)document).getDiagram();
            Object object = diagram.getAttributes().getValue("simulations");
            SimulationExtension.Simulation[] newSimulations = null;
            if (object != null && object instanceof SimulationExtension.Simulation[]) {
                SimulationExtension.Simulation[] oldSimulations = (SimulationExtension.Simulation[])object;
                newSimulations = new SimulationExtension.Simulation[oldSimulations.length + 1];
                System.arraycopy(oldSimulations, 0, newSimulations, 0, oldSimulations.length);
                newSimulations[oldSimulations.length] = simulation;
                diagram.getAttributes().getProperty("simulations").setValue((Object)newSimulations);
            } else {
                newSimulations = new SimulationExtension.Simulation[]{simulation};
                try {
                    diagram.getAttributes().add(new DynamicProperty("simulations", SimulationExtension.Simulation[].class, (Object)newSimulations));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.namesMap.put((Object)simulationResult.getName(), (Object)diagram.getName());
        }
    }

    protected void doRemove(String name) throws Exception {
        if (this.namesMap.containsKey((Object)name)) {
            try {
                DataCollection diagramsDC = Module.getModule((DataElement)this).getDiagrams();
                Diagram diagram = (Diagram)diagramsDC.get((String)this.namesMap.get((Object)name));
                Object object = diagram.getAttributes().getValue("simulations");
                if (object != null && object instanceof SimulationExtension.Simulation[]) {
                    int pos = 0;
                    SimulationExtension.Simulation[] newSimulations = new SimulationExtension.Simulation[((SimulationExtension.Simulation[])object).length - 1];
                    for (SimulationExtension.Simulation simulation : (SimulationExtension.Simulation[])object) {
                        if (simulation.getName().equals(name)) continue;
                        newSimulations[pos++] = simulation;
                    }
                    diagram.getAttributes().getProperty("simulations").setValue((Object)newSimulations);
                    this.namesMap.remove((Object)name);
                    diagramsDC.put((DataElement)diagram);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't remove element " + name + " from " + this.getName(), t);
            }
        }
    }

    public int getSize() {
        this.initNameList();
        return this.namesMap.size();
    }

    public boolean contains(String name) {
        return this.namesMap.containsKey((Object)name);
    }

    public void close() throws Exception {
        super.close();
        if (this.namesMap != null) {
            this.namesMap.close();
            this.namesMap = null;
        }
    }

    public String getDiagramNameByExperiment(String experimentId) {
        return (String)this.namesMap.get((Object)experimentId);
    }
}

