/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Referrer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.access.core.RepositoryException;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.util.TextUtil;
import ru.biosoft.util.XmlUtil;

public class RdfExtensionReader
extends SbmlExtensionSupport {
    private static final String RDF_PARSE_TYPE = "rdf:parseType";
    private static final String V_CARD_N = "vCard:N";
    private static final String V_CARD_ORGNAME = "vCard:Orgname";
    private static final String V_CARD_ORG = "vCard:ORG";
    private static final String V_CARD_EMAIL = "vCard:EMAIL";
    private static final String V_CARD_GIVEN = "vCard:Given";
    private static final String V_CARD_FAMILY = "vCard:Family";
    public static final String RDF_ELEMENT = "rdf:RDF";
    public static final String DESCRIPTION_ELEMENT = "rdf:Description";
    public static final String BAG_ELEMENT = "rdf:Bag";
    public static final String LI_ELEMENT = "rdf:li";
    public static final String RESOURCE_ATTRIBUTE = "rdf:resource";
    public static final String ABOUT_ATTRIBUTE = "rdf:about";
    public static final String URN_MIRIAM = "urn:miriam";
    public static final String DCCREATOR_ELEMENT = "dc:creator";
    public static final String DCTERMS_ELEMENT = "dcterms:W3CDTF";
    public static final String DCTERMSCREATOR_ELEMENT = "dcterms:creator";
    public static final String DCTERMSCREATED_ELEMENT = "dcterms:created";
    public static final String DCTERMSMODIFIED_ELEMENT = "dcterms:modified";
    public static final String BQBIOL = "bqbiol";
    public static final String BQMODEL = "bqmodel";
    public static final String ISDERIVEDFROM_ELEMENT = "isDerivedFrom";
    public static final String IS_ELEMENT = "is";
    public static final String HASINSTANCE_ELEMENT = "hasInstance";
    public static final String ISINSTANCEOF_ELEMENT = "isInstanceOf";
    public static final String HASPART_ELEMENT = "hasPart";
    public static final String HASPROPERTY_ELEMENT = "hasProperty";
    public static final String ISPARTOF_ELEMENT = "isPartOf";
    public static final String ISVERSIONOF_ELEMENT = "isVersionOf";
    public static final String HASVERSION_ELEMENT = "hasVersion";
    public static final String ISHOMOLOGTO_ELEMENT = "isHomologTo";
    public static final String ISDESCRIBEDBY_ELEMENT = "isDescribedBy";
    public static final String ENCODES_ELEMENT = "encodes";
    public static final String ISENCODEDBY_ELEMENT = "isEncodedBy";
    public static final String OCCURSIN_ELEMENT = "occursIn";
    public static final String HASTAXON_ELEMENT = "hasTaxon";
    public static final String ISPROPERTYOF_ELEMENT = "isPropertyOf";
    public static final String XMLNS_RDF = "xmlns:rdf";
    public static final String XMLNS_RDF_VALUE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String XMLNS_DC = "xmlns:dc";
    public static final String XMLNS_DC_VALUE = "http://purl.org/dc/elements/1.1/";
    public static final String XMLNS_DCTERM = "xmlns:dcterms";
    public static final String XMLNS_DCTERM_VALUE = "http://purl.org/dc/terms/";
    public static final String XMLNS_VCARD = "xmlns:vCard";
    public static final String XMLNS_VCARD_VALUE = "http://www.w3.org/2001/vcard-rdf/3.0#";
    public static final String XMLNS_BQBIOL = "xmlns:bqbiol";
    public static final String XMLNS_BQBIOL_VALUE = "http://biomodels.net/biology-qualifiers/";
    public static final String XMLNS_BQMODEL = "xmlns:bqmodel";
    public static final String XMLNS_BQMODEL_VALUE = "http://biomodels.net/model-qualifiers/";
    public static final DataElementPath MIRIAM_RESOURCE = DataElementPath.create((String)"databases/Utils/MIRIAM");
    protected Logger log = Logger.getLogger(RdfExtensionReader.class.getName());
    private Map<String, DatabaseInfo> miriamUrnToInfo;
    private static final List<String> qualifiers = Collections.unmodifiableList(Arrays.asList("is", "hasInstance", "isInstanceOf", "isDerivedFrom", "isDescribedBy", "hasPart", "hasProperty", "isPartOf", "isVersionOf", "hasVersion", "isHomologTo", "encodes", "isEncodedBy", "occursIn", "hasTaxon", "isPropertyOf"));

    public RdfExtensionReader() {
        try {
            this.miriamUrnToInfo = StreamEx.of((Stream)MIRIAM_RESOURCE.getDataCollection(DatabaseInfo.class).stream()).cross(di -> StreamEx.ofNullable((Object)((String[])di.getAttributes().getValue("uri:URN"))).flatMap(Arrays::stream)).invert().toMap((a, b) -> a);
        }
        catch (RepositoryException e) {
            this.miriamUrnToInfo = Collections.emptyMap();
        }
    }

    public static List<String> getQualifiers() {
        return qualifiers;
    }

    @Override
    public void readElement(Element element, DiagramElement specie, @Nonnull Diagram diagram) {
        Element description;
        if (!element.getNodeName().equals(RDF_ELEMENT)) {
            return;
        }
        if (specie.getKernel() instanceof DiagramInfo) {
            this.readAuthors(element, (DiagramInfo)diagram.getKernel());
            this.readTerms(element, (DiagramInfo)diagram.getKernel());
        }
        if ((description = RdfExtensionReader.getElement(element, DESCRIPTION_ELEMENT)) == null || !(specie.getKernel() instanceof Referrer)) {
            return;
        }
        Referrer referrer = (Referrer)specie.getKernel();
        ArrayList<DatabaseReference> databaseReferences = new ArrayList<DatabaseReference>();
        ArrayList<String> literatureReferences = new ArrayList<String>();
        for (Element node : XmlUtil.elements((Element)description)) {
            String referenceType = node.getNodeName();
            if (referenceType.startsWith(BQBIOL)) {
                referenceType = referenceType.substring(BQBIOL.length() + 1, referenceType.length());
            }
            if (referenceType.startsWith(BQMODEL)) {
                referenceType = referenceType.substring(BQMODEL.length() + 1, referenceType.length());
            }
            if (RdfExtensionReader.checkRelationshipType(referenceType)) {
                Element bag = RdfExtensionReader.getElement(node, BAG_ELEMENT);
                if (bag == null) continue;
                this.readBag(bag, databaseReferences, literatureReferences, referenceType);
                continue;
            }
            if (referenceType.equals(DCCREATOR_ELEMENT) || referenceType.equals(DCTERMSCREATED_ELEMENT) || referenceType.equals(DCTERMSMODIFIED_ELEMENT) || referenceType.equals(DCTERMSCREATOR_ELEMENT)) continue;
            this.log.log(Level.SEVERE, "Can not read reference. Reason: unknown relationship type " + referenceType);
        }
        if (!databaseReferences.isEmpty()) {
            referrer.setDatabaseReferences(databaseReferences.toArray(new DatabaseReference[0]));
        }
        if (!literatureReferences.isEmpty()) {
            referrer.setLiteratureReferences(literatureReferences.toArray(new String[0]));
        }
    }

    protected void readBag(Element element, List<DatabaseReference> databaseReferences, List<String> literatureReferences, String refType) {
        for (Element li : XmlUtil.elements((Element)element, (String)LI_ELEMENT)) {
            if (!li.hasAttribute(RESOURCE_ATTRIBUTE)) continue;
            try {
                int pos;
                String address = li.getAttribute(RESOURCE_ATTRIBUTE);
                String databaseName = null;
                String id = null;
                if (address.startsWith(URN_MIRIAM)) {
                    if (address.startsWith("urn:miriam:ENS")) {
                        databaseName = "urn:miriam:ensembl";
                        id = TextUtil.decodeURL((String)address.substring(URN_MIRIAM.length() + 1));
                    } else {
                        pos = address.indexOf(58, URN_MIRIAM.length() + 1);
                        if (pos == -1) {
                            this.log.warning("Unparseable database reference: " + address);
                            continue;
                        }
                        databaseName = address.substring(0, pos);
                        id = TextUtil.decodeURL((String)address.substring(pos + 1));
                    }
                    DatabaseInfo info = this.miriamUrnToInfo.get(databaseName);
                    if (info != null) {
                        databaseName = info.getName();
                    }
                } else if (address.indexOf(35) != -1) {
                    pos = address.indexOf(35);
                    databaseName = address.substring(0, pos);
                    id = address.substring(pos + 1, address.length());
                }
                if (databaseName != null && id != null) {
                    if (refType.equals(ISDESCRIBEDBY_ELEMENT)) {
                        literatureReferences.add(id);
                    } else if (databaseName.equals("MIR:00000004")) {
                        String[] ids;
                        for (String singleId : ids = TextUtil.split((String)id, (char)';')) {
                            if (singleId.startsWith("EC")) {
                                singleId = singleId.substring(3);
                            }
                            DatabaseReference dr = new DatabaseReference(databaseName, singleId);
                            dr.setRelationshipType(refType);
                            databaseReferences.add(dr);
                        }
                    } else {
                        DatabaseReference dr = new DatabaseReference(databaseName, id);
                        dr.setRelationshipType(refType);
                        databaseReferences.add(dr);
                    }
                }
                if (!address.startsWith("http://identifiers.org/")) continue;
                address = address.substring(23);
                String[] parts = address.split("/");
                databaseName = parts[0];
                id = parts.length > 1 ? parts[1] : "";
                DatabaseReference dr = new DatabaseReference(databaseName, id);
                dr.setRelationshipType(refType);
                databaseReferences.add(dr);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "RdfExtensionReader: can not read reference element: " + ExceptionRegistry.log((Throwable)e));
            }
        }
    }

    private String[] parseRDFResource(String URI2) {
        if (URI2.startsWith("http://identifiers.org/")) {
            URI2 = URI2.substring(23);
        }
        return URI2.split("/");
    }

    protected void readTerms(Element rdf, DiagramInfo info) {
        Element date;
        Element created = XmlUtil.findElementByTagName((Element)rdf, (String)DCTERMSCREATED_ELEMENT);
        if (created != null && (date = XmlUtil.findElementByTagName((Element)created, (String)DCTERMS_ELEMENT)) != null) {
            info.setCreated(XmlUtil.getTextContent((Element)date));
        }
        ArrayList<String> modifiedList = new ArrayList<String>();
        for (Element modified : XmlUtil.elements((Element)rdf, (String)DCTERMSMODIFIED_ELEMENT)) {
            Element date2 = XmlUtil.findElementByTagName((Element)modified, (String)DCTERMS_ELEMENT);
            if (date2 == null) continue;
            modifiedList.add(XmlUtil.getTextContent((Element)date2));
        }
        info.setModified(modifiedList.toArray(new String[modifiedList.size()]));
    }

    protected void readAuthors(Element element, DiagramInfo info) {
        ArrayList<DiagramInfo.AuthorInfo> authors = new ArrayList<DiagramInfo.AuthorInfo>();
        Element creator = XmlUtil.findElementByTagName((Element)element, (String)DCCREATOR_ELEMENT);
        if (creator == null) {
            creator = XmlUtil.findElementByTagName((Element)element, (String)DCTERMSCREATOR_ELEMENT);
        }
        if (creator == null) {
            return;
        }
        Element bag = XmlUtil.findElementByTagName((Element)creator, (String)BAG_ELEMENT);
        if (bag == null) {
            return;
        }
        for (Element li : XmlUtil.elements((Element)bag, (String)LI_ELEMENT)) {
            DiagramInfo.AuthorInfo author = new DiagramInfo.AuthorInfo();
            authors.add(author);
            try {
                Element vCardEMAIL;
                Element orgName;
                Element vCardORG;
                Element vCardN = XmlUtil.findElementByTagName((Element)li, (String)V_CARD_N);
                if (vCardN != null) {
                    Element vCardGiven;
                    Element vCardFamily = XmlUtil.findElementByTagName((Element)vCardN, (String)V_CARD_FAMILY);
                    if (vCardFamily != null) {
                        author.setFamilyName(XmlUtil.getTextContent((Element)vCardFamily));
                    }
                    if ((vCardGiven = XmlUtil.findElementByTagName((Element)vCardN, (String)V_CARD_GIVEN)) != null) {
                        author.setGivenName(XmlUtil.getTextContent((Element)vCardGiven));
                    }
                }
                if ((vCardORG = XmlUtil.findElementByTagName((Element)li, (String)V_CARD_ORG)) != null && (orgName = XmlUtil.findElementByTagName((Element)vCardORG, (String)V_CARD_ORGNAME)) != null) {
                    author.setOrgName(XmlUtil.getTextContent((Element)vCardORG));
                }
                if ((vCardEMAIL = XmlUtil.findElementByTagName((Element)li, (String)V_CARD_EMAIL)) == null) continue;
                author.setEmail(XmlUtil.getTextContent((Element)vCardEMAIL));
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Athour can not be parsed" + ExceptionRegistry.log((Throwable)e));
            }
        }
        info.setAuthors(authors.toArray(new DiagramInfo.AuthorInfo[authors.size()]));
    }

    @Override
    public Element[] writeElement(DiagramElement specie, Document document) {
        boolean writeReferences;
        if (!(specie.getKernel() instanceof Referrer)) {
            return null;
        }
        DatabaseReference[] databasereferences = ((Referrer)specie.getKernel()).getDatabaseReferences();
        String[] literaturereferences = ((Referrer)specie.getKernel()).getLiteratureReferences();
        boolean writeAuthors = specie instanceof Diagram && ((DiagramInfo)specie.getKernel()).getAuthors().length > 0;
        boolean writeTerms = specie instanceof Diagram;
        boolean bl = writeReferences = databasereferences != null && databasereferences.length > 0 || literaturereferences != null && literaturereferences.length > 0;
        if (writeReferences || writeAuthors) {
            String rdfType;
            Element rdf = document.createElement(RDF_ELEMENT);
            rdf.setAttribute(XMLNS_RDF, XMLNS_RDF_VALUE);
            rdf.setAttribute(XMLNS_DC, XMLNS_DC_VALUE);
            rdf.setAttribute(XMLNS_DCTERM, XMLNS_DCTERM_VALUE);
            rdf.setAttribute(XMLNS_VCARD, XMLNS_VCARD_VALUE);
            rdf.setAttribute(XMLNS_BQBIOL, XMLNS_BQBIOL_VALUE);
            rdf.setAttribute(XMLNS_BQMODEL, XMLNS_BQMODEL_VALUE);
            if (writeAuthors) {
                this.writeAuthors((Diagram)specie, document, rdf);
            }
            if (writeTerms) {
                this.writeTerms((Diagram)specie, document, rdf);
            }
            Element description = document.createElement(DESCRIPTION_ELEMENT);
            description.setAttribute(ABOUT_ATTRIBUTE, "#" + specie.getName());
            boolean isModelAnnotated = false;
            if (Diagram.getDiagram((DiagramElement)specie).equals(specie)) {
                isModelAnnotated = true;
            }
            Element relation = null;
            TreeSet<String> types = new TreeSet<String>();
            if (databasereferences != null) {
                for (DatabaseReference databasereference : databasereferences) {
                    String nextType = databasereference.getRelationshipType();
                    if (RdfExtensionReader.checkRelationshipType(nextType)) {
                        if (types.contains(nextType)) continue;
                        DatabaseReference[] filteredReferences = ((Referrer)specie.getKernel()).getDatabaseReferences(nextType);
                        String rdfType2 = this.getRdfType(nextType, isModelAnnotated);
                        relation = this.writeRelationElement(filteredReferences, rdfType2, document);
                        types.add(nextType);
                        if (relation == null) continue;
                        description.appendChild(relation);
                        continue;
                    }
                    this.log.info("Unknown relationship type: " + nextType + ". Database references with this type was removed.");
                }
            }
            if (literaturereferences != null && literaturereferences.length > 0 && (relation = this.writeRelationElement(literaturereferences, rdfType = this.getRdfType(ISDESCRIBEDBY_ELEMENT, isModelAnnotated), document)) != null) {
                description.appendChild(relation);
            }
            if (description.getChildNodes() != null && description.getChildNodes().getLength() != 0) {
                rdf.appendChild(description);
            }
            if (rdf.getChildNodes().getLength() != 0) {
                return new Element[]{rdf};
            }
        }
        return null;
    }

    private void writeAuthors(Diagram diagram, Document doc, Element rdf) {
        DiagramInfo info = (DiagramInfo)diagram.getKernel();
        DiagramInfo.AuthorInfo[] authors = info.getAuthors();
        Element creator = doc.createElement(DCTERMSCREATOR_ELEMENT);
        Element bag = doc.createElement(BAG_ELEMENT);
        for (int i = 0; i < authors.length; ++i) {
            DiagramInfo.AuthorInfo author = authors[i];
            Element li = doc.createElement(LI_ELEMENT);
            li.setAttribute(RDF_PARSE_TYPE, RESOURCE_ATTRIBUTE);
            Element vCardN = doc.createElement(V_CARD_N);
            vCardN.setAttribute(RDF_PARSE_TYPE, RESOURCE_ATTRIBUTE);
            if (author.getFamilyName() != null) {
                Element vCardFamily = doc.createElement(V_CARD_FAMILY);
                vCardFamily.appendChild(doc.createTextNode(author.getFamilyName()));
                vCardN.appendChild(vCardFamily);
            }
            if (author.getGivenName() != null) {
                Element vCardGiven = doc.createElement(V_CARD_GIVEN);
                vCardGiven.appendChild(doc.createTextNode(author.getGivenName()));
                vCardN.appendChild(vCardGiven);
            }
            if (vCardN.hasChildNodes()) {
                li.appendChild(vCardN);
            }
            if (author.getEmail() != null) {
                Element vCardEmail = doc.createElement(V_CARD_EMAIL);
                vCardEmail.appendChild(doc.createTextNode(author.getEmail()));
                li.appendChild(vCardEmail);
            }
            if (author.getOrgName() != null) {
                Element vCardORG = doc.createElement(V_CARD_ORG);
                Element vCardOrgname = doc.createElement(V_CARD_ORGNAME);
                vCardOrgname.appendChild(doc.createTextNode(author.getOrgName()));
                vCardORG.appendChild(vCardOrgname);
                li.appendChild(vCardORG);
            }
            if (!li.hasChildNodes()) continue;
            bag.appendChild(li);
        }
        if (bag.hasChildNodes()) {
            creator.appendChild(bag);
            rdf.appendChild(creator);
        }
    }

    public void writeTerms(Diagram diagram, Document doc, Element rdf) {
        DiagramInfo info = (DiagramInfo)diagram.getKernel();
        String date = info.getCreated();
        if (date != null && !date.isEmpty()) {
            Element created = doc.createElement(DCTERMSCREATED_ELEMENT);
            Element w3cdtf = doc.createElement(DCTERMS_ELEMENT);
            w3cdtf.appendChild(doc.createTextNode(date));
            created.appendChild(w3cdtf);
            rdf.appendChild(created);
        }
        String[] modified = info.getModified();
        Element modfiedElement = doc.createElement(DCTERMSMODIFIED_ELEMENT);
        for (int i = 0; i < modified.length; ++i) {
            if (modified[i].isEmpty()) continue;
            Element w3cdtf = doc.createElement(DCTERMS_ELEMENT);
            w3cdtf.appendChild(doc.createTextNode(modified[i]));
            modfiedElement.appendChild(w3cdtf);
        }
        if (modfiedElement.hasChildNodes()) {
            rdf.appendChild(modfiedElement);
        }
    }

    protected Element writeRelationElement(DatabaseReference[] references, String type, Document document) {
        if (type != null) {
            Element relation = document.createElement(type);
            Element bag = document.createElement(BAG_ELEMENT);
            try {
                for (DatabaseReference dr : references) {
                    DataCollection miriamCollection;
                    Element drElement = document.createElement(LI_ELEMENT);
                    try {
                        miriamCollection = MIRIAM_RESOURCE.getDataCollection(DatabaseInfo.class);
                    }
                    catch (RepositoryException e) {
                        miriamCollection = null;
                    }
                    if (miriamCollection != null) {
                        DatabaseInfo info = (DatabaseInfo)miriamCollection.get(dr.getDatabaseName());
                        if (info != null) {
                            drElement.setAttribute(RESOURCE_ATTRIBUTE, info.getURN() + ":" + TextUtil.encodeURL((String)dr.getId()));
                        } else {
                            drElement.setAttribute(RESOURCE_ATTRIBUTE, dr.getDatabaseName() + "#" + TextUtil.encodeURL((String)dr.getId()));
                        }
                    } else {
                        String divider = dr.getDatabaseName().startsWith(URN_MIRIAM) ? ":" : "#";
                        drElement.setAttribute(RESOURCE_ATTRIBUTE, dr.getDatabaseName() + divider + TextUtil.encodeURL((String)dr.getId()));
                    }
                    bag.appendChild(drElement);
                }
                relation.appendChild(bag);
                return relation;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "RdfExtensionReader: can not write relation elements:" + e);
            }
        }
        return null;
    }

    protected Element writeRelationElement(String[] references, String type, Document document) {
        Element relation = document.createElement(type);
        Element bag = document.createElement(BAG_ELEMENT);
        try {
            for (String dr : references) {
                DataCollection miriamCollection;
                Element drElement = document.createElement(LI_ELEMENT);
                try {
                    miriamCollection = MIRIAM_RESOURCE.getDataCollection(DatabaseInfo.class);
                }
                catch (RepositoryException e) {
                    miriamCollection = null;
                }
                if (miriamCollection != null) {
                    DatabaseInfo info = (DatabaseInfo)miriamCollection.get("MIR:00000015");
                    drElement.setAttribute(RESOURCE_ATTRIBUTE, info.getURN() + ":" + dr);
                } else {
                    drElement.setAttribute(RESOURCE_ATTRIBUTE, "urn:miriam:pubmed:" + dr);
                }
                bag.appendChild(drElement);
            }
            relation.appendChild(bag);
            return relation;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "RdfExtensionReader: can not write relation elements:" + e);
            return null;
        }
    }

    public static boolean checkRelationshipType(String type) {
        return type != null && RdfExtensionReader.getQualifiers().contains(type);
    }

    protected String getRdfType(String type, boolean isModelAnnotation) {
        String rdfType = null;
        if (isModelAnnotation && (type.equals(IS_ELEMENT) || type.equals(HASINSTANCE_ELEMENT) || type.equals(ISINSTANCEOF_ELEMENT) || type.equals(ISDESCRIBEDBY_ELEMENT) || type.equals(ISDERIVEDFROM_ELEMENT))) {
            rdfType = "bqmodel:" + type;
        } else if (!type.equals(ISDERIVEDFROM_ELEMENT)) {
            rdfType = "bqbiol:" + type;
        }
        return rdfType;
    }
}

