/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RandomExtension
extends SbmlExtensionSupport {
    private static Map<String, String> definitions = new HashMap<String, String>(){
        {
            this.put("binomial", "http://en.wikipedia.org/wiki/Binomial_distribution");
            this.put("normal", "http://en.wikipedia.org/wiki/Normal_distribution");
            this.put("uniform", "http://en.wikipedia.org/wiki/Uniform_distribution_(continous)");
        }
    };

    @Override
    public Element[] writeElement(DiagramElement de, Document document) {
        if (de.getKernel() != null && de.getKernel().getType().equals("math-function")) {
            Element randomElement = document.createElement("distribution");
            String name = de.getName();
            if (definitions.containsKey("binomial")) {
                randomElement.setAttribute("xmlns", "http://sbml.org/annotations/distribution");
                randomElement.setAttribute("defnition", definitions.get(name));
                return new Element[]{randomElement};
            }
        }
        return null;
    }

    @Override
    public void readElement(Element element, DiagramElement specie, @Nonnull Diagram diagram) {
    }
}

