/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import biouml.model.Diagram;
import biouml.model.Module;
import biouml.plugins.sbml.extensions.DiagramIndex;
import biouml.plugins.sbml.extensions.ResultDataCollection;
import biouml.standard.simulation.plot.Plot;
import biouml.standard.simulation.plot.Series;
import biouml.workbench.diagram.DiagramDocument;
import com.developmentontheedge.beans.DynamicProperty;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.AbstractDataCollection;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.Index;
import ru.biosoft.gui.Document;

public class PlotDataCollection
extends AbstractDataCollection<Plot> {
    protected static final Logger log = Logger.getLogger(PlotDataCollection.class.getName());
    protected Index namesMap = null;
    protected boolean isInitNameList = false;

    public PlotDataCollection(DataCollection<?> parent, Properties properties) {
        super(parent, properties);
        try {
            this.namesMap = new DiagramIndex(new File(properties.getProperty("configPath")), "plot.index");
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create index", t);
        }
    }

    protected void initNameList() {
        if (this.isInitNameList) {
            return;
        }
        this.isInitNameList = true;
        if (!this.namesMap.isValid()) {
            try {
                DataCollection diagrams = Module.getModule((DataElement)this).getDiagrams();
                for (Diagram diagram : diagrams) {
                    Object object = diagram.getAttributes().getValue("plots");
                    if (object == null || !(object instanceof Plot[])) continue;
                    for (Plot plot : (Plot[])object) {
                        this.namesMap.put((Object)plot.getName(), (Object)diagram.getName());
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't initialize collection " + this.getName(), t);
            }
        }
    }

    @Nonnull
    public List<String> getNameList() {
        return this.names().toList();
    }

    public StreamEx<String> names() {
        this.initNameList();
        return StreamEx.ofKeys((Map)this.namesMap);
    }

    protected Plot doGet(String name) {
        if (this.namesMap.containsKey((Object)name)) {
            try {
                Diagram diagram = Module.getModule((DataElement)this).getDiagram((String)this.namesMap.get((Object)name));
                Object object = diagram.getAttributes().getValue("plots");
                if (object != null && object instanceof Plot[]) {
                    for (Plot plot : (Plot[])object) {
                        if (!plot.getName().equals(name)) continue;
                        return plot;
                    }
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't get element " + name + " from " + this.getName(), t);
            }
        }
        return null;
    }

    protected void doPut(Plot plot, boolean isNew) throws Exception {
        Document document = Document.getCurrentDocument();
        Diagram diagram = null;
        if (document != null && document instanceof DiagramDocument) {
            diagram = ((DiagramDocument)document).getDiagram();
        } else {
            List series = plot.getSeries();
            if (series != null && series.size() > 0) {
                Module resultsDC = Module.getModule((DataElement)this);
                try {
                    resultsDC = (DataCollection)resultsDC.get("Simulation");
                    resultsDC = (DataCollection)resultsDC.get("result");
                }
                catch (Exception e) {
                    return;
                }
                if (resultsDC instanceof ResultDataCollection && ((Series)series.get(0)).getSourceNature().equals((Object)Series.SourceNature.SIMULATION_RESULT)) {
                    String diagramName = ((ResultDataCollection)resultsDC).getDiagramNameByExperiment(((Series)series.get(0)).getSource());
                    diagram = Module.getModule((DataElement)this).getDiagram(diagramName);
                }
            }
        }
        if (diagram == null) {
            return;
        }
        Object object = diagram.getAttributes().getValue("plots");
        Plot[] newPlots = null;
        if (object != null && object instanceof Plot[]) {
            Plot[] oldSimulations = (Plot[])object;
            newPlots = new Plot[oldSimulations.length + 1];
            System.arraycopy(oldSimulations, 0, newPlots, 0, oldSimulations.length);
            newPlots[oldSimulations.length] = plot;
            diagram.getAttributes().getProperty("plots").setValue((Object)newPlots);
        } else {
            newPlots = new Plot[]{plot};
            try {
                diagram.getAttributes().add(new DynamicProperty("plots", Plot[].class, (Object)newPlots));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.namesMap.put((Object)plot.getName(), (Object)diagram.getName());
    }

    protected void doRemove(String name) throws Exception {
        if (this.namesMap.containsKey((Object)name)) {
            try {
                DataCollection diagramsDC = Module.getModule((DataElement)this).getDiagrams();
                Diagram diagram = (Diagram)diagramsDC.get((String)this.namesMap.get((Object)name));
                Object object = diagram.getAttributes().getValue("plots");
                if (object != null && object instanceof Plot[]) {
                    int pos = 0;
                    Plot[] newSimulations = new Plot[((Plot[])object).length - 1];
                    for (Plot plot : (Plot[])object) {
                        if (plot.getName().equals(name)) continue;
                        newSimulations[pos++] = plot;
                    }
                    diagram.getAttributes().getProperty("plots").setValue((Object)newSimulations);
                    this.namesMap.remove((Object)name);
                    diagramsDC.put((DataElement)diagram);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "can't remove element " + name + " from " + this.getName(), t);
            }
        }
    }

    public int getSize() {
        this.initNameList();
        return this.namesMap.size();
    }

    public boolean contains(String name) {
        return this.namesMap.containsKey((Object)name);
    }

    public void close() throws Exception {
        super.close();
        if (this.namesMap != null) {
            this.namesMap.close();
            this.namesMap = null;
        }
    }
}

