/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.extensions;

import com.developmentontheedge.application.ApplicationUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ru.biosoft.access.core.Index;
import ru.biosoft.access.core.Key;

public class DiagramIndex
extends HashMap<String, String>
implements Index<String> {
    private String indexName;
    private File indexFile = null;
    private boolean valid = false;

    public DiagramIndex(File directory, String indexName) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("target directory not specified.");
        }
        if (indexName == null) {
            indexName = "id";
        }
        this.indexName = indexName;
        this.indexFile = new File(directory.getPath() + "/" + indexName);
        if (this.indexFile.exists()) {
            if (!this.indexFile.canRead()) {
                throw new IOException("Can not read file " + this.indexFile.getName());
            }
            if (!this.indexFile.canWrite()) {
                throw new IOException("Can not write file " + this.indexFile.getName());
            }
            this.readIndexFile();
        }
    }

    public String getName() {
        return this.indexName;
    }

    public Iterator nodeIterator(Key key) {
        throw new UnsupportedOperationException("Method nodeIterator() not yet implemented.");
    }

    public boolean isValid() {
        return this.valid;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public void close() throws FileNotFoundException, IOException {
        try (PrintWriter file = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexFile), StandardCharsets.UTF_8));){
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                String idx = (String)entry.getValue();
                file.write(key + "\n");
                file.write(idx + "\n");
            }
            file.flush();
        }
    }

    private void readIndexFile() throws IOException {
        try (BufferedReader file = ApplicationUtils.utfReader((File)this.indexFile);){
            String key = file.readLine();
            while (key != null && key.length() > 0) {
                String value = file.readLine();
                this.put(key, value);
                key = file.readLine();
            }
            this.valid = true;
        }
    }
}

