/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.converters;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.DiagramTypeConverterSupport;
import biouml.model.Edge;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.plugins.sbml.SbmlDiagramType;
import biouml.plugins.sbml.SbmlDiagramType_L3v1;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.extensions.RdfExtensionReader;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Cell;
import biouml.standard.type.Compartment;
import biouml.standard.type.Concept;
import biouml.standard.type.DatabaseInfo;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Gene;
import biouml.standard.type.GenericEntity;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Protein;
import biouml.standard.type.Publication;
import biouml.standard.type.RNA;
import biouml.standard.type.Reaction;
import biouml.standard.type.Referrer;
import biouml.standard.type.SemanticRelation;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import biouml.standard.type.Substance;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import one.util.streamex.StreamEx;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graph.Path;

public class SbmlConverter
extends DiagramTypeConverterSupport {
    protected String[] nodeKernelTypes = new String[]{"compartment-cell", "semantic-concept", "molecule-gene", "molecule-RNA", "molecule-protein", "molecule-substance"};
    protected String[] edgeKernelTypes = new String[]{"relation-semantic", "relation-chemical"};
    public static final String COMPLETE_NAME_ATTR = "completeName";
    public static final String CAS_REGISTRY_NUMBER_ATTR = "casRegistryNumber";
    public static final String FORMULA_ATTR = "formula";
    public static final String STRUCTURE_REFERENCES_ATTR = "structureReferences";
    public static final String SYNONYMS_ATTR = "synonyms";
    public static final String FUNCTIONAL_STATE_ATTR = "functionalState";
    public static final String GENE_ATTR = "gene";
    public static final String MODIFICATION_ATTR = "modification";
    public static final String REGULATION_ATTR = "regulation";
    public static final String SPECIES_ATTR = "species";
    public static final String SOURCE_ATTR = "source";
    public static final String RNA_TYPE_ATTR = "rnaType";
    public static final String CHROMOSOME_ATTR = "chromosome";
    public static final String DEFAULT_COLOR_ATTR = "defaultColor";
    public static final String RELATION_TYPE_ATTR = "relationType";
    public static final String INPUT_ELEMENT_NAME_ATTR = "inputElementName";
    public static final String OUTPUT_ELEMENT_NAME_ATTR = "outputElementName";
    public static final String MODIFIER_ACTION_ATTR = "modifierAction";
    public static final String PARTICIPATION_ATTR = "participation";
    public static final String ROLE_ATTR = "role";
    public static final String SPECIE_ATTR = "specie";
    public static final String STOICHIOMETRY_ATTR = "stoichiometry";
    public static final String MIRIAM_RESOURCE = "databases/Utils/MIRIAM";

    public Diagram convert(Diagram diagram, Object type) throws Exception {
        if (type instanceof Class && SbmlDiagramType.class.isAssignableFrom((Class)type) && !((Class)type).equals(SbmlDiagramType.class)) {
            return super.convert(diagram, type);
        }
        return super.convert(diagram, SbmlDiagramType_L3v1.class);
    }

    protected Diagram convert(DiagramType diagramType, Diagram diagram) throws Exception {
        Diagram oldDiagram = diagram.clone(diagram.getOrigin(), diagram.getName());
        diagram.setType(diagramType);
        diagram.clear();
        DiagramInfo oldInfo = (DiagramInfo)diagram.getKernel();
        DiagramInfo newInfo = oldInfo.clone(diagram.getName());
        this.fillMainProperties((BaseSupport)oldInfo, (Referrer)newInfo);
        diagram.setKernel((Base)newInfo);
        if (this.isEModel(diagram)) {
            boolean notification = ((EModel)diagram.getRole(EModel.class)).isNotificationEnabled();
            SbmlEModel emodel = new SbmlEModel((DiagramElement)diagram);
            diagram.setRole((Role)emodel);
            emodel.setNotificationEnabled(notification);
        } else if (diagram.getRole() == null) {
            diagram.setRole((Role)new SbmlEModel((DiagramElement)diagram));
        }
        try {
            this.transformNodesAndEdges((biouml.model.Compartment)diagram, (biouml.model.Compartment)oldDiagram);
            if (this.isEModel(oldDiagram)) {
                this.copyParameters(diagram, (EModel)oldDiagram.getRole(EModel.class));
                this.transformUnits(diagram);
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't convert diagram: ", t);
        }
        return diagram;
    }

    private boolean isEModel(Diagram diagram) {
        return diagram.getRole() != null && diagram.getRole() instanceof EModel;
    }

    protected void copyParameters(Diagram diagram, EModel oldModel) {
        EModel model = (EModel)diagram.getRole(EModel.class);
        for (Variable var : oldModel.getParameters()) {
            Variable newVar = (Variable)var.clone();
            var.setOrigin(model.getVariables());
            var.setParent((Option)model);
            model.put(newVar);
        }
    }

    protected void transformUnits(Diagram diagram) throws Exception {
        DataCollection variables;
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        Set unitsSet = StreamEx.ofValues((Map)emodel.getUnits()).map(Unit::getTitle).toSet();
        DataCollection unitsDC = null;
        Module module = Module.optModule((DataElement)diagram);
        if (module != null && module.get("Dictionaries") != null) {
            DataCollection dictionaries = (DataCollection)module.get("Dictionaries");
            unitsDC = (DataCollection)dictionaries.get("unit");
        }
        if ((variables = emodel.getVariables()) != null) {
            for (Variable var : variables) {
                String varUnits = var.getUnits();
                if (varUnits == null || varUnits.isEmpty() || Unit.getBaseUnitsList().contains(varUnits) || unitsSet.contains(varUnits)) continue;
                if (unitsDC != null) {
                    Unit unit = null;
                    for (Unit de : unitsDC) {
                        if (!de.getTitle().equals(varUnits)) continue;
                        unit = de;
                        break;
                    }
                    if (unit != null) {
                        Unit newUnit = unit.clone(null, unit.getTitle());
                        emodel.addUnit(newUnit);
                        unitsSet.add(varUnits);
                        continue;
                    }
                    var.setUnits("");
                    log.info("All units except the table units must be declared in the units data collection. Unknown units " + varUnits + " was remove.");
                    continue;
                }
                var.setUnits("");
                log.info("SbmlConverter: can not convert units " + varUnits + ". Units data collection is null.");
            }
        }
    }

    protected void transformNodesAndEdges(biouml.model.Compartment newCompartment, biouml.model.Compartment oldCompartment) throws Exception {
        ArrayList elements = new ArrayList(DataCollectionUtils.asCollection((DataCollection)oldCompartment, DiagramElement.class));
        for (DiagramElement de : elements) {
            if (!(de instanceof Node)) continue;
            this.transformNode((Node)de, newCompartment);
        }
        for (DiagramElement de : elements) {
            if (!(de instanceof Edge)) continue;
            this.transformEdge((Edge)de, newCompartment, oldCompartment);
        }
    }

    protected void transformNode(Node node, biouml.model.Compartment newCompartment) throws Exception {
        Base kernel = node.getKernel();
        if (kernel instanceof Specie) {
            if (node instanceof biouml.model.Compartment) {
                Specie newKernel = new Specie(null, kernel.getName());
                this.copyAttributes((BaseSupport)((Specie)kernel), (BaseSupport)newKernel);
                Node newNode = new Node((DataCollection)newCompartment, (Base)newKernel);
                this.fillNodeFields(newNode, node);
                newCompartment.put((DiagramElement)newNode);
            } else {
                newCompartment.put((DiagramElement)node.clone(newCompartment, node.getName()));
            }
            return;
        }
        if (kernel instanceof Reaction) {
            Edge[] edges;
            Reaction newKernel = new Reaction(null, kernel.getName());
            this.copyAttributes((BaseSupport)((Reaction)kernel), (BaseSupport)newKernel);
            this.fillMainProperties((BaseSupport)((Reaction)kernel), (Referrer)newKernel);
            newKernel.setFast(((Reaction)kernel).isFast());
            KineticLaw kineticLaw = ((Reaction)kernel).getKineticLaw();
            newKernel.getKineticLaw().setComment(kineticLaw.getComment());
            newKernel.getKineticLaw().setFormula(kineticLaw.getFormula());
            newKernel.getKineticLaw().setSubstanceUnits(kineticLaw.getSubstanceUnits());
            newKernel.getKineticLaw().setTimeUnits(kineticLaw.getTimeUnits());
            Node newNode = new Node((DataCollection)newCompartment, (Base)newKernel);
            this.fillNodeFields(newNode, node);
            newCompartment.put((DiagramElement)newNode);
            for (Edge edge : edges = node.getEdges()) {
                if (edge.getKernel() == null || !(edge.getKernel() instanceof SpecieReference) || !((Reaction)kernel).contains((DataElement)edge.getKernel())) continue;
                SpecieReference spRef = (SpecieReference)edge.getKernel();
                SpecieReference newSpRef = spRef.clone(spRef.getOrigin(), spRef.getName());
                newKernel.put(newSpRef);
                Node element = "product".equals(spRef.getRole()) ? edge.getOutput() : edge.getInput();
                String newSpecie = element.getCompleteNameInDiagram();
                newSpRef.setSpecie(newSpecie);
            }
            return;
        }
        if (kernel instanceof Stub && kernel.getType().equals("reaction")) {
            Edge[] edges;
            DataElement de;
            Object completeNameObj = node.getAttributes().getValue(COMPLETE_NAME_ATTR);
            if (completeNameObj != null && (de = CollectionFactory.getDataElement((String)completeNameObj.toString())) instanceof Reaction) {
                kernel = (Reaction)de;
            }
            Reaction newKernel = new Reaction(null, kernel.getName());
            this.copyAttributes((BaseSupport)((Reaction)kernel), (BaseSupport)newKernel);
            this.fillMainProperties((BaseSupport)((Reaction)kernel), (Referrer)newKernel);
            newKernel.setFast(((Reaction)kernel).isFast());
            KineticLaw kineticLaw = ((Reaction)kernel).getKineticLaw();
            newKernel.getKineticLaw().setComment(kineticLaw.getComment());
            newKernel.getKineticLaw().setFormula(kineticLaw.getFormula());
            newKernel.getKineticLaw().setSubstanceUnits(kineticLaw.getSubstanceUnits());
            newKernel.getKineticLaw().setTimeUnits(kineticLaw.getTimeUnits());
            Node newNode = new Node((DataCollection)newCompartment, (Base)newKernel);
            this.fillNodeFields(newNode, node);
            newCompartment.put((DiagramElement)newNode);
            for (Edge edge : edges = node.getEdges()) {
                if (edge.getKernel() == null || !(edge.getKernel() instanceof SpecieReference)) continue;
                SpecieReference spRef = (SpecieReference)edge.getKernel();
                SpecieReference newSpRef = spRef.clone(spRef.getOrigin(), spRef.getName());
                newKernel.put(newSpRef);
                Node element = "product".equals(spRef.getRole()) ? edge.getOutput() : edge.getInput();
                String newSpecie = element.getCompleteNameInDiagram();
                newSpRef.setSpecie(newSpecie);
            }
            return;
        }
        Role role = node.getRole();
        if (role != null && (role instanceof Event || role instanceof Equation || role instanceof Function)) {
            String newName = node.getName().replace("-", "_");
            Node newNode = node.clone(newCompartment, newName);
            newNode = (Node)Diagram.getDiagram((DiagramElement)newNode).getType().getSemanticController().validate(newCompartment, (DiagramElement)newNode);
            newCompartment.put((DiagramElement)newNode);
            return;
        }
        if (kernel.getType().equals("compartment")) {
            Compartment newKernel = new Compartment(null, kernel.getName());
            this.copyAttributes((BaseSupport)kernel, (BaseSupport)newKernel);
            this.fillMainProperties((BaseSupport)kernel, (Referrer)newKernel);
            biouml.model.Compartment newNode = new biouml.model.Compartment((DataCollection)newCompartment, (Base)newKernel);
            newNode = (biouml.model.Compartment)Diagram.getDiagram((DiagramElement)newNode).getType().getSemanticController().validate(newCompartment, (DiagramElement)newNode);
            newNode.setShapeSize(node.getShapeSize());
            newNode.setShapeType(((biouml.model.Compartment)node).getShapeType());
            this.fillNodeFields((Node)newNode, node);
            newCompartment.put((DiagramElement)newNode);
            this.transformNodesAndEdges(newNode, (biouml.model.Compartment)node);
            return;
        }
        if (kernel.getType().equals("block")) {
            biouml.model.Compartment c = (biouml.model.Compartment)node;
            for (Node n : c.getNodes()) {
                this.transformNode(n, newCompartment);
            }
        }
        if (this.shouldNodeTransformed(kernel)) {
            Specie newSpecie = new Specie(null, kernel.getName());
            this.fillNodeKernelFields(newSpecie, kernel);
            Node newNode = new Node((DataCollection)newCompartment, (Base)newSpecie);
            newNode = (Node)Diagram.getDiagram((DiagramElement)newNode).getType().getSemanticController().validate(newCompartment, (DiagramElement)newNode);
            this.fillNodeFields(newNode, node);
            newCompartment.put((DiagramElement)newNode);
        }
    }

    protected void transformEdge(Edge edge, biouml.model.Compartment newCompartment, biouml.model.Compartment oldCompartment) throws Exception {
        Diagram diagram = Diagram.getDiagram((DiagramElement)newCompartment);
        Node inputSpecieNode = diagram.findNode(edge.getInput().getCompleteNameInDiagram());
        Node outputSpecieNode = diagram.findNode(edge.getOutput().getCompleteNameInDiagram());
        if (inputSpecieNode == null || outputSpecieNode == null) {
            return;
        }
        Reaction reactionKernel = null;
        Node specieReferenceNode = null;
        if (inputSpecieNode.getKernel() instanceof Reaction) {
            reactionKernel = (Reaction)inputSpecieNode.getKernel();
            specieReferenceNode = outputSpecieNode;
        } else if (outputSpecieNode.getKernel() instanceof Reaction) {
            reactionKernel = (Reaction)outputSpecieNode.getKernel();
            specieReferenceNode = inputSpecieNode;
        } else {
            return;
        }
        if (reactionKernel != null) {
            SpecieReference kernel = null;
            for (SpecieReference spRef : reactionKernel) {
                String specie = spRef.getSpecie();
                if (!specieReferenceNode.getCompleteNameInDiagram().equals(specie)) continue;
                kernel = spRef;
                break;
            }
            if (kernel == null) {
                kernel = new SpecieReference((DataCollection)reactionKernel, ((SpecieReference)edge.getKernel()).getName(), ((SpecieReference)edge.getKernel()).getRole());
                kernel.setSpecie(specieReferenceNode.getCompleteNameInDiagram());
            }
            Edge newEdge = new Edge((DataCollection)newCompartment, edge.getName(), kernel, inputSpecieNode, outputSpecieNode);
            Role role = edge.getRole();
            if (role != null) {
                newEdge.setRole(role.clone((DiagramElement)newEdge));
            }
            this.copyAttributes((DiagramElement)edge, (DiagramElement)newEdge);
            newEdge.setComment(edge.getComment());
            newEdge.setTitle(edge.getTitle());
            newEdge.setPath(edge.getPath() != null ? edge.getPath() : new Path());
            inputSpecieNode.addEdge(newEdge);
            outputSpecieNode.addEdge(newEdge);
            newCompartment.put((DiagramElement)newEdge);
            return;
        }
        Base kernel = edge.getKernel();
        if (this.shouldEdgeTransformed(kernel)) {
            Reaction newKernel = new Reaction(null, kernel.getName());
            SpecieReference input = new SpecieReference(null, kernel.getName() + "-input");
            input.setSpecie(inputSpecieNode.getName());
            input.setRole("reactant");
            SpecieReference output = new SpecieReference(null, kernel.getName() + "-output");
            output.setSpecie(outputSpecieNode.getName());
            output.setRole("product");
            newKernel.setSpecieReferences(new SpecieReference[]{input, output});
            this.fillEdgeKernelFields(newKernel, kernel);
            Node newReaction = new Node((DataCollection)newCompartment, (Base)newKernel);
            Point inputLocation = inputSpecieNode.getLocation();
            Point outputLocation = outputSpecieNode.getLocation();
            newReaction.setLocation((inputLocation.x + outputLocation.x) / 2, (inputLocation.y + outputLocation.y) / 2);
            newCompartment.put((DiagramElement)newReaction);
            Edge inputEdge = new Edge((DataCollection)newCompartment, (Base)input, inputSpecieNode, newReaction);
            newCompartment.put((DiagramElement)inputEdge);
            Edge outputEdge = new Edge((DataCollection)newCompartment, (Base)output, newReaction, outputSpecieNode);
            newCompartment.put((DiagramElement)outputEdge);
        }
    }

    protected boolean shouldNodeTransformed(Base kernel) {
        for (String type : this.nodeKernelTypes) {
            if (!kernel.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldEdgeTransformed(Base kernel) {
        for (String type : this.edgeKernelTypes) {
            if (!kernel.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    protected DatabaseReference[] transformDatabaseReferences(Referrer kernel) {
        DatabaseReference[] references = kernel.getDatabaseReferences();
        ArrayList<DatabaseReference> newReferences = null;
        if (references != null) {
            try {
                newReferences = new ArrayList<DatabaseReference>();
                for (DatabaseReference ref : references) {
                    Module module = Module.optModule((DataElement)kernel);
                    if (module == null || module.get("Dictionaries") == null) continue;
                    DataCollection metadata = (DataCollection)module.get("Dictionaries");
                    DataCollection databaseInfos = (DataCollection)metadata.get("database info");
                    if (databaseInfos != null) {
                        DatabaseInfo info = null;
                        String databaseName = ref.getDatabaseName();
                        if (databaseInfos.contains(databaseName)) {
                            info = (DatabaseInfo)databaseInfos.get(databaseName);
                        } else {
                            for (DatabaseReference[] intermediateInfo : databaseInfos) {
                                if (!intermediateInfo.getTitle().equals(databaseName)) continue;
                                info = intermediateInfo;
                                break;
                            }
                        }
                        if (info == null) {
                            log.info("Database reference " + ref.getId() + " of element " + kernel.getName() + " was removed. Reason: database info " + databaseName + " is null.");
                            continue;
                        }
                        if (info.getDatabaseReferences() == null) {
                            log.info("Database reference " + ref.getId() + " of element " + kernel.getName() + " was removed. Reason: there is no match for " + info.getTitle() + " in Miriam database.");
                            continue;
                        }
                        DataCollection miriamCollection = (DataCollection)CollectionFactory.getDataElement((String)MIRIAM_RESOURCE);
                        if (miriamCollection != null) {
                            for (DatabaseReference reference : info.getDatabaseReferences()) {
                                if (!miriamCollection.contains(reference.getId())) continue;
                                info = (DatabaseInfo)miriamCollection.get(reference.getId());
                                break;
                            }
                        } else {
                            log.log(Level.SEVERE, "Can not convert database references. Miriam database is null.");
                            return null;
                        }
                        if (info == null) continue;
                        DatabaseReference newRef = new DatabaseReference(info.getName(), ref.getId());
                        newRef.setComment(ref.getComment());
                        String type = ref.getRelationshipType();
                        if (RdfExtensionReader.checkRelationshipType(type)) {
                            newRef.setRelationshipType(type);
                            newReferences.add(newRef);
                            continue;
                        }
                        log.info("Database reference " + ref.getId() + " of element " + kernel.getName() + " was removed. Reason: unknown relationship type.");
                        continue;
                    }
                    log.log(Level.SEVERE, "Can not transform database references. Reason: database infos collection is null.");
                    return null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (newReferences != null) {
            return newReferences.toArray(new DatabaseReference[newReferences.size()]);
        }
        return null;
    }

    protected String[] transformLiteratureReferences(Referrer kernel) {
        String[] references = kernel.getLiteratureReferences();
        ArrayList<String> newReferences = new ArrayList<String>();
        if (references != null) {
            try {
                for (String ref : references) {
                    Module module = Module.optModule((DataElement)kernel);
                    if (module == null || module.get("Data") == null) continue;
                    DataCollection data = (DataCollection)module.get("Data");
                    DataCollection literature = (DataCollection)data.get("literature");
                    if (literature != null) {
                        if (literature.contains(ref)) {
                            Publication publication = (Publication)literature.get(ref);
                            if (publication.getPubMedId() != null && !publication.getPubMedId().equals("") && !publication.getPubMedId().equals("0")) {
                                newReferences.add(publication.getPubMedId());
                                continue;
                            }
                            log.info("Literature reference " + publication.getReference() + " of element " + kernel.getName() + " was removed. Reason: PubMedId of the publication is incorrect.");
                            continue;
                        }
                        log.log(Level.SEVERE, "The element " + ref + " does not exist in the literature database.");
                        continue;
                    }
                    log.log(Level.SEVERE, "Can not transform literature references. Reason: literature collection is null.");
                    return null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return newReferences.toArray(new String[newReferences.size()]);
    }

    protected void fillNodeFields(Node newNode, Node node) {
        newNode.setLocation(node.getLocation());
        newNode.setTitle(node.getTitle());
        newNode.setComment(node.getComment());
        Role nodeRole = node.getRole();
        if (nodeRole != null) {
            newNode.setRole(nodeRole.clone((DiagramElement)newNode));
        }
        this.copyAttributes((DiagramElement)node, (DiagramElement)newNode);
    }

    public void fillNodeKernelFields(Specie newSpecie, Base oldSpecie) {
        this.fillNodeKernelFields(newSpecie, oldSpecie, true);
    }

    public void fillNodeKernelFields(Specie newSpecie, Base oldSpecie, boolean transformReferences) {
        if (oldSpecie instanceof BaseSupport) {
            this.copyAttributes((BaseSupport)oldSpecie, (BaseSupport)newSpecie);
            if (oldSpecie instanceof Referrer) {
                this.fillMainProperties((BaseSupport)((Referrer)oldSpecie), (Referrer)newSpecie, transformReferences);
                if (oldSpecie instanceof Substance) {
                    this.fillKernelFromSubstance(newSpecie, (Substance)oldSpecie);
                } else if (oldSpecie instanceof Protein) {
                    this.fillKernelFromProtein(newSpecie, (Protein)oldSpecie);
                } else if (oldSpecie instanceof RNA) {
                    this.fillKernelFromRNA(newSpecie, (RNA)oldSpecie);
                } else if (oldSpecie instanceof Gene) {
                    this.fillKernelFromGene(newSpecie, (Gene)oldSpecie);
                } else if (oldSpecie instanceof Concept) {
                    this.fillKernelFromConcept(newSpecie, (Concept)oldSpecie);
                } else if (oldSpecie instanceof Cell) {
                    this.fillKernelFromCell(newSpecie, (Cell)oldSpecie);
                }
            }
        }
    }

    protected void fillEdgeKernelFields(Reaction newReaction, Base oldSpecie) {
        if (oldSpecie instanceof SemanticRelation) {
            this.fillKernelFromSemanticRelation(newReaction, (SemanticRelation)oldSpecie);
        } else if (oldSpecie instanceof SpecieReference) {
            this.fillKernelFromSpecieReference(newReaction, (SpecieReference)oldSpecie);
        }
    }

    protected void fillKernelFromSubstance(Specie newSpecie, Substance oldSpecie) {
        try {
            String synonyms;
            String[] structureReferences;
            String formula;
            String casRegistryNumber;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((casRegistryNumber = oldSpecie.getCasRegistryNumber()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(CAS_REGISTRY_NUMBER_ATTR, String.class, (Object)casRegistryNumber));
            }
            if ((formula = oldSpecie.getFormula()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(FORMULA_ATTR, String.class, (Object)formula));
            }
            if ((structureReferences = oldSpecie.getStructureReferences()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(STRUCTURE_REFERENCES_ATTR, String[].class, (Object)structureReferences));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromProtein(Specie newSpecie, Protein oldSpecie) {
        try {
            String source;
            String species;
            String regulation;
            String modification;
            String gene;
            String functionalState;
            String synonyms;
            String[] structureReferences;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((structureReferences = oldSpecie.getStructureReferences()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(STRUCTURE_REFERENCES_ATTR, String[].class, (Object)structureReferences));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
            if ((functionalState = oldSpecie.getFunctionalState()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(FUNCTIONAL_STATE_ATTR, String.class, (Object)functionalState));
            }
            if ((gene = oldSpecie.getGene()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(GENE_ATTR, String.class, (Object)gene));
            }
            if ((modification = oldSpecie.getModification()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(MODIFICATION_ATTR, String.class, (Object)modification));
            }
            if ((regulation = oldSpecie.getRegulation()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(REGULATION_ATTR, String.class, (Object)regulation));
            }
            if ((species = oldSpecie.getSpecies()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SPECIES_ATTR, String.class, (Object)species));
            }
            if ((source = oldSpecie.getSource()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SOURCE_ATTR, String.class, (Object)source));
            }
            newSpecie.setType("molecule-protein");
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromRNA(Specie newSpecie, RNA oldSpecie) {
        try {
            String rnaType;
            String source;
            String species;
            String regulation;
            String gene;
            String synonyms;
            String[] structureReferences;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((structureReferences = oldSpecie.getStructureReferences()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(STRUCTURE_REFERENCES_ATTR, String[].class, (Object)structureReferences));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
            if ((gene = oldSpecie.getGene()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(GENE_ATTR, String.class, (Object)gene));
            }
            if ((regulation = oldSpecie.getRegulation()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(REGULATION_ATTR, String.class, (Object)regulation));
            }
            if ((species = oldSpecie.getSpecies()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SPECIES_ATTR, String.class, (Object)species));
            }
            if ((source = oldSpecie.getSource()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SOURCE_ATTR, String.class, (Object)source));
            }
            if ((rnaType = oldSpecie.getRnaType()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(RNA_TYPE_ATTR, String.class, (Object)rnaType));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromGene(Specie newSpecie, Gene oldSpecie) {
        try {
            String source;
            String species;
            String regulation;
            String synonyms;
            String[] structureReferences;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((structureReferences = oldSpecie.getStructureReferences()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(STRUCTURE_REFERENCES_ATTR, String[].class, (Object)structureReferences));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
            if ((regulation = oldSpecie.getRegulation()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(REGULATION_ATTR, String.class, (Object)regulation));
            }
            if ((species = oldSpecie.getSpecies()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SPECIES_ATTR, String.class, (Object)species));
            }
            if ((source = oldSpecie.getSource()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SOURCE_ATTR, String.class, (Object)source));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromConcept(Specie newSpecie, Concept oldSpecie) {
        try {
            String synonyms;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromCell(Specie newSpecie, Cell oldSpecie) {
        try {
            String species;
            String synonyms;
            String completeName = oldSpecie.getCompleteName();
            if (completeName != null) {
                newSpecie.getAttributes().add(new DynamicProperty(COMPLETE_NAME_ATTR, String.class, (Object)completeName));
            }
            if ((synonyms = oldSpecie.getSynonyms()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SYNONYMS_ATTR, String[].class, (Object)synonyms));
            }
            if ((species = oldSpecie.getSpecies()) != null) {
                newSpecie.getAttributes().add(new DynamicProperty(SPECIES_ATTR, String.class, (Object)species));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromSemanticRelation(Reaction newReaction, SemanticRelation oldSpecie) {
        this.fillMainProperties((BaseSupport)oldSpecie, (Referrer)newReaction);
        this.copyAttributes((BaseSupport)oldSpecie, (BaseSupport)newReaction);
        try {
            String outputElementName;
            String inputElementName;
            String relationType = oldSpecie.getRelationType();
            if (relationType != null) {
                newReaction.getAttributes().add(new DynamicProperty(RELATION_TYPE_ATTR, String.class, (Object)relationType));
            }
            if ((inputElementName = oldSpecie.getInputElementName()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(INPUT_ELEMENT_NAME_ATTR, String.class, (Object)inputElementName));
            }
            if ((outputElementName = oldSpecie.getOutputElementName()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(OUTPUT_ELEMENT_NAME_ATTR, String.class, (Object)outputElementName));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void fillKernelFromSpecieReference(Reaction newReaction, SpecieReference oldSpecie) {
        newReaction.setComment(oldSpecie.getComment());
        newReaction.setTitle(oldSpecie.getTitle());
        newReaction.setDate(oldSpecie.getDate());
        this.copyAttributes((BaseSupport)oldSpecie, (BaseSupport)newReaction);
        try {
            String stoichiometry;
            String specie;
            String role;
            String participation;
            String modifierAction;
            String formula = oldSpecie.getFormula();
            if (formula != null) {
                newReaction.getAttributes().add(new DynamicProperty(FORMULA_ATTR, String.class, (Object)formula));
            }
            if ((modifierAction = oldSpecie.getModifierAction()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(MODIFIER_ACTION_ATTR, String.class, (Object)modifierAction));
            }
            if ((participation = oldSpecie.getParticipation()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(PARTICIPATION_ATTR, String.class, (Object)participation));
            }
            if ((role = oldSpecie.getRole()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(ROLE_ATTR, String.class, (Object)role));
            }
            if ((specie = oldSpecie.getSpecie()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(SPECIE_ATTR, String.class, (Object)specie));
            }
            if ((stoichiometry = oldSpecie.getStoichiometry()) != null) {
                newReaction.getAttributes().add(new DynamicProperty(STOICHIOMETRY_ATTR, String.class, (Object)stoichiometry));
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "can't create attribute for specie", t);
        }
    }

    protected void copyAttributes(BaseSupport input, BaseSupport output) {
        for (DynamicProperty dp : input.getAttributes()) {
            output.getAttributes().add(dp);
        }
    }

    protected void copyAttributes(DiagramElement input, DiagramElement output) {
        for (DynamicProperty dp : input.getAttributes()) {
            output.getAttributes().add(dp);
        }
    }

    protected void fillMainProperties(BaseSupport input, Referrer output) {
        this.fillMainProperties(input, output, true);
    }

    protected void fillMainProperties(BaseSupport input, Referrer output, boolean transformReferences) {
        output.setTitle(input.getTitle());
        if (input instanceof GenericEntity) {
            output.setComment(((GenericEntity)input).getComment());
            output.setDate(((GenericEntity)input).getDate());
        }
        if (input instanceof Referrer) {
            output.setDescription(((Referrer)input).getDescription());
            output.setDatabaseReferences(transformReferences ? this.transformDatabaseReferences((Referrer)input) : ((Referrer)input).getDatabaseReferences());
            output.setLiteratureReferences(transformReferences ? this.transformLiteratureReferences((Referrer)input) : ((Referrer)input).getLiteratureReferences());
        }
    }
}

