/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.converters;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.DiagramTypeConverterSupport;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.EModel;
import biouml.plugins.sbgn.SbgnDiagramType;
import biouml.standard.state.State;
import biouml.standard.type.Base;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public abstract class SBGNConverterSupport
extends DiagramTypeConverterSupport {
    public static final String REACTION_TYPE_ATTR = "ReactionType";
    private static final Set<String> sbgnProperty = new HashSet<String>(Arrays.asList("xmlElementType", "sbgn:cloneMarker", "sbgn:entityType", "sbgn:multimer", "sbgn:reactionType", "Style", "orientation", "BodyColor"));

    protected Object getType() {
        return SbgnDiagramType.class;
    }

    public final Diagram convert(Diagram diagram, Object type) throws Exception {
        return super.convert(diagram, this.getType());
    }

    public final Diagram convert(DiagramType diagramType, Diagram diagram) throws Exception {
        Diagram sbgnDiagram = this.createDiagram(diagramType, diagram);
        boolean isSbmlNotificationEnabled = diagram.isNotificationEnabled();
        boolean isSbmlPropogationEnabled = diagram.isPropagationEnabled();
        boolean isNotificationEnabled = sbgnDiagram.isNotificationEnabled();
        boolean isPropagationEnabled = sbgnDiagram.isPropagationEnabled();
        sbgnDiagram.setNotificationEnabled(false);
        sbgnDiagram.setPropagationEnabled(false);
        diagram.setNotificationEnabled(false);
        diagram.setPropagationEnabled(false);
        State currentState = diagram.getCurrentState();
        if (currentState != null) {
            diagram.restore();
        }
        this.createElements((Compartment)diagram, (Compartment)sbgnDiagram);
        this.createEdges((Compartment)diagram, (Compartment)sbgnDiagram, sbgnDiagram);
        this.copyDiagramProperties(diagram, sbgnDiagram);
        this.copyStates(diagram, sbgnDiagram, currentState);
        this.postProcess(diagram, sbgnDiagram);
        diagram.setNotificationEnabled(isSbmlNotificationEnabled);
        diagram.setPropagationEnabled(isSbmlPropogationEnabled);
        sbgnDiagram.setNotificationEnabled(isNotificationEnabled);
        sbgnDiagram.setPropagationEnabled(isPropagationEnabled);
        return sbgnDiagram;
    }

    public final Diagram restoreSBML(Diagram diagram, DiagramType baseType) throws Exception {
        Diagram newDiagram = this.createDiagram(baseType, diagram);
        boolean isSbmlNotificationEnabled = newDiagram.isNotificationEnabled();
        boolean isSbmlPropogationEnabled = newDiagram.isPropagationEnabled();
        boolean isNotificationEnabled = diagram.isNotificationEnabled();
        boolean isPropagationEnabled = diagram.isPropagationEnabled();
        diagram.setNotificationEnabled(false);
        diagram.setPropagationEnabled(false);
        newDiagram.setNotificationEnabled(false);
        newDiagram.setPropagationEnabled(false);
        State currentState = diagram.getCurrentState();
        if (currentState != null) {
            diagram.restore();
        }
        this.restoreElements((Compartment)diagram, (Compartment)newDiagram);
        this.restoreEdges((Compartment)diagram, (Compartment)newDiagram, newDiagram);
        this.copyDiagramProperties(diagram, newDiagram);
        this.postProcessRestore(diagram, newDiagram);
        this.copyStates(diagram, newDiagram, currentState);
        newDiagram.setNotificationEnabled(isSbmlNotificationEnabled);
        newDiagram.setPropagationEnabled(isSbmlPropogationEnabled);
        diagram.setNotificationEnabled(isNotificationEnabled);
        diagram.setPropagationEnabled(isPropagationEnabled);
        if (diagram.getAttributes().getProperty("Packages") != null) {
            newDiagram.getAttributes().add(diagram.getAttributes().getProperty("Packages"));
        }
        if (diagram.getAttributes().getProperty("fbc:activeObjective") != null) {
            newDiagram.getAttributes().add(diagram.getAttributes().getProperty("fbc:activeObjective"));
        }
        if (diagram.getAttributes().getProperty("listObjectives") != null) {
            newDiagram.getAttributes().add(diagram.getAttributes().getProperty("listObjectives"));
        }
        return newDiagram;
    }

    protected abstract void createElements(Compartment var1, Compartment var2) throws Exception;

    protected abstract void createEdges(Compartment var1, Compartment var2, Diagram var3) throws Exception;

    protected abstract void restoreElements(Compartment var1, Compartment var2) throws Exception;

    protected abstract void restoreEdges(Compartment var1, Compartment var2, Diagram var3) throws Exception;

    protected Diagram createDiagram(DiagramType type, Diagram oldDiagram) throws Exception {
        return type.createDiagram(oldDiagram.getOrigin(), oldDiagram.getName(), null);
    }

    protected void postProcess(Diagram oldDiagram, Diagram diagram) {
        diagram.setView(null);
    }

    protected void postProcessRestore(Diagram oldDiagram, Diagram diagram) throws Exception {
        diagram.setView(null);
    }

    protected void copyDiagramProperties(Diagram from, Diagram to) {
        to.setTitle(from.getTitle());
        this.copyViewOptions(from, to);
        this.copyDiagramInfo(from, to);
        Role diagramRole = from.getRole();
        if (diagramRole instanceof EModel) {
            to.setRole(((EModel)diagramRole).clone((DiagramElement)to));
        }
        SBGNConverterSupport.copyAttributes((DiagramElement)from, (DiagramElement)to);
    }

    protected void copyStates(Diagram from, Diagram to, State initialState) throws Exception {
        State newCurrentState = null;
        for (State state : from.states()) {
            State newState = state.clone(to, state.getName());
            if (!state.equals(initialState)) continue;
            newCurrentState = newState;
        }
        if (initialState != null) {
            to.setStateEditingMode(newCurrentState);
            from.setStateEditingMode(initialState);
        }
    }

    protected void copyViewOptions(Diagram from, Diagram to) {
        DiagramViewOptions viewOptions = to.getViewOptions();
        boolean notificationEnabled = viewOptions.isNotificationEnabled();
        viewOptions.setNotificationEnabled(false);
        viewOptions.setDependencyEdges(from.getViewOptions().isDependencyEdges());
        viewOptions.setAutoLayout(from.getViewOptions().isAutoLayout());
        viewOptions.setNotificationEnabled(notificationEnabled);
    }

    protected void copyDiagramInfo(Diagram from, Diagram to) {
        DiagramInfo fromInfo = (DiagramInfo)from.getKernel();
        DiagramInfo toInfo = (DiagramInfo)to.getKernel();
        toInfo.setDescription(fromInfo.getDescription());
        toInfo.setDatabaseReferences(fromInfo.getDatabaseReferences());
        toInfo.setLiteratureReferences(fromInfo.getLiteratureReferences());
        toInfo.setAuthors((DiagramInfo.AuthorInfo[])fromInfo.getAuthors().clone());
        toInfo.setCreated(fromInfo.getCreated());
        toInfo.setModified((String[])fromInfo.getModified().clone());
    }

    protected void updateEdgeConnections(Diagram diagram, Compartment compartment) {
        compartment.visitEdges(edge -> diagram.getType().getSemanticController().recalculateEdgePath(edge));
    }

    public static String guessReactionType(Node node) {
        Object rtObject = node.getAttributes().getValue(REACTION_TYPE_ATTR);
        if (rtObject != null) {
            String s = rtObject.toString().toLowerCase();
            if (s.endsWith("association")) {
                return "association";
            }
            if (s.endsWith("dissociation")) {
                return "dissociation";
            }
            return "process";
        }
        return SBGNConverterSupport.guessReactionType((Reaction)node.getKernel());
    }

    public static String guessReactionType(Reaction reaction) {
        int reactants = 0;
        int products = 0;
        for (SpecieReference sr : reaction.getSpecieReferences()) {
            if (sr.isReactant()) {
                ++reactants;
                continue;
            }
            if (!sr.isProduct()) continue;
            ++products;
        }
        if (reactants > 1 && products == 1) {
            return "association";
        }
        if (reactants == 1 && products > 1) {
            return "dissociation";
        }
        return "process";
    }

    protected static Compartment createCompartmentClone(Compartment compartment, Compartment base, String name) throws Exception {
        Compartment newCompartment = new Compartment((DataCollection)compartment, name, base.getKernel());
        newCompartment.setLocation(base.getLocation());
        newCompartment.setShapeSize(base.getShapeSize());
        newCompartment.setShapeType(base.getShapeType());
        newCompartment.setRole(base.getRole().clone((DiagramElement)newCompartment));
        newCompartment.setTitle(base.getTitle());
        newCompartment.setComment(base.getComment());
        newCompartment.setVisible(base.isVisible());
        newCompartment.setUseCustomImage(base.isUseCustomImage());
        if (newCompartment.isUseCustomImage()) {
            newCompartment.setImage(base.getImage().clone());
        }
        newCompartment.setPredefinedStyle(base.getPredefinedStyle());
        if (newCompartment.getPredefinedStyle().equals("Not selected")) {
            newCompartment.setCustomStyle(base.getCustomStyle().clone());
        }
        compartment.put((DiagramElement)newCompartment);
        return newCompartment;
    }

    protected static Node createNodeClone(Compartment compartment, Node base, String name) throws Exception {
        Node newNode = new Node((DataCollection)compartment, name, base.getKernel());
        newNode.setTitle(base.getTitle());
        newNode.setLocation(base.getLocation());
        newNode.setRole(base.getRole(Role.class).clone((DiagramElement)newNode));
        newNode.setComment(base.getComment());
        newNode.setVisible(base.isVisible());
        newNode.setUseCustomImage(base.isUseCustomImage());
        if (newNode.isUseCustomImage()) {
            newNode.setImage(base.getImage().clone());
        }
        newNode.setPredefinedStyle(base.getPredefinedStyle());
        if (newNode.getPredefinedStyle().equals("Not selected")) {
            newNode.setCustomStyle(base.getCustomStyle().clone());
        }
        compartment.put((DiagramElement)newNode);
        return newNode;
    }

    protected static void copyAttributes(DiagramElement oldNode, DiagramElement newNode) {
        for (DynamicProperty dp : oldNode.getAttributes()) {
            newNode.getAttributes().add(dp);
        }
    }

    protected static void copyAttribute(DiagramElement oldNode, DiagramElement newNode, String attrName) {
        DynamicProperty dp = oldNode.getAttributes().getProperty(attrName);
        if (dp != null) {
            newNode.getAttributes().add(dp);
        }
    }

    protected static final boolean isSbmlProperty(DynamicProperty dp) {
        return !sbgnProperty.contains(dp.getName());
    }

    protected void convertSbgnTypeToKernelType(Node de, Base kernel) {
        if (kernel instanceof Specie && de.getKernel().getType().equals("macromolecule")) {
            ((Specie)kernel).setType("molecule-protein");
        }
    }

    protected static Edge findEdge(Node node, Base kernel) {
        return kernel == null ? null : (Edge)((StreamEx)node.edges().filter(e -> kernel.equals(e.getKernel()))).findAny().orElse(null);
    }

    protected static void restoreEdge(SpecieReference sr, Node input, Node output, Edge edge) throws Exception {
        Edge newEdge = new Edge((Base)sr, input, output);
        newEdge.setRole(edge.getRole());
        newEdge.setPath(edge.getPath());
        newEdge.setComment(edge.getComment());
        for (DynamicProperty dp : edge.getAttributes()) {
            if (!SBGNConverterSupport.isSbmlProperty(dp)) continue;
            SBGNConverterSupport.copyAttribute((DiagramElement)edge, (DiagramElement)newEdge, dp.getName());
        }
        newEdge.save();
    }
}

