/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.converters;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.VariableRole;
import biouml.model.xml.JSUtility;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.plugins.sbgn.SbgnCompositeDiagramType;
import biouml.plugins.sbgn.SbgnSemanticController;
import biouml.plugins.sbgn.SbgnUtil;
import biouml.plugins.sbml.SbmlDiagramType_L3v2;
import biouml.plugins.sbml.SbmlSemanticController;
import biouml.plugins.sbml.composite.SbmlCompositeDiagramType;
import biouml.plugins.sbml.converters.SBGNCompositeConverter;
import biouml.plugins.sbml.converters.SBGNConverterSupport;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Compartment;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Reaction;
import biouml.standard.type.Referrer;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import ru.biosoft.access.ClassLoading;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.InternalException;
import ru.biosoft.graph.Path;
import ru.biosoft.util.TextUtil;

public class SBGNConverterNew
extends SBGNConverterSupport {
    public static final String EMPTY_SET = "EmptySet";
    public static final String COMPLEX_ATTR = "ComplexElements";
    public static final String MODIFICATION_ATTR = "ModificationElements";
    public static final String BODY_COLOR_ATTR = "BodyColor";
    public static final String ANGLE_ATTR = "Angle";
    public static final String ALIAS_ATTR = "Alias";
    public static final String ALIASES_ATTR = "NodeAliases";
    public static final String SPECIE_NAME_ATTR = "SpecieName";

    public static Diagram convert(Diagram diagram) throws Exception {
        return DiagramUtility.isComposite((Diagram)diagram) ? new SBGNCompositeConverter().convert(diagram, null) : new SBGNConverterNew().convert(diagram, null);
    }

    public static Diagram restore(Diagram diagram) throws Exception {
        if (diagram.getType() instanceof SbgnCompositeDiagramType || DiagramUtility.containPorts((biouml.model.Compartment)diagram)) {
            Diagram sbmlDiagram = new SBGNCompositeConverter().restoreSBML(diagram, (DiagramType)new SbmlCompositeDiagramType());
            SbmlSemanticController.addPackage(sbmlDiagram, "comp");
            return sbmlDiagram;
        }
        String type = (String)diagram.getAttributes().getValue("baseDiagramType");
        if (type == null) {
            type = SbmlDiagramType_L3v2.class.getName();
        }
        return new SBGNConverterNew().restoreSBML(diagram, (DiagramType)ClassLoading.loadSubClass((String)type, DiagramType.class).newInstance());
    }

    @Override
    protected void createElements(biouml.model.Compartment baseCompartment, biouml.model.Compartment compartment) throws Exception {
        List elementNames = baseCompartment.getNameList();
        for (String name : elementNames) {
            DiagramElement de = baseCompartment.get(name);
            this.createElement(de, compartment, name);
            if (!(de instanceof Node) || !(de.getAttributes().getValue(ALIASES_ATTR) instanceof Node[])) continue;
            for (Node n : (Node[])de.getAttributes().getValue(ALIASES_ATTR)) {
                this.createElement((DiagramElement)n, compartment, n.getName());
            }
        }
    }

    @Override
    protected void postProcess(Diagram oldDiagram, Diagram diagram) {
        super.postProcess(oldDiagram, diagram);
        SemanticController controller = diagram.getType().getSemanticController();
        for (Node n : (StreamEx)diagram.recursiveStream().select(Node.class).filter(node -> node.getKernel() instanceof Reaction)) {
            try {
                controller.validate(n.getCompartment(), (DiagramElement)n).save();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Error during node " + n.getName() + " post processing. " + ex.getMessage());
            }
        }
    }

    protected void createElement(DiagramElement de, biouml.model.Compartment compartment, String name) throws Exception {
        Base kernel = de.getKernel();
        String type = kernel.getType();
        biouml.model.Compartment newNode = null;
        if (kernel instanceof Compartment) {
            newNode = SBGNConverterNew.createCompartmentClone(compartment, (biouml.model.Compartment)de, name);
            this.createElements((biouml.model.Compartment)de, newNode);
        } else if (de instanceof Node) {
            Node node = (Node)de;
            if (type.equals("math-event") || type.equals("math-function") || type.equalsIgnoreCase("math-equation") || type.equalsIgnoreCase("math-constraint")) {
                newNode = SBGNConverterNew.createNodeClone(compartment, node, name);
            } else if (kernel instanceof Reaction) {
                newNode = SBGNConverterNew.createNodeClone(compartment, node, name);
                newNode.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_REACTION_TYPE_PD, String.class, (Object)SBGNConverterNew.guessReactionType(node)));
            } else {
                newNode = new biouml.model.Compartment((DataCollection)compartment, name, kernel);
                newNode.setLocation(node.getLocation());
                newNode.setVisible(node.isVisible());
                Role role = node.getRole();
                if (role != null) {
                    newNode.setRole(role.clone((DiagramElement)newNode));
                }
                newNode.setTitle(node.getTitle());
                newNode.setComment(node.getComment());
                newNode.setPredefinedStyle(node.getPredefinedStyle());
                newNode.setUseCustomImage(node.isUseCustomImage());
                if (newNode.isUseCustomImage()) {
                    newNode.setImage(node.getImage().clone());
                }
                if (newNode.getPredefinedStyle().equals("Not selected")) {
                    newNode.setCustomStyle(node.getCustomStyle().clone());
                }
                compartment.put((DiagramElement)newNode);
                if (kernel instanceof Specie) {
                    String sbgnType = this.guessSpecieType(node);
                    SbgnUtil.setSBGNTypes((Specie)((Specie)kernel));
                    ((Specie)kernel).setType(sbgnType);
                }
                if (this.checkComplex((DiagramElement)node)) {
                    this.buildComplex(newNode, node);
                } else {
                    Dimension d = node.getShapeSize();
                    newNode.setShapeSize(d != null ? d : new Dimension(60, 40));
                    Object states = de.getAttributes().getValue("states");
                    if (states != null) {
                        this.createStates((Node)newNode, (String)states);
                    }
                }
                this.addComplexElements((DiagramElement)node, newNode);
                Object modifications = node.getAttributes().getValue(MODIFICATION_ATTR);
                if (modifications != null && modifications instanceof Node[]) {
                    biouml.model.Compartment c = newNode;
                    for (Node subElement : (Node[])modifications) {
                        c.put((DiagramElement)subElement.clone(c, subElement.getName()));
                    }
                    this.locateModifications(c);
                }
            }
        }
        if (newNode != null) {
            SBGNConverterNew.copyAttributes(de, (DiagramElement)newNode);
            SbgnSemanticController.setNeccessaryAttributes((DiagramElement)newNode);
        }
    }

    public void buildComplex(biouml.model.Compartment newNode, Node oldNode) {
        DatabaseReference[] dbRefs;
        int childCount = 0;
        if (oldNode.getKernel() instanceof Referrer && (dbRefs = ((Referrer)oldNode.getKernel()).getDatabaseReferences()) != null) {
            for (DatabaseReference ref : dbRefs) {
                if (ref.getRelationshipType() == null || !ref.getRelationshipType().equals("hasPart")) continue;
                ++childCount;
                String refName = ref.getId();
                DataElement childDE = CollectionFactory.getDataElement((String)("databases/UniProt/Data/protein/" + ref.getId()));
                if (childDE instanceof BaseSupport) {
                    refName = ((BaseSupport)childDE).getTitle();
                }
                biouml.model.Compartment child = new biouml.model.Compartment((DataCollection)newNode, (Base)new Specie(null, refName, "macromolecule"));
                child.setShapeSize(new Dimension(60, 30));
                child.setLocation(newNode.getLocation().x + 10, newNode.getLocation().y + (30 * (childCount - 1) + 10));
                SbgnSemanticController.setNeccessaryAttributes((DiagramElement)child);
                newNode.put((DiagramElement)child);
            }
        }
        newNode.setShapeSize(new Dimension(80, 30 + childCount * 30));
    }

    protected void addComplexElements(DiagramElement de, biouml.model.Compartment newNode) throws Exception {
        Object complexes = de.getAttributes().getValue(COMPLEX_ATTR);
        if (complexes != null && complexes instanceof Node[]) {
            for (Node subElement : (Node[])complexes) {
                Object aliases;
                Node newSubElement = subElement.clone(newNode, subElement.getName());
                newNode.put((DiagramElement)newSubElement);
                if (newSubElement instanceof biouml.model.Compartment) {
                    this.locateModifications((biouml.model.Compartment)newSubElement);
                    this.addComplexElements((DiagramElement)subElement, (biouml.model.Compartment)newSubElement);
                }
                if (!((aliases = subElement.getAttributes().getValue(ALIASES_ATTR)) instanceof Node[])) continue;
                for (Node n : (Node[])aliases) {
                    newSubElement = n.clone(newNode, n.getName());
                    newNode.put((DiagramElement)newSubElement);
                    if (!(newSubElement instanceof biouml.model.Compartment)) continue;
                    this.locateModifications((biouml.model.Compartment)newSubElement);
                    this.addComplexElements((DiagramElement)n, (biouml.model.Compartment)newSubElement);
                }
            }
        }
    }

    protected void locateModifications(biouml.model.Compartment node) {
        for (DiagramElement de : node) {
            Object angleObj;
            if (!(de instanceof Node) || (angleObj = ((Node)de).getAttributes().getValue(ANGLE_ATTR)) == null) continue;
            try {
                double angle = Math.PI - Double.parseDouble(angleObj.toString());
                Point location = new Point();
                Dimension nodeSize = node.getShapeSize();
                JSUtility.fillLocationByAngle((Point)location, (Dimension)new Dimension(nodeSize.width, nodeSize.width), (Dimension)new Dimension(20, 20), (double)angle, (boolean)false);
                Point nodeLocation = node.getLocation();
                location.x += nodeLocation.x;
                location.y = (int)((double)location.y * ((double)nodeSize.height / (double)nodeSize.width)) + nodeLocation.y;
                ((Node)de).setLocation(location);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not locate modification", e);
            }
        }
    }

    protected void createStates(Node node, String states) {
        if (node instanceof biouml.model.Compartment) {
            String[] stateArray;
            for (String state : stateArray = TextUtil.split((String)states, (char)';')) {
                Stub stateKenel = new Stub(null, node.getName() + "_" + state, "variable");
                Node stateNode = new Node((DataCollection)((biouml.model.Compartment)node), (Base)stateKenel);
                stateNode.setLocation(node.getLocation());
                stateNode.getAttributes().add(new DynamicProperty("value", String.class, (Object)state));
                ((biouml.model.Compartment)node).put((DiagramElement)stateNode);
            }
        }
    }

    @Override
    protected void createEdges(biouml.model.Compartment baseCompartment, biouml.model.Compartment compartment, Diagram sbgnDiagram) throws Exception {
        List elementNames = baseCompartment.getNameList();
        for (String name : elementNames) {
            DiagramElement de = baseCompartment.get(name);
            if (de instanceof biouml.model.Compartment) {
                this.createEdges((biouml.model.Compartment)de, (biouml.model.Compartment)compartment.get(name), sbgnDiagram);
                continue;
            }
            if (!(de instanceof Node) || !(de.getKernel() instanceof Reaction)) continue;
            for (Edge edge : ((Node)de).getEdges()) {
                if (!(edge.getKernel() instanceof SpecieReference)) continue;
                SpecieReference sr = (SpecieReference)edge.getKernel();
                Node node1 = (Node)compartment.get(name);
                String completeName = null;
                completeName = edge.getAttributes().getValue(SPECIE_NAME_ATTR) instanceof String ? (String)edge.getAttributes().getValue(SPECIE_NAME_ATTR) : (edge.getInput() == de ? edge.getOutput().getCompleteNameInDiagram() : edge.getInput().getCompleteNameInDiagram());
                Node node2 = sbgnDiagram.findNode(completeName);
                if (node1 == null || node2 == null) continue;
                Edge newEdge = null;
                if (sr.getRole().equals("reactant")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node2, node1);
                } else if (sr.getRole().equals("product")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node1, node2);
                } else if (sr.getRole().equals("modifier")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node2, node1);
                    Object oldEdgeType = edge.getAttributes().getValue("sbgn:edgeType");
                    newEdge.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_EDGE_TYPE_PD, String.class, (Object)(oldEdgeType == null ? "catalysis" : oldEdgeType.toString())));
                }
                if (newEdge == null) continue;
                newEdge.setRole(edge.getRole());
                Path path = edge.getPath();
                if (path != null) {
                    newEdge.setPath(path);
                }
                SBGNConverterNew.copyAttributes((DiagramElement)edge, (DiagramElement)newEdge);
                newEdge.save();
            }
        }
    }

    @Override
    protected void updateEdgeConnections(Diagram diagram, biouml.model.Compartment compartment) {
        compartment.visitEdges(edge -> diagram.getType().getSemanticController().recalculateEdgePath(edge));
    }

    protected boolean checkComplex(DiagramElement de) {
        DatabaseReference[] dbRefs;
        if (de.getKernel() instanceof Referrer && (dbRefs = ((Referrer)de.getKernel()).getDatabaseReferences()) != null) {
            return Stream.of(dbRefs).map(DatabaseReference::getRelationshipType).anyMatch("hasPart"::equals);
        }
        return false;
    }

    private static int parseSBO(String sboTerm) {
        if (sboTerm == null || !sboTerm.startsWith("SBO:")) {
            return -1;
        }
        try {
            return Integer.parseInt(sboTerm.substring("SBO:".length()));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected String guessSpecieType(Node baseNode) {
        DatabaseReference[] dbRefs;
        Object entityType = baseNode.getAttributes().getValue("sbgn:entityType");
        if (entityType != null) {
            return (String)entityType;
        }
        String type = baseNode.getKernel().getType();
        if ("molecule-protein".equals(type)) {
            return "macromolecule";
        }
        if ("molecule-gene".equals(type) || "molecule-RNA".equals(type)) {
            return "nucleic acid feature";
        }
        int sboTerm = SBGNConverterNew.parseSBO(baseNode.getAttributes().getValueAsString("sboTerm"));
        switch (sboTerm) {
            case 296: 
            case 297: {
                return "complex";
            }
            case 247: 
            case 280: 
            case 299: {
                return "simple chemical";
            }
            case 14: 
            case 245: 
            case 246: 
            case 248: 
            case 249: 
            case 251: 
            case 252: {
                return "macromolecule";
            }
            case 243: 
            case 250: 
            case 278: 
            case 317: 
            case 334: 
            case 404: {
                return "nucleic acid feature";
            }
            case 405: {
                return "perturbing agent";
            }
        }
        if (this.checkComplex((DiagramElement)baseNode)) {
            return "complex";
        }
        if (baseNode.getKernel() instanceof Referrer && (dbRefs = ((Referrer)baseNode.getKernel()).getDatabaseReferences()) != null) {
            block28: for (DatabaseReference dbRef : dbRefs) {
                switch (dbRef.getRelationshipType()) {
                    case "isEncodedBy": {
                        return "macromolecule";
                    }
                    case "isVersionOf": 
                    case "is": {
                        switch (dbRef.getDatabaseName()) {
                            case "MIR:00000011": 
                            case "MIR:00000005": {
                                return "macromolecule";
                            }
                            case "MIR:00000002": 
                            case "MIR:00000033": {
                                return "simple chemical";
                            }
                            case "MIR:00000051": {
                                if (dbRef.getId().startsWith("HMDBP")) {
                                    return "macromolecule";
                                }
                                if (!dbRef.getId().matches("HMDB\\d+")) break;
                                return "simple chemical";
                            }
                        }
                        continue block28;
                    }
                }
            }
        }
        return "unspecified";
    }

    @Override
    protected void restoreElements(biouml.model.Compartment sbgnCompartment, biouml.model.Compartment compartment) throws Exception {
        for (Node de : sbgnCompartment.getNodes()) {
            this.restoreElement(de, sbgnCompartment, compartment);
        }
    }

    protected Node restoreElement(Node de, biouml.model.Compartment sbgnCompartment, biouml.model.Compartment compartment) throws Exception {
        Base kernel = de.getKernel();
        String type = kernel.getType();
        if ("logical operator".equals(type) || "phenotype".equals(type) || "source-sink".equals(type) || "note".equals(type) || "variable".equals(type) || "unit of information".equals(type) || de instanceof ModelDefinition || de instanceof SubDiagram || "reaction".equals(type)) {
            return null;
        }
        if (kernel instanceof Compartment) {
            if (!((VariableRole)de.getRole(VariableRole.class)).getDiagramElement().equals(de)) {
                biouml.model.Compartment sbgnMain = (biouml.model.Compartment)((VariableRole)de.getRole(VariableRole.class)).getDiagramElement();
                biouml.model.Compartment sbmlMain = (biouml.model.Compartment)compartment.get(sbgnMain.getName());
                if (sbmlMain == null) {
                    sbmlMain = (biouml.model.Compartment)this.restoreElement((Node)sbgnMain, sbgnCompartment, compartment);
                }
                this.restoreElements((biouml.model.Compartment)de, sbmlMain);
                return null;
            }
            biouml.model.Compartment newCompartment = SBGNConverterNew.createCompartmentClone(compartment, (biouml.model.Compartment)de, de.getName());
            this.restoreElements((biouml.model.Compartment)de, newCompartment);
            return newCompartment;
        }
        if (type.equals("math-equation") || type.equals("math-event") || type.equals("math-function") || type.equals("math-constraint")) {
            kernel = new Stub((DataCollection)compartment, de.getName(), type);
        }
        if (de.getRole() instanceof VariableRole && !((VariableRole)de.getRole(VariableRole.class)).getDiagramElement().equals(de)) {
            return null;
        }
        Node node = new Node((DataCollection)compartment, kernel);
        if (de.getRole() != null) {
            node.setRole(de.getRole(Role.class).clone((DiagramElement)node));
        }
        node.setTitle(de.getTitle());
        node.setLocation(de.getLocation());
        node.setShapeSize(de.getShapeSize());
        node.setVisible(de.isVisible());
        node.setComment(de.getComment());
        node.setUseCustomImage(de.isUseCustomImage());
        if (node.isUseCustomImage()) {
            node.setImage(de.getImage().clone());
        }
        for (DynamicProperty dp : de.getAttributes()) {
            if (!SBGNConverterNew.isSbmlProperty(dp)) continue;
            SBGNConverterNew.copyAttribute((DiagramElement)de, (DiagramElement)node, dp.getName());
        }
        node.save();
        return node;
    }

    @Override
    protected void restoreEdges(biouml.model.Compartment sbgnCompartment, biouml.model.Compartment compartment, Diagram sbmlDiagram) throws Exception {
        for (DiagramElement de : sbgnCompartment) {
            DiagramElement comp;
            if (de instanceof Node && de.getKernel() instanceof Reaction) {
                Reaction oldReaction = (Reaction)de.getKernel();
                Reaction newReaction = oldReaction.clone(null, oldReaction.getName());
                Node reactionNode = new Node((DataCollection)compartment, (Base)newReaction);
                newReaction.setParent((Option)reactionNode);
                reactionNode.setTitle(de.getTitle());
                reactionNode.setRole(de.getRole().clone((DiagramElement)reactionNode));
                reactionNode.setLocation(((Node)de).getLocation());
                reactionNode.setVisible(((Node)de).isVisible());
                reactionNode.setComment(de.getComment());
                compartment.put((DiagramElement)reactionNode);
                for (DynamicProperty dp : de.getAttributes()) {
                    if (!SBGNConverterNew.isSbmlProperty(dp)) continue;
                    SBGNConverterNew.copyAttribute(de, (DiagramElement)reactionNode, dp.getName());
                }
                for (SpecieReference sr : (Reaction)de.getKernel()) {
                    try {
                        Node node = (Node)de;
                        Edge originalEdge = SBGNConverterNew.findEdge((Node)de, (Base)sr);
                        if (originalEdge == null) {
                            originalEdge = (Edge)((StreamEx)((StreamEx)node.edges().filter(edge -> SbgnUtil.isLogical((DiagramElement)edge.getOtherEnd(node)))).flatMap(edge -> edge.getOtherEnd(node).edges()).filter(e -> e.getKernel().equals(sr))).findAny().orElseThrow(() -> new InternalException("Unable to find original edge for de=" + de.getCompleteNameInDiagram() + " and sr = " + sr));
                        }
                        SpecieReference newSr = sr.clone((DataCollection)((Reaction)de.getKernel()), sr.getName());
                        Node sbmlNode = sbmlDiagram.findNode(sr.getSpecie());
                        if (sbmlNode == null) {
                            Node sbgnNode = Diagram.getDiagram((DiagramElement)sbgnCompartment).findNode(sr.getSpecie());
                            Node masterNode = (Node)sbgnNode.getRole(Role.class).getDiagramElement();
                            sbmlNode = sbmlDiagram.findNode(masterNode.getName());
                        }
                        if (sbmlNode == null) {
                            throw new Exception("Can not convert specie reference " + sr.getName() + ".");
                        }
                        newSr.setSpecie(sbmlNode.getCompleteNameInDiagram());
                        newReaction.put(newSr);
                        if (newSr.getRole().equals("product")) {
                            SBGNConverterNew.restoreEdge(newSr, reactionNode, sbmlNode, originalEdge);
                            continue;
                        }
                        SBGNConverterNew.restoreEdge(newSr, sbmlNode, reactionNode, originalEdge);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "Error during restoring specie reference " + sr.getName(), ex);
                    }
                }
                continue;
            }
            if (!(de instanceof biouml.model.Compartment) || !((comp = compartment.get(de.getName())) instanceof biouml.model.Compartment)) continue;
            this.restoreEdges((biouml.model.Compartment)de, (biouml.model.Compartment)comp, sbmlDiagram);
        }
    }

    public void appendPorts(Diagram baseDiagram, Diagram sbgnDiagram) throws Exception {
        for (Object obj : baseDiagram) {
            Base kernel;
            if (!(obj instanceof Node) || (kernel = ((Node)obj).getKernel()) == null || !(kernel instanceof Stub.ConnectionPort)) continue;
            Node basePort = (Node)obj;
            baseDiagram.findNode(basePort.getAttributes().getValueAsString("variableName"));
            String orientationStr = SubDiagram.PortOrientation.getOrientation((String)basePort.getAttributes().getValueAsString("orientation")).toDirection();
            String portType = "contact";
            if (kernel instanceof Stub.InputConnectionPort) {
                portType = "input";
            } else if (kernel instanceof Stub.OutputConnectionPort) {
                portType = "output";
            }
            String elName = basePort.getAttributes().getValue("variableName").toString();
            if (elName.startsWith("$\"") && elName.endsWith("\"")) {
                elName = elName.substring(2, elName.length() - 1);
            }
            String portName = elName.replaceAll("\\.", "_") + "_port";
            Node newNode = new Node((DataCollection)sbgnDiagram, (Base)new Stub.ConnectionPort(portName, null, portType));
            newNode.setTitle(basePort.getTitle());
            newNode.getAttributes().add(new DynamicProperty("direction", String.class, (Object)orientationStr));
            newNode.getAttributes().add(new DynamicProperty("portType", String.class, (Object)portType));
            newNode.getAttributes().add(new DynamicProperty("variableName", String.class, (Object)basePort.getAttributes().getValue("variableName").toString()));
            newNode.setLocation(basePort.getLocation());
            sbgnDiagram.put((DiagramElement)newNode);
            Node targetNode = sbgnDiagram.findNode(elName);
            if (targetNode == null) continue;
            Edge edge = new Edge((DataCollection)sbgnDiagram, (Base)new Stub(null, newNode.getName() + "_link", "portlink"), newNode, targetNode);
            sbgnDiagram.put((DiagramElement)edge);
        }
    }
}

