/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.converters;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.xml.JSUtility;
import biouml.model.xml.XmlDiagramSemanticController;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramTypeConstants;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.plugins.sbgn.SbgnUtil;
import biouml.plugins.sbml.converters.SBGNConverterSupport;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Reaction;
import biouml.standard.type.Referrer;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import ru.biosoft.access.core.CollectionFactory;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.graph.Path;
import ru.biosoft.util.TextUtil;

@Deprecated
public class SBGNConverter
extends SBGNConverterSupport {
    public static final String SBGN_NOTATION_NAME = "sbml_sbgn.xml";
    public static final String EMPTY_SET = "EmptySet";
    public static final String COMPLEX_ATTR = "ComplexElements";
    public static final String MODIFICATION_ATTR = "ModificationElements";
    public static final String BODY_COLOR_ATTR = "BodyColor";
    public static final String ANGLE_ATTR = "Angle";
    public static final String ALIAS_ATTR = "Alias";
    public static final String ALIASES_ATTR = "NodeAliases";
    public static final String SPECIE_NAME_ATTR = "SpecieName";

    protected String getNotationName() {
        return SBGN_NOTATION_NAME;
    }

    @Override
    protected Object getType() {
        return this.getNotationName();
    }

    @Override
    protected Diagram createDiagram(DiagramType type, Diagram oldDiagram) throws Exception {
        if (type instanceof XmlDiagramType) {
            XmlDiagramType xmlDiagramType = (XmlDiagramType)type;
            ((XmlDiagramSemanticController)xmlDiagramType.getSemanticController()).setPrototype(oldDiagram.getType().getSemanticController());
            DiagramViewBuilder viewBuilder = xmlDiagramType.getDiagramViewBuilder();
            viewBuilder.setBaseViewBuilder(oldDiagram.getType().getDiagramViewBuilder());
            viewBuilder.setBaseViewOptions(oldDiagram.getViewOptions());
            return xmlDiagramType.createDiagram(oldDiagram.getOrigin(), oldDiagram.getName(), null);
        }
        return super.createDiagram(type, oldDiagram);
    }

    @Override
    protected void postProcessRestore(Diagram oldDiagram, Diagram diagram) {
        String notationPath = DataElementPath.create((DataElement)XmlDiagramType.getTypeObject((String)SBGN_NOTATION_NAME)).toString();
        diagram.getAttributes().add(new DynamicProperty(notationPath, Diagram.class, (Object)oldDiagram));
    }

    @Override
    protected void createElements(Compartment baseCompartment, Compartment compartment) throws Exception {
        List elementNames = baseCompartment.getNameList();
        for (String name : elementNames) {
            DiagramElement de = baseCompartment.get(name);
            this.createElement(de, compartment, name);
            if (!(de instanceof Node) || !(de.getAttributes().getValue(ALIASES_ATTR) instanceof Node[])) continue;
            for (Node n : (Node[])de.getAttributes().getValue(ALIASES_ATTR)) {
                this.createElement((DiagramElement)n, compartment, n.getName());
            }
        }
    }

    protected void createElement(DiagramElement de, Compartment compartment, String name) throws Exception {
        if (de instanceof Compartment) {
            Compartment newCompartment = new Compartment((DataCollection)compartment, name, de.getKernel());
            this.setXmlType((DiagramElement)newCompartment, "compartment");
            newCompartment.setLocation(((Compartment)de).getLocation());
            newCompartment.setShapeSize(((Compartment)de).getShapeSize());
            newCompartment.setShapeType(((Compartment)de).getShapeType());
            newCompartment.setRole(de.getRole());
            newCompartment.setTitle(de.getTitle());
            newCompartment.setComment(de.getComment());
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "NamePoint");
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "closeup");
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "compartmentType");
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "sboTerm");
            compartment.put((DiagramElement)newCompartment);
            this.createElements((Compartment)de, newCompartment);
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "metaid");
        } else if (de instanceof Node) {
            Base kernel = de.getKernel();
            if (kernel.getType().equals("math-event")) {
                Node newNode = this.createNodeClone(compartment, (Node)de, name, "event");
                SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "metaid");
                compartment.put((DiagramElement)newNode);
            } else if (kernel.getType().equals("math-function")) {
                Node newNode = this.createNodeClone(compartment, (Node)de, name, "function");
                SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "metaid");
                compartment.put((DiagramElement)newNode);
            } else if (kernel.getType().equals("math-equation")) {
                Node newNode = this.createNodeClone(compartment, (Node)de, name, "equation");
                SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "metaid");
                compartment.put((DiagramElement)newNode);
            } else if (kernel instanceof Reaction) {
                String s;
                Reaction reaction = (Reaction)kernel;
                int reactants = 0;
                int products = 0;
                int modifiers = 0;
                for (SpecieReference sr : reaction.getSpecieReferences()) {
                    if (sr.getRole().equals("reactant")) {
                        ++reactants;
                        continue;
                    }
                    if (sr.getRole().equals("product")) {
                        ++products;
                        continue;
                    }
                    if (!sr.getRole().equals("modifier")) continue;
                    ++modifiers;
                }
                Object rtObject = de.getAttributes().getValue("ReactionType");
                String reactionType = rtObject != null ? ((s = rtObject.toString().toLowerCase()).endsWith("association") ? "association" : (s.endsWith("dissociation") ? "dissociation" : "process")) : (reactants > 1 && products == 1 ? "association" : (reactants == 1 && products > 1 ? "dissociation" : "process"));
                Node reactionNode = this.createNodeClone(compartment, (Node)de, name, "reaction");
                reactionNode.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_REACTION_TYPE_PD, String.class, (Object)reactionType));
                SBGNConverter.copyAttribute(de, (DiagramElement)reactionNode, "sboTerm");
                if (reactants == 0 || products == 0) {
                    SbgnUtil.generateSourceSink((Node)reactionNode, (boolean)true);
                }
            } else {
                Compartment newNode = new Compartment((DataCollection)compartment, name, kernel);
                newNode.setLocation(((Node)de).getLocation());
                newNode.setVisible(((Node)de).isVisible());
                if (((Node)de).getRole() != null) {
                    newNode.setRole(((Node)de).getRole().clone((DiagramElement)newNode));
                }
                newNode.setTitle(de.getTitle());
                newNode.setComment(de.getComment());
                compartment.put((DiagramElement)newNode);
                Object type = de.getAttributes().getValue("xmlElementType");
                if (type != null) {
                    if (type.equals("source-sink")) {
                        kernel = new Stub(null, kernel.getName(), "source-sink");
                    }
                    if (type.equals("complex")) {
                        this.setXmlType((DiagramElement)newNode, "complex");
                        Dimension shapeSize = ((Node)de).getShapeSize();
                        if (shapeSize != null) {
                            newNode.setShapeSize(shapeSize);
                        }
                    }
                } else if (this.checkComplex(de)) {
                    DatabaseReference[] dbRefs;
                    this.setXmlType((DiagramElement)newNode, "complex");
                    int childCount = 0;
                    if (de.getKernel() instanceof Referrer && (dbRefs = ((Referrer)de.getKernel()).getDatabaseReferences()) != null) {
                        DatabaseReference[] databaseReferenceArray = dbRefs;
                        int n = databaseReferenceArray.length;
                        for (int reactionNode = 0; reactionNode < n; ++reactionNode) {
                            DatabaseReference ref = databaseReferenceArray[reactionNode];
                            if (ref.getRelationshipType() == null || !ref.getRelationshipType().equals("hasPart")) continue;
                            ++childCount;
                            String refName = ref.getId();
                            DataElement childDE = CollectionFactory.getDataElement((String)("databases/UniProt/Data/protein/" + ref.getId()));
                            if (childDE instanceof BaseSupport) {
                                refName = ((BaseSupport)childDE).getTitle();
                            }
                            Compartment child = new Compartment((DataCollection)newNode, (Base)new Stub(null, refName, "entity"));
                            child.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_ENTITY_TYPE_PD, String.class, (Object)"macromolecule"));
                            child.setShapeSize(new Dimension(60, 30));
                            child.setLocation(newNode.getLocation().x + 10, newNode.getLocation().y + (30 * (childCount - 1) + 10));
                            newNode.put((DiagramElement)child);
                        }
                    }
                    newNode.setShapeSize(new Dimension(80, 30 + childCount * 30));
                } else {
                    type = "entity";
                    this.setXmlType((DiagramElement)newNode, (String)type);
                    newNode.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_ENTITY_TYPE_PD, String.class, (Object)this.getElementTypeAttribute((Node)de)));
                    SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "sboTerm");
                    SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "sbgn:multimer");
                    Dimension d = ((Node)de).getShapeSize();
                    if (d == null) {
                        d = new Dimension(60, 40);
                    }
                    newNode.setShapeSize(d);
                    Object states = de.getAttributes().getValue("states");
                    if (states != null) {
                        this.createStates((Node)newNode, (String)states);
                    }
                }
                this.addComplexElements(de, newNode);
                Object modifications = de.getAttributes().getValue(MODIFICATION_ATTR);
                if (modifications != null && modifications instanceof Node[]) {
                    for (Node subElement : (Node[])modifications) {
                        Node newSubElement = subElement.clone(newNode, subElement.getName());
                        newNode.put((DiagramElement)newSubElement);
                    }
                    this.locateModifications(newNode);
                }
                SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "metaid");
                SBGNConverter.copyAttribute(de, (DiagramElement)newNode, "sboTerm");
            }
        }
    }

    protected void addComplexElements(DiagramElement de, Compartment newNode) throws Exception {
        Object complexes = de.getAttributes().getValue(COMPLEX_ATTR);
        if (complexes != null && complexes instanceof Node[]) {
            for (Node subElement : (Node[])complexes) {
                Object aliases;
                Node newSubElement = subElement.clone(newNode, subElement.getName());
                newNode.put((DiagramElement)newSubElement);
                if (newSubElement instanceof Compartment) {
                    this.locateModifications((Compartment)newSubElement);
                    this.addComplexElements((DiagramElement)subElement, (Compartment)newSubElement);
                }
                if (!((aliases = subElement.getAttributes().getValue(ALIASES_ATTR)) instanceof Node[])) continue;
                for (Node n : (Node[])aliases) {
                    newSubElement = n.clone(newNode, n.getName());
                    newNode.put((DiagramElement)newSubElement);
                    if (!(newSubElement instanceof Compartment)) continue;
                    this.locateModifications((Compartment)newSubElement);
                    this.addComplexElements((DiagramElement)n, (Compartment)newSubElement);
                }
            }
        }
    }

    protected void locateModifications(Compartment node) {
        for (DiagramElement de : node) {
            Object angleObj;
            if (!(de instanceof Node) || (angleObj = ((Node)de).getAttributes().getValue(ANGLE_ATTR)) == null) continue;
            try {
                double angle = Math.PI - Double.parseDouble(angleObj.toString());
                Point location = new Point();
                Dimension nodeSize = node.getShapeSize();
                JSUtility.fillLocationByAngle((Point)location, (Dimension)new Dimension(nodeSize.width, nodeSize.width), (Dimension)new Dimension(20, 20), (double)angle, (boolean)false);
                Point nodeLocation = node.getLocation();
                location.x += nodeLocation.x;
                location.y = (int)((double)location.y * ((double)nodeSize.height / (double)nodeSize.width)) + nodeLocation.y;
                ((Node)de).setLocation(location);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can not locate modification", e);
            }
        }
    }

    protected void createStates(Node node, String states) {
        if (node instanceof Compartment) {
            String[] stateArray;
            for (String state : stateArray = TextUtil.split((String)states, (char)';')) {
                Stub stateKenel = new Stub(null, node.getName() + "_" + state, "variable");
                Node stateNode = new Node((DataCollection)((Compartment)node), (Base)stateKenel);
                stateNode.setLocation(node.getLocation());
                stateNode.getAttributes().add(new DynamicProperty("value", String.class, (Object)state));
                ((Compartment)node).put((DiagramElement)stateNode);
            }
        }
    }

    @Override
    protected void createEdges(Compartment baseCompartment, Compartment compartment, Diagram sbgnDiagram) throws Exception {
        List elementNames = baseCompartment.getNameList();
        for (String name : elementNames) {
            DiagramElement de = baseCompartment.get(name);
            if (de instanceof Compartment) {
                this.createEdges((Compartment)de, (Compartment)compartment.get(name), sbgnDiagram);
                continue;
            }
            if (!(de instanceof Node) || !(de.getKernel() instanceof Reaction)) continue;
            for (Edge edge : ((Node)de).getEdges()) {
                if (!(edge.getKernel() instanceof SpecieReference)) continue;
                SpecieReference sr = (SpecieReference)edge.getKernel();
                Node node1 = (Node)compartment.get(name);
                String completeName = null;
                completeName = edge.getAttributes().getValue(SPECIE_NAME_ATTR) instanceof String ? (String)edge.getAttributes().getValue(SPECIE_NAME_ATTR) : (edge.getInput() == de ? edge.getOutput().getCompleteNameInDiagram() : edge.getInput().getCompleteNameInDiagram());
                Node node2 = sbgnDiagram.findNode(completeName);
                if (node1 == null || node2 == null) continue;
                Edge newEdge = null;
                if (sr.getRole().equals("reactant")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node2, node1);
                } else if (sr.getRole().equals("product")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node1, node2);
                } else if (sr.getRole().equals("modifier")) {
                    newEdge = new Edge(edge.getName(), (Base)sr, node2, node1);
                    Object oldEdgeType = edge.getAttributes().getValue("sbgn:edgeType");
                    newEdge.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_EDGE_TYPE_PD, String.class, (Object)(oldEdgeType == null ? "catalysis" : oldEdgeType.toString())));
                }
                if (newEdge == null) continue;
                if (node1.getAttributes().getValue("xmlElementType") != null && node1.getAttributes().getValue("xmlElementType").equals("source-sink") || node2.getAttributes().getValue("xmlElementType") != null && node2.getAttributes().getValue("xmlElementType").equals("source-sink")) {
                    newEdge = new Edge(newEdge.getOrigin(), edge.getName(), (Base)new Stub(sr.getOrigin(), edge.getName(), "production"), newEdge.getInput(), newEdge.getOutput());
                }
                newEdge.setRole(edge.getRole());
                Path path = edge.getPath();
                if (path != null) {
                    newEdge.setPath(path);
                }
                DynamicProperty dp = new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)"reaction");
                newEdge.getAttributes().add(dp);
                newEdge.getAttributes().add(new DynamicProperty(XmlDiagramTypeConstants.KERNEL_ROLE_ATTR_PD, String.class, (Object)sr.getRole()));
                SBGNConverter.copyAttribute((DiagramElement)edge, (DiagramElement)newEdge, "text");
                newEdge.save();
            }
        }
    }

    protected Node createNodeClone(Compartment compartment, Node base, String name, String type) throws Exception {
        Node newNode = SBGNConverter.createNodeClone(compartment, base, name);
        this.setXmlType((DiagramElement)newNode, type);
        return newNode;
    }

    protected boolean checkComplex(DiagramElement de) {
        DatabaseReference[] dbRefs;
        if (de.getKernel() instanceof Referrer && (dbRefs = ((Referrer)de.getKernel()).getDatabaseReferences()) != null) {
            return Stream.of(dbRefs).map(DatabaseReference::getRelationshipType).anyMatch("hasPart"::equals);
        }
        return false;
    }

    protected String getElementTypeAttribute(Node baseNode) {
        DatabaseReference[] dbRefs;
        Object entityType = baseNode.getAttributes().getValue("sbgn:entityType");
        if (entityType != null) {
            return (String)entityType;
        }
        if (baseNode.getKernel().getType().equals("molecule-protein")) {
            return "macromolecule";
        }
        if (baseNode.getKernel() instanceof Referrer && (dbRefs = ((Referrer)baseNode.getKernel()).getDatabaseReferences()) != null) {
            for (DatabaseReference dbRef : dbRefs) {
                if (!dbRef.getRelationshipType().equals("isVersionOf")) continue;
                if (dbRef.getDatabaseName().equals("MIR:00000011") || dbRef.getDatabaseName().equals("MIR:00000005")) {
                    return "macromolecule";
                }
                if (!dbRef.getDatabaseName().equals("MIR:00000002")) continue;
                return "simple chemical";
            }
        }
        return "unspecified";
    }

    protected void setXmlType(DiagramElement de, String type) throws Exception {
        DynamicProperty dp = new DynamicProperty(XmlDiagramTypeConstants.XML_TYPE_PD, String.class, (Object)type);
        de.getAttributes().add(dp);
    }

    @Override
    protected void restoreElements(Compartment sbgnCompartment, Compartment compartment) throws Exception {
        for (DiagramElement de : sbgnCompartment) {
            String xmlType;
            if (!(de instanceof Node) || (xmlType = (String)de.getAttributes().getValue("xmlElementType")) == null || xmlType.equals("source-sink") || xmlType.equals("note")) continue;
            if (xmlType.equals("complex") || xmlType.equals("entity") || xmlType.equals("event") || xmlType.equals("function") || xmlType.equals("equation") || xmlType.equals("phenotype")) {
                String cloneRef;
                Base kernel = de.getKernel();
                this.convertSbgnTypeToKernelType((Node)de, kernel);
                if (xmlType.equals("equation")) {
                    kernel = new Stub((DataCollection)compartment, de.getName(), "math-equation");
                } else if (xmlType.equals("event")) {
                    kernel = new Stub((DataCollection)compartment, de.getName(), "math-event");
                } else if (xmlType.equals("function")) {
                    kernel = new Stub((DataCollection)compartment, de.getName(), "math-function");
                } else if (xmlType.equals("complex")) {
                    Specie newKernel = new Specie((DataCollection)compartment, de.getName());
                    for (DynamicProperty dp : kernel.getAttributes()) {
                        newKernel.getAttributes().add(dp);
                    }
                    kernel = newKernel;
                }
                DynamicProperty cloneMarker = de.getAttributes().getProperty("sbgn:cloneMarker");
                if (cloneMarker != null && cloneMarker.getValue() != null && !(cloneRef = (String)cloneMarker.getValue()).isEmpty() && !cloneRef.equals(de.getCompleteNameInDiagram())) continue;
                Node node = new Node((DataCollection)compartment, kernel);
                node.setRole(de.getRole(Role.class).clone((DiagramElement)node));
                node.setTitle(de.getTitle());
                node.setLocation(((Node)de).getLocation());
                node.setShapeSize(((Node)de).getShapeSize());
                node.setVisible(((Node)de).isVisible());
                for (DynamicProperty dp : de.getAttributes()) {
                    if (!SBGNConverter.isSbmlProperty(dp)) continue;
                    SBGNConverter.copyAttribute(de, (DiagramElement)node, dp.getName());
                }
                compartment.put((DiagramElement)node);
                continue;
            }
            if (!de.getClass().equals(Compartment.class)) continue;
            Compartment newCompartment = new Compartment((DataCollection)compartment, de.getName(), de.getKernel());
            newCompartment.setTitle(de.getTitle());
            newCompartment.setRole(de.getRole());
            newCompartment.setLocation(((Compartment)de).getLocation());
            newCompartment.setShapeSize(((Compartment)de).getShapeSize());
            compartment.put((DiagramElement)newCompartment);
            SBGNConverter.copyAttribute(de, (DiagramElement)newCompartment, "metaid");
            this.restoreElements((Compartment)de, newCompartment);
        }
    }

    @Override
    protected void restoreEdges(Compartment sbgnCompartment, Compartment compartment, Diagram sbmlDiagram) throws Exception {
        for (DiagramElement de : sbgnCompartment) {
            DiagramElement comp;
            if (!(de instanceof Node)) continue;
            String xmlType = (String)de.getAttributes().getValue("xmlElementType");
            if (de.getKernel() instanceof Reaction || xmlType != null && (xmlType.equals("association") || xmlType.equals("dissociation") || xmlType.equals("process"))) {
                Node reactionNode = new Node((DataCollection)compartment, de.getKernel());
                reactionNode.setTitle(de.getTitle());
                reactionNode.setRole(de.getRole().clone((DiagramElement)reactionNode));
                reactionNode.setLocation(((Node)de).getLocation());
                for (DynamicProperty dp : de.getAttributes()) {
                    if (!SBGNConverter.isSbmlProperty(dp)) continue;
                    SBGNConverter.copyAttribute(de, (DiagramElement)reactionNode, dp.getName());
                }
                compartment.put((DiagramElement)reactionNode);
                if (!(de.getKernel() instanceof Reaction)) continue;
                for (SpecieReference sr : ((Reaction)de.getKernel()).getSpecieReferences()) {
                    Node masterNode;
                    Node sbgnNode;
                    Node rNode;
                    Edge originalEdge = SBGNConverter.findEdge((Node)de, (Base)sr);
                    if ("reactant".equals(sr.getRole())) {
                        rNode = sbmlDiagram.findNode(sr.getSpecie());
                        if (rNode == null) {
                            sbgnNode = Diagram.getDiagram((DiagramElement)sbgnCompartment).findNode(sr.getSpecie());
                            masterNode = (Node)sbgnNode.getRole(Role.class).getDiagramElement();
                            rNode = sbmlDiagram.findNode(masterNode.getName());
                        }
                        if (rNode == null) continue;
                        SBGNConverter.restoreEdge(sr, rNode, reactionNode, originalEdge);
                        continue;
                    }
                    if ("product".equals(sr.getRole())) {
                        rNode = sbmlDiagram.findNode(sr.getSpecie());
                        if (rNode == null) {
                            sbgnNode = Diagram.getDiagram((DiagramElement)sbgnCompartment).findNode(sr.getSpecie());
                            masterNode = (Node)sbgnNode.getRole(Role.class).getDiagramElement();
                            rNode = sbmlDiagram.findNode(masterNode.getName());
                        }
                        if (rNode == null) continue;
                        SBGNConverter.restoreEdge(sr, reactionNode, rNode, originalEdge);
                        continue;
                    }
                    rNode = sbmlDiagram.findNode(sr.getSpecie());
                    if (rNode == null) {
                        sbgnNode = Diagram.getDiagram((DiagramElement)sbgnCompartment).findNode(sr.getSpecie());
                        masterNode = (Node)sbgnNode.getRole(Role.class).getDiagramElement();
                        rNode = sbmlDiagram.findNode(masterNode.getName());
                    }
                    if (rNode == null) continue;
                    SBGNConverter.restoreEdge(sr, rNode, reactionNode, originalEdge);
                }
                continue;
            }
            if (!(de instanceof Compartment) || !((comp = compartment.get(de.getName())) instanceof Compartment)) continue;
            this.restoreEdges((Compartment)de, (Compartment)comp, sbmlDiagram);
        }
    }

    public void appendPorts(Diagram baseDiagram, Diagram sbgnDiagram) throws Exception {
        for (Object obj : baseDiagram) {
            Base kernel;
            if (!(obj instanceof Node) || (kernel = ((Node)obj).getKernel()) == null || !(kernel instanceof Stub.ConnectionPort)) continue;
            Node basePort = (Node)obj;
            baseDiagram.findNode(basePort.getAttributes().getValueAsString("variableName"));
            String orientationStr = SubDiagram.PortOrientation.getOrientation((String)basePort.getAttributes().getValueAsString("orientation")).toDirection();
            String portType = "contact";
            if (kernel instanceof Stub.InputConnectionPort) {
                portType = "input";
            } else if (kernel instanceof Stub.OutputConnectionPort) {
                portType = "output";
            }
            String elName = basePort.getAttributes().getValue("variableName").toString();
            if (elName.startsWith("$\"") && elName.endsWith("\"")) {
                elName = elName.substring(2, elName.length() - 1);
            }
            String portName = elName.replaceAll("\\.", "_") + "_port";
            Node newNode = new Node((DataCollection)sbgnDiagram, (Base)new Stub.ConnectionPort(portName, null, portType));
            newNode.setTitle(basePort.getTitle());
            newNode.getAttributes().add(new DynamicProperty("direction", String.class, (Object)orientationStr));
            newNode.getAttributes().add(new DynamicProperty("portType", String.class, (Object)portType));
            newNode.getAttributes().add(new DynamicProperty("variableName", String.class, (Object)basePort.getAttributes().getValue("variableName").toString()));
            this.setXmlType((DiagramElement)newNode, "port");
            newNode.setLocation(basePort.getLocation());
            sbgnDiagram.put((DiagramElement)newNode);
            Node targetNode = sbgnDiagram.findNode(elName);
            if (targetNode == null) continue;
            Edge edge = new Edge((DataCollection)sbgnDiagram, (Base)new Stub(null, newNode.getName() + "_link", "portlink"), newNode, targetNode);
            this.setXmlType((DiagramElement)edge, "portlink");
            sbgnDiagram.put((DiagramElement)edge);
        }
    }
}

