/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.converters;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.util.EModelHelper;
import biouml.plugins.sbgn.SbgnCompositeDiagramType;
import biouml.plugins.sbgn.SbgnSemanticController;
import biouml.plugins.sbml.composite.SbmlCompositeSemanticController;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.standard.diagram.Bus;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Specie;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.Option;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public class SBGNCompositeConverter
extends SBGNConverterNew {
    @Override
    protected Object getType() {
        return SbgnCompositeDiagramType.class;
    }

    @Override
    protected void postProcess(Diagram diagram, Diagram oldDiagram) {
        diagram.getViewOptions().setAutoLayout(true);
        diagram.getAttributes().add(new DynamicProperty("baseDiagramType", String.class, (Object)diagram.getType().getClass().getName()));
        this.adjustSubDiagrams(diagram, oldDiagram);
        DiagramUtility.compositeModelPostprocess((Diagram)diagram);
    }

    @Override
    protected void postProcessRestore(Diagram sbgnDiagram, Diagram sbmlDiagram) throws Exception {
        this.adjustSubDiagrams(sbgnDiagram, sbmlDiagram);
        DiagramUtility.compositeModelPostprocess((Diagram)sbmlDiagram);
        this.createConnections(sbgnDiagram, sbmlDiagram);
    }

    @Override
    protected void createElement(DiagramElement de, Compartment compartment, String name) throws Exception {
        SubDiagram newDe = null;
        if (de instanceof SubDiagram) {
            newDe = this.copySubDiagram(compartment, (SubDiagram)de, SBGNConverterNew.convert(((SubDiagram)de).getDiagram()));
        } else if (de instanceof ModelDefinition) {
            newDe = this.copyModelDefinition(compartment, (ModelDefinition)de, SBGNConverterNew.convert(((ModelDefinition)de).getDiagram()));
        } else if (de instanceof Node && Util.isPort((DiagramElement)de)) {
            newDe = this.copyPort(compartment, (Node)de);
        }
        if (newDe != null) {
            SbgnSemanticController.setNeccessaryAttributes((DiagramElement)newDe);
        } else {
            super.createElement(de, compartment, name);
        }
    }

    @Override
    protected void restoreElements(Compartment sbgnCompartment, Compartment compartment) throws Exception {
        for (Node node : sbgnCompartment.stream(Node.class)) {
            Diagram innerSBMLDiagram;
            Diagram innerDiagram;
            if (node instanceof SubDiagram) {
                SubDiagram oldSubDiagram = (SubDiagram)node;
                innerDiagram = oldSubDiagram.getDiagram();
                innerSBMLDiagram = SBGNConverterNew.restore(innerDiagram);
                innerSBMLDiagram.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)innerDiagram));
                this.copySubDiagram(compartment, oldSubDiagram, innerSBMLDiagram);
                continue;
            }
            if (node instanceof ModelDefinition) {
                ModelDefinition oldModelDefinition = (ModelDefinition)node;
                innerDiagram = oldModelDefinition.getDiagram();
                innerSBMLDiagram = SBGNConverterNew.restore(innerDiagram);
                innerSBMLDiagram.getAttributes().add(new DynamicProperty("sbgn_diagram", Diagram.class, (Object)innerDiagram));
                this.copyModelDefinition(compartment, oldModelDefinition, innerSBMLDiagram);
                continue;
            }
            if (!Util.isPort((DiagramElement)node)) continue;
            this.copyPort(compartment, node);
        }
        super.restoreElements(sbgnCompartment, compartment);
    }

    @Override
    protected void restoreEdges(Compartment sbgnCompartment, Compartment compartment, Diagram sbmlDiagram) throws Exception {
        super.restoreEdges(sbgnCompartment, compartment, sbmlDiagram);
    }

    @Override
    protected void createEdges(Compartment baseCompartment, Compartment compartment, Diagram sbgnDiagram) throws Exception {
        super.createEdges(baseCompartment, compartment, sbgnDiagram);
        this.createConnections(baseCompartment, compartment, sbgnDiagram);
    }

    protected Node copyPort(Compartment compartment, Node node) {
        Node portNode = new Node((DataCollection)compartment, node.getName(), node.getKernel());
        SBGNCompositeConverter.copyAttribute((DiagramElement)node, (DiagramElement)portNode, "portType");
        SBGNCompositeConverter.copyAttribute((DiagramElement)node, (DiagramElement)portNode, "variableName");
        SBGNCompositeConverter.copyAttribute((DiagramElement)node, (DiagramElement)portNode, "orientation");
        SBGNCompositeConverter.copyAttribute((DiagramElement)node, (DiagramElement)portNode, "accessType");
        if (node.getParent() instanceof SubDiagram) {
            SBGNCompositeConverter.copyAttribute((DiagramElement)node, (DiagramElement)portNode, "originalPort");
        }
        portNode.setLocation(node.getLocation());
        compartment.put((DiagramElement)portNode);
        return portNode;
    }

    protected ModelDefinition copyModelDefinition(Compartment compartment, ModelDefinition oldModelDefinition, Diagram diagram) throws Exception {
        ModelDefinition newModelDefinition = new ModelDefinition((DataCollection)compartment, diagram, oldModelDefinition.getName());
        newModelDefinition.setLocation(oldModelDefinition.getLocation());
        newModelDefinition.setShapeSize(oldModelDefinition.getShapeSize());
        newModelDefinition.setTitle(oldModelDefinition.getTitle());
        newModelDefinition.setVisible(oldModelDefinition.isVisible());
        compartment.put((DiagramElement)newModelDefinition);
        return newModelDefinition;
    }

    protected SubDiagram copySubDiagram(Compartment compartment, SubDiagram oldSubDiagram, Diagram diagram) throws Exception {
        SubDiagram newSubDiagram = new SubDiagram((DataCollection)compartment, diagram, oldSubDiagram.getName());
        newSubDiagram.setLocation(oldSubDiagram.getLocation());
        newSubDiagram.setShapeSize(oldSubDiagram.getShapeSize());
        newSubDiagram.setTitle(oldSubDiagram.getTitle());
        SBGNCompositeConverter.copyAttribute((DiagramElement)oldSubDiagram, (DiagramElement)newSubDiagram, "Time scale");
        SBGNCompositeConverter.copyAttribute((DiagramElement)oldSubDiagram, (DiagramElement)newSubDiagram, "Extent factor");
        newSubDiagram.setVisible(oldSubDiagram.isVisible());
        this.createElements((Compartment)oldSubDiagram, (Compartment)newSubDiagram);
        compartment.put((DiagramElement)newSubDiagram);
        return newSubDiagram;
    }

    protected void createConnections(Compartment compartmentFrom, Compartment compartmentTo, Diagram diagramTo) throws Exception {
        for (Edge oldEdge : (StreamEx)compartmentFrom.stream(Edge.class).filter(Util::isConnection)) {
            Node newInput = diagramTo.findNode(oldEdge.getInput().getCompleteNameInDiagram());
            Node newOutput = diagramTo.findNode(oldEdge.getOutput().getCompleteNameInDiagram());
            if (newInput == null || newOutput == null) continue;
            Edge newEdge = new Edge((DataCollection)compartmentTo, oldEdge.getKernel(), newInput, newOutput);
            if (oldEdge.getRole() != null) {
                newEdge.setRole(oldEdge.getRole(Role.class).clone((DiagramElement)newEdge));
            }
            SBGNCompositeConverter.copyAttribute((DiagramElement)oldEdge, (DiagramElement)newEdge, "conversionFactor");
            newEdge.save();
        }
    }

    protected void createConnections(Diagram sbgnDiagram, Diagram sbmlDiagram) throws Exception {
        Map clusters = DiagramUtility.getBuses((Diagram)sbgnDiagram).groupingBy(n -> (Bus)n.getRole());
        for (Map.Entry cluster : clusters.entrySet()) {
            Node mainPort;
            List nodes = (List)cluster.getValue();
            Set ports = ((StreamEx)StreamEx.of((Collection)nodes).flatMap(n -> n.edges().map(e -> e.getOtherEnd(n))).filter(n -> Util.isPort((DiagramElement)n))).toSet();
            List topPorts = ((StreamEx)StreamEx.of((Collection)ports).filter(n -> n.getCompartment() instanceof Diagram)).toList();
            ports.removeAll(topPorts);
            if (ports.size() == 0) continue;
            Node examplePort = (Node)ports.iterator().next();
            boolean undirected = Util.isContactPort((DiagramElement)examplePort);
            boolean species = this.isPortSpecies(examplePort);
            if (undirected) {
                mainPort = this.findMainPort(topPorts);
                Node topPort = null;
                if (topPorts.size() == 0) {
                    String name = SBGNCompositeConverter.createVariable(sbmlDiagram, species, ((Bus)cluster.getKey()).getName());
                    topPort = SBGNCompositeConverter.createPort(sbmlDiagram, Stub.ContactConnectionPort.class, name);
                } else {
                    topPort = (Node)topPorts.get(0);
                }
                for (Node port : ports) {
                    Node sbmlPort = sbmlDiagram.findNode(port.getCompleteNameInDiagram());
                    Node sbmlTop = sbmlDiagram.findNode(topPort.getCompleteNameInDiagram());
                    Edge e = this.createConnection(sbmlPort, sbmlTop, sbmlDiagram, "Connection_" + sbmlPort.getName(), true);
                    if (port.equals(mainPort)) {
                        ((UndirectedConnection)e.getRole(UndirectedConnection.class)).setMainVariableType(UndirectedConnection.MainVariableType.INPUT);
                        continue;
                    }
                    ((UndirectedConnection)e.getRole(UndirectedConnection.class)).setMainVariableType(UndirectedConnection.MainVariableType.OUTPUT);
                }
                continue;
            }
            if (topPorts.size() == 1) {
                Node topPort = (Node)topPorts.get(0);
                for (Node port : ports) {
                    Node sbmlPort = sbmlDiagram.findNode(port.getCompleteNameInDiagram());
                    Node sbmlTop = sbmlDiagram.findNode(topPort.getCompleteNameInDiagram());
                    this.createConnection(sbmlTop, sbmlPort, sbmlDiagram, "Connection_" + port.getName(), false);
                }
                continue;
            }
            if (topPorts.size() != 0) continue;
            mainPort = ((StreamEx)StreamEx.of((Collection)ports).filter(n -> Util.isOutputPort((DiagramElement)n))).findAny().orElse(null);
            if (mainPort == null) {
                return;
            }
            String name = SBGNCompositeConverter.createVariable(sbmlDiagram, species, ((Bus)cluster.getKey()).getName());
            Node topOutput = SBGNCompositeConverter.createPort(sbmlDiagram, Stub.OutputConnectionPort.class, name);
            Node topInput = SBGNCompositeConverter.createPort(sbmlDiagram, Stub.InputConnectionPort.class, name);
            ports.remove(mainPort);
            Node sbmlMainPort = sbmlDiagram.findNode(mainPort.getCompleteNameInDiagram());
            this.createConnection(sbmlMainPort, topInput, sbmlDiagram, "Connection_" + mainPort.getName(), false);
            for (Node port : ports) {
                Node sbmlPort = sbmlDiagram.findNode(port.getCompleteNameInDiagram());
                this.createConnection(topOutput, sbmlPort, sbmlDiagram, "Connection_" + mainPort.getName(), false);
            }
        }
        for (Edge oldEdge : (StreamEx)sbgnDiagram.recursiveStream().select(Edge.class).filter(Util::isConnection)) {
            if (Util.isSubDiagram((DiagramElement)oldEdge.getInput().getCompartment()) && Util.isSubDiagram((DiagramElement)oldEdge.getOutput().getCompartment())) {
                this.processDirectConnection(oldEdge, sbmlDiagram);
                continue;
            }
            if (!Util.isPort((DiagramElement)oldEdge.getInput()) && !Util.isPort((DiagramElement)oldEdge.getOutput())) continue;
            Node newInput = sbmlDiagram.findNode(oldEdge.getInput().getCompleteNameInDiagram());
            Node newOutput = sbmlDiagram.findNode(oldEdge.getOutput().getCompleteNameInDiagram());
            this.createConnection(newInput, newOutput, sbmlDiagram, oldEdge.getName(), oldEdge.getRole() instanceof UndirectedConnection);
        }
    }

    private Node findMainPort(List<Node> ports) {
        for (Node port : ports) {
            for (Edge e : port.edges()) {
                Node mainNode;
                UndirectedConnection connection;
                UndirectedConnection.MainVariableType type;
                if (!(e.getRole() instanceof UndirectedConnection) || (type = (connection = (UndirectedConnection)e.getRole(UndirectedConnection.class)).getMainVariableType()).equals((Object)UndirectedConnection.MainVariableType.INPUT) || !(mainNode = type.equals((Object)UndirectedConnection.MainVariableType.INPUT) ? e.getInput() : e.getOutput()).equals(port)) continue;
                return port;
            }
        }
        return null;
    }

    protected void processDirectConnection(Edge oldEdge, Diagram diagramTo) throws Exception {
        Node oldInput = oldEdge.getInput();
        Node oldOutput = oldEdge.getOutput();
        boolean species = this.isPortSpecies(oldInput);
        Base oldKernel = oldEdge.getKernel();
        boolean undirected = oldKernel instanceof UndirectedConnection;
        Node topLevelPort1 = null;
        Node topLevelPort2 = null;
        Node newOutput = diagramTo.findNode(oldOutput.getCompleteNameInDiagram());
        Node newInput = diagramTo.findNode(oldInput.getCompleteNameInDiagram());
        String name = SBGNCompositeConverter.createVariable(diagramTo, species, Util.getPortVariable((DiagramElement)newOutput));
        if (undirected) {
            topLevelPort2 = topLevelPort1 = SBGNCompositeConverter.createPort(diagramTo, Stub.OutputConnectionPort.class, name);
        } else {
            topLevelPort1 = SBGNCompositeConverter.createPort(diagramTo, Stub.InputConnectionPort.class, name);
            topLevelPort2 = SBGNCompositeConverter.createPort(diagramTo, Stub.OutputConnectionPort.class, name);
        }
        this.createConnection(newInput, topLevelPort1, diagramTo, oldEdge.getName() + "1", undirected);
        this.createConnection(topLevelPort2, newOutput, diagramTo, oldEdge.getName() + "2", undirected);
    }

    private boolean isPortSpecies(Node port) throws Exception {
        Variable var = this.getVariable(port);
        return var instanceof VariableRole;
    }

    private Variable getVariable(Node port) throws Exception {
        if (port.getParent() instanceof SubDiagram) {
            SubDiagram subdiagram = (SubDiagram)port.getCompartment();
            String originalName = port.getAttributes().getValueAsString("originalPort");
            Node originalPort = subdiagram.getDiagram().findNode(originalName);
            return this.getVariable(originalPort);
        }
        if (Util.isPropagatedPort2((DiagramElement)port)) {
            Node basePort = Util.getBasePort((Node)port);
            return this.getVariable(basePort);
        }
        return ((EModel)Diagram.getDiagram((DiagramElement)port).getRole(EModel.class)).getVariable(Util.getPortVariable((DiagramElement)port));
    }

    private Edge createConnection(Node from, Node to, Diagram d, String name, boolean undirected) throws Exception {
        name = DefaultSemanticController.generateUniqueName((Compartment)d, (String)name);
        Object kernel = null;
        Object role = null;
        kernel = undirected ? new Stub.UndirectedConnection(null, name) : new Stub.DirectedConnection(null, name);
        Edge edge = new Edge((Base)kernel, from, to);
        role = undirected ? new UndirectedConnection(edge) : new DirectedConnection(edge);
        edge.setRole((Role)role);
        role.setOutputPort(new Connection.Port(from));
        role.setInputPort(new Connection.Port(to));
        edge.save();
        return edge;
    }

    protected void adjustSubDiagrams(Diagram diagramFrom, Diagram diagramTo) {
        for (SubDiagram subDiagram : diagramTo.stream(SubDiagram.class)) {
            Diagram innerDiagram = subDiagram.getDiagram();
            try {
                Node newModelDefinition;
                Option parent = innerDiagram.getParent();
                if (parent == null || !(parent instanceof ModelDefinition) || !Diagram.getDiagram((DiagramElement)((ModelDefinition)parent)).equals(diagramFrom) || (newModelDefinition = diagramTo.findNode(((ModelDefinition)parent).getName())) == null || !(newModelDefinition instanceof ModelDefinition)) continue;
                innerDiagram.setOrigin((DataCollection)((ModelDefinition)newModelDefinition));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Can not adjust parent for diagram referenced by subdiagram" + subDiagram.getName());
            }
        }
    }

    public static String createVariable(Diagram d, boolean species, String varName) {
        SbmlCompositeSemanticController controller = (SbmlCompositeSemanticController)d.getType().getSemanticController();
        String name = varName;
        if (species) {
            name = DefaultSemanticController.generateUniqueName((Compartment)d, (String)varName);
            name = name.replace(".", "_").replace("$", "");
            DiagramElementGroup deg = controller.createInstance((Compartment)d, Specie.class, name, new Point(), null);
            Node specieNode = (Node)deg.get(0);
            boolean notification = d.isNotificationEnabled();
            d.setNotificationEnabled(true);
            d.put((DiagramElement)specieNode);
            d.setNotificationEnabled(notification);
            VariableRole role = (VariableRole)specieNode.getRole(VariableRole.class);
            name = role.getName();
        } else {
            name = EModelHelper.generateUniqueVariableName((EModel)((EModel)d.getRole(EModel.class)), (String)varName);
            ((EModel)d.getRole(EModel.class)).declareVariable(name, (Object)0.0);
        }
        return name;
    }

    public static Node createPort(Diagram d, Class<? extends Base> portClass, String name) {
        SbmlCompositeSemanticController controller = (SbmlCompositeSemanticController)d.getType().getSemanticController();
        PortProperties properties = new PortProperties(d, portClass);
        properties.setAccessType("private");
        properties.setVarName(name);
        DiagramElementGroup portDeg = controller.createInstance((Compartment)d, Stub.ConnectionPort.class, new Point(), properties);
        for (DiagramElement de : portDeg.nodesStream()) {
            d.put(de);
        }
        for (DiagramElement e : portDeg.edgesStream()) {
            d.put(e);
        }
        return portDeg.nodesStream().findAny().orElse(null);
    }
}

