/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.composite;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramWriter;
import biouml.model.util.DiagramXmlWriter;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelWriter_21;
import biouml.plugins.sbml.SbmlModelWriter_31;
import biouml.plugins.sbml.SbmlModelWriter_32;
import biouml.plugins.sbml.SbmlPackageWriter;
import biouml.plugins.sbml.SbmlUtil;
import biouml.plugins.sbml.composite.MessageBundle;
import biouml.plugins.sbml.composite.SbmlCompositeDiagramType;
import biouml.standard.diagram.Util;
import biouml.standard.state.State;
import biouml.standard.state.StatePropertyChangeUndo;
import biouml.standard.state.StateXmlSerializer;
import biouml.standard.state.TransactionUtils;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.undo.UndoableEdit;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.access.core.undo.DataCollectionAddUndo;
import ru.biosoft.access.core.undo.DataCollectionRemoveUndo;
import ru.biosoft.util.XmlUtil;

public class SbmlCompositeWriter
extends SbmlPackageWriter {
    private Set<String> sbmlIds;
    private Map<Node, String> nodeToSbmlIds;
    private Element externalModelDefList = null;

    public SbmlCompositeWriter() {
        this.log = Logger.getLogger(SbmlCompositeWriter.class.getName());
    }

    @Override
    protected void init(Document document, Diagram diagram) {
        super.init(document, diagram);
        this.sbmlIds = new HashSet<String>();
        this.nodeToSbmlIds = new HashMap<Node, String>();
    }

    @Override
    protected void processSBML(Element sbmlElement, Diagram diagram) {
        this.diagram = diagram;
        this.document = sbmlElement.getOwnerDocument();
        if (!this.modelDefinition) {
            this.writeModelDefinitionList(sbmlElement);
            if (this.externalModelDefList != null && this.externalModelDefList.hasChildNodes()) {
                sbmlElement.appendChild(this.externalModelDefList);
            }
        }
        sbmlElement.setAttribute("comp:required", "true");
    }

    @Override
    protected void processModel(Element modelElement, Diagram diagram) {
        this.diagram = diagram;
        this.document = modelElement.getOwnerDocument();
        this.writeSubmodelList(modelElement);
        this.writePortList(modelElement, diagram);
    }

    protected void writeSubmodelList(Element modelElement) {
        Element submodelList = this.document.createElement("comp:listOfSubmodels");
        for (Node node : this.diagram.recursiveStream().select(SubDiagram.class)) {
            try {
                this.writeSubmodel((SubDiagram)node, submodelList);
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error during submode " + node.getName() + "writing", t);
            }
        }
        if (submodelList.hasChildNodes()) {
            modelElement.appendChild(submodelList);
        }
    }

    protected String getSbmlId(Node species) {
        if (this.nodeToSbmlIds.containsKey(species)) {
            return this.nodeToSbmlIds.get(species);
        }
        String name = SbmlCompositeWriter.castStringToSId(species.getName());
        this.nodeToSbmlIds.put(species, name);
        this.sbmlIds.add(name);
        return name;
    }

    public String generateUniqueName(String baseName) {
        int i = 0;
        String name = baseName;
        while (this.sbmlIds.contains(name)) {
            name = baseName + "_" + i++;
        }
        return name;
    }

    protected void writeSubmodel(SubDiagram subdiagram, Element submodelList) {
        Element submodelElement = this.document.createElement("comp:submodel");
        submodelElement.setAttribute("comp:id", this.getSbmlId((Node)subdiagram));
        submodelElement.setAttribute("comp:modelRef", this.getSbmlId((Node)subdiagram.getDiagram()));
        DynamicProperty dp = subdiagram.getAttributes().getProperty("Time scale");
        if (dp != null && !dp.getValue().toString().isEmpty()) {
            submodelElement.setAttribute("comp:timeConversionFactor", dp.getValue().toString());
        }
        if ((dp = subdiagram.getAttributes().getProperty("Extent factor")) != null && !dp.getValue().toString().isEmpty()) {
            submodelElement.setAttribute("comp:extentConversionFactor", dp.getValue().toString());
        }
        SbmlCompositeWriter.writeSBOTerm(submodelElement, subdiagram.getAttributes());
        this.writeDeletionsList(submodelElement, subdiagram);
        submodelList.appendChild(submodelElement);
        Diagram innerDiagram = subdiagram.getDiagram();
        if (this.writeBioUMLAnnotation) {
            Element annotationElement = this.document.createElement("annotation");
            this.writeSubDiagramState(annotationElement, innerDiagram);
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element compartmentInfoElement = this.document.createElement("biouml:compartmentInfo");
            DiagramXmlWriter.writeCompartmentInfo((Element)compartmentInfoElement, (Compartment)subdiagram, (Document)this.document);
            bioumlElement.appendChild(compartmentInfoElement);
            annotationElement.appendChild(bioumlElement);
            submodelElement.appendChild(annotationElement);
        }
        if (!SbmlUtil.isInternal(innerDiagram, this.diagram)) {
            this.writeExternalModelDefintion(innerDiagram);
        }
    }

    private void writeSubDiagramState(Element submodelElement, Diagram diagram) {
        State state = diagram.getState("SubdiagramState");
        if (state != null) {
            submodelElement.appendChild(StateXmlSerializer.getStateXmlElement((State)state, (Document)this.document, (DiagramWriter)new DiagramXmlWriter(this.document, diagram)));
        }
    }

    protected void writeExternalModelDefintion(Diagram diagram) {
        if (this.externalModelDefList == null) {
            this.externalModelDefList = this.document.createElement("comp:listOfExternalModelDefinitions");
        } else if (XmlUtil.getChildElement((Element)this.externalModelDefList, (String)"comp:id", (String)diagram.getName()) != null) {
            return;
        }
        Element externalModelDef = this.document.createElement("comp:externalModelDefinition");
        externalModelDef.setAttribute("comp:id", SbmlCompositeWriter.castStringToSId(diagram.getName()));
        String path = diagram.getCompletePath().toString();
        if (this.newPaths != null && this.newPaths.containsKey(path)) {
            path = (String)this.newPaths.get(path);
        }
        externalModelDef.setAttribute("comp:source", path);
        if (this.writeBioUMLAnnotation) {
            Element annotationElement = this.document.createElement("annotation");
            Element diagramElement = this.document.createElement("biouml:diagramReference");
            diagramElement.setAttribute("path", path);
            annotationElement.appendChild(diagramElement);
            externalModelDef.appendChild(annotationElement);
        }
        this.externalModelDefList.appendChild(externalModelDef);
    }

    protected void writeDeletionsList(Element subModelElement, SubDiagram subDiagram) {
        Element deletionList = this.document.createElement("comp:listOfDeletions");
        State state = subDiagram.getState();
        if (state == null) {
            return;
        }
        for (Object elem : SbmlCompositeWriter.getRemovedElements(state)) {
            Element deletion = this.document.createElement("comp:deletion");
            if (elem instanceof String) {
                deletion.setAttribute("comp:idRef", (String)elem);
            } else if (elem instanceof SbmlModelReader_21.MetaIdInfo) {
                deletion.setAttribute("comp:metaIdRef", ((SbmlModelReader_21.MetaIdInfo)elem).getId());
            }
            deletionList.appendChild(deletion);
        }
        if (deletionList.hasChildNodes()) {
            subModelElement.appendChild(deletionList);
        }
    }

    protected void writeModelDefinitionList(Element modelElement) {
        NodeList nodeList = modelElement.getElementsByTagName("comp:listOfModelDefinitions");
        boolean noModeDefListYet = nodeList.getLength() == 0;
        Element modelDefinitionList = noModeDefListYet ? this.document.createElement("comp:listOfModelDefinitions") : (Element)nodeList.item(0);
        for (ModelDefinition modelDefinition : this.diagram.stream(ModelDefinition.class)) {
            try {
                Diagram innerDiagram = modelDefinition.getDiagram();
                SbmlModelWriter_31 writer = this.parentWriter instanceof SbmlModelWriter_32 ? new SbmlModelWriter_32() : new SbmlModelWriter_31();
                writer.setWriteBioUMLAnnotation(this.writeBioUMLAnnotation);
                Element modelDefinitionElement = this.document.createElement("comp:modelDefinition");
                boolean notificationEnabled = innerDiagram.isNotificationEnabled();
                innerDiagram.setNotificationEnabled(false);
                State currentState = innerDiagram.getCurrentState();
                if (currentState != null) {
                    innerDiagram.restore();
                }
                writer.writeDiagram(modelDefinitionElement, this.document, innerDiagram);
                if (this.writeBioUMLAnnotation) {
                    Element annotation = this.getElement(modelDefinitionElement, "annotation");
                    Element biouml = this.getElement(annotation, "biouml:BIOUML");
                    Element compartmentInfoElement = this.document.createElement("biouml:compartmentInfo");
                    compartmentInfoElement.setAttribute("completeName", modelDefinition.getCompleteNameInDiagram());
                    DiagramXmlWriter.writeCompartmentInfo((Element)compartmentInfoElement, (Compartment)modelDefinition, (Document)this.document);
                    biouml.appendChild(compartmentInfoElement);
                }
                if (currentState != null) {
                    innerDiagram.setStateEditingMode(currentState);
                }
                innerDiagram.setNotificationEnabled(notificationEnabled);
                modelDefinitionList.appendChild(modelDefinitionElement);
            }
            catch (Throwable t) {
                this.error("ERROR_MODEL_DEFINITION_WRITING", new String[]{this.diagram.getName(), modelDefinition.getName(), t.getMessage()});
            }
        }
        if (noModeDefListYet && modelDefinitionList.hasChildNodes()) {
            modelElement.appendChild(modelDefinitionList);
        }
    }

    @Override
    protected void processSpecie(Element speciesElement, Node species) {
        this.writeReplacementElements(speciesElement, (Variable)species.getRole(VariableRole.class));
    }

    @Override
    protected void processReaction(Element reactionElement, Node reactionNode) {
        Variable variable = this.emodel.getVariable(((Equation)reactionNode.getRole(Equation.class)).getVariable());
        if (variable != null) {
            this.writeReplacementElements(reactionElement, variable);
        }
    }

    protected void writeReplacementElements(Element element, @Nonnull Variable variable) {
        Element list = this.document.createElement("comp:listOfReplacedElements");
        List portNodes = Util.findPrivatePorts((Compartment)this.diagram, (String)variable.getName());
        for (Node port : portNodes) {
            ((StreamEx)port.edges().filter(e -> Util.isConnection((DiagramElement)e))).forEach(e -> this.writeReplacementElement((Edge)e, port, list, element));
        }
        if (variable instanceof VariableRole) {
            Node node = (Node)((VariableRole)variable).getDiagramElement();
            ((StreamEx)node.edges().filter(e -> Util.isConnection((DiagramElement)e) && e.getRole() != null)).forEach(e -> this.writeReplacementElement((Edge)e, node, list, element));
        }
        if (list.hasChildNodes()) {
            element.appendChild(list);
        }
    }

    protected void writeReplacementElement(Edge e, Node node, Element replacedElements, Element specieElement) {
        try {
            boolean inputIsUpperNode = e.getInput().equals(node);
            Node otherNode = e.getOtherEnd(node);
            boolean directed = Util.isDirectedConnection((Edge)e);
            if (Util.isModulePort((DiagramElement)otherNode)) {
                String convFactor;
                boolean forward;
                if (directed) {
                    forward = inputIsUpperNode;
                } else {
                    boolean unknown = UndirectedConnection.MainVariableType.NOT_SELECTED.equals((Object)((UndirectedConnection)e.getRole(UndirectedConnection.class)).getMainVariableType());
                    boolean mainInput = UndirectedConnection.MainVariableType.INPUT.equals((Object)((UndirectedConnection)e.getRole(UndirectedConnection.class)).getMainVariableType());
                    forward = unknown || inputIsUpperNode == mainInput;
                }
                String elementTag = forward ? "comp:replacedElement" : "comp:replacedBy";
                Element replacementElement = this.document.createElement(elementTag);
                replacementElement.setAttribute("metaid", e.getName());
                SubDiagram subDiagram = (SubDiagram)otherNode.getParent();
                Diagram innerDiagram = subDiagram.getDiagram();
                boolean innerIsComposite = innerDiagram.getType() instanceof SbmlCompositeDiagramType;
                replacementElement.setAttribute("comp:submodelRef", this.getSbmlId((Node)subDiagram));
                if (e.getRole() instanceof UndirectedConnection && !(convFactor = ((UndirectedConnection)e.getRole(UndirectedConnection.class)).getConversionFactor()).isEmpty()) {
                    replacementElement.setAttribute("comp:conversionFactor", convFactor);
                }
                if (Util.isPropagatedPort2((DiagramElement)otherNode)) {
                    Node nextPort = this.getNextPort(otherNode);
                    SubDiagram nextSubDiagram = (SubDiagram)nextPort.getParent();
                    replacementElement.setAttribute("comp:idRef", this.getSbmlId((Node)nextSubDiagram));
                    Element sBaseRef = this.createSbaseRef(nextPort, subDiagram.getState());
                    replacementElement.appendChild(sBaseRef);
                } else {
                    Node innerPortNode = innerDiagram.findNode(otherNode.getName());
                    if (this.isStateNode(innerPortNode, subDiagram.getState()) || !innerIsComposite) {
                        String varName = Util.getPortVariable((DiagramElement)otherNode);
                        EModel emodel = (EModel)innerDiagram.getRole(EModel.class);
                        Variable var = emodel.getVariable(varName);
                        if (var instanceof VariableRole) {
                            varName = this.getSbmlId((Node)((VariableRole)var).getDiagramElement());
                        }
                        replacementElement.setAttribute("comp:idRef", varName);
                    } else {
                        replacementElement.setAttribute("comp:portRef", this.getSbmlId(otherNode));
                    }
                }
                if (forward) {
                    replacedElements.appendChild(replacementElement);
                } else {
                    specieElement.appendChild(replacementElement);
                }
                if (this.writeBioUMLAnnotation) {
                    Element annotationElement = this.document.createElement("annotation");
                    Element bioumlElement = this.document.createElement("biouml:BIOUML");
                    bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                    Element edgeInfoElement = this.document.createElement("biouml:edgeInfo");
                    edgeInfoElement.setAttribute("type", directed ? "directed" : "undirected");
                    bioumlElement.appendChild(edgeInfoElement);
                    annotationElement.appendChild(bioumlElement);
                    replacementElement.appendChild(annotationElement);
                }
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Error while writing of connection edge " + e.getName() + ": " + ex.getMessage(), ex);
        }
    }

    protected Element createSbaseRef(Node portNode, State state) throws Exception {
        Element result = this.document.createElement("comp:sBaseRef");
        Node nextPortNode = this.getNextPort(portNode);
        if (nextPortNode == null) {
            Diagram diagram = ((SubDiagram)portNode.getParent()).getDiagram();
            EModel emodel = (EModel)diagram.getRole(EModel.class);
            if (this.isStateNode(portNode, state) || !(diagram.getType() instanceof SbmlCompositeDiagramType)) {
                String variableRef = Util.getPortVariable((DiagramElement)portNode);
                Variable var = emodel.getVariable(variableRef);
                if (var instanceof VariableRole) {
                    variableRef = ((VariableRole)var).getDiagramElement().getName();
                }
                result.setAttribute("comp:idRef", variableRef);
            } else {
                result.setAttribute("comp:portRef", this.getSbmlId(portNode));
            }
            return result;
        }
        SubDiagram subDiagram = (SubDiagram)nextPortNode.getParent();
        result.setAttribute("comp:idRef", this.getSbmlId((Node)subDiagram));
        result.appendChild(this.createSbaseRef(nextPortNode, subDiagram.getState()));
        return result;
    }

    protected boolean isStateNode(Node node, State state) throws Exception {
        if (node.getParent() instanceof SubDiagram) {
            SubDiagram subDiagram = (SubDiagram)node.getParent();
            state = subDiagram.getState();
            node = subDiagram.getDiagram().findNode(node.getName());
        }
        return state != null && StreamEx.of((Collection)state.getStateUndoManager().getEditsFlat()).flatMap(TransactionUtils::editsFlat).select(DataCollectionAddUndo.class).map(DataCollectionAddUndo::getDataElement).has((Object)node);
    }

    protected Node getNextPort(Node node) throws Exception {
        if (!Util.isPropagatedPort2((DiagramElement)node)) {
            return null;
        }
        SubDiagram subDiagram = (SubDiagram)node.getParent();
        String associatedPortName = node.getAttributes().getProperty("originalPort").getValue().toString();
        Diagram associatedDiagram = subDiagram.getDiagram();
        Node associatedPort = associatedDiagram.findNode(associatedPortName);
        return associatedPort.edges().findFirst(Util::isConnection).map(edge -> edge.getOtherEnd(associatedPort)).orElse(null);
    }

    @Override
    protected void processParameter(Element parameterElement, Variable parameter) {
        this.writeReplacementElements(parameterElement, parameter);
    }

    @Override
    protected void processCompartment(Element parameterElement, Compartment compartment) {
        this.writeReplacementElements(parameterElement, (Variable)compartment.getRole(VariableRole.class));
    }

    @Override
    protected void preprocess(Diagram diagram) {
    }

    protected void writePortList(Element modelElement, Diagram diagram) {
        Element portList = this.document.createElement("comp:listOfPorts");
        for (Node node2 : (StreamEx)diagram.stream(Node.class).filter(node -> Util.isPublicPort((DiagramElement)node))) {
            try {
                Element portElement = this.document.createElement("comp:port");
                portElement.setAttribute("comp:id", this.getSbmlId(node2));
                String variableRef = Util.getPortVariable((DiagramElement)node2);
                Variable var = this.emodel.getVariable(variableRef);
                if (var instanceof VariableRole) {
                    variableRef = ((VariableRole)var).getDiagramElement().getName();
                }
                if (variableRef.startsWith("$$")) {
                    variableRef = variableRef.substring(7);
                }
                portElement.setAttribute("comp:idRef", variableRef);
                portList.appendChild(portElement);
                SbmlCompositeWriter.writeSBOTerm(portElement, node2.getAttributes());
                if (!this.writeBioUMLAnnotation) continue;
                Element annotationElement = this.document.createElement("annotation");
                Element bioumlElement = this.document.createElement("biouml:BIOUML");
                bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)node2, (Document)this.document);
                nodeInfoElement.setAttribute("completeName", node2.getCompleteNameInDiagram());
                nodeInfoElement.setAttribute("portType", Util.getPortType((Node)node2));
                bioumlElement.appendChild(nodeInfoElement);
                annotationElement.appendChild(bioumlElement);
                portElement.appendChild(annotationElement);
            }
            catch (Exception ex) {
                this.error("ERROR_PORT_ELEMENT_WRITING", new String[]{diagram.getName(), node2.getName(), ex.getMessage()});
            }
        }
        if (portList.hasChildNodes()) {
            modelElement.appendChild(portList);
        }
    }

    @Override
    public String getNameSpace() {
        return "http://www.sbml.org/sbml/level3/version1/comp/version1";
    }

    @Override
    public String getPackageName() {
        return "comp";
    }

    public static List<Object> getRemovedElements(State state) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (UndoableEdit edit : state.getStateUndoManager().getEditsFlat()) {
            if (edit instanceof DataCollectionRemoveUndo) {
                DataElement de = ((DataCollectionRemoveUndo)edit).getDataElement();
                if (!(de instanceof DiagramElement)) continue;
                result.add(de.getName());
                continue;
            }
            if (!(edit instanceof StatePropertyChangeUndo)) continue;
            StatePropertyChangeUndo propertyEdit = (StatePropertyChangeUndo)edit;
            String propertyName = propertyEdit.getPropertyName();
            Object source = propertyEdit.getSource();
            if (!(source instanceof Node)) continue;
            Node node = (Node)source;
            if (propertyEdit.getOldValue() instanceof Object[] && propertyEdit.getNewValue() instanceof Object[]) {
                SbmlModelReader_21.MetaIdInfo metaIdInfo;
                Object[] oldValue = (Object[])propertyEdit.getOldValue();
                Object[] newValue = (Object[])propertyEdit.getNewValue();
                if (newValue.length != oldValue.length - 1) continue;
                if (newValue.length == 0 && (metaIdInfo = SbmlModelWriter_21.getMetaId(node, propertyName, 0)) != null) {
                    result.add(metaIdInfo);
                }
                for (Object element : newValue) {
                    SbmlModelReader_21.MetaIdInfo metaIdInfo2;
                    int oldIndex = -1;
                    for (int j = 0; j < oldValue.length; ++j) {
                        if (oldValue[j] == element) continue;
                        oldIndex = j;
                        break;
                    }
                    if (oldIndex == -1 || (metaIdInfo2 = SbmlModelWriter_21.getMetaId(node, propertyName, oldIndex)) == null) continue;
                    result.add(metaIdInfo2);
                }
                continue;
            }
            SbmlModelReader_21.MetaIdInfo metaIdInfo = SbmlModelWriter_21.getMetaId(node, propertyName);
            if (metaIdInfo == null) continue;
            result.add(metaIdInfo);
        }
        return result;
    }

    @Override
    protected void warn(String key, String[] params) {
        MessageBundle.warn(this.log, key, params);
    }

    @Override
    protected void error(String key, String[] params) {
        MessageBundle.error(this.log, key, params);
    }
}

