/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.composite;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.Edge;
import biouml.model.InitialElementProperties;
import biouml.model.ModelDefinition;
import biouml.model.Module;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.MultipleConnection;
import biouml.model.dynamics.UndirectedConnection;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.SbmlSemanticController;
import biouml.standard.diagram.CompositeSemanticController;
import biouml.standard.diagram.CreateEdgeDialog;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.SubDiagramProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.exception.ExceptionRegistry;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.util.PropertiesDialog;

public class SbmlCompositeSemanticController
extends SbmlSemanticController {
    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment compartment, Object type, String name, Point point, Object properties) {
        try {
            if (type.equals(Stub.ConnectionPort.class) && properties instanceof PortProperties) {
                PortProperties portProperties = (PortProperties)properties;
                DiagramElementGroup elements = portProperties.createElements(compartment, point, null);
                return elements;
            }
            return super.createInstance(compartment, type, name, point, properties);
        }
        catch (Throwable t) {
            throw ExceptionRegistry.translateException((Throwable)t);
        }
    }

    @Override
    public DiagramElementGroup createInstance(@Nonnull Compartment parent, Object type, Point point, ViewEditorPane viewEditor) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass == Stub.DirectedConnection.class || typeClass == Stub.UndirectedConnection.class) {
                CreateEdgeDialog dialog = CreateEdgeDialog.getConnectionDialog((Module)Module.getModule((DataElement)parent), (Point)point, (ViewEditorPane)viewEditor, (Class)typeClass, (Compartment)parent);
                dialog.setVisible(true);
                return null;
            }
            try {
                Object properties = this.getPropertiesByType(parent, type, point);
                if (properties != null) {
                    PropertiesDialog dialog = new PropertiesDialog((JFrame)Application.getApplicationFrame(), "New element", properties);
                    if (dialog.doModal() && properties instanceof InitialElementProperties) {
                        ((InitialElementProperties)properties).createElements(parent, point, viewEditor);
                    }
                    return null;
                }
            }
            catch (Throwable t) {
                throw ExceptionRegistry.translateException((Throwable)t);
            }
        }
        return super.createInstance(parent, type, point, viewEditor);
    }

    @Override
    public boolean remove(DiagramElement de) throws Exception {
        if (de instanceof Edge) {
            Edge edge = (Edge)de;
            if (Util.isDirectedConnection((Edge)edge) || Util.isUndirectedConnection((Edge)edge)) {
                if (edge.nodes().anyMatch(Util::isPropagatedPort)) {
                    return false;
                }
                de.getOrigin().remove(de.getName());
                return true;
            }
        } else if (de instanceof ModelDefinition) {
            Diagram diagram = Diagram.getDiagram((DiagramElement)de);
            for (SubDiagram node : diagram.stream(SubDiagram.class)) {
                DynamicProperty dp = node.getDiagram().getAttributes().getProperty("refModelDefinition");
                if (dp == null || !dp.getValue().equals(de)) continue;
                this.remove((DiagramElement)node);
            }
            diagram.remove(de.getName());
            return true;
        }
        return super.remove(de);
    }

    public Dimension move(DiagramElement de, Compartment newParent, Dimension offset, Rectangle oldBounds) throws Exception {
        if (offset.width == 0 && offset.height == 0) {
            return offset;
        }
        if (Util.isModulePort((DiagramElement)de)) {
            Compartment compartment = (Compartment)de.getOrigin();
            CompositeSemanticController.movePortToEdge((Node)((Node)de), (Compartment)compartment, (Dimension)offset, (boolean)false);
            for (Edge edge : ((Node)de).getEdges()) {
                this.recalculateEdgePath(edge);
            }
            return offset;
        }
        if (de instanceof Compartment) {
            Compartment compartment = (Compartment)de;
            Point location = compartment.getLocation();
            location.translate(offset.width, offset.height);
            boolean notification = compartment.isNotificationEnabled();
            compartment.setNotificationEnabled(false);
            compartment.setLocation(location);
            compartment.setNotificationEnabled(notification);
            for (Node node : compartment.getNodes()) {
                Point nodeLocation = node.getLocation();
                nodeLocation.translate(offset.width, offset.height);
                node.setLocation(nodeLocation);
            }
            for (Edge edge : CompositeSemanticController.getEdges((Node)compartment)) {
                this.recalculateEdgePath(edge);
            }
            return offset;
        }
        return super.move(de, newParent, offset, oldBounds);
    }

    @Override
    public synchronized DiagramElement validate(Compartment compartment, @Nonnull DiagramElement de, boolean newElement) throws Exception {
        String stubType = de.getKernel().getType();
        if (de instanceof Diagram) {
            SbmlCompositeSemanticController.addPackage((Diagram)de, "comp");
            if (compartment instanceof Diagram) {
                SubDiagram subDiagram = new SubDiagram((DataCollection)compartment, (Diagram)de, de.getName());
                subDiagram.getAttributes().add(new DynamicProperty("Extent factor", String.class, (Object)""));
                subDiagram.getAttributes().add(new DynamicProperty("Time scale", String.class, (Object)""));
                subDiagram.setLocation(((Node)de).getLocation());
                this.setXmlType((DiagramElement)subDiagram, "subDiagram");
                subDiagram.updatePorts();
                return subDiagram;
            }
            if (de.getRole() == null) {
                de.setRole((Role)new SbmlEModel(de));
            }
            return de;
        }
        if ("connection".equals(stubType)) {
            if (de instanceof Edge) {
                return this.createConnection(stubType, compartment, (Edge)de);
            }
        } else {
            if (newElement && "modelDefinition".equals(stubType)) {
                Diagram parent = Diagram.optDiagram((DiagramElement)compartment);
                Diagram innerDiagram = null;
                if (de instanceof ModelDefinition && ((ModelDefinition)de).getDiagram() != null) {
                    innerDiagram = ((ModelDefinition)de).getDiagram();
                } else if (parent != null) {
                    innerDiagram = parent.getType().clone().createDiagram(null, de.getName(), (Base)new DiagramInfo(de.getName()));
                    ModelDefinition modelDefinition = new ModelDefinition((DataCollection)compartment, innerDiagram, de.getName());
                    modelDefinition.setLocation(((Node)de).getLocation());
                    de = modelDefinition;
                }
                if (innerDiagram != null && innerDiagram.getRole() == null) {
                    innerDiagram.setRole((Role)new SbmlEModel((DiagramElement)innerDiagram));
                }
                this.setXmlType(de, "modelDefinition");
                return de;
            }
            if (newElement && "subdiagram".equals(stubType)) {
                DynamicProperty extentFactor;
                DynamicProperty timeFactor;
                Diagram parent = Diagram.optDiagram((DiagramElement)compartment);
                Diagram innerDiagram = null;
                if (de instanceof SubDiagram && ((SubDiagram)de).getDiagram() != null) {
                    innerDiagram = ((SubDiagram)de).getDiagram();
                } else if (parent != null) {
                    innerDiagram = parent.getType().createDiagram((DataCollection)parent, de.getName(), (Base)new DiagramInfo(de.getName()));
                    SubDiagram subDiagram = new SubDiagram((DataCollection)compartment, innerDiagram, de.getName());
                    subDiagram.setLocation(((Node)de).getLocation());
                    de = subDiagram;
                }
                if (innerDiagram != null && innerDiagram.getRole() == null) {
                    innerDiagram.setRole((Role)new EModel((DiagramElement)innerDiagram));
                }
                if ((timeFactor = de.getAttributes().getProperty("Time scale")) == null) {
                    de.getAttributes().add(new DynamicProperty("Time scale", String.class, (Object)""));
                }
                if ((extentFactor = de.getAttributes().getProperty("Extent factor")) == null) {
                    de.getAttributes().add(new DynamicProperty("Extent factor", String.class, (Object)""));
                }
                this.setXmlType(de, "subDiagram");
                return de;
            }
        }
        return super.validate(compartment, de, newElement);
    }

    protected Edge createConnection(String xmlType, Compartment compartment, Edge oldConnection) throws Exception {
        Edge edge = null;
        DynamicPropertySet attributes = oldConnection.getAttributes();
        DynamicProperty typeProperty = attributes.getProperty("connectionType");
        String name = oldConnection.getName();
        Stub.DirectedConnection kernel = new Stub.DirectedConnection((DataCollection)compartment, name);
        if (typeProperty != null) {
            String connectionType = typeProperty.getValue().toString();
            if ("directed".equals(connectionType)) {
                kernel = new Stub.DirectedConnection((DataCollection)compartment, name);
            } else if ("undirected".equals(connectionType)) {
                kernel = new Stub.UndirectedConnection((DataCollection)compartment, name);
            }
        }
        edge = new Edge(name, (Base)kernel, oldConnection.getInput(), oldConnection.getOutput());
        Object connection = kernel instanceof Stub.UndirectedConnection ? new UndirectedConnection(edge) : new DirectedConnection(edge);
        edge.setRole((Role)connection);
        Node input = edge.getInput();
        Node output = edge.getOutput();
        if (Util.isPort((DiagramElement)input) && Util.isPort((DiagramElement)output)) {
            String inputVar = Util.getPortVariable((DiagramElement)input);
            String outputVar = Util.getPortVariable((DiagramElement)output);
            connection.setInputPort(new Connection.Port(inputVar));
            connection.setOutputPort(new Connection.Port(outputVar));
        }
        this.setXmlType((DiagramElement)edge, xmlType);
        return edge;
    }

    @Override
    public Object getPropertiesByType(Compartment compartment, Object type, Point point) {
        if (type instanceof Class && SubDiagram.class.isAssignableFrom((Class)type)) {
            return new SubDiagramProperties(Diagram.getDiagram((DiagramElement)compartment));
        }
        return super.getPropertiesByType(compartment, type, point);
    }

    @Override
    public boolean canAccept(Compartment compartment, DiagramElement de) {
        if (de instanceof Edge) {
            Edge e = (Edge)de;
            if (e.getKernel() instanceof MultipleConnection) {
                return Util.isSubDiagram((DiagramElement)e.getInput()) && Util.isSubDiagram((DiagramElement)e.getOutput());
            }
            if (Util.isDirectedConnection((Edge)e)) {
                return Util.isOutputPort((DiagramElement)e.getInput()) && Util.isInputPort((DiagramElement)e.getOutput());
            }
            if (Util.isUndirectedConnection((Edge)e)) {
                return Util.isContactPort((DiagramElement)e.getInput()) && Util.isContactPort((DiagramElement)e.getOutput());
            }
        }
        if (Util.isSubDiagram((DiagramElement)de) || Util.isPort((DiagramElement)de) || de instanceof ModelDefinition) {
            return true;
        }
        return super.canAccept(compartment, de);
    }
}

