/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.composite;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import biouml.model.dynamics.Connection;
import biouml.model.dynamics.DirectedConnection;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.UndirectedConnection;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.dynamics.util.EModelHelper;
import biouml.model.util.DiagramXmlReader;
import biouml.plugins.sbgn.SbgnCompositeDiagramType;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.SbmlModelFactory;
import biouml.plugins.sbml.SbmlModelReader;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelReader_31;
import biouml.plugins.sbml.SbmlPackageReader;
import biouml.plugins.sbml.composite.MessageBundle;
import biouml.plugins.sbml.composite.SbmlCompositeDiagramType;
import biouml.plugins.sbml.composite.SbmlCompositeWriter;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.Util;
import biouml.standard.state.State;
import biouml.standard.type.Base;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.model.ArrayProperty;
import com.developmentontheedge.beans.model.ComponentFactory;
import com.developmentontheedge.beans.model.ComponentModel;
import com.developmentontheedge.beans.model.Property;
import java.awt.Point;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import one.util.streamex.EntryStream;
import org.eclipse.core.runtime.URIUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElementPath;
import ru.biosoft.util.ApplicationUtils;
import ru.biosoft.util.XmlUtil;

public class SbmlCompositeReader
extends SbmlPackageReader {
    private Map<String, ModelDefinition> modelDefinitions = new HashMap<String, ModelDefinition>();
    private Map<String, Element> modelDefElements = new HashMap<String, Element>();
    private Map<String, Diagram> externalModelDefinitions = new HashMap<String, Diagram>();
    private Map<SubDiagram, Map<String, Object>> deletions = new HashMap<SubDiagram, Map<String, Object>>();
    Set<String> portIds;
    HashMap<String, String> portToElement;
    Map<String, Diagram> subModels = new HashMap<String, Diagram>();

    public SbmlCompositeReader() {
        this.log = Logger.getLogger(SbmlCompositeReader.class.getName());
    }

    @Override
    public void preprocessDiagram(Element element, Diagram diagram) throws Exception {
        this.diagram = diagram;
        this.emodel = (SbmlEModel)diagram.getRole(SbmlEModel.class);
        this.modelName = diagram.getName();
        boolean propagationEnabled = diagram.isPropagationEnabled();
        this.diagram.setPropagationEnabled(false);
        this.readSubmodelList(element);
        this.readPortIds(element, diagram);
        diagram.setPropagationEnabled(propagationEnabled);
    }

    @Override
    public void postprocessDiagram(Element element, Diagram diagram) throws Exception {
        this.portToElement = new HashMap();
        this.readPortElementList(element, diagram);
        if (!this.portToElement.isEmpty()) {
            diagram.getAttributes().add(new DynamicProperty("portInfo", HashMap.class, this.portToElement));
        }
        if (!this.modelDefinition) {
            for (Element e : EntryStream.of(this.modelDefElements).removeKeys(this.modelDefinitions::containsKey).values()) {
                this.readModelDefinition(e, diagram);
            }
            for (ModelDefinition md : EntryStream.of(this.modelDefinitions).values()) {
                md.setOrigin((DataCollection)diagram);
                diagram.put((DiagramElement)md);
            }
        }
    }

    @Override
    public void preprocess(Document doc, DataCollection<?> origin) throws Exception {
        this.document = doc;
        this.readModelDefinitionList(doc);
        this.readExternalModelDefinitionList(doc, origin);
    }

    @Override
    public String getPackageName() {
        return "comp";
    }

    public static Set<String> getSubModelList(Element model) {
        HashSet<String> result = new HashSet<String>();
        Element subModelList = XmlUtil.findElementByTagName((Element)model, (String)"comp:listOfExternalModelDefinitions");
        if (subModelList == null) {
            return result;
        }
        NodeList list = subModelList.getElementsByTagName("comp:externalModelDefinition");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)list.item(i);
            String id = element.getAttribute("comp:source");
            result.add(id);
        }
        return result;
    }

    protected void readSubmodelList(Element model) {
        Element subModelList = this.getElement(model, "comp:listOfSubmodels");
        if (subModelList == null) {
            return;
        }
        NodeList list = subModelList.getElementsByTagName("comp:submodel");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            String modelDefId = "";
            try {
                Element element = (Element)list.item(i);
                String id = element.getAttribute("comp:id");
                Node node = this.readSubmodel(element, model, id);
                this.diagram.put((DiagramElement)node);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_SUB_MODEL_READING", new String[]{this.modelName, modelDefId, t.getMessage()});
            }
        }
    }

    protected Node readSubmodel(Element submodelElement, Element rootElement, String id) throws Exception {
        Diagram diagram;
        String modelRef = submodelElement.getAttribute("comp:modelRef");
        if (this.newPaths != null && this.newPaths.containsKey(modelRef)) {
            modelRef = (String)this.newPaths.get(modelRef);
        }
        if ((diagram = this.findModelDefinition(modelRef)) == null) {
            this.error("ERROR_MODEL_DEFINITION_MISSING", new String[]{this.modelName, id, modelRef});
            return null;
        }
        this.subModels.put(modelRef, diagram);
        SubDiagram subDiagram = new SubDiagram((DataCollection)this.diagram, diagram, id);
        String timeConvFactor = submodelElement.getAttribute("comp:timeConversionFactor");
        subDiagram.getAttributes().add(new DynamicProperty("Time scale", String.class, (Object)timeConvFactor));
        String extentConvFactor = submodelElement.getAttribute("comp:extentConversionFactor");
        subDiagram.getAttributes().add(new DynamicProperty("Extent factor", String.class, (Object)extentConvFactor));
        Element annotation = this.getElement(submodelElement, "annotation");
        if (annotation != null) {
            Element stateElement = this.getElement(annotation, "state");
            if (stateElement != null) {
                DiagramXmlReader.readSubDiagramState((Element)stateElement, (SubDiagram)subDiagram);
            }
            this.readBioUMLAnnotation(annotation, (DiagramElement)subDiagram, "biouml:compartmentInfo");
        }
        this.readDeletionElementList(submodelElement, subDiagram);
        return subDiagram;
    }

    protected Diagram findModelDefinition(String modelRef) throws Exception {
        if (this.modelDefinitions.containsKey(modelRef)) {
            return this.modelDefinitions.get(modelRef).getDiagram();
        }
        if (this.subModels.containsKey(modelRef)) {
            return this.subModels.get(modelRef);
        }
        if (this.modelDefElements.containsKey(modelRef)) {
            return this.readModelDefinition(this.modelDefElements.get(modelRef), this.diagram);
        }
        if (this.externalModelDefinitions.containsKey(modelRef)) {
            return this.externalModelDefinitions.get(modelRef);
        }
        return null;
    }

    protected void readModelDefinitionList(Document document) {
        Element modelDefList = this.getElement(document.getDocumentElement(), "comp:listOfModelDefinitions");
        if (modelDefList == null) {
            return;
        }
        NodeList list = modelDefList.getElementsByTagName("comp:modelDefinition");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String modelDefId = element.getAttribute("id");
            this.modelDefElements.put(modelDefId, element);
        }
    }

    protected void readExternalModelDefinitionList(Document document, DataCollection<?> origin) {
        Element modelDefList = this.getElement(document.getDocumentElement(), "comp:listOfExternalModelDefinitions");
        if (modelDefList == null) {
            return;
        }
        NodeList list = modelDefList.getElementsByTagName("comp:externalModelDefinition");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String modelDefId = element.getAttribute("comp:id");
            try {
                Element diagramReferenceElement;
                Element bioumlElement;
                Element annotationElement = this.getElement(element, "annotation");
                if (annotationElement != null && (bioumlElement = this.getElement(annotationElement, "biouml:diagramReference")) != null && (diagramReferenceElement = this.getElement(annotationElement, "biouml:diagramReference")) != null) {
                    String path = diagramReferenceElement.getAttribute("path");
                    if (this.newPaths != null && this.newPaths.containsKey(path)) {
                        path = (String)this.newPaths.get(path);
                    }
                    Diagram diagram = (Diagram)DataElementPath.create((String)path).getDataElement(Diagram.class);
                    this.externalModelDefinitions.put(modelDefId, diagram);
                    continue;
                }
            }
            catch (Exception annotationElement) {
                // empty catch block
            }
            String source = element.getAttribute("comp:source");
            if (this.newPaths != null && this.newPaths.containsKey(source)) {
                String path = (String)this.newPaths.get(source);
                Diagram diagram = (Diagram)DataElementPath.create((String)path).getDataElement(Diagram.class);
                this.externalModelDefinitions.put(modelDefId, diagram);
                continue;
            }
            String modelRef = element.getAttribute("comp:modelRef");
            try {
                File externalFile = this.getFile(source);
                if (modelRef.isEmpty()) {
                    Diagram externalDiagram = SbmlModelFactory.readDiagram(externalFile, origin, ApplicationUtils.getFileNameWithoutExtension((String)externalFile.getName()));
                    this.externalModelDefinitions.put(modelDefId, externalDiagram);
                    continue;
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document externalDocument = builder.parse(externalFile);
                SbmlCompositeReader newReader = new SbmlCompositeReader();
                newReader.document = externalDocument;
                newReader.readExternalModelDefinitionList(externalDocument, origin);
                newReader.readModelDefinitionList(externalDocument);
                if (newReader.modelDefElements.containsKey(modelRef)) {
                    this.externalModelDefinitions.put(modelDefId, newReader.readModelDefinition(newReader.modelDefElements.get(modelRef), null));
                    continue;
                }
                if (newReader.externalModelDefinitions.containsKey(modelRef)) {
                    this.externalModelDefinitions.put(modelDefId, newReader.externalModelDefinitions.get(modelRef));
                    continue;
                }
                Diagram externalDiagram = SbmlModelFactory.readDiagram(externalFile, origin, ApplicationUtils.getFileNameWithoutExtension((String)externalFile.getName()));
                this.externalModelDefinitions.put(modelDefId, externalDiagram);
                continue;
            }
            catch (Exception ex) {
                this.error("ERROR_EXTERNAL_MODEL_DEFINITION_READING", new String[]{this.modelName, modelRef, ex.getMessage()});
            }
        }
    }

    protected void addModelDefinition(String name, ModelDefinition modelDef) {
        this.modelDefinitions.put(name, modelDef);
    }

    protected Diagram readModelDefinition(Element element, Diagram origin) throws Exception {
        String modelId = element.getAttribute("id");
        try {
            SbmlModelReader_31 reader = new SbmlModelReader_31();
            SbmlCompositeReader compReader = null;
            reader.initPackageReaders(element.getOwnerDocument(), true);
            for (SbmlPackageReader packageReader : reader.getPackageReaders()) {
                if (!(packageReader instanceof SbmlCompositeReader)) continue;
                compReader = (SbmlCompositeReader)packageReader;
            }
            EntryStream.of(this.modelDefinitions).forKeyValue(compReader::addModelDefinition);
            Diagram innerDiagram = reader.readModelDefinition(element, modelId);
            if (origin != null) {
                Element compartmentInfoElement;
                Element bioumlElement;
                Node parentNode;
                String fullName = reader.getCompleteId(element, "biouml:compartmentInfo");
                String id = SbmlModelReader.getBriefName(fullName);
                Diagram parent = origin;
                String parentName = SbmlModelReader.getParentId(fullName);
                if (parentName != null && (parentNode = origin.findNode(parentName)) != null && parentNode instanceof Compartment) {
                    parent = origin;
                }
                if (Diagram.getDiagram((DiagramElement)parent).getType() instanceof SbgnCompositeDiagramType) {
                    Object sbgnDiagram = innerDiagram.getAttributes().getValue("sbgn_diagram");
                    innerDiagram = !(sbgnDiagram instanceof Diagram) ? SBGNConverterNew.convert(innerDiagram) : (Diagram)sbgnDiagram;
                }
                ModelDefinition modelDefinition = new ModelDefinition((DataCollection)parent, innerDiagram, id);
                Element annotationElement = this.getElement(element, "annotation");
                if (annotationElement != null && (bioumlElement = this.getElement(annotationElement, "biouml:BIOUML")) != null && (compartmentInfoElement = this.getElement(bioumlElement, "biouml:compartmentInfo")) != null) {
                    DiagramXmlReader.readCompartmentInfo((Element)compartmentInfoElement, (Compartment)modelDefinition, (String)this.diagram.getName());
                }
                this.modelDefinitions.put(modelId, modelDefinition);
                if (!this.modelDefinition) {
                    modelDefinition.save();
                }
            }
            EntryStream.of(compReader.modelDefElements).forKeyValue(this.modelDefElements::putIfAbsent);
            EntryStream.of(compReader.modelDefinitions).forKeyValue(this.modelDefinitions::putIfAbsent);
            return innerDiagram;
        }
        catch (Throwable t) {
            this.error("ERROR_MODEL_DEFINITION_READING", new String[]{this.modelName, modelId, t.getMessage()});
            return null;
        }
    }

    @Override
    public void processSpecie(Element element, Node node) throws Exception {
        Element replacedBy = this.getElement(element, "comp:replacedBy");
        if (replacedBy != null) {
            this.readReplacedByElement(replacedBy, node);
        }
        this.readReplacedElementList(element, node);
    }

    @Override
    public void processCompartment(Element element, Compartment compartment) throws Exception {
        Element replacedBy = this.getElement(element, "comp:replacedBy");
        if (replacedBy != null) {
            this.readReplacedByElement(replacedBy, compartment);
        }
        this.readReplacedElementList(element, compartment);
    }

    @Override
    public void processParameter(Element element, Variable parameter) throws Exception {
        Element replacedBy = this.getElement(element, "comp:replacedBy");
        if (replacedBy != null) {
            this.readReplacedByElement(replacedBy, parameter);
        }
        this.readReplacedElementList(element, parameter);
    }

    @Override
    public void processRule(Element element, Node ruleNode) {
        this.readReplacedElementList(element, ruleNode);
    }

    @Override
    public void processReaction(Element element, Node node) throws Exception {
        this.readReplacedElementList(element, node);
    }

    @Override
    public void processSpecieReference(Element element, Edge edge) throws Exception {
        String id = element.getAttribute("id");
        Variable parameter = this.emodel.getVariable(id);
        if (parameter != null) {
            this.readReplacedElementList(element, parameter);
        }
    }

    protected void readDeletionElementList(Element element, SubDiagram subDiagram) {
        Element replacedList = this.getElement(element, "comp:listOfDeletions");
        if (replacedList == null) {
            return;
        }
        NodeList list = replacedList.getElementsByTagName("comp:deletion");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            try {
                Element deletionElement = (Element)list.item(i);
                this.readDeletionElement(deletionElement, subDiagram);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_DELETION_ELEMENT_READING", new String[]{this.modelName, subDiagram.getName(), t.getMessage()});
            }
        }
    }

    protected void readDeletionElement(Element element, SubDiagram subDiagram) throws Exception {
        Stack<SubDiagram> nestedSubDiagrams = new Stack<SubDiagram>();
        nestedSubDiagrams.add(subDiagram);
        String reference = this.readSBaseRef(element, nestedSubDiagrams, subDiagram);
        SubDiagram lowestSubDiagram = nestedSubDiagrams.pop();
        Diagram innerDiagram = lowestSubDiagram.getDiagram();
        Node refObject = null;
        String propertyName = null;
        SbmlModelReader_21.MetaIdInfo metaIdInfo = null;
        Map metaIdMap = (Map)innerDiagram.getAttributes().getProperty("metaIds").getValue();
        if (metaIdMap != null && metaIdMap.containsKey(reference)) {
            metaIdInfo = (SbmlModelReader_21.MetaIdInfo)metaIdMap.get(reference);
            reference = metaIdInfo.getObjectName();
            propertyName = metaIdInfo.getProperty();
            Class<?> objectClass = metaIdInfo.getOjectClass();
            Object object = refObject = Node.class.isAssignableFrom(objectClass) ? innerDiagram.findNode(reference) : ((EModel)innerDiagram.getRole(EModel.class)).getVariable(reference);
        }
        if (refObject == null) {
            refObject = innerDiagram.findNode(reference);
        }
        if (refObject == null) {
            return;
        }
        this.setState(lowestSubDiagram);
        for (Object obj : SbmlCompositeWriter.getRemovedElements(lowestSubDiagram.getState())) {
            SbmlModelReader_21.MetaIdInfo existInfo;
            if (!(obj instanceof SbmlModelReader_21.MetaIdInfo) || !metaIdInfo.equals(existInfo = (SbmlModelReader_21.MetaIdInfo)obj)) continue;
            return;
        }
        if (refObject instanceof Variable) {
            String baseId;
            Variable globalVariable;
            EModel emodel = (EModel)innerDiagram.getRole(EModel.class);
            Variable var = (Variable)refObject;
            if (var.getAttributes().getProperty("baseId") != null && (globalVariable = emodel.getVariable(baseId = var.getAttributes().getProperty("baseId").getValue().toString())) != null) {
                new EModelHelper(emodel).renameVariable(var.getName(), globalVariable.getName(), true);
            }
        } else if (refObject instanceof Node) {
            Node node = refObject;
            if (propertyName == null) {
                SemanticController controller = innerDiagram.getType().getSemanticController();
                controller.remove((DiagramElement)node);
            } else {
                Role role = node.getRole();
                ComponentModel model = ComponentFactory.getModel((Object)role, (ComponentFactory.Policy)ComponentFactory.Policy.UI, (boolean)true);
                Property property = model.findProperty(propertyName);
                if (property instanceof ArrayProperty) {
                    ((ArrayProperty)property).removeItem(metaIdInfo.getIndex());
                } else {
                    property.setValue(null);
                }
            }
        }
        String deletionId = element.getAttribute("comp:id");
        Map<String, Object> subDiagramDeletions = this.deletions.get(subDiagram);
        if (subDiagramDeletions == null) {
            subDiagramDeletions = new HashMap<String, Object>();
            this.deletions.put(subDiagram, subDiagramDeletions);
        }
        subDiagramDeletions.put(deletionId, refObject);
    }

    protected void readReplacedElementList(Element element, Object de) {
        Element replacedList = this.getElement(element, "comp:listOfReplacedElements");
        if (replacedList == null) {
            return;
        }
        NodeList list = replacedList.getElementsByTagName("comp:replacedElement");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            try {
                this.readReplacedElement((Element)list.item(i), de);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void readReplacedByElement(Element element, Object de) {
        this.createConnectionChain(element, de, false);
    }

    protected void readReplacedElement(Element element, Object de) {
        this.createConnectionChain(element, de, true);
    }

    private boolean readConnectionType(Element element) {
        Element bioumlElement;
        boolean directed = false;
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null && (bioumlElement = this.getElement(annotationElement, "biouml:BIOUML")) != null) {
            Element edgeInfo = this.getElement(bioumlElement, "biouml:edgeInfo");
            directed = edgeInfo != null && "directed".equals(edgeInfo.getAttribute("type"));
        }
        return directed;
    }

    protected void createConnectionChain(String upperVariable, String reference, Stack<SubDiagram> nestedSubDiagrams, Element element, boolean forward) throws Exception {
        boolean directed = this.readConnectionType(element);
        SubDiagram subDiagram = nestedSubDiagrams.pop();
        Node innerPort = this.getInnerNodeByReference(subDiagram, reference, false);
        if (upperVariable == null || innerPort == null) {
            return;
        }
        String convFactor = element.getAttribute("comp:conversionFactor");
        String replacementName = element.getAttribute("metaid");
        if (replacementName.isEmpty()) {
            replacementName = "connection";
        }
        while (true) {
            Node upperPort;
            Diagram nextDiagram;
            if ((nextDiagram = Diagram.getDiagram((DiagramElement)subDiagram)).equals(this.diagram)) {
                PortProperties portProperties = new PortProperties(this.diagram, Stub.ContactConnectionPort.class);
                portProperties.setAccessType("private");
                portProperties.setVarName(upperVariable);
                portProperties.setName(this.createPortName(portProperties.getName(), this.diagram));
                upperPort = Util.findPort((Compartment)this.diagram, (PortProperties)portProperties);
                if (upperPort == null) {
                    DiagramElementGroup elements = portProperties.createElements((Compartment)this.diagram, new Point(0, 0), null);
                    upperPort = (Node)elements.getElement(Util::isPort);
                }
                this.createConnection(this.diagram, upperPort, subDiagram, innerPort, convFactor, forward, replacementName, directed);
                return;
            }
            SubDiagram parentSubDiagram = SubDiagram.getParentSubDiagram((Diagram)nextDiagram);
            this.setState(parentSubDiagram);
            PortProperties portProperties = new PortProperties(nextDiagram, Stub.ContactConnectionPort.class);
            portProperties.setAccessType("propagated");
            portProperties.setModuleName(subDiagram.getName());
            portProperties.setBasePortName(innerPort.getName());
            upperPort = Util.findPort((Compartment)nextDiagram, (PortProperties)portProperties);
            if (upperPort == null) {
                DiagramElementGroup elements = portProperties.createElements((Compartment)nextDiagram, new Point(0, 0), null);
                upperPort = (Node)elements.getElement(Util::isPort);
                parentSubDiagram.updatePorts();
            }
            subDiagram = nestedSubDiagrams.pop();
            innerPort = subDiagram.findNode(upperPort.getName());
        }
    }

    protected String createPortName(String baseName, Diagram diagram) {
        int i = 1;
        String name = baseName;
        while (this.portIds.contains(name) || diagram.contains(name)) {
            name = baseName + "_" + i++;
        }
        return name;
    }

    protected void createConnectionChain(Element element, Object de, boolean forward) {
        try {
            String submodelRef = element.getAttribute("comp:submodelRef");
            SubDiagram subDiagram = (SubDiagram)this.diagram.findNode(submodelRef);
            Stack<SubDiagram> nestedSubDiagrams = new Stack<SubDiagram>();
            nestedSubDiagrams.add(subDiagram);
            String reference = this.readSBaseRef(element, nestedSubDiagrams, subDiagram);
            if (reference == null) {
                return;
            }
            String upperVariable = null;
            if (de instanceof Node) {
                Node node = (Node)de;
                if (Util.isVariable((DiagramElement)node)) {
                    upperVariable = ((VariableRole)node.getRole(VariableRole.class)).getName();
                } else if (Util.isReaction((DiagramElement)node)) {
                    upperVariable = ((Equation)node.getRole(Equation.class)).getVariable();
                }
            } else if (de instanceof Variable) {
                upperVariable = ((Variable)de).getName();
            } else if (de instanceof Edge) {
                upperVariable = ((Edge)de).getName();
            }
            this.createConnectionChain(upperVariable, reference, nestedSubDiagrams, element, forward);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Node getInnerNodeByReference(SubDiagram subDiagram, String reference, boolean isTransient) throws Exception {
        Diagram innerDiagram = subDiagram.getDiagram();
        EModel emodel = (EModel)innerDiagram.getRole(EModel.class);
        DiagramElement refNode = null;
        if (!innerDiagram.getAttributes().hasProperty("metaIds")) {
            refNode = innerDiagram.findDiagramElement(reference);
        } else {
            Map metaIdMap = (Map)innerDiagram.getAttributes().getProperty("metaIds").getValue();
            if (metaIdMap != null && metaIdMap.containsKey(reference)) {
                SbmlModelReader_21.MetaIdInfo metaIdInfo = (SbmlModelReader_21.MetaIdInfo)metaIdMap.get(reference);
                reference = metaIdInfo.getObjectName();
                Class<?> clazz = metaIdInfo.getOjectClass();
                if (Variable.class.isAssignableFrom(clazz)) {
                    String lowerVariable = emodel.getVariable(reference).getName();
                    return this.createPortNode(subDiagram, lowerVariable, "public");
                }
                if (!Node.class.isAssignableFrom(clazz)) {
                    // empty if block
                }
            } else {
                refNode = innerDiagram.findDiagramElement(reference);
            }
        }
        if (refNode == null) {
            if (!emodel.containsVariable(reference)) {
                return null;
            }
            String lowerVariable = emodel.getVariable(reference).getName();
            return this.createPortNode(subDiagram, lowerVariable, "public");
        }
        if (Util.isPort((DiagramElement)refNode)) {
            return subDiagram.findNode(refNode.getName());
        }
        if (Util.isVariable((DiagramElement)refNode)) {
            String lowerVariable = ((VariableRole)refNode.getRole(VariableRole.class)).getName();
            return this.createPortNode(subDiagram, lowerVariable, "public");
        }
        if (Util.isReaction((DiagramElement)refNode)) {
            String lowerVariable = ((Equation)refNode.getRole(Equation.class)).getVariable();
            return this.createPortNode(subDiagram, lowerVariable, "public");
        }
        if (Util.isSpecieReference((DiagramElement)refNode)) {
            String lowerVariable = refNode.getName();
            return this.createPortNode(subDiagram, lowerVariable, "public");
        }
        this.setState(subDiagram);
        SemanticController controller = Diagram.getDiagram((DiagramElement)refNode).getType().getSemanticController();
        controller.remove(refNode);
        return null;
    }

    protected void createConnection(Diagram diagram, Node diagramNode, SubDiagram subDiagram, Node innerNode, String convFactor, boolean forward, String name, boolean directed) {
        try {
            DirectedConnection connection;
            subDiagram.updatePorts();
            for (Edge e : diagramNode.getEdges()) {
                if (!e.getOtherEnd(diagramNode).equals(innerNode) || !Util.isUndirectedConnection((Edge)e)) continue;
                return;
            }
            String replacementVarName = Util.isPort((DiagramElement)diagramNode) ? Util.getPortVariable((DiagramElement)diagramNode) : ((VariableRole)diagramNode.getRole(VariableRole.class)).getName();
            String edgeName = DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)name);
            String replacedVarName = Util.getPortVariable((DiagramElement)innerNode);
            Stub.DirectedConnection kernel = directed ? new Stub.DirectedConnection(null, edgeName) : new Stub.UndirectedConnection(null, edgeName);
            Edge edge = new Edge((DataCollection)diagram, (Base)kernel, diagramNode, innerNode);
            diagramNode.addEdge(edge);
            innerNode.addEdge(edge);
            if (directed) {
                connection = new DirectedConnection(edge);
            } else {
                connection = new UndirectedConnection(edge);
                ((UndirectedConnection)connection).setMainVariableType(forward ? UndirectedConnection.MainVariableType.INPUT : UndirectedConnection.MainVariableType.OUTPUT);
                ((UndirectedConnection)connection).setConversionFactor(convFactor);
            }
            edge.setRole((Role)connection);
            connection.setOutputPort(new Connection.Port(replacedVarName));
            connection.setInputPort(new Connection.Port(replacementVarName));
            edge.save();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    protected Node createPortNode(Diagram diagram, String variableName, String accessType) throws Exception {
        String existingAccessType;
        Node portNode = Util.findPort((Compartment)diagram, (String)variableName);
        if (portNode != null && accessType.equals(existingAccessType = portNode.getAttributes().getValueAsString("accessType"))) {
            return portNode;
        }
        String portName = variableName.contains(".") ? variableName.substring(variableName.lastIndexOf(".") + 1) : variableName;
        if ((portName = portName + "_port_" + accessType).startsWith("$$")) {
            portName = portName.substring(2);
        } else if (portName.startsWith("$")) {
            portName = portName.substring(1);
        }
        portName = DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)portName);
        portNode = new Node((DataCollection)diagram, portName, (Base)new Stub.ConnectionPort(portName, (DataCollection)diagram, "contact connection port"));
        this.addProperty((DiagramElement)portNode, new DynamicProperty("variableName", String.class, (Object)variableName), false, true);
        this.addProperty((DiagramElement)portNode, new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)SubDiagram.PortOrientation.LEFT), false, false);
        this.addProperty((DiagramElement)portNode, new DynamicProperty("accessType", String.class, (Object)accessType), false, true);
        portNode.save();
        return portNode;
    }

    protected Node createPortNode(SubDiagram subDiagram, String variableName, String accessType) throws Exception {
        Diagram innerDiagram = subDiagram.getDiagram();
        Node diagramNode = this.createPortNode(innerDiagram, variableName, accessType);
        subDiagram.updatePorts();
        DynamicProperty dp = innerDiagram.getAttributes().getProperty("refModelDefinition");
        if (dp != null) {
            Diagram originalDiagram = ((ModelDefinition)dp.getValue()).getDiagram();
            originalDiagram.put((DiagramElement)diagramNode.clone((Compartment)originalDiagram, diagramNode.getName()));
        }
        return subDiagram.findNode(diagramNode.getName());
    }

    protected void setState(SubDiagram subDiagram) {
        State state = subDiagram.getState();
        if (state == null) {
            String stateName;
            Diagram innerDiagram = subDiagram.getDiagram();
            state = innerDiagram.getState(stateName = "SubdiagramState");
            if (state == null) {
                state = new State(innerDiagram, stateName);
                innerDiagram.addState(state);
            }
            subDiagram.setState(state);
        }
    }

    protected String generateStateName(SubDiagram subDiagram) {
        StringBuffer stateName = new StringBuffer();
        try {
            Stack<SubDiagram> parentSubDiagrams = new Stack<SubDiagram>();
            Diagram highestDiagarm = SbmlCompositeReader.fillParentSubDiagrams(subDiagram, parentSubDiagrams);
            stateName.append(highestDiagarm.getName());
            stateName.append("_");
            while (!parentSubDiagrams.isEmpty()) {
                stateName.append(parentSubDiagrams.pop().getName());
                stateName.append("_");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stateName.append(subDiagram.getName());
        stateName.append("_state");
        return stateName.toString();
    }

    protected static Diagram fillParentSubDiagrams(SubDiagram subDiagram, Stack<SubDiagram> parentSubDiagrams) throws Exception {
        Diagram upperDiagram = Diagram.getDiagram((DiagramElement)subDiagram);
        DynamicProperty dp = upperDiagram.getAttributes().getProperty("subDiagram");
        if (dp != null && upperDiagram.getOrigin() instanceof Diagram) {
            Diagram nextDiagram = (Diagram)upperDiagram.getOrigin();
            SubDiagram nextSubDiagram = (SubDiagram)nextDiagram.findNode(dp.getValue().toString());
            parentSubDiagrams.add(nextSubDiagram);
            upperDiagram = SbmlCompositeReader.fillParentSubDiagrams(nextSubDiagram, parentSubDiagrams);
        }
        return upperDiagram;
    }

    protected String readSBaseRef(Element element, Stack<SubDiagram> nestedSubDiagrams, SubDiagram subDiagram) throws Exception {
        DiagramElement subModelElement;
        Diagram upperDiagram = subDiagram.getDiagram();
        String submodelElementRef = element.getAttribute("comp:idRef");
        if (submodelElementRef.isEmpty() && !(submodelElementRef = element.getAttribute("comp:metaIdRef")).isEmpty()) {
            return submodelElementRef;
        }
        if (submodelElementRef.isEmpty()) {
            HashMap ports;
            submodelElementRef = element.getAttribute("comp:portRef");
            DynamicProperty dp = upperDiagram.getAttributes().getProperty("portInfo");
            if (dp != null && (ports = (HashMap)dp.getValue()).containsKey(submodelElementRef)) {
                return (String)ports.get(submodelElementRef);
            }
        }
        if (submodelElementRef.isEmpty()) {
            Object obj;
            submodelElementRef = element.getAttribute("comp:deletion");
            Map<String, Object> subDiagramDeletions = this.deletions.get(subDiagram);
            if (subDiagramDeletions != null && subDiagramDeletions.containsKey(submodelElementRef) && (obj = subDiagramDeletions.get(submodelElementRef)) instanceof Node) {
                return ((Node)obj).getName();
            }
        }
        if ((subModelElement = upperDiagram.findDiagramElement(submodelElementRef)) == null) {
            Variable var = ((EModel)upperDiagram.getRole(EModel.class)).getVariable(submodelElementRef);
            return var != null ? var.getName() : null;
        }
        if (Util.isVariable((DiagramElement)subModelElement)) {
            return ((VariableRole)subModelElement.getRole(VariableRole.class)).getName();
        }
        if (subModelElement instanceof Edge) {
            Base kernel = ((Edge)subModelElement).getKernel();
            if (kernel instanceof SpecieReference) {
                return kernel.getName();
            }
        } else if (!(subModelElement instanceof SubDiagram)) {
            return submodelElementRef;
        }
        SubDiagram nextSubDiagram = (SubDiagram)subModelElement;
        nestedSubDiagrams.add(nextSubDiagram);
        Diagram nextDiagram = nextSubDiagram.getDiagram();
        NodeList list = element.getElementsByTagName("comp:sBaseRef");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element onlyChild = (Element)list.item(i);
            String childRef = onlyChild.getAttribute("comp:idRef");
            if (childRef.isEmpty()) {
                childRef = onlyChild.getAttribute("comp:metaIdRef");
            }
            if (childRef.isEmpty()) {
                childRef = onlyChild.getAttribute("comp:portRef");
            }
            if (childRef.isEmpty()) {
                return null;
            }
            subModelElement = nextDiagram.findNode(childRef);
            if (subModelElement == null) {
                EModel emodel = (EModel)nextDiagram.getRole(EModel.class);
                Variable var = emodel.getVariable(childRef);
                if (var == null) continue;
                return var.getName();
            }
            if (Util.isVariable((DiagramElement)subModelElement)) {
                return ((VariableRole)subModelElement.getRole(VariableRole.class)).getName();
            }
            if (subModelElement instanceof SubDiagram) {
                nextSubDiagram = (SubDiagram)subModelElement;
                nestedSubDiagrams.add(nextSubDiagram);
                nextDiagram = nextSubDiagram.getDiagram();
                continue;
            }
            if (!(subModelElement instanceof Compartment)) continue;
            return ((VariableRole)subModelElement.getRole(VariableRole.class)).getName();
        }
        return subModelElement.getName();
    }

    @Override
    public DiagramType getDiagramType() {
        return new SbmlCompositeDiagramType();
    }

    protected void readPortIds(Element element, Diagram diagram) {
        this.portIds = new HashSet<String>();
        Element portList = this.getElement(element, "comp:listOfPorts");
        if (portList == null) {
            return;
        }
        NodeList list = portList.getElementsByTagName("comp:port");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            try {
                Element portElement = (Element)list.item(i);
                String id = portElement.getAttribute("comp:id");
                this.portIds.add(id);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void readPortElementList(Element element, Diagram diagram) {
        Element portList = this.getElement(element, "comp:listOfPorts");
        if (portList == null) {
            return;
        }
        NodeList list = portList.getElementsByTagName("comp:port");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            try {
                Element portElement = (Element)list.item(i);
                this.readPortElement(portElement, diagram);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void readPortElement(Element element, Diagram diagram) throws Exception {
        Element nodeInfoElement;
        Element bioumlElement;
        String fullvarName;
        String idRef = element.getAttribute("comp:idRef");
        if (idRef.isEmpty()) {
            idRef = element.getAttribute("comp:metaIdRef");
        }
        String id = element.getAttribute("comp:id");
        EModel model = (EModel)diagram.getRole(EModel.class);
        Variable var = model.getVariable(idRef);
        if (var == null && (fullvarName = model.getQualifiedName("$" + idRef, null)) != null) {
            var = model.getVariable(fullvarName);
        }
        if (var == null && (fullvarName = model.getQualifiedName("$$rate_" + idRef, null)) != null) {
            var = model.getVariable(fullvarName);
        }
        if (var == null) {
            this.portToElement.put(id, idRef);
            return;
        }
        Node existingNode = Util.findPort((Compartment)diagram, (String)var.getName());
        if (existingNode != null && Util.isPublicPort((DiagramElement)existingNode)) {
            return;
        }
        SemanticController controller = diagram.getType().getSemanticController();
        Node portNode = new Node((DataCollection)diagram, id, (Base)new Stub.ContactConnectionPort((DataCollection)diagram, id));
        this.readSBOTerm(element, portNode.getAttributes());
        this.addProperty((DiagramElement)portNode, new DynamicProperty("variableName", String.class, (Object)var.getName()), false, true);
        this.addProperty((DiagramElement)portNode, new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)SubDiagram.PortOrientation.LEFT), false, false);
        this.addProperty((DiagramElement)portNode, new DynamicProperty("accessType", String.class, (Object)"public"), false, true);
        Element annotationElement = this.getElement(element, "annotation");
        if (annotationElement != null && (bioumlElement = this.getElement(annotationElement, "biouml:BIOUML")) != null && (nodeInfoElement = this.getElement(bioumlElement, "biouml:nodeInfo")) != null) {
            DiagramXmlReader.readNodeInfo((Element)nodeInfoElement, (Node)portNode, (String)diagram.getName());
        }
        portNode.save();
    }

    private void addProperty(DiagramElement de, DynamicProperty dp, boolean hidden, boolean readOnly) {
        dp.setHidden(hidden);
        dp.setReadOnly(readOnly);
        de.getAttributes().add(dp);
    }

    @Override
    protected void warn(String key, String[] params) {
        MessageBundle.warn(this.log, key, params);
    }

    @Override
    protected void error(String key, String[] params) {
        MessageBundle.error(this.log, key, params);
    }

    private File getFile(String source) throws Exception {
        String sourceName;
        int index;
        URI sourceURI = URI.create(source);
        if (URIUtil.isFileURI((URI)sourceURI)) {
            return URIUtil.toFile((URI)sourceURI);
        }
        URI currentURI = URI.create(this.document.getBaseURI());
        File currentDir = URIUtil.toFile((URI)currentURI).getParentFile();
        File targetFile = new File(currentDir, sourceURI.getPath());
        if (!targetFile.exists() && (index = (sourceName = sourceURI.getPath()).lastIndexOf(".")) != -1) {
            targetFile = new File(currentDir, sourceName.substring(0, index));
        }
        if (targetFile.exists()) {
            return targetFile;
        }
        throw new Exception("Can not find model by URI " + source);
    }
}

