/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.composite;

import biouml.model.Compartment;
import biouml.model.DiagramViewOptions;
import biouml.model.GlobalViewOptions;
import biouml.model.ModelDefinition;
import biouml.plugins.sbml.SbmlDiagramViewBuilder;
import biouml.plugins.sbml.composite.SbmlCompositeDiagramViewOptions;
import biouml.standard.diagram.CompositeDiagramViewBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import ru.biosoft.graphics.BoxView;
import ru.biosoft.graphics.ComplexTextView;
import ru.biosoft.graphics.CompositeView;
import ru.biosoft.graphics.Pen;
import ru.biosoft.graphics.View;

public class SbmlCompositeDiagramViewBuilder
extends CompositeDiagramViewBuilder {
    public DiagramViewOptions createDefaultDiagramViewOptions() {
        return new SbmlCompositeDiagramViewOptions(null);
    }

    public Icon getIcon(Object type) {
        Icon icon = this.getIcon((Class)type, ((Object)((Object)this)).getClass());
        if (icon == null) {
            icon = this.getIcon((Class)type, SbmlDiagramViewBuilder.class);
        }
        if (icon == null) {
            icon = this.getIcon((Class)type, CompositeDiagramViewBuilder.class);
        }
        return icon;
    }

    public boolean createCompartmentCoreView(CompositeView container, Compartment compartment, DiagramViewOptions options, Graphics g) {
        if ("modelDefinition".equals(compartment.getKernel().getType())) {
            return this.createModelDefinitionView(container, (ModelDefinition)compartment, (SbmlCompositeDiagramViewOptions)options, g);
        }
        return super.createCompartmentCoreView(container, compartment, options, g);
    }

    protected boolean createModelDefinitionView(CompositeView container, ModelDefinition compartment, SbmlCompositeDiagramViewOptions options, Graphics g) {
        String title = compartment.getTitle();
        if (title == null || title.equals("")) {
            title = compartment.getName();
        }
        ComplexTextView titleView = new ComplexTextView(title, options.getCompartmentTitleFont(), options.getFontRegistry(), 15, GlobalViewOptions.getMaxTitleSize(), g);
        Dimension size = compartment.getShapeSize();
        if (size.height == 0 && size.width == 0) {
            size = new Dimension(250, 250);
        }
        Pen pen = new Pen(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f), Color.black);
        BoxView boxView = new BoxView(pen, options.getModelDefBrush(), 0, 0, size.width, size.height);
        container.add((View)boxView);
        container.add((View)titleView, 127);
        container.setModel((Object)compartment);
        container.setActive(true);
        container.setLocation(compartment.getLocation());
        compartment.setView((View)container);
        return false;
    }
}

