/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.celldesigner;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerExtension;
import biouml.plugins.sbml.celldesigner.SpeciesInfo;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import one.util.streamex.StreamEx;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.graph.Path;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.TextUtil;

public class CellDesignerUtils
implements CellDesignerConstants {
    protected static final Logger log = Logger.getLogger(CellDesignerUtils.class.getName());

    public static CellDesignerExtension.DoublePoint getOrthogonalPoint(CellDesignerExtension.DoublePoint p1, CellDesignerExtension.DoublePoint p2) {
        return new CellDesignerExtension.DoublePoint(p1.x - p2.y + p1.y, p1.y + p2.x - p1.x);
    }

    public static CellDesignerExtension.DoublePoint getPointByBase(String pair, CellDesignerExtension.DoublePoint p1, CellDesignerExtension.DoublePoint p2, CellDesignerExtension.DoublePoint p3) {
        String[] vals = TextUtil.split((String)pair, (char)',');
        if (vals.length == 2) {
            try {
                double a = Double.parseDouble(vals[0]);
                double b = Double.parseDouble(vals[1]);
                return new CellDesignerExtension.DoublePoint(a * p2.x + b * p3.x + (1.0 - a - b) * p1.x, a * p2.y + b * p3.y + (1.0 - a - b) * p1.y);
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, "Cannot parse double value", e);
            }
        }
        return new CellDesignerExtension.DoublePoint(0.0, 0.0);
    }

    public static Point getProjection(CellDesignerExtension.DoublePoint p, CellDesignerExtension.DoublePoint p1, CellDesignerExtension.DoublePoint p2) {
        double fDenominator = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        if (fDenominator == 0.0) {
            return new Point((int)p1.x, (int)p1.y);
        }
        double t = (p.x * (p2.x - p1.x) - (p2.x - p1.x) * p1.x + p.y * (p2.y - p1.y) - (p2.y - p1.y) * p1.y) / fDenominator;
        if (t < 0.0 || t > 1.0) {
            return new Point((int)p1.x, (int)p1.y);
        }
        return new Point((int)(p1.x + (p2.x - p1.x) * t), (int)(p1.y + (p2.y - p1.y) * t));
    }

    public static Rectangle getBounds(Node node) {
        Point l = node.getLocation();
        Dimension d = node.getShapeSize();
        return d == null ? new Rectangle(l.x, l.y, 5, 5) : new Rectangle(l.x, l.y, d.width, d.height);
    }

    public static boolean isNodeInComplex(Node base, String name) {
        if (base.getName().equals(name)) {
            return true;
        }
        Object complexes = base.getAttributes().getValue("ComplexElements");
        return complexes != null && StreamEx.of((Object[])((Node[])complexes)).anyMatch(n -> name.equals(n.getName()));
    }

    public static Edge findEdge(Node reaction, Node species, String role) {
        for (Edge e : reaction.getEdges()) {
            if (!(e.getKernel() instanceof SpecieReference) || !((SpecieReference)e.getKernel()).getRole().equals(role) || (e.getInput() != reaction || !CellDesignerUtils.isNodeInComplex(e.getOutput(), species.getName())) && (e.getOutput() != reaction || !CellDesignerUtils.isNodeInComplex(e.getInput(), species.getName()))) continue;
            return e;
        }
        Edge result = null;
        try {
            Reaction reactionKernel = (Reaction)reaction.getKernel();
            SpecieReference ref = new SpecieReference((DataCollection)reactionKernel, reactionKernel.getName(), species.getName(), role);
            String fullName = CellDesignerUtils.getCompleteNameInDiagram((DiagramElement)species);
            ref.setSpecie(fullName);
            ref.setTitle(reaction.getTitle());
            result = role.equals("product") ? new Edge((Base)ref, reaction, species) : new Edge((Base)ref, species, reaction);
            reactionKernel.put(ref);
            result.save();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create edge", e);
        }
        return result;
    }

    public static String getCompleteNameInDiagram(DiagramElement de) {
        String result = de.getName();
        if (!(de instanceof Diagram)) {
            Diagram diagram = Diagram.optDiagram((DiagramElement)de);
            for (DataCollection dc = de.getOrigin(); dc != null && dc != diagram; dc = dc.getOrigin()) {
                result = dc.getName() + "." + result;
            }
        }
        return result;
    }

    public static String getCompleteName(Node node) {
        Object parent;
        if (node.getOrigin() == null && (parent = node.getAttributes().getValue("parent")) instanceof Node) {
            return CellDesignerUtils.getCompleteNameInDiagram((DiagramElement)((Node)parent)) + "." + node.getName();
        }
        return CellDesignerUtils.getCompleteNameInDiagram((DiagramElement)node);
    }

    public static CellDesignerExtension.DoublePoint getNodePort(Node node, float portX, float portY) {
        Object xObj = node.getAttributes().getValue("x");
        Object yObj = node.getAttributes().getValue("y");
        Point location = node.getLocation();
        CellDesignerExtension.DoublePoint result = new CellDesignerExtension.DoublePoint(location.x, location.y);
        double x = xObj == null || !(xObj instanceof Double) ? result.x : (Double)xObj;
        double y = yObj == null || !(yObj instanceof Double) ? result.y : (Double)yObj;
        Dimension d = node.getShapeSize();
        if (d != null) {
            Object wObj = node.getAttributes().getValue("w");
            Object hObj = node.getAttributes().getValue("h");
            double w = wObj == null || !(wObj instanceof Double) ? (double)d.width : (Double)wObj;
            double h = hObj == null || !(hObj instanceof Double) ? (double)d.height : (Double)hObj;
            result.x = x + w / 2.0 + (double)portX * w;
            result.y = y + h / 2.0 + (double)portY * h;
        }
        return result;
    }

    public static CellDesignerExtension.DoublePoint getNodeCenter(Node node) {
        Object xObj = node.getAttributes().getValue("x");
        Object yObj = node.getAttributes().getValue("y");
        Point location = node.getLocation();
        CellDesignerExtension.DoublePoint result = new CellDesignerExtension.DoublePoint(location.x, location.y);
        double x = xObj == null || !(xObj instanceof Double) ? result.x : (Double)xObj;
        double y = yObj == null || !(yObj instanceof Double) ? result.y : (Double)yObj;
        Dimension d = node.getShapeSize();
        if (d != null) {
            Object wObj = node.getAttributes().getValue("w");
            Object hObj = node.getAttributes().getValue("h");
            double w = wObj == null || !(wObj instanceof Double) ? (double)d.width : (Double)wObj;
            double h = hObj == null || !(hObj instanceof Double) ? (double)d.height : (Double)hObj;
            result.x = x + w / 2.0;
            result.y = y + h / 2.0;
        } else {
            result.x += 7.0;
            result.y += 7.0;
        }
        return result;
    }

    public static void curveLine(@Nonnull Diagram diagram, Edge edge, SpeciesInfo baseSpecie, Node specieNode, Node reaction) throws Exception {
        Node baseNode = CellDesignerUtils.findNode(diagram, baseSpecie.getName(), baseSpecie.getAlias());
        if (baseNode != null) {
            CellDesignerExtension.DoublePoint inport = CellDesignerUtils.getNodeCenter(edge.getInput());
            CellDesignerExtension.DoublePoint outport = CellDesignerUtils.getNodeCenter(edge.getOutput());
            CellDesignerExtension.DoublePoint p1 = CellDesignerUtils.getNodeCenter(reaction);
            CellDesignerExtension.DoublePoint p2 = CellDesignerUtils.getNodeCenter(baseNode);
            CellDesignerExtension.DoublePoint p = CellDesignerUtils.getNodeCenter(specieNode);
            Point controlPoint = CellDesignerUtils.getProjection(p, p1, p2);
            Path path = new Path();
            path.addPoint((int)inport.x, (int)inport.y);
            path.addPoint(controlPoint.x, controlPoint.y, 1);
            path.addPoint((int)outport.x, (int)outport.y);
            edge.setPath(path);
        }
    }

    public static Node findNode(@Nonnull Diagram diagram, String name, String alias) {
        Node node = diagram.findNode(name);
        if (node == null) {
            node = CellDesignerUtils.findInComplex((Node)diagram, name, alias);
        }
        return node;
    }

    public static Node findInComplex(Node node, String name, String alias) {
        Object complexes = node.getAttributes().getValue("ComplexElements");
        if (complexes instanceof Node[]) {
            for (Node n : (Node[])complexes) {
                Node inner;
                if (n.getName().equals(name)) {
                    if (alias != null) {
                        Object nAlias = n.getAttributes().getValue("Alias");
                        if (nAlias != null && nAlias.toString().equals(alias)) {
                            return n;
                        }
                    } else {
                        return n;
                    }
                }
                if ((inner = CellDesignerUtils.findInComplex(n, name, alias)) == null) continue;
                return inner;
            }
        }
        if (node instanceof Compartment) {
            for (DiagramElement child : (Compartment)node) {
                Node result;
                if (!(child instanceof Node) || (result = CellDesignerUtils.findInComplex((Node)child, name, alias)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static boolean containsComplexElement(Node parent, String subElement) throws Exception {
        DynamicProperty complexes = parent.getAttributes().getProperty("ComplexElements");
        return complexes != null && StreamEx.of((Object[])((Node[])complexes.getValue())).anyMatch(n -> subElement.equals(n.getName()));
    }

    public static void addProperty(DiagramElement de, DynamicProperty property, boolean processAliases) {
        try {
            de.getAttributes().remove(property.getName());
            de.getAttributes().add(property);
            if (processAliases && de.getAttributes().getValue("NodeAliases") instanceof Node[]) {
                for (Node n : (Node[])de.getAttributes().getValue("NodeAliases")) {
                    n.getAttributes().add(property);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot set attribute: " + property.getName(), e);
        }
    }

    public static void addElementToNodeAttributes(Node parent, Node subElement, String propertyName) throws Exception {
        DynamicProperty props = parent.getAttributes().getProperty(propertyName);
        if (props == null) {
            props = DPSUtils.createTransient((String)propertyName, Node[].class, (Object)new Node[]{subElement});
            parent.getAttributes().add(props);
        } else {
            Node[] oldNodes = (Node[])props.getValue();
            boolean addNew = true;
            for (int i = 0; i < oldNodes.length; ++i) {
                if (!oldNodes[i].getName().equals(subElement.getName())) continue;
                oldNodes[i] = subElement;
                addNew = false;
                break;
            }
            if (addNew) {
                Node[] newNodes = new Node[oldNodes.length + 1];
                System.arraycopy(oldNodes, 0, newNodes, 0, oldNodes.length);
                newNodes[oldNodes.length] = subElement;
                props.setValue((Object)newNodes);
            }
        }
    }

    public static Set<Node> updateAliases(Node node) {
        HashSet<Node> result = new HashSet<Node>();
        Diagram diagram = Diagram.optDiagram((DiagramElement)node);
        if (diagram != null) {
            Set<Node> nodes = CellDesignerUtils.getAllNodes((Node)diagram, node.getName());
            result.addAll(nodes);
            for (Node otherNode : nodes) {
                result.addAll(CellDesignerUtils.getAliases(otherNode).toList());
            }
        }
        result.addAll(CellDesignerUtils.getAliases(node).toList());
        result.add(node);
        return result;
    }

    public static Set<Node> getAllNodes(Node node, String name) {
        HashSet<Node> result = new HashSet<Node>();
        if (node.getName().equals(name)) {
            result.add(node);
        }
        if (node instanceof Compartment) {
            for (Node innerNode : ((Compartment)node).getNodes()) {
                result.addAll(CellDesignerUtils.getAllNodes(innerNode, name));
            }
        }
        for (Node aliasNode : CellDesignerUtils.getAliases(node)) {
            result.addAll(CellDesignerUtils.getAllNodes(aliasNode, name));
        }
        return result;
    }

    public static StreamEx<Node> getAliases(Node node) {
        Object val = node.getAttributes().getValue("NodeAliases");
        if (val instanceof Node[]) {
            return StreamEx.of((Object[])((Node[])val));
        }
        return StreamEx.empty();
    }

    protected static void readClass(Element element, DiagramElement de) {
        Element classElement = SbmlExtensionSupport.getElement(element, "celldesigner:class");
        String result = "undefiend";
        if (classElement != null) {
            String type = SbmlExtensionSupport.getTextContent(classElement);
            try {
                if (type.equals("PROTEIN")) {
                    result = "macromolecule";
                } else if (type.equals("RNA") || type.equals("GENE")) {
                    result = "nucleic acid feature";
                } else if (type.equals("SIMPLE_MOLECULE") || type.equals("ION")) {
                    result = "simple chemical";
                } else {
                    if (type.equals("PHENOTYPE")) {
                        CellDesignerUtils.addProperty(de, new DynamicProperty("xmlElementType", String.class, (Object)"phenotype"), true);
                        return;
                    }
                    if (type.equals("COMPLEX")) {
                        result = "complex";
                    } else if (type.equals("DEGRADED")) {
                        CellDesignerUtils.addProperty(de, new DynamicProperty("xmlElementType", String.class, (Object)"undefiend"), true);
                        return;
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot create type attribute", e);
            }
        }
        if (de instanceof Node) {
            for (Node node : CellDesignerUtils.updateAliases((Node)de)) {
                if (node.getKernel() instanceof Specie) {
                    ((Specie)node.getKernel()).setType(result);
                }
                node.getAttributes().add(new DynamicProperty(SBGNPropertyConstants.SBGN_ENTITY_TYPE_PD, String.class, (Object)result));
            }
        }
    }
}

