/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.celldesigner;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerExtension;
import biouml.plugins.sbml.celldesigner.CellDesignerUtils;
import biouml.plugins.sbml.celldesigner.SpeciesInfo;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.MutableDataElementSupport;
import ru.biosoft.graph.Path;
import ru.biosoft.graphics.Pen;
import ru.biosoft.util.TextUtil;

public class CellDesignerPostProcessor
extends SbmlExtensionSupport
implements CellDesignerConstants {
    protected static final Logger log = Logger.getLogger(CellDesignerUtils.class.getName());
    protected Map<DiagramElement, CellDesignerExtension.ElementSet> unprocessedElements = new HashMap<DiagramElement, CellDesignerExtension.ElementSet>();
    protected CellDesignerExtension.ReactionSpeciesCache reactionSpecieCache = new CellDesignerExtension.ReactionSpeciesCache();
    protected Map<String, Node> complexes = new HashMap<String, Node>();
    protected Element proteinListElement = null;
    protected Map<String, List<Object>> proteinRefs = new HashMap<String, List<Object>>();
    protected Map<String, String> stateValues = new HashMap<String, String>();

    public CellDesignerPostProcessor(CellDesignerExtension extension) {
        this.unprocessedElements = extension.unprocessedElements;
        this.reactionSpecieCache = extension.reactionSpecieCache;
        this.complexes = extension.complexes;
        this.stateValues = extension.stateValues;
        this.proteinListElement = extension.proteinListElement;
        this.proteinRefs = extension.proteinRefs;
    }

    public void processElements(@Nonnull Diagram diagram) {
        for (Map.Entry<DiagramElement, CellDesignerExtension.ElementSet> entry : this.unprocessedElements.entrySet()) {
            this.readSpecieAttr(entry.getValue(), entry.getKey());
        }
        if (this.proteinListElement != null) {
            this.readProteinList(this.proteinListElement, diagram);
        }
    }

    protected void readProteinList(Element element, @Nonnull Diagram diagram) {
        Element listElement = this.getTopElement(element, "celldesigner:listOfProteins");
        if (listElement == null) {
            return;
        }
        NodeList list = listElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            org.w3c.dom.Node node = list.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:protein")) continue;
            String id = ((Element)node).getAttribute("id");
            List<Object> baseNodeList = this.proteinRefs.get(id);
            if (baseNodeList == null) {
                return;
            }
            try {
                for (Object baseNodeObj : baseNodeList) {
                    Node baseNode = baseNodeObj instanceof Node ? (Node)baseNodeObj : CellDesignerUtils.findNode(diagram, (String)baseNodeObj, null);
                    this.fillProteinForNode((Element)node, baseNode);
                    Object nodeAliases = baseNode.getAttributes().getValue("NodeAliases");
                    if (!(nodeAliases instanceof Node[])) continue;
                    for (Node n : (Node[])nodeAliases) {
                        this.fillProteinForNode((Element)node, n);
                    }
                }
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot parse modifications", e);
            }
        }
    }

    protected void fillProteinForNode(Element element, Node baseNode) throws Exception {
        Element modificationList;
        String title = element.getAttribute("name");
        if (title != null && title.trim().length() > 0) {
            baseNode.setTitle(title);
        }
        if ((modificationList = CellDesignerPostProcessor.getElement(element, "celldesigner:listOfModificationResidues")) != null) {
            NodeList childs = modificationList.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                org.w3c.dom.Node mNode = childs.item(j);
                if (!(mNode instanceof Element) || !mNode.getNodeName().equals("celldesigner:modificationResidue")) continue;
                Element modification = (Element)mNode;
                String mID = modification.getAttribute("id");
                String angle = modification.getAttribute("angle");
                if (angle.trim().length() == 0) {
                    angle = "0";
                }
                Compartment parent = null;
                if (baseNode instanceof Compartment) {
                    parent = (Compartment)baseNode;
                }
                Node variable = new Node((DataCollection)parent, (Base)new Stub(null, mID, "variable"));
                variable.getAttributes().add(new DynamicProperty("Angle", String.class, (Object)angle));
                String value = this.stateValues.get(CellDesignerUtils.getCompleteNameInDiagram((DiagramElement)baseNode) + "/" + mID);
                if (value != null) {
                    variable.setTitle(value);
                } else {
                    variable.setTitle("");
                }
                if (parent != null) {
                    ((Compartment)baseNode).put((DiagramElement)variable);
                    continue;
                }
                CellDesignerUtils.addElementToNodeAttributes(baseNode, variable, "ModificationElements");
            }
        }
    }

    protected void readSpecieAttr(CellDesignerExtension.ElementSet elementSet, DiagramElement de) {
        if (de instanceof Node) {
            Element heterodimerElement;
            Element identityElement = elementSet.getElement("celldesigner:speciesIdentity");
            if (identityElement != null) {
                Element stateElement;
                CellDesignerUtils.readClass(identityElement, de);
                Element nameElement = CellDesignerPostProcessor.getElement(identityElement, "celldesigner:name");
                if (nameElement != null) {
                    String title = CellDesignerPostProcessor.getTextContent(nameElement);
                    de.setTitle(title);
                    if (de.getAttributes().getValue("NodeAliases") instanceof Node[]) {
                        for (Node n : (Node[])de.getAttributes().getValue("NodeAliases")) {
                            n.setTitle(title);
                        }
                    }
                }
                if ((stateElement = CellDesignerPostProcessor.getElement(identityElement, "celldesigner:state")) != null) {
                    Element modificationsList;
                    org.w3c.dom.Node node;
                    int i;
                    NodeList list;
                    Element statesList;
                    Element homodimer = CellDesignerPostProcessor.getElement(stateElement, "celldesigner:homodimer");
                    if (homodimer != null) {
                        try {
                            int multimer = Integer.parseInt(CellDesignerPostProcessor.getTextContent(homodimer));
                            if (multimer > 1) {
                                CellDesignerUtils.addProperty(de, new DynamicProperty(SBGNPropertyConstants.SBGN_MULTIMER_PD, Integer.class, (Object)multimer), true);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Cannot parse celldesigner:homodimer field", e);
                        }
                    }
                    if ((statesList = CellDesignerPostProcessor.getElement(stateElement, "celldesigner:listOfStructuralStates")) != null) {
                        StringBuffer states = null;
                        list = statesList.getChildNodes();
                        for (i = 0; i < list.getLength(); ++i) {
                            node = list.item(i);
                            if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:structuralState")) continue;
                            String state = ((Element)node).getAttribute("structuralState");
                            if (states == null) {
                                states = new StringBuffer();
                            } else {
                                states.append(';');
                            }
                            states.append(state);
                        }
                        if (states != null) {
                            CellDesignerUtils.addProperty(de, new DynamicProperty("states", String.class, (Object)states.toString()), true);
                        }
                    }
                    if ((modificationsList = CellDesignerPostProcessor.getElement(stateElement, "celldesigner:listOfModifications")) != null) {
                        list = modificationsList.getChildNodes();
                        for (i = 0; i < list.getLength(); ++i) {
                            node = list.item(i);
                            if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:modification")) continue;
                            String id = ((Element)node).getAttribute("residue");
                            String state = ((Element)node).getAttribute("state");
                            if (state.length() <= 0) continue;
                            if (state.equals("phosphorylated")) {
                                this.stateValues.put(CellDesignerUtils.getCompleteNameInDiagram(de) + "/" + id, "P");
                                continue;
                            }
                            if (!state.equals("ubiquitinated")) continue;
                            this.stateValues.put(CellDesignerUtils.getCompleteNameInDiagram(de) + "/" + id, "Ub");
                        }
                    }
                }
                this.addProteinRef(identityElement, de);
            }
            if ((heterodimerElement = elementSet.getElement("celldesigner:heterodimerIdentity")) != null) {
                try {
                    CellDesignerUtils.addProperty(de, new DynamicProperty("xmlElementType", String.class, (Object)"complex"), true);
                    CellDesignerUtils.addProperty(de, new DynamicProperty("BodyColor", Color.class, (Object)new Color(255, 255, 255, 50)), true);
                    Element heterodimerEntryList = CellDesignerPostProcessor.getElement(heterodimerElement, "celldesigner:listOfHeterodimerEntries");
                    if (heterodimerEntryList != null) {
                        NodeList list = heterodimerEntryList.getChildNodes();
                        for (int i = 0; i < list.getLength(); ++i) {
                            org.w3c.dom.Node n = list.item(i);
                            if (!(n instanceof Element) || !n.getNodeName().equals("celldesigner:heterodimerEntry")) continue;
                            this.readInnerHeterodimer(de, (Element)n);
                            Object nodeAliases = de.getAttributes().getValue("NodeAliases");
                            if (!(nodeAliases instanceof Node[])) continue;
                            for (Node aliasNode : (Node[])nodeAliases) {
                                this.readInnerHeterodimer((DiagramElement)aliasNode, (Element)n);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot parse heterodimer attr", e);
                }
            }
            if (((Node)de).getKernel() instanceof Reaction) {
                Element modificationsElement;
                Pen linePen;
                Diagram diagram = Diagram.getDiagram((DiagramElement)de);
                Node rNode = (Node)de;
                List<SpeciesInfo> reactants = this.getSpeciesList(elementSet, "celldesigner:baseReactants", "celldesigner:baseReactant", rNode.getName(), "reactant");
                List<SpeciesInfo> products = this.getSpeciesList(elementSet, "celldesigner:baseProducts", "celldesigner:baseProduct", rNode.getName(), "product");
                Element typeElement = elementSet.getElement("celldesigner:reactionType");
                if (typeElement != null) {
                    try {
                        String type = CellDesignerPostProcessor.getTextContent(typeElement);
                        CellDesignerUtils.addProperty((DiagramElement)rNode, new DynamicProperty("ReactionType", String.class, (Object)type), true);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Cannot read reaction type", e);
                    }
                }
                try {
                    Edge[] average;
                    Edge[] edges = rNode.getEdges();
                    Element pointsElement = elementSet.getElement("celldesigner:editPoints");
                    if (pointsElement != null) {
                        String[] pointValues = TextUtil.split((String)CellDesignerPostProcessor.getTextContent(pointsElement), (char)' ');
                        if (reactants.size() == 1 && products.size() == 1) {
                            String endBaseName;
                            Node end;
                            String startBaseName = reactants.get(0).getName();
                            Node start = CellDesignerUtils.findNode(diagram, startBaseName, reactants.get(0).getAlias());
                            if (start != null) {
                                start = this.getNodeAlias(start, reactants.get(0).getAlias());
                            }
                            if ((end = CellDesignerUtils.findNode(diagram, endBaseName = products.get(0).getName(), products.get(0).getAlias())) != null) {
                                end = this.getNodeAlias(end, products.get(0).getAlias());
                            }
                            if (start != null && end != null) {
                                int center;
                                SpeciesInfo si1 = reactants.get(0);
                                CellDesignerExtension.DoublePoint p1 = CellDesignerUtils.getNodePort(start, si1.getPortX(), si1.getPortY());
                                SpeciesInfo si2 = products.get(0);
                                CellDesignerExtension.DoublePoint p2 = CellDesignerUtils.getNodePort(end, si2.getPortX(), si2.getPortY());
                                CellDesignerExtension.DoublePoint p3 = CellDesignerUtils.getOrthogonalPoint(p1, p2);
                                CellDesignerExtension.DoublePoint[] points = new CellDesignerExtension.DoublePoint[pointValues.length];
                                for (int i = 0; i < pointValues.length; ++i) {
                                    points[i] = CellDesignerUtils.getPointByBase(pointValues[i], p1, p2, p3);
                                }
                                int n = center = points.length % 2 == 0 ? points.length / 2 : points.length / 2 + 1;
                                if (center == 0) {
                                    rNode.setLocation((int)(points[0].x - 7.0), (int)(points[0].y - 7.0));
                                } else {
                                    CellDesignerExtension.DoublePoint c1 = points[center - 1];
                                    CellDesignerExtension.DoublePoint c2 = center < points.length ? points[center] : p2;
                                    CellDesignerExtension.DoublePoint centerPoint = new CellDesignerExtension.DoublePoint((c1.x + c2.x) / 2.0 - 7.0, (c1.y + c2.y) / 2.0 - 7.0);
                                    rNode.setLocation((int)centerPoint.x, (int)centerPoint.y);
                                    for (Edge edge : rNode.getEdges()) {
                                        int i;
                                        boolean ouput;
                                        boolean input = edge.getInput().getName().equals(startBaseName) || CellDesignerUtils.containsComplexElement(edge.getInput(), startBaseName);
                                        boolean bl = ouput = edge.getOutput().getName().equals(endBaseName) || CellDesignerUtils.containsComplexElement(edge.getOutput(), endBaseName);
                                        if (!input && !ouput) continue;
                                        Point inport = this.getInPort(edge);
                                        Point outport = this.getOutPort(edge);
                                        Path path = new Path();
                                        if (input) {
                                            path.addPoint(inport.x, inport.y);
                                            for (i = 0; i < center; ++i) {
                                                path.addPoint((int)points[i].x, (int)points[i].y);
                                            }
                                            path.addPoint((int)centerPoint.x, (int)centerPoint.y);
                                            CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(start)), false);
                                        }
                                        if (ouput) {
                                            path.addPoint((int)centerPoint.x, (int)centerPoint.y);
                                            for (i = center; i < points.length; ++i) {
                                                path.addPoint((int)points[i].x, (int)points[i].y);
                                            }
                                            path.addPoint(outport.x, outport.y);
                                            CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(end)), false);
                                        }
                                        edge.setPath(path);
                                        diagram.getType().getSemanticController().recalculateEdgePath(edge);
                                    }
                                }
                            }
                        } else if (reactants.size() + products.size() >= 3) {
                            int edgeSegments3;
                            int edgeSegments2;
                            CellDesignerExtension.DoublePoint pt;
                            String[] pairs;
                            int edgeSegments1;
                            Edge edge;
                            Node node;
                            CellDesignerExtension.DoublePoint[] portPoints = new CellDesignerExtension.DoublePoint[3];
                            CellDesignerExtension.DoublePoint[] centerPoints = new CellDesignerExtension.DoublePoint[3];
                            int ind = 0;
                            for (SpeciesInfo si : reactants) {
                                if (ind > 2) break;
                                node = CellDesignerUtils.findNode(diagram, si.getName(), si.getAlias());
                                edge = CellDesignerUtils.findEdge(rNode, node, "reactant");
                                node = this.getNodeAlias(node, si.getAlias());
                                portPoints[ind] = CellDesignerUtils.getNodePort(node, si.getPortX(), si.getPortY());
                                centerPoints[ind++] = CellDesignerUtils.getNodeCenter(node);
                                CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(node)), false);
                            }
                            for (SpeciesInfo si : products) {
                                if (ind > 2) break;
                                node = CellDesignerUtils.findNode(diagram, si.getName(), si.getAlias());
                                edge = CellDesignerUtils.findEdge(rNode, node, "product");
                                node = this.getNodeAlias(node, si.getAlias());
                                portPoints[ind] = CellDesignerUtils.getNodePort(node, si.getPortX(), si.getPortY());
                                centerPoints[ind++] = CellDesignerUtils.getNodeCenter(node);
                                CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(node)), false);
                            }
                            CellDesignerExtension.DoublePoint cp = CellDesignerUtils.getPointByBase(pointValues[pointValues.length - 1], centerPoints[0], centerPoints[1], centerPoints[2]);
                            rNode.setLocation((int)cp.x, (int)cp.y);
                            int currentIdx = 0;
                            String numAttr = pointsElement.getAttribute("num0");
                            if (numAttr != null && numAttr.length() > 0 && (edgeSegments1 = Integer.parseInt(numAttr)) > 0) {
                                pairs = new String[edgeSegments1];
                                for (int i = 0; i < edgeSegments1; ++i) {
                                    pairs[i] = pointValues[currentIdx++];
                                }
                                pt = CellDesignerUtils.getOrthogonalPoint(cp, portPoints[0]);
                                this.fillPath(diagram, rNode, edges[0], pairs, cp, portPoints[0], pt, edges[0].getInput() == rNode);
                            }
                            if ((numAttr = pointsElement.getAttribute("num1")) != null && numAttr.length() > 0 && (edgeSegments2 = Integer.parseInt(numAttr)) > 0) {
                                pairs = new String[edgeSegments2];
                                for (int i = 0; i < edgeSegments2; ++i) {
                                    pairs[i] = pointValues[currentIdx++];
                                }
                                pt = CellDesignerUtils.getOrthogonalPoint(cp, portPoints[1]);
                                this.fillPath(diagram, rNode, edges[1], pairs, cp, portPoints[1], pt, edges[1].getInput() == rNode);
                            }
                            if ((numAttr = pointsElement.getAttribute("num2")) != null && numAttr.length() > 0 && (edgeSegments3 = Integer.parseInt(numAttr)) > 0) {
                                pairs = new String[edgeSegments3];
                                for (int i = 0; i < edgeSegments3; ++i) {
                                    pairs[i] = pointValues[currentIdx++];
                                }
                                pt = CellDesignerUtils.getOrthogonalPoint(cp, portPoints[2]);
                                this.fillPath(diagram, rNode, edges[2], pairs, cp, portPoints[2], pt, edges[2].getInput() == rNode);
                            }
                        }
                    } else {
                        CellDesignerExtension.DoublePoint p;
                        Edge edge;
                        String completeName;
                        Node node;
                        average = new CellDesignerExtension.DoublePoint(0.0, 0.0);
                        int count = 0;
                        for (SpeciesInfo si : reactants) {
                            node = CellDesignerUtils.findNode(diagram, si.getName(), si.getAlias());
                            completeName = CellDesignerUtils.getCompleteName(node);
                            edge = CellDesignerUtils.findEdge(rNode, node, "reactant");
                            if ((node = this.getNodeAlias(node, si.getAlias())) != null) {
                                completeName = CellDesignerUtils.getCompleteName(node);
                                p = CellDesignerUtils.getNodePort(node, si.getPortX(), si.getPortY());
                                average.x += p.x;
                                average.y += p.y;
                                ++count;
                            }
                            CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)completeName), false);
                        }
                        for (SpeciesInfo si : products) {
                            node = CellDesignerUtils.findNode(diagram, si.getName(), si.getAlias());
                            completeName = CellDesignerUtils.getCompleteName(node);
                            edge = CellDesignerUtils.findEdge(rNode, node, "product");
                            if ((node = this.getNodeAlias(node, si.getAlias())) != null) {
                                completeName = CellDesignerUtils.getCompleteName(node);
                                p = CellDesignerUtils.getNodePort(node, si.getPortX(), si.getPortY());
                                average.x += p.x;
                                average.y += p.y;
                                ++count;
                            }
                            CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)completeName), false);
                        }
                        if (count != 0) {
                            average.x = average.x / (double)count - 7.0;
                            average.y = average.y / (double)count - 7.0;
                            rNode.setLocation((int)average.x, (int)average.y);
                        }
                    }
                    average = edges;
                    int count = average.length;
                    for (int centerPoints = 0; centerPoints < count; ++centerPoints) {
                        Edge edge = average[centerPoints];
                        if (!(edge.getKernel() instanceof SpecieReference) || ((SpecieReference)edge.getKernel()).getRole().equals("product")) continue;
                        edge.getAttributes().add(new DynamicProperty("text", String.class, (Object)rNode.getName()));
                    }
                    CellDesignerUtils.addProperty((DiagramElement)rNode, new DynamicProperty("Alias", String.class, (Object)rNode.getName()), false);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot calculate edge path", e);
                }
                Element lineElement = elementSet.getElement("celldesigner:line");
                if (lineElement != null && (linePen = this.readLinePen(lineElement)) != null) {
                    try {
                        for (Edge edge : ((Node)de).getEdges()) {
                            edge.setPredefinedStyle("Not selected");
                            edge.getCustomStyle().setPen(linePen.clone());
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Parse line brush error", e);
                    }
                }
                if ((modificationsElement = elementSet.getElement("celldesigner:listOfModification")) != null) {
                    NodeList list = modificationsElement.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        org.w3c.dom.Node node = list.item(i);
                        if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:modification")) continue;
                        this.readModification((Node)de, (Element)node, diagram);
                    }
                }
                if (reactants.size() > 0) {
                    this.parseReactionLinks(elementSet, (Node)de, "celldesigner:listOfReactantLinks", "celldesigner:reactantLink", "reactant", diagram, reactants.get(0), "reactant");
                }
                if (products.size() > 0) {
                    this.parseReactionLinks(elementSet, (Node)de, "celldesigner:listOfProductLinks", "celldesigner:productLink", "product", diagram, products.get(0), "product");
                }
            }
        }
    }

    protected void readModification(Node reaction, Element element, @Nonnull Diagram diagram) {
        SpeciesInfo si = null;
        Element specieInfoElement = CellDesignerPostProcessor.getElement(element, "celldesigner:linkTarget");
        if (specieInfoElement != null) {
            si = this.getSpeciesInfo(specieInfoElement);
        } else {
            String id = element.getAttribute("modifiers");
            String alias = element.getAttribute("aliases");
            if (id.length() > 0 && alias.length() > 0) {
                si = new SpeciesInfo(id, alias);
            }
        }
        if (si != null) {
            try {
                String type = element.getAttribute("type");
                Node node = CellDesignerUtils.findNode(diagram, si.getName(), si.getAlias());
                if (node == null) {
                    throw new Exception("Can not find node '" + si.getName() + "' in diagram " + diagram.getName());
                }
                Edge edge = CellDesignerUtils.findEdge(reaction, node, "modifier");
                if ((node = this.getNodeAlias(node, si.getAlias())) != null && edge != null) {
                    String editPoints;
                    if (type.equals("INHIBITION")) {
                        CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty(SBGNPropertyConstants.SBGN_EDGE_TYPE_PD, String.class, (Object)"inhibition"), false);
                    }
                    if ((editPoints = element.getAttribute("editPoints")) != null && editPoints.length() > 0) {
                        String[] pointValues = TextUtil.split((String)editPoints, (char)' ');
                        CellDesignerExtension.DoublePoint p1 = CellDesignerUtils.getNodePort(node, si.getPortX(), si.getPortY());
                        CellDesignerExtension.DoublePoint cp = CellDesignerUtils.getNodeCenter(reaction);
                        CellDesignerExtension.DoublePoint p3 = CellDesignerUtils.getOrthogonalPoint(p1, cp);
                        this.fillPath(diagram, node, edge, pointValues, p1, cp, p3, true);
                    }
                    CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(node)), false);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot parse modification info", e);
            }
        }
    }

    protected void parseReactionLinks(CellDesignerExtension.ElementSet elementSet, Node de, String listTag, String elementTag, String elementIdAttr, @Nonnull Diagram diagram, SpeciesInfo baseSpecie, String role) {
        Element elements = elementSet.getElement(listTag);
        if (elements != null) {
            NodeList list = elements.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                org.w3c.dom.Node node = list.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equals(elementTag)) continue;
                String id = ((Element)node).getAttribute(elementIdAttr);
                String alias = ((Element)node).getAttribute("alias");
                for (Edge edge : de.getEdges()) {
                    if (!(edge.getKernel() instanceof SpecieReference) || !((SpecieReference)edge.getKernel()).getRole().equals(role) || !edge.nodes().map(MutableDataElementSupport::getName).has((Object)id)) continue;
                    try {
                        Node specieNode = CellDesignerUtils.findNode(diagram, id, alias);
                        specieNode = this.getNodeAlias(specieNode, alias);
                        CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("SpecieName", String.class, (Object)CellDesignerUtils.getCompleteName(specieNode)), false);
                        if (Util.isReaction((DiagramElement)edge.getOutput())) {
                            edge.setInput(specieNode);
                        } else {
                            edge.setOutput(specieNode);
                        }
                        Element lineElement = CellDesignerPostProcessor.getElement((Element)node, "celldesigner:line");
                        if (lineElement != null) {
                            CellDesignerUtils.curveLine(diagram, edge, baseSpecie, specieNode, de);
                            Pen linePen = this.readLinePen(lineElement);
                            edge.getCustomStyle().setPen(linePen.clone());
                            CellDesignerUtils.addProperty((DiagramElement)edge, new DynamicProperty("linePen", Pen.class, (Object)linePen), false);
                            if (!lineElement.getAttribute("type").equals("Curve")) continue;
                            CellDesignerUtils.curveLine(diagram, edge, baseSpecie, specieNode, de);
                            continue;
                        }
                        CellDesignerUtils.curveLine(diagram, edge, baseSpecie, specieNode, de);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can not load edge line properties", e);
                    }
                }
            }
        }
    }

    protected void fillPath(Diagram diagram, Node center, Edge edge, String[] pairs, CellDesignerExtension.DoublePoint p1, CellDesignerExtension.DoublePoint p2, CellDesignerExtension.DoublePoint p3, boolean direct) {
        Path path = new Path();
        Point inport = this.getInPort(edge);
        Rectangle inputBounds = CellDesignerUtils.getBounds(edge.getInput());
        Point outport = this.getOutPort(edge);
        Rectangle outputBounds = CellDesignerUtils.getBounds(edge.getOutput());
        boolean addAll = false;
        if (direct) {
            path.addPoint(inport.x, inport.y);
            for (String pair : pairs) {
                CellDesignerExtension.DoublePoint p = CellDesignerUtils.getPointByBase(pair, p1, p2, p3);
                if (outputBounds.contains((int)p.x, (int)p.y)) break;
                if (!addAll && inputBounds.contains((int)p.x, (int)p.y)) continue;
                path.addPoint((int)p.x, (int)p.y);
                addAll = true;
            }
            path.addPoint(outport.x, outport.y);
        } else {
            path.addPoint(outport.x, outport.y);
            for (int i = pairs.length - 1; i >= 0; --i) {
                CellDesignerExtension.DoublePoint p = CellDesignerUtils.getPointByBase(pairs[i], p1, p2, p3);
                if (inputBounds.contains((int)p.x, (int)p.y)) break;
                if (!addAll && outputBounds.contains((int)p.x, (int)p.y)) continue;
                path.addPoint((int)p.x, (int)p.y);
                addAll = true;
            }
            path.addPoint(inport.x, inport.y);
        }
        edge.setPath(path);
        diagram.getType().getSemanticController().recalculateEdgePath(edge);
    }

    protected List<SpeciesInfo> getSpeciesList(CellDesignerExtension.ElementSet elementSet, String listTag, String elementTag, String reactionName, String role) {
        ArrayList<SpeciesInfo> result;
        block5: {
            result = new ArrayList<SpeciesInfo>();
            Element elements = elementSet.getElement(listTag);
            if (elements == null) break block5;
            String textContent = CellDesignerPostProcessor.getTextContent(elements);
            if (textContent != null && textContent.trim().length() > 0) {
                String[] names;
                for (String name : names = TextUtil.split((String)textContent, (char)',')) {
                    Element aliasElement;
                    CellDesignerExtension.ElementSet specieElement;
                    String specieName = name.trim();
                    String alias = null;
                    Edge edge = this.reactionSpecieCache.getEdge(reactionName, specieName, role);
                    if (edge != null && (specieElement = this.unprocessedElements.get(edge)) != null && (aliasElement = specieElement.getElement("celldesigner:alias")) != null) {
                        alias = CellDesignerPostProcessor.getTextContent(aliasElement).trim();
                    }
                    SpeciesInfo si = new SpeciesInfo(specieName, alias);
                    result.add(si);
                }
            } else {
                NodeList list = elements.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    org.w3c.dom.Node node = list.item(i);
                    if (!(node instanceof Element) || !node.getNodeName().equals(elementTag)) continue;
                    result.add(this.getSpeciesInfo((Element)node));
                }
            }
        }
        return result;
    }

    protected SpeciesInfo getSpeciesInfo(Element element) {
        SpeciesInfo si = new SpeciesInfo(element.getAttribute("species"), element.getAttribute("alias"));
        Element anchor = CellDesignerPostProcessor.getElement(element, "celldesigner:linkAnchor");
        if (anchor != null) {
            si.setPort(anchor.getAttribute("position"));
        }
        return si;
    }

    protected Node getNodeAlias(Node node, String alias) {
        Compartment parent;
        Object compartmentAliases;
        if (alias == null) {
            return node;
        }
        Object nodeAlias = node.getAttributes().getValue("Alias");
        if (nodeAlias != null && nodeAlias.toString().equals(alias)) {
            return node;
        }
        Object nodeAliases = node.getAttributes().getValue("NodeAliases");
        if (nodeAliases instanceof Node[]) {
            for (Node n : (Node[])nodeAliases) {
                nodeAlias = n.getAttributes().getValue("Alias");
                if (nodeAlias == null || !nodeAlias.toString().equals(alias)) continue;
                return n;
            }
        }
        if ((compartmentAliases = (parent = (Compartment)node.getOrigin()).getAttributes().getValue("NodeAliases")) instanceof Node[]) {
            for (Node n : (Node[])compartmentAliases) {
                try {
                    Node n2 = (Node)((Compartment)n).get(node.getName());
                    nodeAlias = n2.getAttributes().getValue("Alias");
                    if (nodeAlias != null && nodeAlias.toString().equals(alias)) {
                        return n2;
                    }
                    Object node2Aliases = n2.getAttributes().getValue("NodeAliases");
                    if (!(node2Aliases instanceof Node[])) continue;
                    for (Node n3 : (Node[])node2Aliases) {
                        nodeAlias = n3.getAttributes().getValue("Alias");
                        if (nodeAlias == null || !nodeAlias.toString().equals(alias)) continue;
                        return n3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected Point getInPort(Edge edge) {
        return edge.getInPort() != null ? edge.getInPort() : new Point();
    }

    protected Point getOutPort(Edge edge) {
        return edge.getOutPort() != null ? edge.getOutPort() : new Point();
    }

    protected Pen readLinePen(Element element) {
        Pen linePen = null;
        float width = (float)Double.parseDouble(element.getAttribute("width"));
        String colorStr = element.getAttribute("color");
        if (colorStr.length() >= 6) {
            int l = colorStr.length();
            colorStr = colorStr.substring(l - 6, l);
            Color color = new Color(Integer.parseInt(colorStr, 16));
            linePen = new Pen(width, color);
        }
        return linePen;
    }

    protected void readInnerHeterodimer(DiagramElement de, Element inner) {
        String innerName = inner.getAttribute("innerId");
        Node childNode = CellDesignerUtils.findInComplex((Node)de, innerName, null);
        Element nameElement = CellDesignerPostProcessor.getElement(inner, "celldesigner:name");
        if (nameElement != null) {
            childNode.setTitle(CellDesignerPostProcessor.getTextContent(nameElement));
        }
        CellDesignerUtils.readClass(inner, (DiagramElement)childNode);
        this.addProteinRef(inner, childNode);
    }

    protected void addProteinRef(Element speciesIdentity, Object node) {
        Element prElement = CellDesignerPostProcessor.getElement(speciesIdentity, "celldesigner:proteinReference");
        if (prElement != null) {
            String pr = CellDesignerPostProcessor.getTextContent(prElement);
            List<Object> list = this.proteinRefs.get(pr);
            if (list == null) {
                list = new ArrayList<Object>();
                this.proteinRefs.put(pr, list);
            }
            list.add(node);
        }
    }

    public Element getTopElement(Element element, String name) {
        if (element.getNodeName().equals(name)) {
            return element;
        }
        return CellDesignerPostProcessor.getElement(element, name);
    }

    @Override
    public void readElement(Element element, DiagramElement specie, Diagram diagram) {
    }

    @Override
    public Element[] writeElement(DiagramElement specie, Document document) {
        return null;
    }
}

