/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.celldesigner;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramViewBuilder;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.SemanticController;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbgn.SbgnSemanticController;
import biouml.plugins.sbml.SbmlImporter;
import biouml.plugins.sbml.SbmlModelFactory;
import biouml.plugins.sbml.SbmlModelReader;
import biouml.plugins.sbml.celldesigner.CellDesignerExtension;
import biouml.plugins.sbml.celldesigner.CellDesignerPostProcessor;
import biouml.plugins.sbml.converters.SBGNConverterNew;
import biouml.standard.diagram.Util;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.application.ApplicationUtils;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graph.Path;

public class CellDesignerImporter
extends SbmlImporter {
    protected static final Logger log = Logger.getLogger(CellDesignerImporter.class.getName());

    @Override
    protected int getAcceptPriority() {
        return 20;
    }

    @Override
    public int accept(File file) {
        try {
            String header = ApplicationUtils.readAsString((File)file, (int)2000);
            int iXml = header.indexOf("<?xml");
            if (iXml == -1) {
                return 0;
            }
            if (!header.substring(iXml, iXml + 100 > header.length() ? header.length() : iXml + 100).matches("(\\s)*<\\?xml(\\s)*version(\\s)*=(.|\\s)*")) {
                return 0;
            }
            int start = header.indexOf("<sbml");
            int end = header.indexOf(">", start);
            if (start == -1 || end == -1) {
                return 0;
            }
            int isCellDesigner = header.indexOf("<celldesigner:");
            if (isCellDesigner == -1) {
                return 0;
            }
            String str = header.substring(start, end);
            if (SbmlImporter.checkSBMLVersion(str, log)) {
                return this.getAcceptPriority();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "accept error :", t);
        }
        return 0;
    }

    protected DataElement doImport(DataCollection origin, File file, String diagramName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        SbmlModelReader reader = SbmlModelFactory.getReader(document);
        CellDesignerExtension extension = new CellDesignerExtension();
        reader.addExtension("celldesigner", extension);
        reader.setShouldLayout(false);
        Diagram diagram = reader.read(document, diagramName, origin);
        diagram.getViewOptions().setAutoLayout(false);
        CellDesignerPostProcessor processor = new CellDesignerPostProcessor(extension);
        processor.processElements(diagram);
        this.correctCompartmentSize((Compartment)diagram);
        this.processCloseup((Compartment)diagram);
        this.processTitles((Compartment)diagram);
        SBGNConverterNew converter = new SBGNConverterNew();
        Diagram sbgnDiagram = converter.convert(diagram, null);
        sbgnDiagram.getAttributes().add(new DynamicProperty("baseDiagramType", String.class, (Object)diagram.getType().getClass().getName()));
        this.fixNodes(sbgnDiagram);
        this.fixEdges(sbgnDiagram);
        this.fixSpecieReference(sbgnDiagram);
        this.fixClones(sbgnDiagram);
        origin.put((DataElement)sbgnDiagram);
        return sbgnDiagram;
    }

    @Override
    public SbmlImporter.SbmlImportProperties getProperties(DataCollection parent, File file, String elementName) {
        return null;
    }

    protected void fixSpecieReference(Diagram diagram) {
        for (Edge e2 : (StreamEx)diagram.recursiveStream().select(Edge.class).filter(e -> Util.isSpecieReference((DiagramElement)e))) {
            Node specieNode = Util.isReaction((DiagramElement)e2.getInput()) ? e2.getOutput() : e2.getInput();
            String specieName = specieNode.getCompleteNameInDiagram();
            ((SpecieReference)e2.getKernel()).setSpecie(specieName);
        }
    }

    protected void fixClones(Diagram diagram) {
        Map clones = new HashMap<String, Set>();
        for (Node n2 : (StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> n.getRole() instanceof VariableRole && n.getKernel() instanceof Specie)) {
            clones.computeIfAbsent(((VariableRole)n2.getRole()).getName(), k -> new HashSet()).add(n2);
        }
        clones = ((StreamEx)StreamEx.of(clones.entrySet()).filter(e -> ((Set)e.getValue()).size() > 1)).toMap(e -> (String)e.getKey(), e -> (Set)e.getValue());
        for (Map.Entry entry : StreamEx.of(clones.entrySet())) {
            HashSet<Node> activeNodes = new HashSet<Node>();
            for (Node node : (Set)entry.getValue()) {
                if (!CellDesignerImporter.isActive(node)) continue;
                activeNodes.add(node);
            }
            if (activeNodes.isEmpty() || activeNodes.size() == ((Set)entry.getValue()).size()) continue;
            ((Set)entry.getValue()).removeAll(activeNodes);
        }
        EModel emodel = (EModel)diagram.getRole(EModel.class);
        for (Map.Entry entry : StreamEx.of(clones.entrySet())) {
            Node mainNode = (Node)((Set)entry.getValue()).iterator().next();
            VariableRole role = (VariableRole)mainNode.getRole(VariableRole.class);
            emodel.getVariableRoles().put((DataElement)role);
            for (Node n3 : (Set)entry.getValue()) {
                n3.setRole(mainNode.getRole());
                SbgnSemanticController.setCloneMarker((Node)n3, (String)mainNode.getTitle());
            }
        }
    }

    public static boolean isActive(Node node) {
        if (!(node instanceof Compartment)) {
            return false;
        }
        for (Node innerNode : ((Compartment)node).recursiveStream().select(Node.class)) {
            if (!"variable".equals(innerNode.getKernel().getType())) continue;
            return true;
        }
        return false;
    }

    protected void fixNodes(Diagram diagram) {
        DiagramViewBuilder viewBuilder = diagram.getType().getDiagramViewBuilder();
        for (Node n : diagram.recursiveStream().select(Node.class)) {
            try {
                if (!n.getAttributes().hasProperty("x")) continue;
                double x = Double.parseDouble(n.getAttributes().getValueAsString("x"));
                double y = Double.parseDouble(n.getAttributes().getValueAsString("y"));
                double h = Double.parseDouble(n.getAttributes().getValueAsString("h"));
                double w = Double.parseDouble(n.getAttributes().getValueAsString("w"));
                double centerX = x + w / 2.0;
                double centerY = y + h / 2.0;
                Rectangle rec = viewBuilder.getNodeBounds(n);
                double actualH = rec.getHeight();
                double actualW = rec.getWidth();
                double newLocationX = centerX - actualW / 2.0;
                double newLocationY = centerY - actualH / 2.0;
                n.setLocation((int)newLocationX, (int)newLocationY);
            }
            catch (Exception exception) {}
        }
    }

    protected void fixEdges(Diagram diagram) {
        DiagramViewBuilder viewBuilder = diagram.getType().getDiagramViewBuilder();
        SemanticController semanticController = diagram.getType().getSemanticController();
        for (Edge e : diagram.recursiveStream().select(Edge.class)) {
            if (e.getPath() == null) {
                semanticController.recalculateEdgePath(e);
                continue;
            }
            Point in = new Point();
            Point out = new Point();
            viewBuilder.calculateInOut(e, in, out);
            Path path = e.getPath();
            path.xpoints[0] = in.x;
            path.ypoints[0] = in.y;
            path.xpoints[path.npoints - 1] = out.x;
            path.ypoints[path.npoints - 1] = out.y;
            e.setPath(path);
        }
    }

    protected void correctCompartmentSize(Compartment compartment) throws Exception {
        Point oldLocation = compartment.getLocation();
        Dimension size = compartment.getShapeSize();
        boolean changeSize = false;
        for (DiagramElement de : compartment) {
            Object fixed;
            if (de instanceof Compartment) {
                this.correctCompartmentSize((Compartment)de);
            }
            if ((fixed = compartment.getAttributes().getValue("fixedSize")) != null && (!(fixed instanceof Boolean) || ((Boolean)fixed).booleanValue()) || !(de instanceof Node)) continue;
            Point location = ((Node)de).getLocation();
            Dimension dimension = ((Node)de).getShapeSize();
            if (location == null || dimension == null) continue;
            if (location.x + dimension.width > oldLocation.x + size.width) {
                size.width = location.x + dimension.width - oldLocation.x;
                changeSize = true;
            }
            if (location.y + dimension.height <= oldLocation.y + size.height) continue;
            size.height = location.y + dimension.height - oldLocation.y;
            changeSize = true;
        }
        if (changeSize) {
            compartment.setShapeSize(new Dimension(size.width + 20, size.height + 20));
        }
    }

    protected void processCloseup(Compartment comp) throws Exception {
        Object type = comp.getAttributes().getValue("closeup");
        if (type instanceof String) {
            DataCollection parent = comp.getOrigin();
            if (!(parent instanceof Compartment)) {
                return;
            }
            comp.setShapeSize(new Dimension(0, 0));
            Point parentLocation = ((Compartment)parent).getLocation();
            Dimension parentSize = ((Compartment)parent).getShapeSize();
            if (type.equals("NORTH")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 1);
                this.resizeToBorder(comp, parentLocation, parentSize, 2);
                this.resizeToBorder(comp, parentLocation, parentSize, 3);
            } else if (type.equals("EAST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 0);
                this.resizeToBorder(comp, parentLocation, parentSize, 2);
                this.resizeToBorder(comp, parentLocation, parentSize, 3);
            } else if (type.equals("WEST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 0);
                this.resizeToBorder(comp, parentLocation, parentSize, 1);
                this.resizeToBorder(comp, parentLocation, parentSize, 2);
            } else if (type.equals("SOUTH")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 0);
                this.resizeToBorder(comp, parentLocation, parentSize, 1);
                this.resizeToBorder(comp, parentLocation, parentSize, 3);
            } else if (type.equals("NORTHWEST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 1);
                this.resizeToBorder(comp, parentLocation, parentSize, 2);
            } else if (type.equals("NORTHEAST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 2);
                this.resizeToBorder(comp, parentLocation, parentSize, 3);
            } else if (type.equals("SOUTHEAST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 3);
                this.resizeToBorder(comp, parentLocation, parentSize, 0);
            } else if (type.equals("SOUTHWEST")) {
                this.resizeToBorder(comp, parentLocation, parentSize, 0);
                this.resizeToBorder(comp, parentLocation, parentSize, 1);
            }
        }
        for (DiagramElement de : comp) {
            if (!(de instanceof Compartment)) continue;
            this.processCloseup((Compartment)de);
        }
    }

    protected void resizeToBorder(Compartment comp, Point parentLocation, Dimension parentSize, int type) {
        Point oldLocation = comp.getLocation();
        Dimension d = comp.getShapeSize();
        if (type == 0) {
            comp.setLocation(oldLocation.x, parentLocation.y);
            comp.setShapeSize(new Dimension(d.width, d.height + oldLocation.y - parentLocation.y));
        } else if (type == 1) {
            comp.setShapeSize(new Dimension(parentLocation.x + parentSize.width - oldLocation.x, d.height));
        } else if (type == 2) {
            comp.setShapeSize(new Dimension(d.width, parentLocation.y + parentSize.height - oldLocation.y));
        } else if (type == 3) {
            comp.setLocation(parentLocation.x, oldLocation.y);
            comp.setShapeSize(new Dimension(d.width + oldLocation.x - parentLocation.x, d.height));
        }
    }

    protected void processTitles(Compartment compartment) throws Exception {
        for (DiagramElement de : compartment) {
            this.fixNodeTitle(de);
            Object aliases = de.getAttributes().getValue("NodeAliases");
            if (aliases instanceof Node[]) {
                for (Node node : (Node[])aliases) {
                    this.fixNodeTitle((DiagramElement)node);
                }
            }
            if (!(de instanceof Compartment)) continue;
            this.processTitles((Compartment)de);
        }
    }

    protected void fixNodeTitle(DiagramElement de) {
        this.fixTitle(de);
        Object complexElements = de.getAttributes().getValue("ComplexElements");
        if (complexElements instanceof Node[]) {
            for (Node n : (Node[])complexElements) {
                this.fixTitle((DiagramElement)n);
            }
        }
    }

    protected void fixTitle(DiagramElement de) {
        String title = de.getTitle();
        title = title.replaceAll("_super_", "<sup>");
        title = title.replaceAll("_endsuper_", "</sup>");
        title = title.replaceAll("_endsuper", "</sup>");
        title = title.replaceAll("_sub_", "<sub>");
        title = title.replaceAll("_endsub_", "</sub>");
        title = title.replaceAll("_endsub", "</sub>");
        title = title.replaceAll("_plus_", "+");
        title = title.replaceAll("_minus_", "-");
        title = title.replaceAll("_br_", "<br>");
        title = title.replaceAll("_slash_", "/");
        title = title.replaceAll("_alpha_", "&alpha;");
        title = title.replaceAll("_beta_", "&beta;");
        title = title.replaceAll("_gamma_", "&gamma;");
        title = title.replaceAll("_delta_", "&delta;");
        de.setTitle(title);
    }

    protected void removeNotUsedElements(Compartment compartment) throws Exception {
        List names = compartment.names().collect(Collectors.toList());
        for (String cName : names) {
            Object nodeAlias;
            Object aliases;
            DiagramElement de = compartment.get(cName);
            if (de instanceof Compartment) {
                this.removeNotUsedElements((Compartment)de);
            }
            if ((aliases = de.getAttributes().getValue("NodeAliases")) instanceof Node[]) {
                for (Node node : (Node[])aliases) {
                    if (!(node instanceof Compartment)) continue;
                    this.removeNotUsedElements((Compartment)node);
                }
            }
            if (cName.equals("default") || !(de instanceof Node) || (nodeAlias = ((Node)de).getAttributes().getValue("Alias")) != null) continue;
            compartment.remove(cName);
        }
    }
}

