/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml.celldesigner;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.Role;
import biouml.plugins.sbgn.SBGNPropertyConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerConstants;
import biouml.plugins.sbml.celldesigner.CellDesignerUtils;
import biouml.plugins.sbml.extensions.SbmlExtensionSupport;
import biouml.standard.type.Base;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.graphics.Brush;
import ru.biosoft.graphics.Pen;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.XmlUtil;

public class CellDesignerExtension
extends SbmlExtensionSupport
implements CellDesignerConstants {
    protected static final Logger log = Logger.getLogger(CellDesignerExtension.class.getName());
    protected Map<DiagramElement, ElementSet> unprocessedElements = new HashMap<DiagramElement, ElementSet>();
    protected ReactionSpeciesCache reactionSpecieCache = new ReactionSpeciesCache();
    protected Map<String, Node> complexes = new HashMap<String, Node>();
    protected Element proteinListElement = null;
    protected Map<String, List<Object>> proteinRefs = new HashMap<String, List<Object>>();
    protected Map<String, String> stateValues = new HashMap<String, String>();

    @Override
    public void readElement(Element element, DiagramElement specie, @Nonnull Diagram diagram) {
        if (specie == diagram) {
            this.readIncludedSpecies(element, diagram);
            this.readCompartmentAliases(element, diagram);
            this.readComplexAliases(element, diagram);
            this.readSpecieAliases(element, diagram);
            Element listOfProteins = this.getTopElement(element, "celldesigner:listOfProteins");
            if (listOfProteins != null) {
                this.proteinListElement = listOfProteins;
            }
        } else {
            ElementSet elementSet = this.unprocessedElements.get(specie);
            if (elementSet == null) {
                elementSet = new ElementSet();
                this.unprocessedElements.put(specie, elementSet);
            }
            elementSet.addElement(element);
            if (specie instanceof Edge) {
                this.reactionSpecieCache.addEdge((Edge)specie);
            }
        }
    }

    @Override
    public Element[] writeElement(DiagramElement specie, Document document) {
        return null;
    }

    protected void readCompartmentAliases(Element element, @Nonnull Diagram diagram) {
        Element listElement = this.getTopElement(element, "celldesigner:listOfCompartmentAliases");
        if (listElement == null) {
            return;
        }
        for (Element node : XmlUtil.elements((Element)listElement)) {
            if (!node.getNodeName().equals("celldesigner:compartmentAlias")) continue;
            String id = node.getAttribute("compartment");
            this.readAlias(node, diagram, id, node.getAttribute("id"), null, null);
            this.readCompartmentType(node, diagram, id);
        }
    }

    protected void readComplexAliases(Element element, @Nonnull Diagram diagram) {
        Element listElement = this.getTopElement(element, "celldesigner:listOfComplexSpeciesAliases");
        if (listElement == null) {
            return;
        }
        for (Element node : XmlUtil.elements((Element)listElement, (String)"celldesigner:complexSpeciesAlias")) {
            Node specieNode;
            String complexID = node.getAttribute("id");
            String id = node.getAttribute("species");
            String compartmentID = node.getAttribute("compartmentAlias");
            if (compartmentID.isEmpty()) {
                compartmentID = null;
            }
            if ((specieNode = this.readAlias(node, diagram, id, complexID, null, compartmentID)) == null) continue;
            this.complexes.put(complexID, specieNode);
        }
    }

    protected void readIncludedSpecies(Element element, @Nonnull Diagram diagram) {
        Element listElement = this.getTopElement(element, "celldesigner:listOfIncludedSpecies");
        if (listElement == null) {
            return;
        }
        NodeList list = listElement.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element complex;
            org.w3c.dom.Node node = list.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:species")) continue;
            String name = ((Element)node).getAttribute("id");
            String title = ((Element)node).getAttribute("name");
            Element annotation = CellDesignerExtension.getElement((Element)node, "celldesigner:annotation");
            if (annotation == null || (complex = CellDesignerExtension.getElement(annotation, "celldesigner:complexSpecies")) == null) continue;
            try {
                String complexId = CellDesignerExtension.getTextContent(complex);
                Node parent = CellDesignerUtils.findNode(diagram, complexId, null);
                Compartment child = new Compartment(null, (Base)new Specie(null, name, "macromolecule"));
                child.setTitle(title);
                Element identity = CellDesignerExtension.getElement(annotation, "celldesigner:speciesIdentity");
                if (identity != null) {
                    CellDesignerUtils.readClass(identity, (DiagramElement)child);
                }
                this.addComplexElement(parent, (Node)child);
                Element speciesIdentity = CellDesignerExtension.getElement(annotation, "celldesigner:speciesIdentity");
                if (speciesIdentity == null) continue;
                this.addProteinRef(speciesIdentity, name);
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot add complex subelement", e);
            }
        }
    }

    protected void readSpecieAliases(Element element, @Nonnull Diagram diagram) {
        Element listElement = this.getTopElement(element, "celldesigner:listOfSpeciesAliases");
        if (listElement != null) {
            NodeList list = listElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                org.w3c.dom.Node node = list.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equals("celldesigner:speciesAlias")) continue;
                String speciesAttr = ((Element)node).getAttribute("species");
                String alias = ((Element)node).getAttribute("id");
                String complexID = ((Element)node).getAttribute("complexSpeciesAlias");
                if (!complexID.isEmpty()) {
                    if (this.complexes.containsKey(complexID)) {
                        try {
                            Node parent = this.complexes.get(complexID);
                            if (!CellDesignerUtils.containsComplexElement(parent, speciesAttr)) {
                                Compartment child = new Compartment(null, (Base)new Specie(null, speciesAttr, "macromolecule"));
                                CellDesignerUtils.addProperty((DiagramElement)child, new DynamicProperty(SBGNPropertyConstants.SBGN_ENTITY_TYPE_PD, String.class, (Object)"macromolecule"), true);
                                this.addComplexElement(parent, (Node)child);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Cannot add complex subelement", e);
                        }
                    }
                    this.readAlias((Element)node, diagram, speciesAttr, alias, complexID, null);
                    continue;
                }
                String compartmentID = ((Element)node).getAttribute("compartmentAlias");
                if (compartmentID.isEmpty()) {
                    compartmentID = null;
                }
                this.readAlias((Element)node, diagram, speciesAttr, alias, null, compartmentID);
            }
        }
    }

    protected void addProteinRef(Element speciesIdentity, Object node) {
        Element prElement = CellDesignerExtension.getElement(speciesIdentity, "celldesigner:proteinReference");
        if (prElement != null) {
            String pr = CellDesignerExtension.getTextContent(prElement);
            List<Object> list = this.proteinRefs.get(pr);
            if (list == null) {
                list = new ArrayList<Object>();
                this.proteinRefs.put(pr, list);
            }
            list.add(node);
        }
    }

    protected void addComplexElement(Node parent, Node subElement) throws Exception {
        CellDesignerUtils.addElementToNodeAttributes(parent, subElement, "ComplexElements");
        Object nodeAliases = parent.getAttributes().getValue("NodeAliases");
        if (nodeAliases instanceof Node[]) {
            for (Node n : (Node[])nodeAliases) {
                Node nodeCopy = this.cloneNode(subElement, null, subElement.getName());
                CellDesignerUtils.addElementToNodeAttributes(n, nodeCopy, "ComplexElements");
            }
        }
        subElement.getAttributes().add(DPSUtils.createTransient((String)"parent", Node.class, (Object)parent));
    }

    protected Node readAlias(Element element, @Nonnull Diagram diagram, String id, String alias, String complexAlias, String compartmentAlias) {
        try {
            Node node = CellDesignerUtils.findNode(diagram, id, null);
            if (node != null) {
                Element e;
                Element activityElement;
                Object nodeAlias;
                Node complex;
                Object complexElements;
                if (complexAlias != null && this.complexes.containsKey(complexAlias) && (complexElements = (complex = this.complexes.get(complexAlias)).getAttributes().getValue("ComplexElements")) instanceof Node[]) {
                    for (Node n : (Node[])complexElements) {
                        if (!n.getName().equals(id)) continue;
                        node = n;
                        break;
                    }
                }
                if ((nodeAlias = (node = this.getNodeInCompartment(node, id, compartmentAlias)).getAttributes().getValue("Alias")) != null) {
                    Node parent = node;
                    String name = parent.getName();
                    Object aliases = parent.getAttributes().getValue("NodeAliases");
                    name = aliases instanceof Node[] ? name + "_" + (((Node[])aliases).length + 2) : name + "_2";
                    Role role = node.getRole();
                    node = this.cloneNode(node, (Compartment)parent.getOrigin(), name);
                    node.setRole(role);
                    CellDesignerUtils.addElementToNodeAttributes(parent, node, "NodeAliases");
                }
                CellDesignerUtils.addProperty((DiagramElement)node, new DynamicProperty("Alias", String.class, (Object)alias), false);
                Rectangle nodeBounds = this.readBoundsInfo(element, node);
                this.readPaintInfo(element, node);
                Element namePoint = CellDesignerExtension.getElement(element, "celldesigner:namePoint");
                if (namePoint != null) {
                    try {
                        double x = Double.parseDouble(namePoint.getAttribute("x"));
                        double y = Double.parseDouble(namePoint.getAttribute("y"));
                        Point location = new Point((int)x - node.getLocation().x, (int)y - node.getLocation().y);
                        CellDesignerUtils.addProperty((DiagramElement)node, new DynamicProperty("NamePoint", Point.class, (Object)location), false);
                    }
                    catch (NumberFormatException xe) {
                        log.log(Level.SEVERE, "Invalid name location format");
                    }
                }
                if ((activityElement = CellDesignerExtension.getElement(element, "celldesigner:activity")) != null) {
                    String activityStr = CellDesignerExtension.getTextContent(activityElement);
                    if (activityStr.equals("active")) {
                        Node variable = new Node(null, (Base)new Stub(null, node.getName() + "_active", "variable"));
                        variable.setTitle("Active");
                        String angle = String.valueOf(4.71238898038469);
                        variable.getAttributes().add(new DynamicProperty("Angle", String.class, (Object)angle));
                        variable.getAttributes().add(new DynamicProperty("value", String.class, (Object)"Active"));
                        CellDesignerUtils.addElementToNodeAttributes(node, variable, "ModificationElements");
                    } else if (activityStr.equals("inactive")) {
                        node.getAttributes().remove("ModificationElements");
                    }
                }
                if ((e = CellDesignerExtension.getElement(element, "celldesigner:listOfInnerAliases")) != null) {
                    Rectangle complexBounds = null;
                    NodeList list = e.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        org.w3c.dom.Node n = list.item(i);
                        if (!(n instanceof Element) || !n.getNodeName().equals("celldesigner:innerAlias")) continue;
                        Element innerNodeElement = (Element)n;
                        String childName = innerNodeElement.getAttribute("heterodimerEntry");
                        Compartment child = new Compartment(null, (Base)new Specie(null, childName, "entity"));
                        CellDesignerUtils.addProperty((DiagramElement)child, new DynamicProperty(SBGNPropertyConstants.SBGN_ENTITY_TYPE_PD, String.class, (Object)"macromolecule"), true);
                        this.addComplexElement(node, (Node)child);
                        Rectangle rect = this.readBoundsInfo(innerNodeElement, (Node)child);
                        if (rect != null) {
                            if (complexBounds == null) {
                                complexBounds = rect;
                            } else {
                                complexBounds.add(rect);
                            }
                        }
                        this.readPaintInfo(innerNodeElement, (Node)child);
                    }
                    if (complexBounds != null && nodeBounds == null) {
                        node.setLocation(complexBounds.x - 5, complexBounds.y - 5);
                        node.setShapeSize(new Dimension(complexBounds.width + 10, complexBounds.height + 10));
                        if (node instanceof Compartment) {
                            node.getAttributes().add(new DynamicProperty("fixedSize", Boolean.class, (Object)Boolean.TRUE));
                        }
                    }
                }
            }
            return node;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot find node: " + id, e);
            return null;
        }
    }

    protected Rectangle readBoundsInfo(Element element, Node node) throws Exception {
        Element e = CellDesignerExtension.getElement(element, "celldesigner:bounds");
        if (e != null) {
            try {
                double x = Double.parseDouble(e.getAttribute("x"));
                double y = Double.parseDouble(e.getAttribute("y"));
                double w = Double.parseDouble(e.getAttribute("w"));
                double h = Double.parseDouble(e.getAttribute("h"));
                if (node != null) {
                    this.addHiddenDoubleProperty((DiagramElement)node, "x", x);
                    this.addHiddenDoubleProperty((DiagramElement)node, "y", y);
                    this.addHiddenDoubleProperty((DiagramElement)node, "w", w);
                    this.addHiddenDoubleProperty((DiagramElement)node, "h", h);
                    node.setLocation((int)x, (int)y);
                    node.setShapeSize(new Dimension((int)w, (int)h));
                    if (node instanceof Compartment) {
                        node.getAttributes().add(new DynamicProperty("fixedSize", Boolean.class, (Object)Boolean.TRUE));
                    }
                }
                return new Rectangle((int)x, (int)y, (int)w, (int)h);
            }
            catch (NumberFormatException xe) {
                log.log(Level.SEVERE, "Invalid bounds format");
            }
        }
        return null;
    }

    protected void readPaintInfo(Element element, Node node) throws Exception {
        Element e = CellDesignerExtension.getElement(element, "celldesigner:usualView");
        Element element2 = e = e == null ? CellDesignerExtension.getElement(element, "celldesigner:paint") : CellDesignerExtension.getElement(e, "celldesigner:paint");
        if (e != null) {
            String colorStr = e.getAttribute("color");
            String scheme = e.getAttribute("scheme");
            try {
                colorStr = colorStr.toLowerCase();
                if (colorStr.length() >= 6) {
                    int l = colorStr.length();
                    colorStr = colorStr.substring(l - 6, l);
                    Paint color = new Color(Integer.parseInt(colorStr, 16));
                    Element doubleLine = CellDesignerExtension.getElement(element, "celldesigner:doubleLine");
                    if (doubleLine != null) {
                        Color outColor;
                        Color inColor;
                        int r = color.getRed();
                        int g = color.getGreen();
                        int b = color.getBlue();
                        if (r == 255 && g == 255 && b == 255) {
                            inColor = Color.black;
                            outColor = Color.black;
                        } else {
                            inColor = color;
                            outColor = color;
                            color = new Color(r, g, b, 200);
                        }
                        int width = (int)Double.parseDouble(doubleLine.getAttribute("thickness"));
                        Pen pen = new Pen((float)width, color);
                        node.setPredefinedStyle("Not selected");
                        node.getCustomStyle().setPen(pen.clone());
                        try {
                            int widthOut = (int)Double.parseDouble(doubleLine.getAttribute("outerWidth"));
                            CellDesignerUtils.addProperty((DiagramElement)node, new DynamicProperty("linePenOut", Pen.class, (Object)new Pen((float)widthOut, outColor)), false);
                            int widthIn = (int)Double.parseDouble(doubleLine.getAttribute("innerWidth"));
                            CellDesignerUtils.addProperty((DiagramElement)node, new DynamicProperty("linePenIn", Pen.class, (Object)new Pen((float)widthIn, inColor)), false);
                        }
                        catch (Exception exception) {}
                    } else {
                        if (color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255) {
                            color = new Color(254, 254, 254);
                        }
                        if (scheme != null && scheme.toLowerCase().equals("gradation")) {
                            color = new GradientPaint(0.0f, 0.0f, Color.white, 100.0f, 100.0f, (Color)color);
                        }
                        node.setPredefinedStyle("Not selected");
                        node.getCustomStyle().setBrush(new Brush(color));
                    }
                }
            }
            catch (Exception xe) {
                log.log(Level.SEVERE, "Invalid color format");
            }
        }
    }

    protected void readCompartmentType(Element element, @Nonnull Diagram diagram, String id) {
        try {
            Element classElement;
            Node node = CellDesignerUtils.findNode(diagram, id, null);
            if (node instanceof Compartment && (classElement = CellDesignerExtension.getElement(element, "celldesigner:class")) != null) {
                String type = CellDesignerExtension.getTextContent(classElement);
                if (type.indexOf("_CLOSEUP_") != -1) {
                    String bioumlType = type.substring(type.lastIndexOf(95) + 1);
                    CellDesignerUtils.addProperty((DiagramElement)node, new DynamicProperty("closeup", String.class, (Object)bioumlType), false);
                    Element point = CellDesignerExtension.getElement(element, "celldesigner:point");
                    if (point != null) {
                        double x = Double.parseDouble(point.getAttribute("x"));
                        double y = Double.parseDouble(point.getAttribute("y"));
                        node.setLocation((int)x, (int)y);
                    }
                } else if (type.equals("OVAL")) {
                    ((Compartment)node).setShapeType(2);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot find compartment: " + id, e);
        }
    }

    protected Node cloneNode(Node node, Compartment newParent, String newName) throws Exception {
        Base newKernel = node.getKernel();
        if (node.getKernel() instanceof Specie) {
            Specie oldKernel = (Specie)node.getKernel();
            newKernel = new Specie(oldKernel.getOrigin(), newName, oldKernel.getType());
        }
        Node result = node.clone(newParent, newName, newKernel);
        result.getAttributes().remove("NodeAliases");
        Object complexElements = node.getAttributes().getValue("ComplexElements");
        if (complexElements instanceof Node[]) {
            int size = ((Node[])complexElements).length;
            Node[] newComplexElements = new Node[size];
            for (int i = 0; i < size; ++i) {
                Node e = ((Node[])complexElements)[i];
                newComplexElements[i] = e.clone(null, e.getName());
                node.getAttributes().getProperty("ComplexElements").setValue((Object)newComplexElements);
            }
        }
        return result;
    }

    protected void addHiddenDoubleProperty(DiagramElement de, String name, double value) {
        try {
            DynamicProperty dp = new DynamicProperty(name, Double.class, (Object)value);
            dp.setHidden(true);
            de.getAttributes().add(dp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Node getNodeInCompartment(Node node, String nodeId, String compartmentAlias) throws Exception {
        Compartment comp;
        Object aliases;
        if (compartmentAlias != null && (aliases = (comp = (Compartment)node.getOrigin()).getAttributes().getValue("NodeAliases")) instanceof Node[]) {
            for (Node compAlias : (Node[])aliases) {
                Object compAliasName = compAlias.getAttributes().getValue("Alias");
                if (compAliasName == null || !compAliasName.equals(compartmentAlias)) continue;
                return (Node)((Compartment)compAlias).get(nodeId);
            }
        }
        return node;
    }

    public Element getTopElement(Element element, String name) {
        if (element.getNodeName().equals(name)) {
            return element;
        }
        return CellDesignerExtension.getElement(element, name);
    }

    public static class ReactionSpeciesCache {
        protected Map<String, Map<String, List<Edge>>> edgesMap = new HashMap<String, Map<String, List<Edge>>>();

        public void addEdge(Edge edge) {
            String reaction = null;
            String specie = null;
            if (edge.getInput().getKernel() instanceof Reaction) {
                reaction = edge.getInput().getName();
                specie = edge.getOutput().getName();
            } else if (edge.getOutput().getKernel() instanceof Reaction) {
                reaction = edge.getOutput().getName();
                specie = edge.getInput().getName();
            }
            if (reaction != null && specie != null) {
                List<Edge> edges;
                Map<String, List<Edge>> specieMap = this.edgesMap.get(reaction);
                if (specieMap == null) {
                    specieMap = new HashMap<String, List<Edge>>();
                    this.edgesMap.put(reaction, specieMap);
                }
                if ((edges = specieMap.get(specie)) == null) {
                    edges = new ArrayList<Edge>();
                    specieMap.put(specie, edges);
                }
                edges.add(edge);
            }
        }

        public Edge getEdge(String reaction, String specie, String role) {
            Map<String, List<Edge>> specieMap = this.edgesMap.get(reaction);
            if (specieMap == null) {
                return null;
            }
            List<Edge> edges = specieMap.get(specie);
            if (edges != null) {
                for (Edge edge : edges) {
                    Base base = edge.getKernel();
                    if (!(base instanceof SpecieReference) || !((SpecieReference)base).getRole().equals(role)) continue;
                    return edge;
                }
            }
            return null;
        }
    }

    public static class ElementSet {
        protected Map<String, Element> elements = new HashMap<String, Element>();

        public void addElement(Element element) {
            if (element.getNodeName().equals("celldesigner:extension")) {
                for (Element node : XmlUtil.elements((Element)element)) {
                    this.elements.put(node.getNodeName(), node);
                }
            } else {
                this.elements.put(element.getNodeName(), element);
            }
        }

        public Element getElement(String tagName) {
            return this.elements.get(tagName);
        }
    }

    public static class DoublePoint {
        public double x;
        public double y;

        public DoublePoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return this.x + " : " + this.y;
        }
    }
}

