/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.ModelDefinition;
import biouml.model.SemanticController;
import biouml.model.SubDiagram;
import com.developmentontheedge.beans.DynamicProperty;
import one.util.streamex.StreamEx;
import ru.biosoft.access.core.DataCollection;

public class SbmlUtil {
    public static boolean isInternal(Diagram diagram, Diagram compositeDiagram) {
        DynamicProperty dp = diagram.getAttributes().getProperty("refModelDefinition");
        if (dp == null) {
            return false;
        }
        ModelDefinition modelDef = (ModelDefinition)dp.getValue();
        return Diagram.getDiagram((DiagramElement)modelDef).equals(compositeDiagram);
    }

    public static void inlineModelDefinitions(Diagram diagram) throws Exception {
        SemanticController controller = diagram.getType().getSemanticController();
        for (Diagram d2 : (StreamEx)diagram.recursiveStream().select(SubDiagram.class).map(s -> s.getDiagram()).filter(d -> !SbmlUtil.isInternal(d, diagram))) {
            diagram.put(controller.validate((Compartment)diagram, (DiagramElement)new ModelDefinition((DataCollection)diagram, d2, DefaultSemanticController.generateUniqueNodeName((Compartment)diagram, (String)(d2.getName() + "_definition")))));
        }
    }
}

