/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.standard.type.DatabaseReference;
import biouml.standard.type.Specie;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import ru.biosoft.util.ApplicationUtils;
import ru.biosoft.util.TextUtil;

public class SbmlTypeMapper {
    public static final String MAP_FILE_NAME = "types.map";
    static SbmlTypeMapper typeMapper = null;
    protected Map<String, String> typeMap = new HashMap<String, String>();

    public static synchronized SbmlTypeMapper getInstance() {
        if (typeMapper == null) {
            typeMapper = new SbmlTypeMapper();
        }
        return typeMapper;
    }

    public SbmlTypeMapper() {
        try {
            URL url = ApplicationUtils.getResourceURL((String)"biouml.plugins.sbml", (String)MAP_FILE_NAME);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] values = TextUtil.split((String)line, (char)' ');
                    if (values.length < 2) continue;
                    this.typeMap.put(values[0], values[1]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getSpecieType(Specie specie) {
        if (specie.getDatabaseReferences() != null) {
            for (DatabaseReference dr : specie.getDatabaseReferences()) {
                for (Map.Entry<String, String> entry : this.typeMap.entrySet()) {
                    if (!dr.getDatabaseName().matches(entry.getKey())) continue;
                    return entry.getValue();
                }
            }
        }
        return null;
    }
}

