/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.standard.type.access.TitleIndex;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.biosoft.access.DataCollectionUtils;
import ru.biosoft.access.FileCollection;
import ru.biosoft.access.FileDataElement;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.TransformedDataCollection;
import ru.biosoft.access.security.PrivilegedAction;
import ru.biosoft.access.security.SecurityManager;

public class SbmlTitleIndex
extends TitleIndex {
    public SbmlTitleIndex(DataCollection<?> dc, String indexName) throws Exception {
        super(dc, indexName);
    }

    protected void doInit() throws Exception {
        SecurityManager.runPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() throws Exception {
                FileCollection fileCollection = (FileCollection)((TransformedDataCollection)DataCollectionUtils.fetchPrimaryCollectionPrivileged((DataCollection)SbmlTitleIndex.this.dc)).getPrimaryCollection();
                for (FileDataElement element : fileCollection) {
                    File file = element.getFile();
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    SAXHandler handler = new SAXHandler();
                    try {
                        parser.parse(file, (DefaultHandler)handler);
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    SbmlTitleIndex.this.putInternal(element.getName(), handler.getName());
                }
                return null;
            }
        });
    }

    private static class SAXHandler
    extends DefaultHandler {
        private String name;

        private SAXHandler() {
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equalsIgnoreCase("model")) {
                this.name = atts.getValue("name");
                if (this.name == null) {
                    this.name = atts.getValue("id");
                }
                throw new SAXException();
            }
        }
    }
}

