/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.util.DiagramXmlReader;
import biouml.plugins.sbml.MessageBundle;
import biouml.plugins.sbml.SbmlConstants;
import biouml.plugins.sbml.SbmlEModel;
import biouml.standard.type.Compartment;
import biouml.standard.type.Specie;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.biosoft.util.DPSUtils;
import ru.biosoft.util.TextUtil;

public class SbmlSupport
extends SbmlConstants {
    protected Logger log;
    protected String modelName;
    protected Diagram diagram;
    protected SbmlEModel emodel;
    protected Map<String, String> newPaths;
    protected static final int MAX_SIZE = 30000;
    protected boolean shouldLayout = true;

    public void setNewPaths(Map<String, String> newPaths) {
        this.newPaths = newPaths;
    }

    public Map<String, String> getNewPaths() {
        return this.newPaths;
    }

    protected void warn(String key, String[] params) {
        MessageBundle.warn(this.log, key, params);
    }

    protected void error(String key, String[] params) {
        MessageBundle.error(this.log, key, params);
    }

    public Element getElement(Element element, String childName) {
        Element child = null;
        String elementName = element.getAttribute("name");
        if (elementName.isEmpty()) {
            elementName = element.getTagName();
        }
        try {
            NodeList list = element.getChildNodes();
            Element result = null;
            for (int i = 0; i < list.getLength(); ++i) {
                org.w3c.dom.Node node = list.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equals(childName)) continue;
                if (result == null) {
                    result = (Element)node;
                    continue;
                }
                this.warn("WARN_MULTIPLE_DECLARATION", new String[]{this.modelName, elementName, childName});
            }
            return result;
        }
        catch (Throwable t) {
            this.error("ERROR_ELEMENT_PROCESSING", new String[]{this.modelName, elementName, childName, t.getMessage()});
            return child;
        }
    }

    public static String getBriefName(String fullName) {
        int index = fullName.lastIndexOf(".");
        return index == -1 ? fullName : fullName.substring(index + 1);
    }

    public String readXhtml(Element element) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(element);
            transformer.transform(source, result);
            String html = sw.toString();
            String body = TextUtil.getSection((String)"body", (String)html);
            if (body == null) {
                body = TextUtil.getSection((String)"notes", (String)html);
            }
            if (body == null) {
                body = html;
            }
            body = this.removeLongTables(body);
            return body;
        }
        catch (Throwable t) {
            this.error("ERROR_HTML_PROCESSING", new String[]{this.modelName, t.getMessage(), element.toString()});
            return null;
        }
    }

    protected String removeLongTables(String html) {
        if (html.length() > 30000) {
            int end;
            int start;
            String result = html;
            int offset = 0;
            while ((start = result.indexOf("<table", offset)) != -1 && (end = result.indexOf("</table>", start)) != -1) {
                if (end - start > 30000) {
                    result = result.substring(0, start) + result.substring(end + 8, result.length());
                    offset = start;
                    continue;
                }
                offset = end;
            }
            return result;
        }
        return html;
    }

    public void writeXhtml(Document document, Element element, String notes) {
        try {
            String html = notes;
            String body = TextUtil.getSection((String)"body", (String)html);
            if (body != null) {
                html = body;
            }
            html = "<body xmlns=\"http://www.w3.org/1999/xhtml\">" + html + "</body>";
            html = html.replace("&nbsp;", " ");
            html = html.replace("&ndash;", "-");
            html = html.replace("&rdquo;", "\"");
            html = html.replace("&ldquo;", "\"");
            InputSource inputSource = new InputSource(new StringReader(html));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            org.w3c.dom.Node node = document.importNode(doc.getFirstChild(), true);
            element.appendChild(node);
        }
        catch (Throwable t) {
            this.error("ERROR_XTML_WRITING", new String[]{this.diagram.getName(), t.getMessage(), notes});
        }
    }

    public String parseFormula(String formula, Node reaction) {
        if (formula == null) {
            return null;
        }
        String delimiters = "\n\t ,;()[]+-/%*^|&";
        StringTokenizer tokens = new StringTokenizer(formula.trim(), delimiters, true);
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (delimiters.indexOf(token) >= 0) {
                if (token.charAt(0) == '\n' || token.charAt(0) == '\t') continue;
                result.append(token);
                continue;
            }
            if (this.parseAsSpecie(token, result) || this.parseAsCompartment(token, result) || this.parseAsParameter(token, result, reaction)) continue;
            result.append(token);
        }
        return result.toString();
    }

    protected boolean parseAsSpecie(String token, StringBuffer result) {
        return false;
    }

    protected boolean parseAsCompartment(String token, StringBuffer result) {
        return false;
    }

    protected boolean parseAsParameter(String token, StringBuffer result, Node reaction) {
        return false;
    }

    public static String castStringToSId(String input) {
        String result = input.replaceAll("\\W", "_");
        if (result.matches("\\d\\w*")) {
            result = "_" + result;
        }
        return result;
    }

    public static String castFullName(String fullName) {
        return StreamEx.of((Object[])fullName.split("\\.")).map(s -> SbmlSupport.castStringToSId(s)).joining((CharSequence)".");
    }

    protected void readBioUMLAnnotation(Element annotationElement, DiagramElement de, String expectedInfo) {
        Element nodeInfoElement;
        Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
        Element element = nodeInfoElement = bioumlElement != null ? this.getElement(bioumlElement, expectedInfo) : this.getElement(annotationElement, expectedInfo);
        if (nodeInfoElement != null) {
            this.shouldLayout = false;
            if (de instanceof biouml.model.Compartment) {
                DiagramXmlReader.readCompartmentInfo((Element)nodeInfoElement, (biouml.model.Compartment)((biouml.model.Compartment)de), (String)this.diagram.getName());
            }
            if (de instanceof Node) {
                DiagramXmlReader.readNodeInfo((Element)nodeInfoElement, (Node)((Node)de), (String)this.diagram.getName());
            } else if (de instanceof Edge) {
                DiagramXmlReader.readEdgeInfo((Element)nodeInfoElement, (Edge)((Edge)de), (String)this.diagram.getName());
            }
        }
    }

    protected String readEdgeName(Element annotationElement, String expectedInfo) {
        Element infoElement;
        Element bioumlElement = this.getElement(annotationElement, "biouml:BIOUML");
        Element element = infoElement = bioumlElement != null ? this.getElement(bioumlElement, expectedInfo) : this.getElement(annotationElement, expectedInfo);
        if (infoElement != null) {
            String id = DiagramXmlReader.readEdgeID((Element)infoElement);
            return SbmlSupport.castStringToSId(id);
        }
        return "";
    }

    protected void readSBOTerm(Element element, DynamicPropertySet dps) {
        DynamicProperty dp = new DynamicProperty("sboTerm", String.class, (Object)element.getAttribute("sboTerm"));
        DPSUtils.makeTransient((DynamicProperty)dp);
        dps.add(dp);
    }

    public static void writeSBOTerm(Element element, DynamicPropertySet dps) {
        Object sboTerm = dps.getValue("sboTerm");
        if (sboTerm != null && sboTerm instanceof String && ((String)sboTerm).length() > 0) {
            element.setAttribute("sboTerm", (String)sboTerm);
        }
    }

    protected List<Node> fillSpecieList(Diagram diagram) {
        return ((StreamEx)diagram.recursiveStream().select(Node.class).filter(n -> n.getKernel() instanceof Specie)).toList();
    }

    protected static List<biouml.model.Compartment> fillCompartmentList(Diagram diagram) {
        return ((StreamEx)diagram.recursiveStream().select(biouml.model.Compartment.class).filter(c -> c.getKernel() instanceof Compartment)).toList();
    }

    protected double readDouble(Element element, String attr, String error, double defaultValue) {
        double result = defaultValue;
        if (element.hasAttribute(attr)) {
            try {
                result = Double.parseDouble(element.getAttribute(attr));
            }
            catch (NumberFormatException ex) {
                this.log.log(Level.SEVERE, error);
            }
        }
        return result;
    }

    public static double parseSBMLDoubleValue(String value) throws NumberFormatException {
        if (value.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (value.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value.equals("NaN")) {
            return Double.NaN;
        }
        return Double.parseDouble(value);
    }

    protected double readDouble(Element element, String attr, double defaultValue, String errorCode, String deID) {
        if (element.hasAttribute(attr)) {
            String attrValue = element.getAttribute(attr);
            try {
                return SbmlSupport.parseSBMLDoubleValue(attrValue);
            }
            catch (NumberFormatException ex) {
                this.error(errorCode, new String[]{this.modelName, deID, attrValue, ex.toString()});
            }
        }
        return defaultValue;
    }

    protected int readInt(Element element, String attr, int defaultValue, String errorCode, String deID) {
        if (element.hasAttribute(attr)) {
            String attrValue = element.getAttribute(attr);
            try {
                return Integer.parseInt(attrValue);
            }
            catch (NumberFormatException ex) {
                this.error(errorCode, new String[]{this.modelName, deID, attrValue, ex.toString()});
            }
        }
        return defaultValue;
    }

    protected boolean readObligatoryBoolean(Element element, String attr, boolean defaultValue, String error) {
        if (element.hasAttribute(attr)) {
            return Boolean.parseBoolean(element.getAttribute(attr));
        }
        this.log.log(Level.SEVERE, error);
        return defaultValue;
    }

    protected boolean readOptionalBoolean(Element element, String attr, boolean defaultValue) {
        return element.hasAttribute(attr) ? Boolean.parseBoolean(element.getAttribute(attr)) : defaultValue;
    }
}

