/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramElementGroup;
import biouml.model.DiagramViewOptions;
import biouml.model.Edge;
import biouml.model.ModelDefinition;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.SubDiagram;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.VariableRole;
import biouml.model.xml.XmlDiagramType;
import biouml.model.xml.XmlDiagramViewOptions;
import biouml.plugins.sbml.CreateDiagramElementDialog;
import biouml.plugins.sbml.SbmlEModel;
import biouml.standard.diagram.CreatorElementWithName;
import biouml.standard.diagram.DiagramUtility;
import biouml.standard.diagram.PathwaySimulationSemanticController;
import biouml.standard.diagram.PortProperties;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.Compartment;
import biouml.standard.type.Gene;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Stub;
import com.developmentontheedge.application.Application;
import com.developmentontheedge.application.ApplicationFrame;
import com.developmentontheedge.beans.DynamicProperty;
import java.awt.Dimension;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.graphics.editor.ViewEditorPane;
import ru.biosoft.math.model.Parser;
import ru.biosoft.math.model.Utils;
import ru.biosoft.util.DPSUtils;

public class SbmlSemanticController
extends PathwaySimulationSemanticController
implements CreatorElementWithName {
    static final String[] RESERVED_KEY_WORDS = new String[]{"abs", "acos", "and", "asin", "atan", "ceil", "cos", "exp", "floor", "hilli", "hillmmr", "hillmr", "hillr", "isouur", "log", "log10", "massi", "massr", "not", "or", "ordbbr", "ordbur", "ordubr", "pow", "ppbrr", "sin", "sqr", "sqrt", "substance", "time", "tan", "umai", "umar", "uai", "ualii", "uar", "ucii", "ucir", "ucti", "uctr", "uhmi", "uhmr", "umar", "umi", "unii", "unir", "uuhr", "umr", "usii", "usir", "uuci", "uucr", "uui", "uur", "volume", "xor"};
    private static final HashMap<String, String> newStyleOrientation = new HashMap<String, String>(){
        {
            this.put("north", "up");
            this.put("east", "right");
            this.put("west", "left");
            this.put("south", "bottom");
        }
    };
    private static final TypeDescriptor[] TYPE_DESCRIPTORS = new TypeDescriptor[]{new TypeDescriptor("equation", "math-equation", Equation.class), new TypeDescriptor("function", "math-function", Function.class), new TypeDescriptor("event", "math-event", Event.class), new TypeDescriptor("entity", "molecule-substance", Specie.class), new TypeDescriptor("entity", "molecule-gene", Gene.class), new TypeDescriptor("compartment", "compartment", Compartment.class), new TypeDescriptor("reaction", "reaction", Reaction.class)};

    public static boolean isReservedKeyWord(String str) {
        for (String element : RESERVED_KEY_WORDS) {
            if (!element.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static Object resolveName(Diagram diagram, String sname) {
        DiagramElement result = null;
        HashMap<String, DiagramElement> map = new HashMap<String, DiagramElement>();
        SbmlSemanticController.fillNameMap((biouml.model.Compartment)diagram, map);
        result = map.get(sname);
        if (result != null) {
            return result;
        }
        if (diagram.getRole() instanceof EModel) {
            try {
                EModel model = (EModel)diagram.getRole(EModel.class);
                result = model.getVariable(sname);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Error during resolving name " + sname + " in diagram " + diagram + ", error: " + t.getMessage(), t);
            }
        }
        return result;
    }

    protected static void fillNameMap(biouml.model.Compartment compartment, HashMap<String, DiagramElement> map) {
        map.put(compartment.getName(), (DiagramElement)compartment);
        for (DiagramElement de : compartment) {
            if (de instanceof biouml.model.Compartment) {
                SbmlSemanticController.fillNameMap((biouml.model.Compartment)de, map);
                continue;
            }
            map.put(de.getName(), de);
        }
    }

    public static String validateSName(String name) {
        if (!Character.isLetter(name.charAt(0)) && name.charAt(0) != '_') {
            name = "_" + name;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '_') {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public String generateReactionName(Diagram diagram) throws Exception {
        HashMap<String, DiagramElement> map = new HashMap<String, DiagramElement>();
        SbmlSemanticController.fillNameMap((biouml.model.Compartment)diagram, map);
        int n = 1;
        String name = null;
        DecimalFormat formatter = Reaction.NAME_FORMAT;
        while (map.containsKey(name = formatter.format(n++))) {
        }
        return name;
    }

    public DiagramElementGroup createInstance(@Nonnull biouml.model.Compartment parent, Object type, Point point, ViewEditorPane viewEditor) {
        Class classType = (Class)type;
        Node de = null;
        Diagram diagram = (Diagram)viewEditor.getView().getModel();
        if (classType == Reaction.class || classType == Stub.Note.class || classType == Stub.NoteLink.class || classType == Equation.class || classType == Function.class || classType == Event.class || Stub.ConnectionPort.class.isAssignableFrom(classType) || classType == SubDiagram.class || classType == ModelDefinition.class || classType == Stub.UndirectedConnection.class) {
            return super.createInstance(parent, type, point, viewEditor);
        }
        ApplicationFrame frame = Application.getApplicationFrame();
        CreateDiagramElementDialog dialog = new CreateDiagramElementDialog((JFrame)frame, diagram, parent, classType);
        if (dialog.doModal()) {
            de = dialog.getNode();
        }
        return new DiagramElementGroup((DiagramElement)de);
    }

    public DiagramElementGroup createInstance(@Nonnull biouml.model.Compartment compartment, Object type, Point point, Object properties) {
        return this.createInstance(compartment, type, null, point, properties);
    }

    public DiagramElementGroup createInstance(@Nonnull biouml.model.Compartment compartment, Object type, String name, Point point, Object properties) {
        try {
            for (TypeDescriptor descriptor : TYPE_DESCRIPTORS) {
                if (!descriptor.getTypeClass().equals(type) && !descriptor.getXMLType().equals(type)) continue;
                String id = name;
                if (id == null) {
                    id = SbmlSemanticController.generateUniqueNodeName((biouml.model.Compartment)compartment, (String)descriptor.getType().replace("-", "_"));
                }
                if (type.equals(Specie.class) || type.equals(descriptor.getXMLType())) {
                    return new DiagramElementGroup(this.createVariableRoleOwner(descriptor.getXMLType(), compartment, point, (Base)new Specie(null, id)));
                }
                if (type.equals(Gene.class) || type.equals(descriptor.getXMLType())) {
                    return new DiagramElementGroup(this.createVariableRoleOwner(descriptor.getXMLType(), compartment, point, (Base)new Gene(null, id)));
                }
                if (type.equals(Compartment.class) || type.equals(descriptor.getXMLType())) {
                    return new DiagramElementGroup(this.createVariableRoleOwner(descriptor.getXMLType(), compartment, point, (Base)new Compartment(null, id)));
                }
                if (type.equals(Reaction.class)) {
                    return new DiagramElementGroup(this.createReaction(descriptor.getXMLType(), compartment, point, properties, id));
                }
                Stub stub = new Stub(null, id, descriptor.getType());
                Node node = new Node((DataCollection)compartment, (Base)stub);
                Role role = !(properties instanceof Role) ? descriptor.getTypeClass().getConstructor(DiagramElement.class).newInstance(node) : ((Role)properties).clone((DiagramElement)node);
                this.setXmlType((DiagramElement)node, descriptor.getXMLType());
                node.setRole(role.clone((DiagramElement)node));
                if (point != null) {
                    node.setLocation(point);
                }
                return new DiagramElementGroup((DiagramElement)node);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "While creating instance of type " + type.toString(), e);
        }
        return DiagramElementGroup.EMPTY_EG;
    }

    public Object getPropertiesByType(biouml.model.Compartment compartment, Object type, Point point) {
        Class<?> cl = null;
        if (type instanceof Class) {
            cl = (Class<?>)type;
            if (Reaction.class == cl || !Role.class.isAssignableFrom(cl) && !Base.class.isAssignableFrom(cl)) {
                return null;
            }
        } else {
            for (TypeDescriptor descriptor : TYPE_DESCRIPTORS) {
                if (!descriptor.getXMLType().equals(type)) continue;
                cl = descriptor.getTypeClass();
                break;
            }
        }
        if (cl != null && Stub.ConnectionPort.class.isAssignableFrom(cl)) {
            return new PortProperties(Diagram.getDiagram((DiagramElement)compartment), cl.asSubclass(Stub.ConnectionPort.class));
        }
        if (cl != null) {
            try {
                Object[] values = new Object[cl.getConstructors()[0].getParameterTypes().length];
                return cl.getConstructors()[0].newInstance(values);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "SbmlSemanticComtroller: can not get properties by type " + type);
                return null;
            }
        }
        return null;
    }

    protected DiagramElement createVariableRoleOwner(String xmlType, biouml.model.Compartment compartment, Point point, Base kernel) {
        String name;
        Diagram diagram = Diagram.getDiagram((DiagramElement)compartment);
        boolean isSbgnModel = false;
        if (diagram.getType() instanceof XmlDiagramType && ("sbml_sbgn.xml".equals(name = ((XmlDiagramType)diagram.getType()).getName()) || "sbml_sbgn_composite.xml".equals(name))) {
            isSbgnModel = true;
        }
        Object node = null;
        node = kernel instanceof Compartment || isSbgnModel ? new biouml.model.Compartment((DataCollection)compartment, kernel) : new Node((DataCollection)compartment, kernel);
        boolean notificationEnabled = node.isNotificationEnabled();
        if (notificationEnabled) {
            node.setNotificationEnabled(false);
        }
        node.setShapeSize(new Dimension(0, 0));
        this.setXmlType((DiagramElement)node, xmlType);
        VariableRole var = new VariableRole((DiagramElement)node, 0.0);
        node.setRole((Role)var);
        if (notificationEnabled) {
            node.setNotificationEnabled(true);
        }
        return node;
    }

    protected DiagramElement createReaction(String xmlType, biouml.model.Compartment compartment, Point point, Object properties, String nodeName) throws Exception {
        Diagram diagram = Diagram.getDiagram((DiagramElement)compartment);
        Reaction oldReaction = (Reaction)properties;
        List<SpecieReference> components = Arrays.asList(oldReaction.getSpecieReferences());
        Node reactionNode = DiagramUtility.createReactionNode((Diagram)diagram, (biouml.model.Compartment)compartment, null, components, (String)oldReaction.getFormula(), (Point)point, (String)xmlType, (String)nodeName);
        this.setXmlType((DiagramElement)reactionNode, xmlType);
        for (Edge edge : reactionNode.getEdges()) {
            this.setXmlType((DiagramElement)edge, xmlType);
        }
        return reactionNode;
    }

    public synchronized DiagramElement validate(biouml.model.Compartment compartment, @Nonnull DiagramElement de, boolean newElement) throws Exception {
        Base kernel;
        if (de instanceof Diagram) {
            if (((Diagram)de).getRole() == null) {
                ((Diagram)de).setRole((Role)new SbmlEModel(de));
            }
            this.addSBOAttriubute(de);
            return de;
        }
        this.addSBOAttriubute(de);
        String parentStubType = this.getXmlType((DiagramElement)compartment);
        if (de.getOrigin() != compartment && "complex".equals(parentStubType) && !((kernel = de.getKernel()) instanceof Stub)) {
            Node node = new Node(de.getOrigin(), (Base)new Stub(null, kernel.getName(), "entity"));
            boolean notificationEnabled = node.isNotificationEnabled();
            if (notificationEnabled) {
                node.setNotificationEnabled(false);
            }
            node.setShapeSize(new Dimension(0, 0));
            this.setXmlType((DiagramElement)node, "entity");
            this.copyAttributes(de, (DiagramElement)node);
            if (notificationEnabled) {
                node.setNotificationEnabled(true);
            }
            return node;
        }
        if ((de.getKernel() instanceof Specie || de.getKernel() instanceof biouml.model.Compartment) && de.getRole() == null) {
            de.setRole((Role)new VariableRole(de));
        }
        if (de.getKernel() instanceof Stub && de.getRole() == null) {
            Diagram diagram = Diagram.getDiagram((DiagramElement)compartment);
            String stubType = de.getKernel().getType();
            if ("compartment".equals(stubType)) {
                Compartment kernel2 = new Compartment(null, de.getName());
                DiagramElement node = this.createVariableRoleOwner(stubType, compartment, ((Node)de).getLocation(), (Base)kernel2);
                this.copyAttributes(de, node);
                return node;
            }
            if ("entity".equals(stubType) && !"complex".equals(parentStubType)) {
                Node node = (Node)this.createVariableRoleOwner(stubType, compartment, ((Node)de).getLocation(), (Base)new Specie(null, de.getName()));
                this.copyAttributes(de, (DiagramElement)node);
                return node;
            }
            if ("complex".equals(stubType)) {
                Compartment kernel3 = new Compartment(null, de.getName());
                Node node = (Node)this.createVariableRoleOwner(stubType, compartment, ((Node)de).getLocation(), (Base)kernel3);
                this.copyAttributes(de, (DiagramElement)node);
                return node;
            }
            if ("event".equals(stubType)) {
                DiagramElement node = this.createInstance(de.getCompartment(), Event.class, de.getName(), ((Node)de).getLocation(), de.getRole()).getElement();
                Event event = (Event)node.getRole(Event.class);
                String message = this.checkMath(diagram, event.getTrigger());
                if (message != null) {
                    throw new Exception("Incorrect value of trigger: " + event.getTrigger() + ". " + message);
                }
                for (int i = 0; i < event.getEventAssignment().length; ++i) {
                    message = this.checkMath(diagram, event.getEventAssignment(i).getMath());
                    if (message == null) continue;
                    throw new Exception("Incorrect value of trigger: " + event.getTrigger() + ". " + message);
                }
                return node;
            }
            if ("function".equals(stubType)) {
                return this.createInstance(de.getCompartment(), Function.class, de.getName(), ((Node)de).getLocation(), de.getRole()).getElement();
            }
            if ("equation".equals(stubType)) {
                DiagramElement node = this.createInstance(de.getCompartment(), Equation.class, de.getName(), ((Node)de).getLocation(), de.getRole()).getElement();
                Equation eq = (Equation)node.getRole(Equation.class);
                String message = this.checkMath(diagram, eq.getFormula());
                if (message != null) {
                    throw new Exception("Can not accept the equation to " + compartment.getCompleteNameInDiagram() + ". " + message);
                }
                if (!(eq.getType().equals("scalar") || eq.getType().equals("algebraic") || eq.getType().equals("rate") || eq.getType().equals("initial assignment"))) {
                    throw new Exception("Unknown type of the equation:" + eq.getType() + ". Acceptable types are: " + "algebraic" + ", " + "rate" + ", " + "scalar" + ", " + "initial assignment");
                }
                return node;
            }
            if ("association".equals(stubType) || "dissociation".equals(stubType) || "process".equals(stubType)) {
                Reaction reaction = new Reaction(null, de.getName());
                Node node = new Node(de.getOrigin(), de.getName(), (Base)reaction);
                this.setXmlType((DiagramElement)node, stubType);
                return node;
            }
            if (de instanceof Node && Util.isPort((DiagramElement)de)) {
                DynamicProperty dp;
                this.setXmlType(de, "port");
                DynamicProperty property = de.getAttributes().getProperty("portType");
                if (property != null) {
                    property.setHidden(true);
                }
                if ((property = de.getAttributes().getProperty("accessType")) != null) {
                    property.setHidden(true);
                } else {
                    property = new DynamicProperty("accessType", String.class, (Object)"public");
                    property.setHidden(true);
                    de.getAttributes().add(property);
                }
                property = de.getAttributes().getProperty("variableName");
                if (property != null) {
                    property.setReadOnly(true);
                }
                if ((dp = de.getAttributes().getProperty("direction")) != null) {
                    de.getAttributes().add(new DynamicProperty("xmlElementType", String.class, (Object)"port"));
                    String direction = dp.getValue().toString();
                    DynamicProperty newDp = new DynamicProperty("orientation", SubDiagram.PortOrientation.class, (Object)SubDiagram.PortOrientation.getOrientation((String)newStyleOrientation.get(direction)));
                    if (compartment instanceof SubDiagram) {
                        newDp.setReadOnly(true);
                        newDp.setHidden(true);
                    }
                    de.getAttributes().add(newDp);
                    de.getAttributes().remove("direction");
                }
                if (de.getParent() instanceof SubDiagram && (dp = de.getAttributes().getProperty("orientation")) != null) {
                    dp.setHidden(true);
                }
                return de;
            }
            if ("consumption".equals(stubType)) {
                if (de instanceof Edge && ((Edge)de).getOutput().getKernel() instanceof Reaction) {
                    Reaction reaction = (Reaction)((Edge)de).getOutput().getKernel();
                    String id = ((Edge)de).getOutput().getName() + ": " + reaction.getName() + " as " + "reactant";
                    SpecieReference ref = new SpecieReference((DataCollection)reaction, id, "reactant");
                    try {
                        reaction.put(ref);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can not add specie reference to reaction", e);
                    }
                }
            } else if ("production".equals(stubType)) {
                if (de instanceof Edge && ((Edge)de).getInput().getKernel() instanceof Reaction) {
                    Reaction reaction = (Reaction)((Edge)de).getInput().getKernel();
                    String id = reaction.getName() + ": " + ((Edge)de).getOutput().getName() + " as " + "product";
                    SpecieReference ref = new SpecieReference((DataCollection)reaction, id, "product");
                    try {
                        reaction.put(ref);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can not add specie reference to reaction", e);
                    }
                }
            } else if ("regulation".equals(stubType)) {
                if (de instanceof Edge && ((Edge)de).getOutput().getKernel() instanceof Reaction) {
                    Reaction reaction = (Reaction)((Edge)de).getOutput().getKernel();
                    String id = ((Edge)de).getOutput().getName() + ": " + reaction.getName() + " as " + "modifier";
                    SpecieReference ref = new SpecieReference((DataCollection)reaction, id, "modifier");
                    try {
                        reaction.put(ref);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can not add specie reference to reaction", e);
                    }
                }
            } else if ("submap".equals(stubType)) {
                throw new Exception(stubType + " is not able for this diagram");
            }
        } else if (de.getKernel() instanceof Reaction) {
            if (((Node)de).getEdges().length > 0) {
                DynamicProperty property;
                int reactantCount = 0;
                int productCount = 0;
                for (Edge edge : ((Node)de).getEdges()) {
                    String type;
                    if (edge.getKernel() instanceof SpecieReference) {
                        type = ((SpecieReference)edge.getKernel()).getRole();
                        if (type.equals("reactant")) {
                            ++reactantCount;
                            continue;
                        }
                        if (!type.equals("product")) continue;
                        ++productCount;
                        continue;
                    }
                    if (!(edge.getKernel() instanceof Stub)) continue;
                    type = edge.getKernel().getType();
                    if (type.equals("consumption")) {
                        ++reactantCount;
                    } else if (type.equals("production")) {
                        ++productCount;
                    }
                    if (!type.isEmpty()) continue;
                    ++reactantCount;
                    ++productCount;
                }
                boolean addSourceSink = false;
                DiagramViewOptions options = Diagram.getDiagram((DiagramElement)de).getViewOptions();
                if (options instanceof XmlDiagramViewOptions && (property = ((XmlDiagramViewOptions)options).getOptions().getProperty("addSourceSink")) != null && property.getValue() instanceof Boolean) {
                    addSourceSink = (Boolean)property.getValue();
                }
                if (addSourceSink) {
                    Edge sourceSinkEdge;
                    String edgeName;
                    if (reactantCount == 0) {
                        Node sourceSink = new Node(de.getOrigin(), (Base)new Stub(null, de.getKernel().getName() + "_empty_reactant", "source-sink"));
                        sourceSink.setShapeSize(new Dimension(30, 30));
                        sourceSink.setLocation(((Node)de).getLocation().x - 60, ((Node)de).getLocation().y);
                        de.getOrigin().put((DataElement)sourceSink);
                        edgeName = sourceSink.getName() + "_egde";
                        sourceSinkEdge = new Edge(de.getOrigin(), edgeName, (Base)new Stub((DataCollection)((Reaction)de.getKernel()), edgeName, "consumption"), sourceSink, (Node)de);
                        this.setXmlType((DiagramElement)sourceSinkEdge, "reaction");
                        de.getOrigin().put((DataElement)sourceSinkEdge);
                    }
                    if (productCount == 0) {
                        Node sourceSink = new Node(de.getOrigin(), (Base)new Stub(null, de.getKernel().getName() + "_empty_product", "source-sink"));
                        sourceSink.setShapeSize(new Dimension(30, 30));
                        sourceSink.setLocation(((Node)de).getLocation().x + 30, ((Node)de).getLocation().y);
                        de.getOrigin().put((DataElement)sourceSink);
                        edgeName = sourceSink.getName() + "_egde";
                        sourceSinkEdge = new Edge(de.getOrigin(), edgeName, (Base)new Stub((DataCollection)((Reaction)de.getKernel()), edgeName, "production"), (Node)de, sourceSink);
                        this.setXmlType((DiagramElement)sourceSinkEdge, "reaction");
                        de.getOrigin().put((DataElement)sourceSinkEdge);
                    }
                }
            }
        } else if ((de.getKernel().getType().equals("unit of information") || de.getKernel().getType().equals("variable")) && !(compartment.getKernel() instanceof Specie)) {
            throw new Exception("Can not accept " + de.getKernel().getType() + " to " + compartment.getCompleteNameInDiagram());
        }
        return de;
    }

    protected void copyAttributes(DiagramElement oldElement, DiagramElement newElement) {
        oldElement.getAttributes().forEach(dp -> newElement.getAttributes().add(dp));
    }

    protected void setXmlType(DiagramElement de, String type) {
        DynamicProperty dp = new DynamicProperty("xmlElementType", String.class, (Object)type);
        dp.setHidden(true);
        de.getAttributes().add(dp);
    }

    protected void addSBOAttriubute(DiagramElement de) {
        if (de.getAttributes().getProperty("sboTerm") == null) {
            de.getAttributes().add(new DynamicProperty("sboTerm", String.class, (Object)""));
        }
    }

    protected String getXmlType(DiagramElement de) {
        Object xmlType = de.getAttributes().getValue("xmlElementType");
        return xmlType != null ? xmlType.toString() : "";
    }

    private String checkMath(Diagram diagram, String math) {
        Role role = diagram.getRole();
        if (!(role instanceof EModel)) {
            return "Invalid executable model of the diagram " + diagram.getName();
        }
        EModel emodel = (EModel)role;
        int status = emodel.getParser().parse(math);
        try {
            if (status > 0) {
                return "There were errors or warnings during the math " + math + " parsing\n errors: \n" + Utils.formatErrors((Parser)emodel.getParser());
            }
        }
        catch (Throwable t) {
            return "There were errors or warnings during the math " + math + " parsing\n errors: \n" + t.toString();
        }
        return null;
    }

    public static void addPackage(Diagram diagram, String packageName) throws Exception {
        DynamicProperty dp = diagram.getAttributes().getProperty("Packages");
        if (dp == null) {
            dp = new DynamicProperty("Packages", String[].class, (Object)new String[]{"comp"});
            dp.setHidden(true);
            DPSUtils.makeTransient((DynamicProperty)dp);
            diagram.getAttributes().add(dp);
        }
        String[] val = (String[])dp.getValue();
        boolean alreadyHasPackage = false;
        for (String v : val) {
            if (!packageName.equals(v)) continue;
            alreadyHasPackage = true;
            break;
        }
        if (!alreadyHasPackage) {
            String[] newVal = new String[val.length + 1];
            System.arraycopy(val, 0, newVal, 0, val.length);
            newVal[val.length] = packageName;
        }
    }

    public boolean remove(DiagramElement de) throws Exception {
        if (de instanceof Diagram) {
            return false;
        }
        if (de.getKernel() instanceof Stub.Note || de.getKernel() instanceof Stub.NoteLink) {
            return super.remove(de);
        }
        if (de instanceof Edge) {
            Edge edge = (Edge)de;
            if (edge.getKernel().getType().equals("relation-semantic")) {
                edge.getOrigin().remove(edge.getName());
                return true;
            }
            return false;
        }
        if (de instanceof biouml.model.Compartment) {
            this.doRemove(((biouml.model.Compartment)de).stream().toList());
        }
        Node node = (Node)de;
        Base kernel = node.getKernel();
        DataCollection parent = node.getOrigin();
        if (kernel.getType().equals("reaction")) {
            for (Edge edge : node.edges().toList()) {
                edge.getCompartment().remove(edge.getName());
            }
        }
        parent.remove(node.getName());
        return true;
    }

    public boolean canAccept(biouml.model.Compartment compartment, DiagramElement de) {
        if (de instanceof Edge && de.getKernel() instanceof SpecieReference) {
            return true;
        }
        return super.canAccept(compartment, de);
    }

    private static class TypeDescriptor {
        private final String xmlType;
        private final String type;
        private final Class<?> typeClass;

        public TypeDescriptor(String xmlType, String type, Class<?> typeClass) {
            this.xmlType = xmlType;
            this.type = type;
            this.typeClass = typeClass;
        }

        public String getXMLType() {
            return this.xmlType;
        }

        public String getType() {
            return this.type;
        }

        public Class<?> getTypeClass() {
            return this.typeClass;
        }
    }
}

