/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.dynamics.EModel;
import biouml.plugins.sbml.SbmlModelWriter;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import java.util.List;
import org.w3c.dom.Element;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstFunNode;
import ru.biosoft.math.model.AstStart;

public class SbmlModelWriter_L1
extends SbmlModelWriter {
    @Override
    protected void initContext() {
    }

    @Override
    protected Element createSpecieElement() {
        return this.document.createElement("specie");
    }

    @Override
    protected void setLevel(Element sbmlElement) {
        sbmlElement.setAttribute("level", "1");
    }

    @Override
    protected void setVersion(Element sbmlElement) {
        sbmlElement.setAttribute("version", "1");
    }

    @Override
    protected void setId(Element element, String name) {
        element.setAttribute("name", name);
    }

    @Override
    protected void setTitle(Element element, String name) {
    }

    @Override
    protected boolean validCompartmentList(List compartmentList) {
        return compartmentList.size() > 0;
    }

    @Override
    protected boolean validReaction(Node reaction) {
        int counterReactant = 0;
        int counterProduct = 0;
        for (SpecieReference species : (Reaction)reaction.getKernel()) {
            if (species.getRole().equals("reactant")) {
                ++counterReactant;
            }
            if (!species.getRole().equals("product")) continue;
            ++counterProduct;
        }
        if (counterReactant > 0 && counterProduct > 0) {
            return true;
        }
        this.error("ERROR_REACTION_INVALID", new String[]{this.diagram.getName(), reaction.getName()});
        return false;
    }

    @Override
    protected void writeFunctionDefinitionList(Element model) {
        this.error("ERROR_FUNCTION_DEFINITIONS_NOT_SUPPORTED", new String[]{this.diagram.getName()});
    }

    @Override
    protected void writeRuleList(Element model) {
    }

    @Override
    protected void writeInitialAssignmentList(Element model) {
    }

    @Override
    protected void writeEventList(Element model) {
        this.error("ERROR_EVENTS_NOT_SUPPORTED", new String[]{this.diagram.getName()});
    }

    @Override
    protected void writeConstraintList(Element model) {
        this.error("ERROR_CONSTRAINTS_NOT_SUPPORTED", new String[]{this.diagram.getName()});
    }

    @Override
    protected void writeFormula(String formula, Node reaction, Element kineticLawElement) {
        if (formula != null && formula.length() > 0) {
            kineticLawElement.setAttribute("formula", formula);
        } else {
            kineticLawElement.setAttribute("formula", "0");
            this.warn("WARN_FORMULA_EMPTY", new String[]{this.diagram.getName(), reaction.getName()});
        }
    }

    @Override
    protected Element writeCompartmentList(Element model) {
        Element compartmentListElement = super.writeCompartmentList(model);
        model.appendChild(compartmentListElement);
        return compartmentListElement;
    }

    @Override
    protected Element writeSpecieList(Element model) {
        Element speciesListElement = super.writeSpecieList(model);
        model.appendChild(speciesListElement);
        return speciesListElement;
    }

    @Override
    protected Element writeReactionList(Element model) {
        Element reactionListElement = super.writeReactionList(model);
        model.appendChild(reactionListElement);
        return reactionListElement;
    }

    @Override
    protected void writeSpeciesReferenceAttributes(Element specieReferenceElement, SpecieReference species, Node reaction) {
        String stoichiometry = species.getStoichiometry();
        if (stoichiometry == null) {
            return;
        }
        String s = stoichiometry.trim();
        if (s.isEmpty()) {
            return;
        }
        AstStart start = this.emodel.readMath(s, reaction.getRole());
        if (start.jjtGetNumChildren() == 1 && start.jjtGetChild(0) instanceof AstConstant) {
            Object value = ((AstConstant)start.jjtGetChild(0)).getValue();
            if (value instanceof Integer) {
                specieReferenceElement.setAttribute("stoichiometry", "" + s);
            } else if (value instanceof Double) {
                double v = (Double)value;
                specieReferenceElement.setAttribute("stoichiometry", "" + Math.round(v * 1000.0));
                specieReferenceElement.setAttribute("denominator", "1000");
                this.warn("WARNING_WRITE_STOICHIOMETRY_11", new String[]{this.modelName, species.getName(), s, "" + Math.round(v * 1000.0) + "/1000"});
            }
            return;
        }
        if (start.jjtGetNumChildren() == 2 && start.jjtGetChild(0) instanceof AstFunNode && ((AstFunNode)start.jjtGetChild(0)).getFunction().getName().equals("/") && start.jjtGetChild(1) instanceof AstConstant && ((AstConstant)start.jjtGetChild(1)).getValue() instanceof Integer && start.jjtGetChild(2) instanceof AstConstant && ((AstConstant)start.jjtGetChild(2)).getValue() instanceof Integer) {
            specieReferenceElement.setAttribute("stoichiometry", "" + ((AstConstant)start.jjtGetChild(1)).getValue());
            specieReferenceElement.setAttribute("denominator", "" + ((AstConstant)start.jjtGetChild(1)).getValue());
            return;
        }
        this.error("ERROR_WRITE_STOICHIOMETRY_11", new String[]{this.modelName, species.getName(), s});
    }

    public static boolean isValidModel(Diagram diagram) {
        EModel emodel = (EModel)diagram.getRole();
        if (emodel == null) {
            return false;
        }
        int modelType = emodel.getModelType();
        if (EModel.isOfType((int)modelType, (int)32) || EModel.isOfType((int)modelType, (int)16) || EModel.isOfType((int)modelType, (int)8)) {
            return false;
        }
        return SbmlModelWriter_L1.hasElement((Compartment)diagram, Reaction.class) && SbmlModelWriter_L1.hasElement((Compartment)diagram, Specie.class) && SbmlModelWriter_L1.hasElement((Compartment)diagram, Compartment.class);
    }

    private static boolean hasElement(Compartment compartment, Class element) {
        for (Object obj : compartment) {
            Node node;
            if (!(element.equals(Compartment.class) ? obj instanceof Compartment : (obj instanceof Node ? element.isInstance((node = (Node)obj).getKernel()) : obj instanceof Compartment && SbmlModelWriter_L1.hasElement((Compartment)obj, element)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getSbmlNamespace() {
        return "http://www.sbml.org/sbml/level1";
    }

    @Override
    protected String getUnitsAttr() {
        return "units";
    }

    @Override
    protected String getCompartmentVolumeAttr() {
        return "volume";
    }
}

