/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelWriter_24;
import biouml.plugins.sbml.SbmlPackageRegistry;
import biouml.plugins.sbml.SbmlPackageWriter;
import biouml.standard.type.BaseUnit;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SbmlModelWriter_31
extends SbmlModelWriter_24 {
    List<SbmlPackageWriter> packageWriters;

    public void writeDiagram(Element model, Document doc, Diagram diagram) throws Exception {
        this.document = doc;
        this.diagram = diagram;
        this.initPackages(diagram, true);
        this.writeDiagram(model);
    }

    @Override
    protected Element createSBMLElement() {
        this.initPackages(this.diagram, false);
        Element sbml = super.createSBMLElement();
        sbml.setAttribute("xmlns", this.getSbmlNamespace());
        for (SbmlPackageWriter writer : this.packageWriters) {
            sbml.setAttribute("xmlns:" + writer.getPackageName(), writer.getNameSpace());
        }
        this.setLevel(sbml);
        this.setVersion(sbml);
        return sbml;
    }

    @Override
    protected void writeDiagram(Element model) throws Exception {
        for (SbmlPackageWriter writer : this.packageWriters) {
            writer.setParent(this);
            writer.setNewPaths(this.newPaths);
            writer.init(this.document, this.diagram);
            writer.preprocess(this.diagram);
        }
        super.writeDiagram(model);
        Element sbmlElement = (Element)model.getOwnerDocument().getElementsByTagName("sbml").item(0);
        for (SbmlPackageWriter writer : this.packageWriters) {
            writer.processModel(model, this.diagram);
            writer.processSBML(sbmlElement, this.diagram);
        }
    }

    protected void initPackages(Diagram diagram, boolean modelDefinition) {
        String[] packageNames;
        this.packageWriters = new ArrayList<SbmlPackageWriter>();
        DynamicProperty dp = diagram.getAttributes().getProperty("Packages");
        if (dp == null) {
            return;
        }
        for (String packageName : packageNames = (String[])dp.getValue()) {
            SbmlPackageWriter packageWriter = SbmlPackageRegistry.getWriter(packageName);
            packageWriter.setModelDefinition(modelDefinition);
            packageWriter.setWriteBioUMLAnnotation(this.writeBioUMLAnnotation);
            this.packageWriters.add(packageWriter);
        }
    }

    @Override
    protected void setLevel(Element sbmlElement) {
        sbmlElement.setAttribute("level", "3");
    }

    @Override
    protected void setVersion(Element sbmlElement) {
        sbmlElement.setAttribute("version", "1");
    }

    @Override
    protected String getSbmlNamespace() {
        return "http://www.sbml.org/sbml/level3/version1/core";
    }

    @Override
    public Element writeCompartment(Element compartmentListElement, Compartment compartment) {
        Element compartmentElement = super.writeCompartment(compartmentListElement, compartment);
        String isConstant = "false";
        if (!this.isAutoCreated(compartment) && compartment.getRole() instanceof VariableRole) {
            isConstant = Boolean.toString(((VariableRole)compartment.getRole(VariableRole.class)).isConstant());
        }
        compartmentElement.setAttribute("constant", isConstant);
        if (compartmentElement.hasAttribute("outside")) {
            compartmentElement.removeAttribute("outside");
        }
        for (SbmlPackageWriter writer : this.packageWriters) {
            if (this.isAutoCreated(compartment)) continue;
            writer.processSpecie(compartmentElement, (Node)compartment);
        }
        return compartmentElement;
    }

    @Override
    public Element writeSpecie(Element speciesListElement, Node species) {
        Element speciesElement = super.writeSpecie(speciesListElement, species);
        VariableRole role = (VariableRole)species.getRole(VariableRole.class);
        String conversionFactor = role.getConversionFactor();
        if (conversionFactor != null) {
            speciesElement.setAttribute("conversionFactor", conversionFactor);
        }
        if (!speciesElement.hasAttribute("constant")) {
            speciesElement.setAttribute("constant", Boolean.toString(role.isConstant()));
        }
        if (!speciesElement.hasAttribute("boundaryCondition")) {
            speciesElement.setAttribute("boundaryCondition", Boolean.toString(role.isBoundaryCondition()));
        }
        for (SbmlPackageWriter writer : this.packageWriters) {
            writer.processSpecie(speciesElement, species);
        }
        return speciesElement;
    }

    @Override
    public Element writeParameter(Element parameterListElement, Variable parameter) {
        Element parameterElement = super.writeParameter(parameterListElement, parameter);
        for (SbmlPackageWriter writer : this.packageWriters) {
            writer.processParameter(parameterElement, parameter);
        }
        return parameterElement;
    }

    @Override
    public Element writeReaction(Element reactionListElement, Node reaction) {
        super.writeReaction(reactionListElement, reaction);
        NodeList list = reactionListElement.getChildNodes();
        Element reactionElement = (Element)list.item(list.getLength() - 1);
        for (SbmlPackageWriter writer : this.packageWriters) {
            writer.processReaction(reactionElement, reaction);
        }
        return reactionElement;
    }

    @Override
    protected void writeReactionAttributes(Reaction reaction, Element element) {
        element.setAttribute("reversible", Boolean.toString(reaction.isReversible()));
        element.setAttribute("fast", Boolean.toString(reaction.isFast()));
    }

    @Override
    protected void writeSpeciesReferenceAttributes(Element specieReferenceElement, SpecieReference species, Node reaction) {
        VariableRole var;
        super.writeSpeciesReferenceAttributes(specieReferenceElement, species, reaction);
        if (specieReferenceElement.getNodeName().equals("speciesReference") && (var = (VariableRole)this.emodel.getVariable(species.getSpecie())) != null) {
            specieReferenceElement.setAttribute("constant", Boolean.toString(var.isConstant()));
        }
    }

    @Override
    public Element writeEvent(Event event, Element eventListElement) {
        Element element = super.writeEvent(event, eventListElement);
        if (!event.getPriority().isEmpty()) {
            Element priorityElement = this.document.createElement("priority");
            this.appendMathChild(priorityElement, event.getPriority(), (Role)event);
            element.appendChild(priorityElement);
            SbmlModelReader_21.MetaIdInfo info = SbmlModelWriter_31.getMetaId((Node)event.getDiagramElement(), "priority");
            if (info != null) {
                priorityElement.setAttribute("metaid", info.id);
            }
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals("trigger")) continue;
            Element triggerElement = (Element)childNodes.item(i);
            triggerElement.setAttribute("persistent", String.valueOf(event.isTriggerPersistent()));
            triggerElement.setAttribute("initialValue", String.valueOf(event.isTriggerInitialValue()));
        }
        return element;
    }

    @Override
    protected void writeModelAttributes(Element model) {
        super.writeModelAttributes(model);
        if (!"".equals(this.emodel.getConversionFactor())) {
            model.setAttribute("conversionFactor", this.emodel.getConversionFactor());
        }
        if (!"".equals(this.emodel.getLengthUnits())) {
            model.setAttribute("lengthUnits", this.emodel.getLengthUnits());
        }
        if (!"".equals(this.emodel.getAreaUnits())) {
            model.setAttribute("areaUnits", this.emodel.getAreaUnits());
        }
        if (!"".equals(this.emodel.getVolumeUnits())) {
            model.setAttribute("volumeUnits", this.emodel.getVolumeUnits());
        }
        if (!"".equals(this.emodel.getExtentUnits())) {
            model.setAttribute("extentUnits", this.emodel.getExtentUnits());
        }
        if (!"".equals(this.emodel.getTimeUnits())) {
            model.setAttribute("timeUnits", this.emodel.getTimeUnits());
        } else if (!"".equals(this.emodel.getVariable("time").getUnits())) {
            model.setAttribute("timeUnits", this.emodel.getVariable("time").getUnits());
        }
        if (!"".equals(this.emodel.getSubstanceUnits())) {
            model.setAttribute("substanceUnits", this.emodel.getSubstanceUnits());
        }
    }

    @Override
    public Element writeBaseUnit(BaseUnit baseUnit, Element baseUnitsListElement) {
        Element baseUnitElement = this.document.createElement("unit");
        baseUnitsListElement.appendChild(baseUnitElement);
        baseUnitElement.setAttribute("kind", baseUnit.getType());
        baseUnitElement.setAttribute("exponent", Integer.toString(baseUnit.getExponent()));
        baseUnitElement.setAttribute("scale", Integer.toString(baseUnit.getScale()));
        baseUnitElement.setAttribute("multiplier", Double.toString(baseUnit.getMultiplier()));
        return baseUnitElement;
    }
}

