/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlWriter;
import biouml.plugins.sbml.SbmlModelWriter_21;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Compartment;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import ru.biosoft.access.core.DataCollection;

public class SbmlModelWriter_22
extends SbmlModelWriter_21 {
    @Override
    protected void writeModelAttributes(Element model) {
        super.writeModelAttributes(model);
        SbmlModelWriter_22.writeSBOTerm(model, this.diagram.getAttributes());
    }

    @Override
    protected void setVersion(Element sbmlElement) {
        sbmlElement.setAttribute("version", "2");
    }

    @Override
    protected void writeCompartmentTypeList(Element model) {
        Element cTypeListElement = this.document.createElement("listOfCompartmentTypes");
        ArrayList<String> compartmentTypes = new ArrayList<String>();
        for (biouml.model.Compartment compartment : this.compartmentList) {
            BaseSupport cType = (BaseSupport)compartment.getAttributes().getValue("compartmentType");
            if (cType == null) continue;
            if (compartmentTypes.size() == 0) {
                model.appendChild(cTypeListElement);
            }
            if (compartmentTypes.contains(cType.getName())) continue;
            Element cTypeElement = this.document.createElement("compartmentType");
            this.setId(cTypeElement, cType.getName());
            String title = cType.getTitle();
            if (title != null && title.length() > 0) {
                cTypeElement.setAttribute("name", cType.getTitle());
            }
            cTypeListElement.appendChild(cTypeElement);
            compartmentTypes.add(cType.getName());
        }
    }

    @Override
    public Element writeCompartment(Element compartmentListElement, biouml.model.Compartment compartment) {
        boolean isConstant;
        DataCollection parent;
        Element compartmentElement = this.document.createElement("compartment");
        compartmentListElement.appendChild(compartmentElement);
        this.setId(compartmentElement, this.getSbmlId((Node)compartment));
        this.setTitle(compartmentElement, compartment.getTitle());
        BaseSupport cType = (BaseSupport)compartment.getAttributes().getValue("compartmentType");
        if (cType != null) {
            compartmentElement.setAttribute("compartmentType", cType.getName());
        }
        SbmlModelWriter_22.writeSBOTerm(compartmentElement, compartment.getAttributes());
        this.writeNotes(compartmentElement, compartment.getComment());
        if (compartment != this.diagram && (parent = compartment.getOrigin()) != null && !parent.getName().equals(this.diagram.getName())) {
            compartmentElement.setAttribute("outside", parent.getName());
        }
        int dimension = 3;
        if (compartment.getKernel() instanceof Compartment) {
            dimension = ((Compartment)compartment.getKernel()).getSpatialDimension();
        }
        compartmentElement.setAttribute("spatialDimensions", String.valueOf(dimension));
        if (compartment.getRole() instanceof Variable) {
            Variable var = (Variable)compartment.getRole(VariableRole.class);
            compartmentElement.setAttribute(this.getCompartmentVolumeAttr(), String.valueOf(var.getInitialValue()));
            if (var.getUnits() != null && !var.getUnits().isEmpty()) {
                compartmentElement.setAttribute("units", var.getUnits());
            }
        } else {
            compartmentElement.setAttribute(this.getCompartmentVolumeAttr(), "1");
        }
        if (!this.isAutoCreated(compartment) && !(isConstant = ((VariableRole)compartment.getRole(VariableRole.class)).isConstant())) {
            compartmentElement.setAttribute("constant", Boolean.toString(isConstant));
        }
        Element annotationElement = this.document.createElement("annotation");
        this.writeAnnotation(annotationElement, (DiagramElement)compartment);
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element compartmentInfoElement = this.document.createElement("biouml:compartmentInfo");
            DiagramXmlWriter.writeCompartmentInfo((Element)compartmentInfoElement, (biouml.model.Compartment)compartment, (Document)this.document);
            compartmentInfoElement.setAttribute("completeName", compartment.getCompleteNameInDiagram());
            if (this.isAutoCreated(compartment)) {
                compartmentInfoElement.setAttribute("isDefault", "true");
            } else {
                this.writeVariable((Variable)compartment.getRole(VariableRole.class), bioumlElement);
            }
            bioumlElement.appendChild(compartmentInfoElement);
            annotationElement.appendChild(bioumlElement);
        }
        if (annotationElement.hasChildNodes()) {
            compartmentElement.appendChild(annotationElement);
        }
        return compartmentElement;
    }

    @Override
    protected void writeSpecieTypeList(Element model) {
        List<Node> specieList = this.fillSpecieList(this.diagram);
        Element specieTypeListElement = null;
        ArrayList<String> specieTypes = new ArrayList<String>();
        for (Node specie : specieList) {
            BaseSupport sType = (BaseSupport)specie.getAttributes().getValue("speciesType");
            if (sType == null) continue;
            if (specieTypes.size() == 0) {
                specieTypeListElement = this.document.createElement("listOfSpeciesTypes");
                model.appendChild(specieTypeListElement);
            }
            if (specieTypes.contains(sType.getName())) continue;
            Element sTypeElement = this.document.createElement("speciesType");
            this.setId(sTypeElement, sType.getName());
            String title = sType.getTitle();
            if (title != null && title.length() > 0) {
                sTypeElement.setAttribute("name", sType.getTitle());
            }
            specieTypeListElement.appendChild(sTypeElement);
            specieTypes.add(sType.getName());
        }
    }

    @Override
    public Element writeFunction(Function function, Element functionListElement) {
        Element element = super.writeFunction(function, functionListElement);
        DiagramElement de = function.getDiagramElement();
        if (de != null) {
            SbmlModelWriter_22.writeSBOTerm(element, de.getAttributes());
        }
        return element;
    }

    @Override
    public Element writeRule(Equation equation, Element ruleListElement) {
        DiagramElement de;
        Element element = super.writeRule(equation, ruleListElement);
        if (element != null && (de = equation.getDiagramElement()) != null) {
            SbmlModelWriter_22.writeSBOTerm(element, de.getAttributes());
        }
        return element;
    }

    @Override
    public Element writeInitialAssignment(Equation assignment, Element initialAssignmentsListElement) {
        DiagramElement de;
        Element element = super.writeInitialAssignment(assignment, initialAssignmentsListElement);
        if (element != null && (de = assignment.getDiagramElement()) != null) {
            SbmlModelWriter_22.writeSBOTerm(element, de.getAttributes());
        }
        return element;
    }

    @Override
    public Element writeEvent(Event event, Element eventListElement) {
        Element element = super.writeEvent(event, eventListElement);
        DiagramElement de = event.getDiagramElement();
        if (de != null) {
            SbmlModelWriter_22.writeSBOTerm(element, de.getAttributes());
        }
        return element;
    }

    @Override
    public Element writeReaction(Element reactionListElement, Node reaction) {
        Element element = super.writeReaction(reactionListElement, reaction);
        if (element != null) {
            SbmlModelWriter_22.writeSBOTerm(element, reaction.getAttributes());
        }
        return element;
    }

    @Override
    protected void writeConstraintList(Element modelElement) {
        Element constraintListElement = this.document.createElement("listOfConstraints");
        for (Constraint constraint : this.emodel.getConstraints()) {
            try {
                this.writeConstraint(constraint, constraintListElement);
            }
            catch (Throwable t) {
                this.error("ERROR_PROCESSING_CONSTRAINT", new String[]{this.diagram.getName(), constraint.getDiagramElement() != null ? constraint.getDiagramElement().getName() : null, t.getMessage()});
            }
        }
        if (constraintListElement.hasChildNodes()) {
            modelElement.appendChild(constraintListElement);
        }
    }

    @Override
    public Element writeConstraint(Constraint constraint, Element constraintListElement) {
        Element constraintElement = this.document.createElement("constraint");
        Node node = (Node)constraint.getDiagramElement();
        constraintElement.setAttribute("id", node.getName());
        Element annotationElement = this.document.createElement("annotation");
        this.writeAnnotation(annotationElement, (DiagramElement)node);
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
            DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)node, (Document)this.document);
            nodeInfoElement.setAttribute("completeName", node.getCompleteNameInDiagram());
            bioumlElement.appendChild(nodeInfoElement);
            annotationElement.appendChild(bioumlElement);
        }
        if (annotationElement.hasChildNodes()) {
            constraintElement.appendChild(annotationElement);
        }
        this.appendMathChild(constraintElement, constraint.getFormula(), (Role)constraint);
        String message = constraint.getMessage();
        if (!message.isEmpty()) {
            Element messageElement = this.document.createElement("message");
            Element pElement = this.document.createElement("p");
            Text text = this.document.createTextNode(message);
            pElement.appendChild(text);
            pElement.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            messageElement.appendChild(pElement);
            constraintElement.appendChild(messageElement);
        }
        constraintListElement.appendChild(constraintElement);
        return constraintElement;
    }
}

