/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Assignment;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlWriter;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelWriter;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Compartment;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.filter.Filter;
import ru.biosoft.math.model.AstConstant;
import ru.biosoft.math.model.AstStart;
import ru.biosoft.math.model.ParserContext;
import ru.biosoft.math.parser.Parser;
import ru.biosoft.math.xml.MathMLFormatter;

public class SbmlModelWriter_21
extends SbmlModelWriter {
    MathMLFormatter mathMLFormatter = new MathMLFormatter();

    public SbmlModelWriter_21() {
        this.mathMLFormatter.declareCSymbol("time", "http://www.sbml.org/sbml/symbols/time");
        this.mathMLFormatter.declareCSymbol("delay", "http://www.sbml.org/sbml/symbols/delay");
        this.mathMLFormatter.declareCSymbol("avogadro", "http://www.sbml.org/sbml/symbols/avogadro");
    }

    @Override
    protected void initContext() {
        this.mathMLFormatter.setParserContext((ParserContext)((EModel)this.diagram.getRole()));
    }

    @Override
    protected Element createSpecieElement() {
        return this.document.createElement("species");
    }

    @Override
    protected void setLevel(Element sbmlElement) {
        sbmlElement.setAttribute("level", "2");
    }

    @Override
    protected void setVersion(Element sbmlElement) {
        sbmlElement.setAttribute("version", "1");
    }

    @Override
    protected void setId(Element element, String id) {
        element.setAttribute("id", id);
    }

    @Override
    protected void setTitle(Element element, String id) {
        element.setAttribute("name", id);
    }

    @Override
    protected boolean validCompartmentList(List compartmentList) {
        return true;
    }

    @Override
    protected boolean validReaction(Node reaction) {
        int counter = 0;
        for (SpecieReference species : (Reaction)reaction.getKernel()) {
            if (!species.isReactant() && !species.isProduct()) continue;
            ++counter;
        }
        if (counter > 0) {
            return true;
        }
        this.error("ERROR_REACTION_INVALID", new String[]{this.diagram.getName(), reaction.getName()});
        return false;
    }

    protected void appendMathChild(Element element, String formula, Role role) {
        try {
            EModel emodel = (EModel)this.diagram.getRole(EModel.class);
            Parser oldParser = emodel.getParser();
            emodel.setParser((Parser)new WriterParser(oldParser));
            String math = this.parseFormula(formula, (Node)role.getDiagramElement());
            AstStart astStart = emodel.readMath(math, role);
            emodel.setParser(oldParser);
            if (this.mathMLFormatter.getParserContext() != emodel) {
                this.mathMLFormatter.setParserContext((ParserContext)emodel);
            }
            this.mathMLFormatter.format(astStart, (org.w3c.dom.Node)element, this.document);
        }
        catch (Throwable t) {
            this.error("ERROR_CREATING_MATH_ELEMENT", new String[]{this.diagram.getName(), formula, t.getMessage()});
        }
    }

    @Override
    protected void writeModelAttributes(Element model) {
        DynamicProperty dp = this.diagram.getAttributes().getProperty("id");
        if (dp != null && dp.getType().equals(String.class)) {
            this.setId(model, dp.getValue().toString());
        } else {
            this.setId(model, this.getSbmlId((Node)this.diagram));
        }
        dp = this.diagram.getAttributes().getProperty("metaid");
        if (dp != null && dp.getType().equals(String.class)) {
            model.setAttribute("metaid", dp.getValue().toString());
        }
        model.setAttribute("name", this.diagram.getTitle());
    }

    @Override
    public Element writeSpecie(Element speciesListElement, Node species) {
        try {
            biouml.model.Compartment parent;
            BaseSupport sType;
            boolean initialSubstance;
            VariableRole role;
            Element speciesElement = this.createSpecieElement();
            speciesListElement.appendChild(speciesElement);
            this.setId(speciesElement, this.getSbmlId(species));
            if (species.getTitle() != null && !species.getName().equals(species.getTitle())) {
                this.setTitle(speciesElement, species.getTitle());
            }
            if ((role = (VariableRole)species.getRole(VariableRole.class)).isConstant()) {
                speciesElement.setAttribute("constant", Boolean.toString(role.isConstant()));
            }
            if (role.isBoundaryCondition()) {
                speciesElement.setAttribute("boundaryCondition", Boolean.toString(role.isBoundaryCondition()));
            }
            boolean hasOnlySubstanceUnits = role.getQuantityType() == 0;
            speciesElement.setAttribute("hasOnlySubstanceUnits", String.valueOf(hasOnlySubstanceUnits));
            boolean bl = initialSubstance = role.getInitialQuantityType() == 0;
            if (initialSubstance) {
                speciesElement.setAttribute("initialAmount", String.valueOf(role.getInitialValue()));
            } else {
                speciesElement.setAttribute("initialConcentration", String.valueOf(role.getInitialValue()));
            }
            if (role.getUnits() != null && !role.getUnits().isEmpty()) {
                speciesElement.setAttribute("substanceUnits", role.getUnits());
            }
            if ((sType = (BaseSupport)species.getAttributes().getValue("speciesType")) != null) {
                speciesElement.setAttribute("speciesType", sType.getName());
            }
            String compartment = (parent = (biouml.model.Compartment)species.getOrigin()) instanceof Diagram ? this.defaultCompartmentName : this.getSbmlId((Node)parent);
            speciesElement.setAttribute("compartment", compartment);
            Specie speciesKernel = null;
            if (species.getKernel() instanceof Specie && (speciesKernel = (Specie)species.getKernel()).getCharge() != 0) {
                speciesElement.setAttribute("charge", "" + speciesKernel.getCharge());
            }
            Element annotationElement = this.document.createElement("annotation");
            this.writeAnnotation(annotationElement, (DiagramElement)species);
            if (this.writeBioUMLAnnotation) {
                Element bioumlElement = this.document.createElement("biouml:BIOUML");
                bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)species, (Document)this.document);
                nodeInfoElement.setAttribute("completeName", species.getCompleteNameInDiagram());
                bioumlElement.appendChild(nodeInfoElement);
                if (species.getKernel() != null && species.getKernel() instanceof Specie && !(speciesKernel = (Specie)species.getKernel()).getType().equals("molecule")) {
                    Element speciesInfoElement = this.document.createElement("biouml:specieInfo");
                    speciesInfoElement.setAttribute("type", speciesKernel.getType());
                    DiagramXmlWriter.serializeDPS((Document)this.document, (Element)speciesInfoElement, (DynamicPropertySet)speciesKernel.getAttributes(), null);
                    this.writeVariable((Variable)species.getRole(VariableRole.class), bioumlElement);
                    bioumlElement.appendChild(speciesInfoElement);
                }
                annotationElement.appendChild(bioumlElement);
            }
            if (annotationElement.hasChildNodes()) {
                speciesElement.appendChild(annotationElement);
            }
            return speciesElement;
        }
        catch (Throwable t) {
            this.error("ERROR_SPECIE_WRITING", new String[]{this.diagram.getName(), species.getName(), t.getMessage()});
            return null;
        }
    }

    @Override
    protected void writeFunctionDefinitionList(Element modelElement) {
        Element functionList = this.document.createElement("listOfFunctionDefinitions");
        for (Function function : this.emodel.getFunctions()) {
            try {
                this.writeFunction(function, functionList);
            }
            catch (Throwable t) {
                this.error("ERROR_FUNCTION_DECLARATION_PROCESSING", new String[]{this.diagram.getName(), function.getDiagramElement().getName(), t.getMessage()});
            }
        }
        if (functionList.hasChildNodes()) {
            modelElement.appendChild(functionList);
        }
    }

    @Override
    public Element writeFunction(Function function, Element functionListElement) {
        Element functionDefinitonElement = this.document.createElement("functionDefinition");
        Node node = (Node)function.getDiagramElement();
        functionDefinitonElement.setAttribute("id", function.getName());
        Element annotationElement = this.document.createElement("annotation");
        this.writeAnnotation(annotationElement, (DiagramElement)node);
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
            DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)node, (Document)this.document);
            nodeInfoElement.setAttribute("completeName", node.getCompleteNameInDiagram());
            bioumlElement.appendChild(nodeInfoElement);
            annotationElement.appendChild(bioumlElement);
        }
        if (annotationElement.hasChildNodes()) {
            functionDefinitonElement.appendChild(annotationElement);
        }
        this.appendMathChild(functionDefinitonElement, function.getFormula(), (Role)function);
        functionListElement.appendChild(functionDefinitonElement);
        return functionDefinitonElement;
    }

    @Override
    protected Element writeCompartmentList(Element model) {
        Element compartmentListElement = super.writeCompartmentList(model);
        if (compartmentListElement.hasChildNodes()) {
            model.appendChild(compartmentListElement);
        }
        return compartmentListElement;
    }

    @Override
    public Element writeCompartment(Element compartmentListElement, biouml.model.Compartment compartment) {
        boolean isConstant;
        Element compartmentElement = super.writeCompartment(compartmentListElement, compartment);
        int dimension = ((Compartment)compartment.getKernel()).getSpatialDimension();
        compartmentElement.setAttribute("spatialDimensions", String.valueOf(dimension));
        if (!this.isAutoCreated(compartment) && !(isConstant = ((VariableRole)compartment.getRole(VariableRole.class)).isConstant())) {
            compartmentElement.setAttribute("constant", Boolean.toString(isConstant));
        }
        return compartmentElement;
    }

    @Override
    protected Element writeSpecieList(Element model) {
        Element speciesListElement = super.writeSpecieList(model);
        if (speciesListElement.hasChildNodes()) {
            model.appendChild(speciesListElement);
        }
        return speciesListElement;
    }

    @Override
    protected Element writeReactionList(Element model) {
        Element reactionListElement = this.document.createElement("listOfReactions");
        this.writeReactionList(reactionListElement, (biouml.model.Compartment)this.diagram);
        if (reactionListElement.hasChildNodes()) {
            model.appendChild(reactionListElement);
        }
        return reactionListElement;
    }

    @Override
    protected void writeRuleList(Element modelElement) {
        Element ruleListElement = this.document.createElement("listOfRules");
        for (Equation eq : this.emodel.getEquations((Filter)new EModel.NotInitialAssignmentsFilter())) {
            try {
                this.writeRule(eq, ruleListElement);
            }
            catch (Throwable t) {
                this.error("ERROR_RULE_PROCESSING", new String[]{this.diagram.getName(), eq.getFormula(), t.getMessage()});
            }
        }
        if (ruleListElement.hasChildNodes()) {
            modelElement.appendChild(ruleListElement);
        }
    }

    @Override
    public Element writeRule(Equation equation, Element ruleListElement) {
        if (equation.getDiagramElement().getKernel().getType().equals("math-equation")) {
            Node ruleNode = (Node)equation.getDiagramElement();
            Element ruleElement = null;
            if (equation.getType().equals("algebraic")) {
                ruleElement = this.document.createElement("algebraicRule");
            } else {
                Element element = equation.getType().equals("rate") ? this.document.createElement("rateRule") : (ruleElement = equation.getType().equals("scalar") ? this.document.createElement("assignmentRule") : null);
                if (ruleElement == null) {
                    throw new IllegalStateException("Invalid equation type: " + equation.getType() + " (equation is " + equation + ")");
                }
                String variableName = this.castVariableNameToSId(equation.getVariable());
                ruleElement.setAttribute("variable", variableName);
            }
            SbmlModelReader_21.MetaIdInfo info = SbmlModelWriter_21.getMetaId(ruleNode, null);
            if (info != null) {
                ruleElement.setAttribute("metaid", info.id);
            }
            Element annotationElement = this.document.createElement("annotation");
            if (this.writeBioUMLAnnotation) {
                Element bioumlElement = this.document.createElement("biouml:BIOUML");
                bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)ruleNode, (Document)this.document);
                nodeInfoElement.setAttribute("completeName", ruleNode.getCompleteNameInDiagram());
                bioumlElement.appendChild(nodeInfoElement);
                annotationElement.appendChild(bioumlElement);
            }
            if (annotationElement.hasChildNodes()) {
                ruleElement.appendChild(annotationElement);
            }
            this.appendMathChild(ruleElement, equation.getFormula(), (Role)equation);
            ruleListElement.appendChild(ruleElement);
            return ruleElement;
        }
        return null;
    }

    @Override
    protected void writeInitialAssignmentList(Element modelElement) {
        Element initialAssignmentsList = this.document.createElement("listOfInitialAssignments");
        for (Equation assignment : this.emodel.getInitialAssignments()) {
            try {
                this.writeInitialAssignment(assignment, initialAssignmentsList);
            }
            catch (Throwable t) {
                this.error("ERROR_INITIAL_ASSIGNMENT_PROCESSING", new String[]{this.diagram.getName(), assignment.getFormula(), t.getMessage()});
            }
        }
        if (initialAssignmentsList.hasChildNodes()) {
            modelElement.appendChild(initialAssignmentsList);
        }
    }

    @Override
    public Element writeInitialAssignment(Equation assignment, Element initialAssignmentsListElement) {
        if (assignment.getDiagramElement().getKernel().getType().equals("math-equation")) {
            Node assignmentNode = (Node)assignment.getDiagramElement();
            Element assignmentElement = this.document.createElement("initialAssignment");
            Element annotationElement = this.document.createElement("annotation");
            if (assignmentNode.getName() != null) {
                assignmentElement.setAttribute("metaid", this.getSbmlId(assignmentNode));
            }
            if (this.writeBioUMLAnnotation) {
                Element bioumlElement = this.document.createElement("biouml:BIOUML");
                bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)assignmentNode, (Document)this.document);
                nodeInfoElement.setAttribute("completeName", assignmentNode.getCompleteNameInDiagram());
                bioumlElement.appendChild(nodeInfoElement);
                annotationElement.appendChild(bioumlElement);
            }
            if (annotationElement.hasChildNodes()) {
                assignmentElement.appendChild(annotationElement);
            }
            String variableName = this.castVariableNameToSId(assignment.getVariable());
            assignmentElement.setAttribute("symbol", variableName);
            this.appendMathChild(assignmentElement, assignment.getFormula(), (Role)assignment);
            initialAssignmentsListElement.appendChild(assignmentElement);
            return assignmentElement;
        }
        return null;
    }

    @Override
    protected void writeEventList(Element modelElement) {
        Element eventListElement = this.document.createElement("listOfEvents");
        for (Event event : this.emodel.getEvents()) {
            try {
                this.writeEvent(event, eventListElement);
            }
            catch (Throwable t) {
                this.error("ERROR_PROCESSING_EVENT", new String[]{this.diagram.getName(), event.getDiagramElement().getName(), t.getMessage()});
            }
        }
        if (eventListElement.hasChildNodes()) {
            modelElement.appendChild(eventListElement);
        }
    }

    @Override
    public Element writeEvent(Event event, Element eventListElement) {
        SbmlModelReader_21.MetaIdInfo info;
        Element eventElement = this.document.createElement("event");
        Node node = (Node)event.getDiagramElement();
        if (node.getName() != null) {
            eventElement.setAttribute("id", this.getSbmlId(node));
        }
        if ((info = SbmlModelWriter_21.getMetaId(node, null)) != null) {
            eventElement.setAttribute("metaid", info.id);
        }
        if (node.getComment() != null && node.getComment().length() > 0) {
            eventElement.setAttribute("name", node.getComment());
        }
        if (event.getTimeUnits() != null && event.getTimeUnits().length() > 0) {
            eventElement.setAttribute("timeUnits", event.getTimeUnits());
        }
        if (event.getTrigger() != null && event.getTrigger().length() > 0) {
            Element triggerElement = this.document.createElement("trigger");
            this.appendMathChild(triggerElement, event.getTrigger(), (Role)event);
            eventElement.appendChild(triggerElement);
            info = SbmlModelWriter_21.getMetaId(node, "trigger");
            if (info != null) {
                triggerElement.setAttribute("metaid", info.id);
            }
        }
        if (event.getDelay() != null && event.getDelay().length() > 0 && !"0".equals(event.getDelay())) {
            Element delayElement = this.document.createElement("delay");
            this.appendMathChild(delayElement, event.getDelay(), (Role)event);
            eventElement.appendChild(delayElement);
            info = SbmlModelWriter_21.getMetaId(node, "delay");
            if (info != null) {
                delayElement.setAttribute("metaid", info.id);
            }
        }
        Element annotationElement = this.document.createElement("annotation");
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
            Node ruleNode = (Node)event.getDiagramElement();
            DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)ruleNode, (Document)this.document);
            nodeInfoElement.setAttribute("completeName", node.getCompleteNameInDiagram());
            bioumlElement.appendChild(nodeInfoElement);
            annotationElement.appendChild(bioumlElement);
        }
        if (annotationElement.hasChildNodes()) {
            eventElement.appendChild(annotationElement);
        }
        this.writeEventAssignmentList(event, eventElement);
        eventListElement.appendChild(eventElement);
        return eventElement;
    }

    protected void writeEventAssignmentList(Event event, Element eventElement) {
        Element eventAssignmentListElement = this.document.createElement("listOfEventAssignments");
        Node node = (Node)event.getDiagramElement();
        Assignment[] assignments = event.getEventAssignment();
        for (int i = 0; i < assignments.length; ++i) {
            try {
                Element eventAssignmentElement = this.writeAssignment(assignments[i], eventAssignmentListElement);
                eventAssignmentListElement.appendChild(eventAssignmentElement);
                SbmlModelReader_21.MetaIdInfo info = SbmlModelWriter_21.getMetaId(node, "eventAssignment", i);
                if (info == null) continue;
                eventAssignmentElement.setAttribute("metaid", info.id);
                continue;
            }
            catch (Throwable t) {
                this.error("ERROR_PROCESSING_ASSIGNMENT", new String[]{this.diagram.getName(), event.getDiagramElement() != null ? event.getDiagramElement().getName() : null, t.getMessage()});
            }
        }
        if (eventAssignmentListElement.hasChildNodes()) {
            eventElement.appendChild(eventAssignmentListElement);
        }
    }

    protected Element writeAssignment(Assignment assignment, Element eventAssignmentListElement) {
        Element eventAssignmentElement = this.document.createElement("eventAssignment");
        String variableName = this.castVariableNameToSId(assignment.getVariable());
        eventAssignmentElement.setAttribute("variable", variableName);
        this.appendMathChild(eventAssignmentElement, assignment.getMath(), assignment.getRole());
        return eventAssignmentElement;
    }

    @Override
    protected void writeFormula(String formula, Node reaction, Element kineticLawElement) {
        this.appendMathChild(kineticLawElement, formula, reaction.getRole());
    }

    @Override
    protected void writeSpeciesReferenceAttributes(Element specieReferenceElement, SpecieReference species, Node reaction) {
        String s = species.getStoichiometry();
        if (s == null) {
            return;
        }
        if ((s = s.trim()).isEmpty()) {
            return;
        }
        AstStart start = this.emodel.readMath(s, reaction.getRole());
        if (start.jjtGetNumChildren() == 1 && start.jjtGetChild(0) instanceof AstConstant) {
            specieReferenceElement.setAttribute("stoichiometry", "" + ((AstConstant)start.jjtGetChild(0)).getValue());
        } else {
            Element stoichiometryMathElement = this.document.createElement("stoichiometryMath");
            this.appendMathChild(stoichiometryMathElement, s, reaction.getRole());
            specieReferenceElement.appendChild(stoichiometryMathElement);
        }
    }

    @Override
    protected void writeConstraintList(Element model) {
        if (this.emodel.getConstraints().length > 0) {
            this.log.info("Constraints in the model " + this.diagram.getName() + " are not supported by target SBML level and will be ignored");
        }
    }

    @Override
    protected void writeModifiers(Element reactionElement, Node reaction) {
        Element modifierListElement = this.document.createElement("listOfModifiers");
        this.writeSpecieReferences(modifierListElement, reaction, "modifier", "modifierSpeciesReference");
        if (modifierListElement.getFirstChild() != null) {
            reactionElement.appendChild(modifierListElement);
        }
    }

    @Override
    protected void writeReactants(Element reactionElement, Node reaction) {
        Element reactantListElement = this.document.createElement("listOfReactants");
        this.writeSpecieReferences(reactantListElement, reaction, "reactant");
        if (reactantListElement.hasChildNodes()) {
            reactionElement.appendChild(reactantListElement);
        }
    }

    @Override
    protected void writeProducts(Element reactionElement, Node reaction) {
        Element productListElement = this.document.createElement("listOfProducts");
        this.writeSpecieReferences(productListElement, reaction, "product");
        if (productListElement.hasChildNodes()) {
            reactionElement.appendChild(productListElement);
        }
    }

    protected String castVariableNameToSId(String variableName) {
        if (this.emodel.containsVariable(variableName)) {
            return this.getSbmlId(this.emodel.getVariable(variableName));
        }
        return SbmlModelWriter_21.castStringToSId(variableName);
    }

    public static boolean isValidModel(Diagram diagram) {
        EModel emodel = (EModel)diagram.getRole();
        if (emodel == null) {
            return false;
        }
        int modelType = emodel.getModelType();
        return !EModel.isOfType((int)modelType, (int)32);
    }

    @Override
    protected String getSbmlNamespace() {
        return "http://www.sbml.org/sbml/level2";
    }

    @Override
    protected String getUnitsAttr() {
        return "substanceUnits";
    }

    @Override
    protected String getCompartmentVolumeAttr() {
        return "size";
    }

    public static SbmlModelReader_21.MetaIdInfo getMetaId(Node node, String propertyName, int index) {
        DynamicProperty dp = node.getAttributes().getProperty("metaid");
        if (dp == null) {
            return null;
        }
        List infos = (List)dp.getValue();
        for (SbmlModelReader_21.MetaIdInfo info : infos) {
            if (propertyName == null || !propertyName.equals(info.getProperty()) || index != info.index) continue;
            return info;
        }
        return null;
    }

    public static SbmlModelReader_21.MetaIdInfo getMetaId(Node node, String propertyName) {
        DynamicProperty dp = node.getAttributes().getProperty("metaid");
        if (dp == null) {
            return null;
        }
        List infos = (List)dp.getValue();
        for (SbmlModelReader_21.MetaIdInfo info : infos) {
            if (propertyName != null && propertyName.equals(info.getProperty())) {
                return info;
            }
            if (propertyName != null || info.getProperty() != null) continue;
            return info;
        }
        return null;
    }

    class FunctionParser
    extends Parser {
        public FunctionParser(Parser prototype) {
            this.setContext(prototype.getContext());
            this.setDeclareUndefinedVariables(false);
        }

        protected String processVariable(String varName) {
            return varName;
        }
    }

    class WriterParser
    extends Parser {
        public WriterParser(Parser prototype) {
            this.setContext(prototype.getContext());
            this.setDeclareUndefinedVariables(false);
        }

        protected String processVariable(String varName) {
            return SbmlModelWriter_21.this.castVariableNameToSId(varName);
        }
    }
}

