/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.DefaultSemanticController;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.dynamics.Constraint;
import biouml.model.dynamics.Equation;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Function;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.model.util.DiagramXmlWriter;
import biouml.plugins.sbml.MessageBundle;
import biouml.plugins.sbml.SbmlEModel;
import biouml.plugins.sbml.SbmlSupport;
import biouml.plugins.sbml.extensions.SbmlAnnotationRegistry;
import biouml.plugins.sbml.extensions.SbmlExtension;
import biouml.standard.diagram.Util;
import biouml.standard.type.Base;
import biouml.standard.type.BaseUnit;
import biouml.standard.type.Compartment;
import biouml.standard.type.DiagramInfo;
import biouml.standard.type.KineticLaw;
import biouml.standard.type.Reaction;
import biouml.standard.type.Specie;
import biouml.standard.type.SpecieReference;
import biouml.standard.type.Unit;
import com.developmentontheedge.beans.DynamicProperty;
import com.developmentontheedge.beans.DynamicPropertySet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import one.util.streamex.StreamEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.biosoft.access.core.DataCollection;

public abstract class SbmlModelWriter
extends SbmlSupport {
    protected Document document;
    protected List<biouml.model.Compartment> compartmentList;
    protected String defaultCompartmentName;
    protected Element speciesListElement;
    protected boolean doReactantStub = false;
    protected boolean doProductStub = false;
    protected boolean writeBioUMLAnnotation = true;
    protected Map<String, SbmlExtension> annotationsExtensions = null;
    protected Set<String> sbmlIds;
    protected Map<Node, String> nodeToSbmlIds;
    protected Map<Variable, String> parameterToSbmlIds;

    public void setWriteBioUMLAnnotation(boolean writeBioUMLAnnotation) {
        this.writeBioUMLAnnotation = writeBioUMLAnnotation;
    }

    public boolean isWriteBioUMLAnnotation() {
        return this.writeBioUMLAnnotation;
    }

    abstract void writeSpeciesReferenceAttributes(Element var1, SpecieReference var2, Node var3);

    public SbmlModelWriter() {
        this.log = Logger.getLogger(SbmlModelWriter.class.getName());
    }

    protected abstract void setLevel(Element var1);

    protected abstract void setVersion(Element var1);

    protected abstract String getSbmlNamespace();

    protected abstract String getUnitsAttr();

    protected abstract String getCompartmentVolumeAttr();

    protected abstract void setId(Element var1, String var2);

    protected abstract void setTitle(Element var1, String var2);

    protected abstract void initContext();

    protected abstract boolean validCompartmentList(List var1);

    protected abstract boolean validReaction(Node var1);

    protected Element createSBMLElement() {
        Element sbml = this.document.createElement("sbml");
        sbml.setAttribute("xmlns", this.getSbmlNamespace());
        this.setLevel(sbml);
        this.setVersion(sbml);
        return sbml;
    }

    public Document createDOM(Diagram sourceDiagram) throws Exception {
        if (sourceDiagram == null) {
            this.error("ERROR_DIAGRAM_NULL", new String[0]);
            throw new NullPointerException(MessageBundle.resources.getResourceString("ERROR_DIAGRAM_NULL"));
        }
        this.diagram = sourceDiagram;
        this.modelName = this.diagram.getName();
        this.initContext();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        Element element = this.createSBMLElement();
        this.document.appendChild(element);
        Element model = this.document.createElement("model");
        element.appendChild(model);
        this.writeDiagram(model);
        return this.document;
    }

    public void writeNotes(Element element, String notes) {
        if (notes == null || notes.isEmpty()) {
            return;
        }
        Element notesElement = this.document.createElement("notes");
        element.appendChild(notesElement);
        this.writeXhtml(this.document, notesElement, notes);
    }

    protected void writeDiagram(Element model) throws Exception {
        this.sbmlIds = new HashSet<String>();
        this.nodeToSbmlIds = new HashMap<Node, String>();
        this.parameterToSbmlIds = new HashMap<Variable, String>();
        this.compartmentList = SbmlModelWriter.fillCompartmentList(this.diagram);
        if (this.diagram.getKernel() instanceof DiagramInfo) {
            DiagramInfo info = (DiagramInfo)this.diagram.getKernel();
            this.writeNotes(model, info.getDescription());
        }
        this.emodel = (SbmlEModel)this.diagram.getRole();
        this.writeModelAttributes(model);
        Element annotationElement = this.document.createElement("annotation");
        this.writeAnnotation(annotationElement, (DiagramElement)this.diagram);
        if (this.writeBioUMLAnnotation) {
            this.writeBioUMLAnnotation(annotationElement);
        }
        if (annotationElement.hasChildNodes()) {
            model.appendChild(annotationElement);
        }
        this.writeFunctionDefinitionList(model);
        this.writeUnitList(model);
        this.writeCompartmentTypeList(model);
        this.writeCompartmentList(model);
        this.writeSpecieTypeList(model);
        this.writeSpecieList(model);
        this.writeParameterList(model);
        this.writeInitialAssignmentList(model);
        this.writeRuleList(model);
        this.writeReactionList(model);
        this.writeEventList(model);
        this.writeConstraintList(model);
    }

    private void writeBioUMLAnnotation(Element annotationElement) {
        Element plots;
        Element bioumlElement = this.document.createElement("biouml:BIOUML");
        bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
        Element diagrammInfoElement = this.document.createElement("biouml:diagramInfo");
        bioumlElement.appendChild(diagrammInfoElement);
        Element element = this.document.createElement("biouml:viewOptions");
        element.setAttribute("dependencyEdges", String.valueOf(this.diagram.getViewOptions().isDependencyEdges()));
        element.setAttribute("autoLayout", String.valueOf(this.diagram.getViewOptions().isAutoLayout()));
        Element simulationInfoElement = DiagramXmlWriter.writeSimulationOptions((Document)this.document, (String)"biouml:simulationInfo", (Diagram)this.diagram);
        if (simulationInfoElement != null) {
            bioumlElement.appendChild(simulationInfoElement);
        }
        if ((plots = DiagramXmlWriter.writePlotsInfo((Document)this.document, (String)"biouml:plotInfo", (Diagram)this.diagram, (Map)this.newPaths)) != null) {
            bioumlElement.appendChild(plots);
        }
        String bioHub = this.diagram.getAttributes().getValueAsString("bioHub");
        String refType = this.diagram.getAttributes().getValueAsString("referenceType");
        String converter = this.diagram.getAttributes().getValueAsString("converter");
        String species = this.diagram.getAttributes().getValueAsString("species");
        Element dbInfo = this.document.createElement("biouml:dbInfo");
        if (bioHub != null) {
            dbInfo.setAttribute("bioHub", bioHub);
        }
        if (refType != null) {
            dbInfo.setAttribute("referenceType", refType);
        }
        if (converter != null) {
            dbInfo.setAttribute("converter", converter);
        }
        if (species != null) {
            dbInfo.setAttribute("species", species);
        }
        if (dbInfo.hasAttributes()) {
            bioumlElement.appendChild(dbInfo);
        }
        bioumlElement.appendChild(element);
        annotationElement.appendChild(bioumlElement);
    }

    protected abstract void writeFunctionDefinitionList(Element var1);

    public Element writeFunction(Function function, Element functionListElement) {
        return null;
    }

    protected abstract void writeRuleList(Element var1);

    public Element writeRule(Equation equation, Element ruleListElement) {
        return null;
    }

    protected abstract void writeInitialAssignmentList(Element var1);

    public Element writeInitialAssignment(Equation initialAssignments, Element initialAssignmentsListElement) {
        return null;
    }

    protected abstract void writeEventList(Element var1);

    public Element writeEvent(Event event, Element eventListElement) {
        return null;
    }

    protected abstract void writeConstraintList(Element var1);

    public Element writeConstraint(Constraint constraint, Element constraintListElement) {
        return null;
    }

    protected void writeModelAttributes(Element model) {
        model.setAttribute("name", this.diagram.getTitle());
        this.setId(model, this.getSbmlId((Node)this.diagram));
    }

    protected void writeCompartmentTypeList(Element model) {
    }

    protected void writeSpecieTypeList(Element model) {
    }

    protected Element writeCompartmentList(Element model) {
        boolean includeDiagram = this.diagram.stream(Node.class).anyMatch(node -> node.getKernel() instanceof Specie && node.getParent() == this.diagram);
        if (includeDiagram) {
            this.defaultCompartmentName = DefaultSemanticController.generateUniqueNodeName((biouml.model.Compartment)this.diagram, (String)"default", (boolean)true, (String)"");
            biouml.model.Compartment defaultCompartment = new biouml.model.Compartment((DataCollection)this.diagram, this.defaultCompartmentName, (Base)new Compartment(null, this.diagram.getName()));
            this.compartmentList.add(0, defaultCompartment);
            this.setAutoCreated(defaultCompartment);
            Rectangle dRect = (Rectangle)this.diagram.stream(Node.class).append((Object)this.diagram).mapToEntry(Node::getLocation, Node::getShapeSize).mapKeyValue((loc, size) -> new Rectangle((Point)loc, size == null ? new Dimension(0, 0) : size)).reduce(Rectangle::union).get();
            defaultCompartment.setShapeSize(dRect.getSize());
        }
        Element compartmentListElement = null;
        if (this.validCompartmentList(this.compartmentList)) {
            compartmentListElement = this.document.createElement("listOfCompartments");
            for (biouml.model.Compartment compartment : this.compartmentList) {
                try {
                    this.writeCompartment(compartmentListElement, compartment);
                }
                catch (Throwable t) {
                    this.error("ERROR_COMPARTMENT_WRITING", new String[]{this.diagram.getName(), compartment != null ? compartment.getName() : "", t.getMessage()});
                }
            }
        }
        return compartmentListElement;
    }

    public Element writeCompartment(Element compartmentListElement, biouml.model.Compartment compartment) {
        Element compartmentElement = this.document.createElement("compartment");
        compartmentListElement.appendChild(compartmentElement);
        this.setId(compartmentElement, this.getSbmlId((Node)compartment));
        this.setTitle(compartmentElement, compartment.getTitle());
        if (!this.isAutoCreated(compartment)) {
            DataCollection parent = compartment.getOrigin();
            if (parent != null && !parent.getName().equals(this.diagram.getName())) {
                compartmentElement.setAttribute("outside", parent.getName());
            }
            if (compartment.getRole() != null && compartment.getRole() instanceof VariableRole) {
                Variable var = (Variable)compartment.getRole(VariableRole.class);
                compartmentElement.setAttribute(this.getCompartmentVolumeAttr(), "" + var.getInitialValue());
                if (var.getUnits() != null && !var.getUnits().equals("")) {
                    compartmentElement.setAttribute("units", var.getUnits());
                }
                this.writeNotes(compartmentElement, var.getComment());
            }
        }
        Element annotationElement = this.document.createElement("annotation");
        this.writeAnnotation(annotationElement, (DiagramElement)compartment);
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            Element compartmentInfoElement = this.document.createElement("biouml:compartmentInfo");
            DiagramXmlWriter.writeCompartmentInfo((Element)compartmentInfoElement, (biouml.model.Compartment)compartment, (Document)this.document);
            compartmentInfoElement.setAttribute("completeName", compartment.getCompleteNameInDiagram());
            if (this.isAutoCreated(compartment)) {
                compartmentInfoElement.setAttribute("isDefault", "true");
            } else {
                this.writeVariable((Variable)compartment.getRole(VariableRole.class), bioumlElement);
            }
            bioumlElement.appendChild(compartmentInfoElement);
            annotationElement.appendChild(bioumlElement);
        }
        if (annotationElement.hasChildNodes()) {
            compartmentElement.appendChild(annotationElement);
        }
        return compartmentElement;
    }

    protected Element writeSpecieList(Element model) {
        this.speciesListElement = this.document.createElement("listOfSpecies");
        for (Node node : this.fillSpecieList(this.diagram)) {
            try {
                this.writeSpecie(this.speciesListElement, node);
            }
            catch (Throwable t) {
                this.error("ERROR_SPECIE_LIST_WRITING", new String[]{this.diagram.getName(), this.diagram.getName(), t.getMessage()});
            }
        }
        return this.speciesListElement;
    }

    protected abstract Element createSpecieElement();

    public Element writeSpecie(Element speciesListElement, Node species) {
        try {
            biouml.model.Compartment parent;
            Element speciesElement = this.createSpecieElement();
            speciesListElement.appendChild(speciesElement);
            this.setId(speciesElement, this.getSbmlId(species));
            if (species.getTitle() != null) {
                this.setTitle(speciesElement, species.getTitle());
            }
            String compartment = (parent = (biouml.model.Compartment)species.getOrigin()) instanceof Diagram ? this.defaultCompartmentName : this.getSbmlId((Node)parent);
            speciesElement.setAttribute("compartment", compartment);
            if (species.getRole() instanceof Variable) {
                VariableRole var = (VariableRole)species.getRole(VariableRole.class);
                speciesElement.setAttribute("initialAmount", "" + var.getInitialValue());
                if (var.getUnits() != null && !var.getUnits().equals("")) {
                    speciesElement.setAttribute(this.getUnitsAttr(), var.getUnits());
                }
                this.writeNotes(speciesElement, var.getComment());
                if (var.isBoundaryCondition()) {
                    speciesElement.setAttribute("boundaryCondition", "true");
                }
            } else {
                speciesElement.setAttribute("initialAmount", "0.0");
                this.warn("WARNING_SPECIE_AMOUNT_NOT_SPECIFIED", new String[]{this.diagram.getName(), species.getName()});
            }
            Specie speciesKernel = (Specie)species.getKernel();
            if (speciesKernel != null && speciesKernel.getCharge() != 0) {
                speciesElement.setAttribute("charge", "" + speciesKernel.getCharge());
            }
            Element annotationElement = this.document.createElement("annotation");
            this.writeAnnotation(annotationElement, (DiagramElement)species);
            if (this.writeBioUMLAnnotation) {
                Element bioumlElement = this.document.createElement("biouml:BIOUML");
                bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)species, (Document)this.document);
                nodeInfoElement.setAttribute("completeName", species.getCompleteNameInDiagram());
                bioumlElement.appendChild(nodeInfoElement);
                this.writeVariable((Variable)species.getRole(VariableRole.class), bioumlElement);
                if (speciesKernel != null && !speciesKernel.getType().equals("molecule")) {
                    Element speciesInfoElement = this.document.createElement("biouml:specieInfo");
                    bioumlElement.appendChild(speciesInfoElement);
                    speciesInfoElement.setAttribute("type", speciesKernel.getType());
                    DiagramXmlWriter.serializeDPS((Document)this.document, (Element)speciesInfoElement, (DynamicPropertySet)speciesKernel.getAttributes(), null);
                    bioumlElement.appendChild(speciesInfoElement);
                }
                annotationElement.appendChild(bioumlElement);
            }
            if (annotationElement.hasChildNodes()) {
                speciesElement.appendChild(annotationElement);
            }
            return speciesElement;
        }
        catch (Throwable t) {
            this.error("ERROR_SPECIE_WRITING", new String[]{this.diagram.getName(), species.getName(), t.getMessage()});
            return null;
        }
    }

    public void writeVariable(Variable variable, Element element) {
        Element varInfoElement = this.document.createElement("biouml:variableInfo");
        if (variable.getComment() != null) {
            varInfoElement.setAttribute("comment", variable.getComment());
        }
        if (varInfoElement.hasAttributes()) {
            element.appendChild(varInfoElement);
        }
    }

    protected void writeParameterList(Element element) {
        Element parameterListElement = this.document.createElement("listOfParameters");
        for (Variable var : this.emodel.getParameters()) {
            try {
                if (var.getName().equals("time")) continue;
                this.writeParameter(parameterListElement, var);
            }
            catch (Throwable t) {
                this.error("ERROR_PARAMETER_WRITING", new String[]{this.diagram.getName(), var.getName(), t.toString()});
            }
        }
        if (parameterListElement.hasChildNodes()) {
            element.appendChild(parameterListElement);
        }
    }

    public Element writeParameter(Element parameterListElement, Variable parameter) {
        String units;
        String sbmlName;
        Element parameterElement = this.document.createElement("parameter");
        parameterListElement.appendChild(parameterElement);
        this.writeNotes(parameterElement, parameter.getComment());
        this.setId(parameterElement, this.getSbmlId(parameter));
        parameterElement.setAttribute("value", "" + parameter.getInitialValue());
        if (parameter.getComment() != null && !parameter.getComment().isEmpty()) {
            parameterElement.setAttribute("name", parameter.getComment());
        }
        if ((sbmlName = parameter.getTitle()) != null && !sbmlName.isEmpty()) {
            parameterElement.setAttribute("name", sbmlName);
        }
        if ((units = parameter.getUnits()) != null && units.length() > 0) {
            parameterElement.setAttribute("units", units);
        }
        parameterElement.setAttribute("constant", parameter.isConstant() ? "true" : "false");
        Element annotationElement = this.document.createElement("annotation");
        if (this.writeBioUMLAnnotation) {
            Element bioumlElement = this.document.createElement("biouml:BIOUML");
            bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
            this.writeVariable(parameter, bioumlElement);
            if (bioumlElement.hasChildNodes()) {
                annotationElement.appendChild(bioumlElement);
            }
        }
        if (annotationElement.hasChildNodes()) {
            parameterElement.appendChild(annotationElement);
        }
        return parameterElement;
    }

    protected Element writeReactionList(Element model) {
        Element reactionListElement = this.document.createElement("listOfReactions");
        this.doReactantStub = false;
        this.doProductStub = false;
        this.writeReactionList(reactionListElement, (biouml.model.Compartment)this.diagram);
        if (this.doReactantStub) {
            this.writeSpecieStub(this.speciesListElement, "_in_empty_set", "REACTION_STUB_NOTE");
        }
        if (this.doProductStub) {
            this.writeSpecieStub(this.speciesListElement, "_out_empty_set", "REACTION_STUB_NOTE");
        }
        return reactionListElement;
    }

    protected void writeReactionList(Element reactionListElement, biouml.model.Compartment compartment) {
        try {
            for (Node n2 : (StreamEx)compartment.recursiveStream().select(Node.class).filter(n -> n.getKernel() instanceof Reaction)) {
                this.writeReaction(reactionListElement, n2);
            }
        }
        catch (Throwable t) {
            this.error("ERROR_REACTION_LIST_WRITING", new String[]{this.diagram.getName(), t.getMessage()});
        }
    }

    public Element writeReaction(Element reactionListElement, Node reaction) {
        try {
            if (this.validReaction(reaction)) {
                Element reactionElement = this.document.createElement("reaction");
                reactionListElement.appendChild(reactionElement);
                this.writeNotes(reactionElement, reaction.getComment());
                this.setId(reactionElement, this.getSbmlId(reaction));
                Reaction reactionKernel = (Reaction)reaction.getKernel();
                if (reaction.getTitle() != null) {
                    this.setTitle(reactionElement, reactionKernel.getTitle());
                }
                this.writeReactionAttributes(reactionKernel, reactionElement);
                Element annotationElement = this.document.createElement("annotation");
                this.writeAnnotation(annotationElement, (DiagramElement)reaction);
                if (this.writeBioUMLAnnotation) {
                    Element bioumlElement = this.document.createElement("biouml:BIOUML");
                    bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                    Element nodeInfoElement = this.document.createElement("biouml:nodeInfo");
                    DiagramXmlWriter.writeNodeInfo((Element)nodeInfoElement, (Node)reaction, (Document)this.document);
                    nodeInfoElement.setAttribute("completeName", reaction.getCompleteNameInDiagram());
                    Element reactionInfoElement = this.document.createElement("biouml:reactionInfo");
                    DiagramXmlWriter.serializeDPS((Document)this.document, (Element)reactionInfoElement, (DynamicPropertySet)reactionKernel.getAttributes(), null);
                    if (reactionKernel.isFast()) {
                        reactionInfoElement.setAttribute("fast", "true");
                    }
                    bioumlElement.appendChild(reactionInfoElement);
                    bioumlElement.appendChild(nodeInfoElement);
                    annotationElement.appendChild(bioumlElement);
                }
                if (annotationElement.hasChildNodes()) {
                    reactionElement.appendChild(annotationElement);
                }
                this.writeReactants(reactionElement, reaction);
                this.writeProducts(reactionElement, reaction);
                this.writeModifiers(reactionElement, reaction);
                this.writeKineticLaw(reactionElement, reaction);
                return reactionElement;
            }
        }
        catch (Throwable t) {
            this.error("ERROR_REACTION_WRITING", new String[]{this.diagram.getName(), reaction.getName(), t.getMessage()});
        }
        return null;
    }

    protected void writeReactionAttributes(Reaction reaction, Element element) {
        if (!reaction.isReversible()) {
            element.setAttribute("reversible", "false");
        }
        if (reaction.isFast()) {
            element.setAttribute("fast", "true");
        }
    }

    protected void writeModifiers(Element reactionElement, Node reaction) {
    }

    protected void writeReactants(Element reactionElement, Node reaction) {
        Element reactantListElement = this.document.createElement("listOfReactants");
        reactionElement.appendChild(reactantListElement);
        if (!this.writeSpecieReferences(reactantListElement, reaction, "reactant")) {
            this.doReactantStub = true;
            this.writeStubReference(reactantListElement, reaction, "_in_empty_set");
        }
        this.writeSpecieReferences(reactantListElement, reaction, "modifier");
    }

    protected void writeProducts(Element reactionElement, Node reaction) {
        Element productListElement = this.document.createElement("listOfProducts");
        reactionElement.appendChild(productListElement);
        if (!this.writeSpecieReferences(productListElement, reaction, "product")) {
            this.doProductStub = true;
            this.writeStubReference(productListElement, reaction, "_out_empty_set");
        }
    }

    protected Element createSpeciesReferenceElement() {
        return this.document.createElement("speciesReference");
    }

    protected void setSpeciesAttribute(Element speciesReferenceElement, String speciesName) {
        speciesReferenceElement.setAttribute("species", speciesName);
    }

    protected boolean writeSpecieReferences(Element listElement, Node reaction, String role) {
        return this.writeSpecieReferences(listElement, reaction, role, null);
    }

    protected boolean writeSpecieReferences(Element listElement, Node reaction, String role, String elementType) {
        int n = 0;
        for (Edge edge : reaction.getEdges()) {
            if (!(edge.getKernel() instanceof SpecieReference)) continue;
            SpecieReference species = (SpecieReference)edge.getKernel();
            Node speciesNode = Util.isReaction((DiagramElement)edge.getInput()) ? edge.getOutput() : edge.getInput();
            String specie = this.getSbmlId(speciesNode);
            if (!role.equals(species.getRole())) continue;
            try {
                Element speciesReferenceElement = elementType == null ? this.createSpeciesReferenceElement() : this.document.createElement(elementType);
                listElement.appendChild(speciesReferenceElement);
                this.writeNotes(speciesReferenceElement, species.getComment());
                String speciesName = specie;
                this.setSpeciesAttribute(speciesReferenceElement, speciesName);
                if (elementType == null || !elementType.equals("modifierSpeciesReference")) {
                    this.writeSpeciesReferenceAttributes(speciesReferenceElement, species, reaction);
                }
                ++n;
                Element annotationElement = this.document.createElement("annotation");
                this.writeAnnotation(annotationElement, (DiagramElement)reaction);
                if (this.writeBioUMLAnnotation) {
                    Element bioumlElement = this.document.createElement("biouml:BIOUML");
                    bioumlElement.setAttribute("xmlns:biouml", "http://www.biouml.org/ns");
                    Element edgeInfoElement = this.document.createElement("biouml:edgeInfo");
                    DiagramXmlWriter.writeEdgeInfo((Element)edgeInfoElement, (Edge)edge, (Document)this.document);
                    bioumlElement.appendChild(edgeInfoElement);
                    annotationElement.appendChild(bioumlElement);
                }
                if (!annotationElement.hasChildNodes()) continue;
                speciesReferenceElement.appendChild(annotationElement);
            }
            catch (Throwable t) {
                this.error("ERROR_SPECIE_REFERENCE_WRITING", new String[]{this.diagram.getName(), reaction.getName(), species.getName(), t.getMessage()});
            }
        }
        return n > 0;
    }

    protected void writeStubReference(Element listElement, Node reaction, String stubName) {
        Element speciesReferenceElement = this.createSpeciesReferenceElement();
        listElement.appendChild(speciesReferenceElement);
        this.setSpeciesAttribute(speciesReferenceElement, stubName);
    }

    protected void writeSpecieStub(Element speciesListElement, String stubName, String messageKey) {
        Element speciesElement = this.document.createElement("species");
        speciesListElement.appendChild(speciesElement);
        this.setId(speciesElement, stubName);
        speciesElement.setAttribute("boundaryCondition", "true");
        Diagram compartment = this.diagram;
        speciesElement.setAttribute("compartment", compartment.getName());
        speciesElement.setAttribute("initialAmount", "0.0");
        this.writeNotes(speciesElement, MessageBundle.resources.getResourceString(messageKey));
    }

    protected void writeKineticLaw(Element reactionElement, Node reaction) {
        KineticLaw kineticLaw = ((Reaction)reaction.getKernel()).getKineticLaw();
        Element kineticLawElement = this.document.createElement("kineticLaw");
        this.writeNotes(kineticLawElement, reaction.getComment());
        this.writeFormula(this.parseFormula(kineticLaw.getFormula(), reaction), reaction, kineticLawElement);
        if (kineticLaw.getTimeUnits() != null && kineticLaw.getTimeUnits().length() > 0) {
            kineticLawElement.setAttribute("timeUnits", kineticLaw.getTimeUnits());
        }
        if (kineticLaw.getSubstanceUnits() != null && kineticLaw.getSubstanceUnits().length() > 0) {
            kineticLawElement.setAttribute("substanceUnits", kineticLaw.getSubstanceUnits());
        }
        if (kineticLawElement.getFirstChild() != null) {
            reactionElement.appendChild(kineticLawElement);
        }
    }

    public void validateAnnotationsExtensions(Set<String> namespaces) {
        this.annotationsExtensions = new LinkedHashMap<String, SbmlExtension>();
        for (SbmlAnnotationRegistry.SbmlAnnotationInfo extension : SbmlAnnotationRegistry.getAnnotations()) {
            try {
                SbmlExtension se = extension.create();
                se.setSbmlModelWriter(this);
                if (!namespaces.contains(extension.getNamespace())) continue;
                this.annotationsExtensions.put(extension.getNamespace(), se);
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Can not validate annotation extensions.", t);
            }
        }
    }

    protected void writeAnnotation(Element annotation, DiagramElement diagramElement) {
        if (this.annotationsExtensions == null) {
            this.validateAnnotationsExtensions(SbmlAnnotationRegistry.getNamespaces());
        }
        for (SbmlExtension annotationsExtension : this.annotationsExtensions.values()) {
            annotationsExtension.setSbmlModelWriter(this);
            Element[] newElements = annotationsExtension.writeElement(diagramElement, this.document);
            if (newElements == null) continue;
            for (Element newElement : newElements) {
                if (newElement == null) continue;
                annotation.appendChild(newElement);
            }
        }
    }

    protected abstract void writeFormula(String var1, Node var2, Element var3);

    @Override
    protected boolean parseAsSpecie(String token, StringBuffer result) {
        if (token.charAt(0) == '$') {
            if (token.startsWith("$$rate_")) {
                token = token.substring(7);
            } else {
                int i = 1;
                while (token.charAt(i) == '$') {
                    ++i;
                }
                token = token.substring(i);
            }
            if (token.length() > 2 && token.charAt(0) == '\"' && token.charAt(token.length() - 1) == '\"') {
                token = token.substring(1, token.length() - 1);
            }
            result.append(token);
            return true;
        }
        return false;
    }

    protected boolean isAutoCreated(biouml.model.Compartment compartment) {
        return compartment.getAttributes().getProperty("autoCreated") != null;
    }

    protected void setAutoCreated(biouml.model.Compartment compartment) {
        try {
            compartment.getAttributes().add(new DynamicProperty("autoCreated", Boolean.class, (Object)true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSbmlId(Node species) {
        if (this.nodeToSbmlIds.containsKey(species)) {
            return this.nodeToSbmlIds.get(species);
        }
        String name = SbmlModelWriter.castStringToSId(species.getName());
        if (this.sbmlIds.contains(name)) {
            name = this.generateUniqueName(SbmlModelWriter.castStringToSId(species.getCompleteNameInDiagram()));
        }
        this.nodeToSbmlIds.put(species, name);
        this.sbmlIds.add(name);
        return name;
    }

    public String generateUniqueName(String baseName) {
        int i = 0;
        String name = baseName;
        while (this.sbmlIds.contains(name)) {
            name = baseName + "_" + i++;
        }
        return name;
    }

    protected String getSbmlId(Variable var) {
        if (var instanceof VariableRole && ((VariableRole)var).getDiagramElement() instanceof Node) {
            return this.getSbmlId((Node)((VariableRole)var).getDiagramElement());
        }
        if (this.parameterToSbmlIds.containsKey(var)) {
            return this.parameterToSbmlIds.get(var);
        }
        String name = this.generateUniqueName(var.getName());
        this.sbmlIds.add(name);
        this.parameterToSbmlIds.put(var, name);
        return name;
    }

    protected void writeUnitList(Element modelElement) {
        Element unitListElement = this.document.createElement("listOfUnitDefinitions");
        for (Unit unit : this.emodel.getUnits().values()) {
            try {
                this.writeUnit(unit, unitListElement);
            }
            catch (Throwable t) {
                this.error("ERROR_UNIT_DEFINITION_PROCESSING", new String[]{this.diagram.getName(), unit.getName(), t.getMessage()});
            }
        }
        if (unitListElement.hasChildNodes()) {
            modelElement.appendChild(unitListElement);
        }
    }

    public Element writeUnit(Unit unit, Element unitListElement) {
        Element unitElement = this.document.createElement("unitDefinition");
        unitListElement.appendChild(unitElement);
        this.setId(unitElement, unit.getName());
        this.setTitle(unitElement, unit.getTitle());
        Element baseUnitsListElement = this.document.createElement("listOfUnits");
        BaseUnit[] baseUnits = unit.getBaseUnits();
        if (baseUnits != null) {
            for (BaseUnit baseUnit : baseUnits) {
                try {
                    this.writeBaseUnit(baseUnit, baseUnitsListElement);
                }
                catch (Throwable t) {
                    this.error("ERROR_UNIT_PROCESSING", new String[]{this.diagram.getName(), unit.getName(), t.getMessage()});
                }
            }
            if (baseUnitsListElement.hasChildNodes()) {
                unitElement.appendChild(baseUnitsListElement);
            }
        }
        return unitElement;
    }

    public Element writeBaseUnit(BaseUnit baseUnit, Element baseUnitsListElement) {
        Element baseUnitElement = this.document.createElement("unit");
        baseUnitsListElement.appendChild(baseUnitElement);
        baseUnitElement.setAttribute("kind", baseUnit.getType());
        if (baseUnit.getExponent() != 1) {
            baseUnitElement.setAttribute("exponent", "" + baseUnit.getExponent());
        }
        if (baseUnit.getScale() != 0) {
            baseUnitElement.setAttribute("scale", "" + baseUnit.getScale());
        }
        if (baseUnit.getMultiplier() != 1.0) {
            baseUnitElement.setAttribute("multiplier", "" + baseUnit.getMultiplier());
        }
        return baseUnitElement;
    }
}

