/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Edge;
import biouml.model.Node;
import biouml.model.dynamics.EModel;
import biouml.model.dynamics.Event;
import biouml.model.dynamics.Variable;
import biouml.model.dynamics.VariableRole;
import biouml.plugins.sbml.SbmlDiagramType_L3v1;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.plugins.sbml.SbmlModelReader_24;
import biouml.plugins.sbml.SbmlPackageReader;
import biouml.plugins.sbml.SbmlPackageRegistry;
import biouml.standard.type.Reaction;
import biouml.standard.type.SpecieReference;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.util.DPSUtils;

public class SbmlModelReader_31
extends SbmlModelReader_24 {
    protected List<SbmlPackageReader> packageReaders = new ArrayList<SbmlPackageReader>();

    public SbmlModelReader_31() {
        this.log = Logger.getLogger(SbmlModelReader_31.class.getName());
    }

    public List<SbmlPackageReader> getPackageReaders() {
        return this.packageReaders;
    }

    public void initPackageReaders(Document document, boolean modelDefinition) {
        this.packageReaders = SbmlPackageRegistry.getReaders(SbmlModelReader_31.readPackages(document));
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.setNewPaths(this.newPaths);
        }
        if (!modelDefinition) {
            return;
        }
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.setModelDefintion(modelDefinition);
        }
    }

    @Override
    public Diagram read(Document document, String name, DataCollection<?> origin) throws Exception {
        this.initPackageReaders(document, false);
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.preprocess(document, origin);
        }
        return super.read(document, name, origin);
    }

    public Diagram readModelDefinition(Element element, String name) throws Exception {
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.preprocess(element.getOwnerDocument(), null);
        }
        this.modelName = name;
        Diagram diagram = this.readDiagram(element, (DataCollection)null);
        if (this.shouldLayout) {
            this.layout((Compartment)diagram);
        }
        return diagram;
    }

    @Override
    protected void readDiagramElements(Element element) {
        super.readDiagramElements(element);
        for (SbmlPackageReader reader : this.packageReaders) {
            try {
                reader.postprocessDiagram(element, this.diagram);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected Diagram createDiagram(Element element, DataCollection<?> origin) throws Exception {
        Diagram diagram = super.createDiagram(element, origin);
        if (this.packageReaders.size() > 0) {
            String[] packageNames = new String[this.packageReaders.size()];
            int i = 0;
            for (SbmlPackageReader reader : this.packageReaders) {
                reader.preprocessDiagram(element, diagram);
                packageNames[i++] = reader.getPackageName();
            }
            diagram.getAttributes().add(DPSUtils.createHiddenReadOnlyTransient((String)"Packages", String[].class, (Object)packageNames));
        }
        return diagram;
    }

    public static List<String> readPackages(Document document) {
        ArrayList<String> requiredPackages = new ArrayList<String>();
        Element root = document.getDocumentElement();
        for (int i = 0; i < root.getAttributes().getLength(); ++i) {
            String nextAttribute = root.getAttributes().item(i).toString();
            if (!nextAttribute.startsWith("xmlns:")) continue;
            nextAttribute = nextAttribute.replace("xmlns:", "");
            String packageName = nextAttribute.substring(0, nextAttribute.indexOf("="));
            requiredPackages.add(packageName);
        }
        return requiredPackages;
    }

    @Override
    protected DiagramType getDiagramType(Element modelElement) {
        for (SbmlPackageReader reader : this.packageReaders) {
            DiagramType type = reader.getDiagramType();
            if (type == null) continue;
            return type;
        }
        return new SbmlDiagramType_L3v1();
    }

    @Override
    public void readModelAttributes(Element element, Diagram diagram) {
        String conversionFactor;
        super.readModelAttributes(element, diagram);
        if (element.hasAttribute("conversionFactor")) {
            String conversionFactorAttr = element.getAttribute("conversionFactor");
            if (this.emodel.containsVariable(conversionFactorAttr)) {
                this.emodel.setConversionFactor(conversionFactorAttr);
            } else {
                this.error("UNKNOWN_CONVERSION_FACTOR", new String[]{this.modelName, conversionFactorAttr});
            }
        }
        if (element.hasAttribute("volumeUnits")) {
            this.emodel.setVolumeUnits(element.getAttribute("volumeUnits"));
        }
        if (element.hasAttribute("substanceUnits")) {
            this.emodel.setSubstanceUnits(element.getAttribute("substanceUnits"));
        }
        if (element.hasAttribute("timeUnits")) {
            this.emodel.setTimeUnits(element.getAttribute("timeUnits"));
        }
        if (element.hasAttribute("areaUnits")) {
            this.emodel.setAreaUnits(element.getAttribute("areaUnits"));
        }
        if (element.hasAttribute("extentUnits")) {
            this.emodel.setExtentUnits(element.getAttribute("extentUnits"));
        }
        if (element.hasAttribute("lengthUnits")) {
            this.emodel.setLengthUnits(element.getAttribute("lengthUnits"));
        }
        if (!(conversionFactor = this.emodel.getConversionFactor()).isEmpty()) {
            for (VariableRole role : this.emodel.getVariableRoles()) {
                boolean isCompartment;
                boolean bl = isCompartment = role.getDiagramElement().getKernel() != null && "compartment".equals(role.getDiagramElement().getKernel().getType());
                if (role.getConversionFactor() != null || isCompartment) continue;
                role.setConversionFactor(conversionFactor);
            }
        }
    }

    @Override
    protected void readLocalParameterList(Element parent, Node reaction) {
        Element parameterList = this.getElement(parent, "listOfLocalParameters");
        if (!this.isValid("listOfLocalParameters", parameterList, null) || parameterList == null) {
            return;
        }
        NodeList list = parameterList.getElementsByTagName("localParameter");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)list.item(i);
            String parameterId = this.getId(element);
            try {
                this.readParameter(element, parameterId, reaction);
                continue;
            }
            catch (Throwable t) {
                if (reaction == null) {
                    this.error("ERROR_GLOBAL_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, t.getMessage()});
                    continue;
                }
                this.error("ERROR_REACTION_PARAMETER_PROCESSING", new String[]{this.modelName, parameterId, reaction.getName(), t.getMessage()});
            }
        }
    }

    @Override
    protected void readStoichiometry(Element element, SpecieReference reference, Node reaction) {
        String stoichiometry = "1";
        String species = "null";
        if (element.hasAttribute("species")) {
            species = element.getAttribute("species");
        }
        if (element.hasAttribute("id")) {
            String constantAttr = element.getAttribute("constant");
            stoichiometry = element.getAttribute("id");
            Variable stoichiometryVar = new Variable(stoichiometry, (EModel)this.emodel, this.emodel.getVariables());
            stoichiometryVar.setConstant(Boolean.parseBoolean(constantAttr));
            stoichiometryVar.setInitialValue(this.readDouble(element, "stoichiometry", "", 0.0));
            this.emodel.put(stoichiometryVar);
        } else if (element.hasAttribute("stoichiometry")) {
            stoichiometry = element.getAttribute("stoichiometry");
        } else {
            this.error("SPECIES_STOICHIOMETRY_PROCESSING", new String[]{this.modelName, species, stoichiometry});
        }
        reference.setStoichiometry(stoichiometry);
    }

    @Override
    public Node readEvent(Element eventElement, int i) {
        Node node = super.readEvent(eventElement, i);
        Event event = (Event)node.getRole(Event.class);
        if (!eventElement.hasAttribute("useValuesFromTriggerTime")) {
            this.error("ERROR_USE_VALUES_FROM_TRIGGER_TIME_ABSENT", new String[]{this.modelName, node.getName()});
        }
        try {
            Element triggerElement = this.getElement(eventElement, "trigger");
            event.setTriggerInitialValue(Boolean.parseBoolean(triggerElement.getAttribute("initialValue")));
            event.setTriggerPersistent(Boolean.parseBoolean(triggerElement.getAttribute("persistent")));
        }
        catch (Exception ex) {
            this.error("ERROR_TRIGGER_PROCESSING", new String[]{this.modelName, node.getName(), ex.getMessage()});
        }
        try {
            String priority;
            Element priorityElement = this.getElement(eventElement, "priority");
            if (priorityElement != null && (priority = this.readMath(priorityElement, (DiagramElement)node)) != null) {
                DynamicProperty dp;
                event.setPriority(priority);
                SbmlModelReader_21.MetaIdInfo metaIdInfo = this.readMetaId(priorityElement, node.getName(), Node.class, "priority");
                if (metaIdInfo != null && (dp = node.getAttributes().getProperty("metaid")) != null) {
                    List metaInfos = (List)dp.getValue();
                    metaInfos.add(metaIdInfo);
                }
            }
        }
        catch (Exception ex) {
            this.error("ERROR_PRIORITY_PROCESSING", new String[]{this.modelName, node.getName(), ex.getMessage()});
        }
        Element delayElement = this.getElement(eventElement, "delay");
        if (delayElement != null && delayElement.hasAttribute("units")) {
            event.setTimeUnits(delayElement.getAttribute("units"));
        }
        return node;
    }

    @Override
    public Compartment readCompartment(Element element, String compartmentId, String parentId, String compartmentName) throws Exception {
        Compartment compartment = super.readCompartment(element, compartmentId, parentId, compartmentName);
        if (compartment == null) {
            return null;
        }
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processCompartment(element, compartment);
        }
        return compartment;
    }

    @Override
    public Node readSpecie(Element element, String specieId, String specieName) throws Exception {
        Node node = super.readSpecie(element, specieId, specieName);
        if (element.hasAttribute("conversionFactor")) {
            String conversionFactor = element.getAttribute("conversionFactor");
            if (!this.emodel.containsVariable(conversionFactor)) {
                this.error("UNKNOWN_CONVERSION_FACTOR", new String[]{this.modelName, conversionFactor});
            } else {
                String resolvedName = this.variableResolver.resolveVariable(conversionFactor);
                ((VariableRole)node.getRole(VariableRole.class)).setConversionFactor(resolvedName);
            }
        }
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processSpecie(element, node);
        }
        return node;
    }

    @Override
    public Variable readParameter(Element element, String parameterId, Node reaction) throws Exception {
        Variable parameter = super.readParameter(element, parameterId, reaction);
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processParameter(element, parameter);
        }
        return parameter;
    }

    @Override
    public Node readRule(Element ruleElement, int i) {
        Node rule = super.readRule(ruleElement, i);
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processRule(ruleElement, rule);
        }
        return rule;
    }

    @Override
    public Node readReaction(Element element, String reactionId, String reactionName) throws Exception {
        Node reaction = super.readReaction(element, reactionId, reactionName);
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processReaction(element, reaction);
        }
        return reaction;
    }

    @Override
    protected Edge readSpecieReference(Node reactionNode, Element element, String specieId, String role) throws Exception {
        Edge reference = super.readSpecieReference(reactionNode, element, specieId, role);
        for (SbmlPackageReader reader : this.packageReaders) {
            reader.processSpecieReference(element, reference);
        }
        return reference;
    }

    @Override
    protected String createSpecieReferenceId(Element element, Reaction reaction, Node specie, String role) {
        String id = "";
        if (element.hasAttribute("id")) {
            id = element.getAttribute("id");
        }
        if (id.isEmpty()) {
            id = super.createSpecieReferenceId(element, reaction, specie, role);
        }
        return id;
    }
}

