/*
 * Decompiled with CFR 0.152.
 */
package biouml.plugins.sbml;

import biouml.model.Compartment;
import biouml.model.Diagram;
import biouml.model.DiagramElement;
import biouml.model.DiagramType;
import biouml.model.Node;
import biouml.model.Role;
import biouml.model.dynamics.Constraint;
import biouml.plugins.sbml.SbmlDiagramType_L2v2;
import biouml.plugins.sbml.SbmlModelReader_21;
import biouml.standard.type.Base;
import biouml.standard.type.BaseSupport;
import biouml.standard.type.Stub;
import com.developmentontheedge.beans.DynamicProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.biosoft.access.core.DataCollection;
import ru.biosoft.access.core.DataElement;
import ru.biosoft.util.XmlUtil;

public class SbmlModelReader_22
extends SbmlModelReader_21 {
    protected Map<String, DataElement> compartmentTypes = new HashMap<String, DataElement>();
    protected Map<String, DataElement> specieTypes = new HashMap<String, DataElement>();

    public SbmlModelReader_22() {
        this.log = Logger.getLogger(SbmlModelReader_22.class.getName());
    }

    @Override
    protected DiagramType getDiagramType(Element modelElement) {
        return new SbmlDiagramType_L2v2();
    }

    @Override
    protected boolean isValid(String elementName, Object element, String name) {
        if (elementName.equals("listOfCompartmentTypes")) {
            return this.validateList(element, "compartmentType", name);
        }
        if (elementName.equals("listOfSpeciesTypes")) {
            return this.validateList(element, "speciesType", name);
        }
        if (elementName.equals("listOfInitialAssignments")) {
            return this.validateList(element, "initialAssignment", name);
        }
        if (elementName.equals("listOfConstraints")) {
            return this.validateList(element, "constraint", name);
        }
        return super.isValid(elementName, element, name);
    }

    @Override
    public void readModelAttributes(Element element, Diagram diagram) {
        super.readModelAttributes(element, diagram);
        this.readSBOTerm(element, diagram.getAttributes());
    }

    @Override
    public Node readFunctionDefinition(Element funcDefElement, Map<String, Element> functions, Set<String> alreadyRead) throws Exception {
        Node fd = super.readFunctionDefinition(funcDefElement, functions, alreadyRead);
        this.readSBOTerm(funcDefElement, fd.getAttributes());
        return fd;
    }

    @Override
    protected void readCompartmentTypeList(Element model) {
        Element compartmentTypeList = this.getElement(model, "listOfCompartmentTypes");
        if (!this.isValid("listOfCompartmentTypes", compartmentTypeList, null)) {
            return;
        }
        NodeList list = compartmentTypeList.getElementsByTagName("compartmentType");
        for (Element element : XmlUtil.elements((NodeList)list)) {
            String id = this.getId(element);
            if (this.compartmentTypes.containsKey(id)) continue;
            BaseSupport cType = new BaseSupport(null, id, "compartmentType");
            String name = this.getTitle(element);
            if (!name.isEmpty()) {
                cType.setTitle(name);
            }
            this.compartmentTypes.put(id, (DataElement)cType);
        }
    }

    @Override
    public Compartment readCompartment(Element element, String compartmentId, String parentId, String compartmentName) throws Exception {
        String id;
        Compartment compartment = super.readCompartment(element, compartmentId, parentId, compartmentName);
        if (compartment == null) {
            return null;
        }
        if (element.hasAttribute("compartmentType") && this.compartmentTypes.containsKey(id = element.getAttribute("compartmentType"))) {
            compartment.getAttributes().add(new DynamicProperty("compartmentType", BaseSupport.class, (Object)this.compartmentTypes.get(id)));
        }
        this.readSBOTerm(element, compartment.getAttributes());
        return compartment;
    }

    @Override
    protected void readSpecieTypeList(Element model) {
        Element specieTypeList = this.getElement(model, "listOfSpeciesTypes");
        if (!this.isValid("listOfSpeciesTypes", specieTypeList, null)) {
            return;
        }
        NodeList list = specieTypeList.getElementsByTagName("speciesType");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)list.item(i);
            String id = this.getId(element);
            if (this.specieTypes.containsKey(id)) continue;
            BaseSupport cType = new BaseSupport(null, id, "speciesType");
            String name = this.getTitle(element);
            if (!name.isEmpty()) {
                cType.setTitle(name);
            }
            this.specieTypes.put(id, (DataElement)cType);
        }
    }

    @Override
    public Node readSpecie(Element element, String specieId, String specieName) throws Exception {
        String id;
        Node node = super.readSpecie(element, specieId, specieName);
        if (element.hasAttribute("speciesType") && this.specieTypes.containsKey(id = element.getAttribute("speciesType"))) {
            node.getAttributes().add(new DynamicProperty("speciesType", BaseSupport.class, (Object)this.specieTypes.get(id)));
        }
        return node;
    }

    @Override
    public Node readRule(Element ruleElement, int i) {
        Node rule = super.readRule(ruleElement, i);
        this.readSBOTerm(ruleElement, rule.getAttributes());
        return rule;
    }

    @Override
    public Node readInitialAssignment(Element initialAssignmentElement, int i) {
        Node initialAssignment = super.readInitialAssignment(initialAssignmentElement, i);
        this.readSBOTerm(initialAssignmentElement, initialAssignment.getAttributes());
        return initialAssignment;
    }

    @Override
    public Node readEvent(Element eventElement, int i) {
        Node event = super.readEvent(eventElement, i);
        this.readSBOTerm(eventElement, event.getAttributes());
        return event;
    }

    @Override
    public Node readReaction(Element element, String reactionId, String reactionName) throws Exception {
        Node reaction = super.readReaction(element, reactionId, reactionName);
        this.readSBOTerm(element, reaction.getAttributes());
        return reaction;
    }

    @Override
    protected void readConstraints(Element model) {
        Element constraintList = this.getElement(model, "listOfConstraints");
        if (!this.isValid("listOfConstraints", constraintList, null)) {
            return;
        }
        NodeList list = constraintList.getElementsByTagName("constraint");
        for (int i = 0; i < list.getLength(); ++i) {
            this.readConstraint((Element)list.item(i), i);
        }
    }

    protected Node readConstraint(Element constraintElement, int i) {
        Element p;
        Element message;
        String id = this.getBriefId(constraintElement, "biouml:nodeInfo");
        if (id.isEmpty()) {
            id = constraintElement.getAttribute("metaid");
        }
        if (id.isEmpty()) {
            id = "constraint_" + i;
        }
        Node node = new Node((DataCollection)this.diagram, (Base)new Stub((DataCollection)this.diagram, id, "math-constraint"));
        Element annotationElement = this.getElement(constraintElement, "annotation");
        if (annotationElement != null) {
            this.readBioUMLAnnotation(annotationElement, (DiagramElement)node, "biouml:nodeInfo");
        }
        Constraint constraint = new Constraint((DiagramElement)node);
        node.setRole((Role)constraint);
        String formula = this.readMath(constraintElement, (DiagramElement)node);
        if (formula != null) {
            constraint.setFormula(formula);
        }
        if ((message = this.getElement(constraintElement, "message")) != null && (p = this.getElement(message, "p")) != null) {
            constraint.setMessage(p.getFirstChild().getNodeValue());
        }
        try {
            node.save();
            return node;
        }
        catch (Throwable t) {
            this.error("ERROR_CONSTRAINT_PROCESSING", new String[]{this.modelName, t.getMessage()});
            return null;
        }
    }
}

